/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.ui;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.ReferenceEditorWithBrowseButton;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.search.OCSearchUtil;
import com.jetbrains.cidr.lang.ui.OCFileChooserDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFileReferenceEditor
extends ReferenceEditorWithBrowseButton {
    private OCFile myLastSelectedFile;

    public OCFileReferenceEditor(ActionListener browseActionListener, EditorTextField editorTextField, Function<String, Document> factory) {
        super(browseActionListener, editorTextField, factory);
    }

    public static OCFileReferenceEditor create(final Project project) {
        final Ref result2 = Ref.create(null);
        ArrayList<OCFile> files = new ArrayList<OCFile>();
        ClassCompletionProvider completionProvider = new ClassCompletionProvider((Collection<OCFile>)files);
        final TextFieldWithAutoCompletion<OCFile> textField = new TextFieldWithAutoCompletion<OCFile>(project, completionProvider, false, null);
        Function<String, Document> documentFactory = new Function<String, Document>(){

            @Nullable
            public Document fun(String s) {
                textField.setText(s);
                return textField.getDocument();
            }
        };
        result2.set((Object)new OCFileReferenceEditor(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OCFileChooserDialog dialog = new OCFileChooserDialog("Choose Containing Class", project);
                dialog.showDialog();
                if (dialog.isOK()) {
                    OCFile selectedFile = (OCFile)dialog.getSelected();
                    ((OCFileReferenceEditor)((Object)result2.get())).myLastSelectedFile = selectedFile;
                    ((OCFileReferenceEditor)((Object)result2.get())).setText(selectedFile.getName());
                }
            }
        }, textField, documentFactory));
        return (OCFileReferenceEditor)((Object)result2.get());
    }

    @Nullable
    public OCFile getFile(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/ui/OCFileReferenceEditor", "getFile"));
        }
        return (OCFile)ContainerUtil.getFirstItem(OCSearchUtil.getProjectOCFilesByName(project, this.getText()));
    }

    private static class ClassCompletionProvider
    extends TextFieldWithAutoCompletionListProvider<OCFile> {
        protected ClassCompletionProvider(@Nullable Collection<OCFile> variants) {
            super(variants);
        }

        @Override
        protected Icon getIcon(@NotNull OCFile file2) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/ui/OCFileReferenceEditor$ClassCompletionProvider", "getIcon"));
            }
            return file2.getIcon(0);
        }

        @Override
        @NotNull
        protected String getLookupString(@NotNull OCFile file2) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/ui/OCFileReferenceEditor$ClassCompletionProvider", "getLookupString"));
            }
            String string = file2.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/ui/OCFileReferenceEditor$ClassCompletionProvider", "getLookupString"));
            }
            return string;
        }

        @Override
        protected String getTailText(@NotNull OCFile file2) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/ui/OCFileReferenceEditor$ClassCompletionProvider", "getTailText"));
            }
            VirtualFile virtualFile = file2.getVirtualFile();
            VirtualFile parent = virtualFile != null ? virtualFile.getParent() : null;
            return parent != null ? parent.getPath() : null;
        }

        @Override
        protected String getTypeText(@NotNull OCFile file2) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/ui/OCFileReferenceEditor$ClassCompletionProvider", "getTypeText"));
            }
            return null;
        }

        @Override
        public int compare(OCFile file1, OCFile file2) {
            return file1.getName().compareTo(file2.getName());
        }
    }
}

