/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types.visitors;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.OCLValueVisitor;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterValueSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCReferenceExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCEllipsisType;
import com.jetbrains.cidr.lang.types.OCExpressionTypeArgument;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCSimpleTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import com.jetbrains.cidr.lang.util.OCNumber;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCTypeUnificationVisitor
implements OCTypeVisitor<UnificationResult> {
    public static final UnificationResult NOT_UNIFIED = new UnificationResult(-1);
    public static final UnificationResult UNIFIED = new UnificationResult(1);
    public static final UnificationResult UNKNOWN = new UnificationResult(0);
    private boolean myFunctionParametersMode;
    private final boolean myMagicTypesEqual;
    private OCTypeArgument myArgument;
    @Nullable
    private Object myArgumentExpr;
    private final Map<OCTypeParameterSymbol, OCTypeArgument> mySubstitutionMap;
    @NotNull
    private final OCResolveContext myContext;

    public OCTypeUnificationVisitor(boolean functionParametersMode, boolean magicTypesEqual, @NotNull OCTypeArgument argument, @Nullable Object expression, @NotNull Map<OCTypeParameterSymbol, OCTypeArgument> substitutionMap, @NotNull OCResolveContext context) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "com/jetbrains/cidr/lang/types/visitors/OCTypeUnificationVisitor", "<init>"));
        }
        if (substitutionMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutionMap", "com/jetbrains/cidr/lang/types/visitors/OCTypeUnificationVisitor", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/types/visitors/OCTypeUnificationVisitor", "<init>"));
        }
        this.myFunctionParametersMode = functionParametersMode;
        this.myMagicTypesEqual = magicTypesEqual;
        this.myArgument = argument;
        this.myArgumentExpr = expression;
        this.mySubstitutionMap = substitutionMap;
        this.myContext = context;
    }

    public UnificationResult unify(@NotNull OCTypeArgument parameter, @NotNull OCTypeArgument argument) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/jetbrains/cidr/lang/types/visitors/OCTypeUnificationVisitor", "unify"));
        }
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "com/jetbrains/cidr/lang/types/visitors/OCTypeUnificationVisitor", "unify"));
        }
        if (parameter instanceof OCExpressionTypeArgument) {
            OCResolveContext context = this.myContext.substitute(OCSimpleTypeSubstitution.create(this.mySubstitutionMap));
            OCExpressionSymbol parameterSymbol = ((OCExpressionTypeArgument)parameter).getSymbol();
            Object paramValue = OCExpressionEvaluator.evaluate(parameterSymbol, context);
            Object argValue = null;
            if (paramValue == null) {
                OCSymbol symbol;
                if (parameterSymbol instanceof OCReferenceExpressionSymbol && (symbol = ((OCReferenceExpressionSymbol)parameterSymbol).resolveToSymbol(this.myContext)) instanceof OCTypeParameterValueSymbol) {
                    this.mySubstitutionMap.put((OCTypeParameterSymbol)((Object)symbol), argument);
                    return UNIFIED;
                }
                return UNKNOWN;
            }
            if (argument instanceof OCExpressionTypeArgument) {
                argValue = OCExpressionEvaluator.evaluate(((OCExpressionTypeArgument)argument).getSymbol(), context);
            } else if (argument instanceof OCReferenceType) {
                OCSymbol symbol = (OCSymbol)ContainerUtil.getFirstItem(this.myContext.resolveToSymbols(((OCReferenceType)argument).getReference()));
                argValue = OCExpressionEvaluator.evaluate(symbol, context);
            } else if (!(argument instanceof OCMagicType)) {
                return NOT_UNIFIED;
            }
            if (argValue != null) {
                return OCTypeUnificationVisitor.isSameValue(paramValue, argValue) ? UNIFIED : NOT_UNIFIED;
            }
        } else if (parameter instanceof OCType) {
            if (argument instanceof OCReferenceType) {
                argument = OCUnknownType.INSTANCE;
            }
            if (parameter instanceof OCPointerType && !(argument instanceof OCPointerType) && ((OCPointerType)parameter).getRefType() instanceof OCFunctionType) {
                parameter = ((OCPointerType)parameter).getRefType();
            }
            if (parameter instanceof OCCppReferenceType && ((OCCppReferenceType)parameter).getRefType() instanceof OCFunctionType) {
                parameter = ((OCCppReferenceType)parameter).getRefType();
            }
            if (argument instanceof OCCppReferenceType && ((OCCppReferenceType)argument).getRefType() instanceof OCFunctionType) {
                argument = ((OCCppReferenceType)argument).getRefType();
            }
            if (this.myFunctionParametersMode) {
                if (argument instanceof OCCppReferenceType) {
                    argument = ((OCCppReferenceType)argument).getRefType();
                }
                if (parameter instanceof OCCppReferenceType) {
                    if (argument instanceof OCType && ((OCCppReferenceType)parameter).isRvalueRef() && !((OCCppReferenceType)parameter).getRefType().isConst() && OCLValueVisitor.isLvalue(this.myArgumentExpr) && !(argument instanceof OCCppReferenceType)) {
                        argument = OCCppReferenceType.to((OCType)argument);
                    }
                    parameter = ((OCCppReferenceType)parameter).getRefType();
                }
            }
            OCTypeArgument save = this.myArgument;
            this.myArgument = argument;
            UnificationResult result2 = !(this.myFunctionParametersMode || parameter instanceof OCTypeParameterType && !((OCTypeParameterType)parameter).isConst() && !((OCTypeParameterType)parameter).isVolatile() || !(argument instanceof OCType) || ((OCType)argument).isUnknown() || ((OCType)parameter).isConst() == ((OCType)argument).isConst() && ((OCType)parameter).isVolatile() == ((OCType)argument).isVolatile()) ? this.defaultResult() : ((OCType)parameter).accept(this);
            this.myArgument = save;
            return result2;
        }
        return UNKNOWN;
    }

    private static boolean isSameValue(@Nullable Object value1, @Nullable Object value2) {
        if (value1 instanceof Boolean && value2 instanceof Number) {
            return (Boolean)value1 == (OCExpressionEvaluator.singAsInC(value2) != 0);
        }
        if (value1 instanceof Number && value2 instanceof Boolean) {
            return OCExpressionEvaluator.singAsInC(value1) != 0 == (Boolean)value2;
        }
        if (value1 instanceof Number && value2 instanceof Number) {
            return OCNumber.valueOf(value1).compareTo(OCNumber.valueOf(value2)) == 0;
        }
        return Comparing.equal((Object)value1, (Object)value2);
    }

    private boolean isMagicType() {
        return !(this.myArgument instanceof OCType) || this.myArgument instanceof OCMagicType;
    }

    private UnificationResult defaultResult() {
        if (this.isMagicType()) {
            return this.myMagicTypesEqual ? UNKNOWN : NOT_UNIFIED;
        }
        return this.myFunctionParametersMode ? UNKNOWN : NOT_UNIFIED;
    }

    @Override
    public UnificationResult visitFunctionType(OCFunctionType type) {
        if (this.myArgument instanceof OCFunctionType) {
            OCFunctionType argumentFunction = (OCFunctionType)this.myArgument;
            List<? extends OCType> funTypes = type.getParameterTypes();
            List<? extends OCType> argTypes = argumentFunction.getParameterTypes();
            int paramsCnt = funTypes.size();
            int argumentsCnt = argTypes.size();
            if (type.isVararg()) {
                --paramsCnt;
            }
            if (paramsCnt == argumentsCnt || type.isVararg() && argumentsCnt >= paramsCnt) {
                UnificationResult result2 = UNIFIED;
                UnificationResult cur = this.unify(type.getReturnType(), argumentFunction.getReturnType());
                if (cur == NOT_UNIFIED) {
                    return cur;
                }
                result2 = result2.add(cur);
                for (int i = 0; i < Math.min(argumentsCnt, paramsCnt); ++i) {
                    cur = this.unify(funTypes.get(i), argTypes.get(i));
                    if (cur == NOT_UNIFIED) {
                        return cur;
                    }
                    result2 = result2.add(cur);
                }
                return result2;
            }
        }
        return this.defaultResult();
    }

    @Override
    public UnificationResult visitMagicType(OCMagicType type) {
        return UNKNOWN;
    }

    @Override
    public UnificationResult visitObjectType(OCObjectType type) {
        return UNKNOWN;
    }

    @Override
    public UnificationResult visitArrayType(OCArrayType type) {
        if (this.myArgument instanceof OCArrayType) {
            UnificationResult cur = this.unify(type.getRefType(), ((OCArrayType)this.myArgument).getRefType());
            if (cur == NOT_UNIFIED) {
                return cur;
            }
            return cur.add(UNIFIED);
        }
        return this.defaultResult();
    }

    @Override
    public UnificationResult visitPointerType(OCPointerType type) {
        if (this.myArgument instanceof OCPointerType) {
            UnificationResult cur = this.unify(type.getRefType(), ((OCPointerType)this.myArgument).getRefType());
            if (cur == NOT_UNIFIED) {
                return cur;
            }
            return cur.add(UNIFIED);
        }
        return this.defaultResult();
    }

    @Override
    public UnificationResult visitBlockPointerType(OCBlockPointerType type) {
        if (this.myArgument instanceof OCBlockPointerType) {
            UnificationResult cur = this.unify(type.getRefType(), ((OCBlockPointerType)this.myArgument).getRefType());
            if (cur == NOT_UNIFIED) {
                return cur;
            }
            return cur.add(UNIFIED);
        }
        return this.defaultResult();
    }

    @Override
    public UnificationResult visitCppReferenceType(OCCppReferenceType type) {
        if (this.myArgument instanceof OCCppReferenceType) {
            OCCppReferenceType argument = (OCCppReferenceType)this.myArgument;
            if (type.isRvalueRef() == argument.isRvalueRef()) {
                UnificationResult cur = this.unify(type.getRefType(), argument.getRefType());
                if (cur == NOT_UNIFIED) {
                    return cur;
                }
                return cur.add(UNIFIED);
            }
        }
        return this.defaultResult();
    }

    @Override
    public UnificationResult visitIdType(OCIdType type) {
        return UNKNOWN;
    }

    @Override
    public UnificationResult visitReferenceType(OCReferenceType type) {
        return UNKNOWN;
    }

    @Override
    public UnificationResult visitUnknownType(OCUnknownType type) {
        return UNKNOWN;
    }

    @Override
    public UnificationResult visitAutoType(OCAutoType type) {
        return UNKNOWN;
    }

    @Override
    public UnificationResult visitEllipsisReferenceType(OCEllipsisType type) {
        return this.myArgument instanceof OCEllipsisType ? UNIFIED : this.defaultResult();
    }

    @Override
    public UnificationResult visitIntType(OCIntType type) {
        return this.myArgument.equals(type, this.myContext) ? UNIFIED : this.defaultResult();
    }

    @Override
    public UnificationResult visitRealType(OCRealType type) {
        return this.myArgument.equals(type, this.myContext) ? UNIFIED : this.defaultResult();
    }

    @Override
    public UnificationResult visitVoidType(OCVoidType type) {
        return this.myArgument.equals(type, this.myContext) ? UNIFIED : this.defaultResult();
    }

    @Nullable
    private OCType findMatchingAncestor(OCType argumentType, OCStructType paramType) {
        if (argumentType instanceof OCMagicType || argumentType instanceof OCStructType && ((OCStructType)argumentType).getSymbol().resolvedNamesEqual(paramType.getSymbol())) {
            return argumentType;
        }
        if (this.myFunctionParametersMode && argumentType instanceof OCStructType) {
            for (final OCStructSymbol paramSymbol : paramType.getStructs()) {
                for (OCStructSymbol argumentSymbol : ((OCStructType)argumentType).getStructs()) {
                    final Ref result2 = new Ref();
                    argumentSymbol.processAllBaseClasses(this.myContext, new OCStructSymbol.BaseClassProcessor(){

                        @Override
                        public boolean process(OCSymbol baseSymbol, OCVisibility visibility) {
                            if (baseSymbol instanceof OCStructSymbol && ((OCStructSymbol)baseSymbol).resolvedNamesEqual(paramSymbol)) {
                                if (!result2.isNull()) {
                                    result2.set(null);
                                    return false;
                                }
                                result2.set((Object)baseSymbol.getType());
                            }
                            if (baseSymbol instanceof OCTypeParameterSymbol) {
                                result2.set((Object)new OCMagicType());
                            }
                            return true;
                        }
                    }, false);
                    if (result2.isNull()) continue;
                    return (OCType)result2.get();
                }
            }
        }
        return null;
    }

    @Override
    public UnificationResult visitStructType(OCStructType type) {
        OCType argumentType;
        OCType oCType = argumentType = this.myArgument instanceof OCStructType ? this.findMatchingAncestor((OCStructType)this.myArgument, type) : null;
        if (argumentType == null) {
            return this.defaultResult();
        }
        UnificationResult result2 = UNIFIED;
        if (argumentType instanceof OCStructType) {
            List<OCTypeArgument> thatStructArgs = type.getSymbol().getTemplateArguments(this.myContext);
            List<OCTypeArgument> myStructArgs = ((OCStructType)argumentType).getSymbol().getTemplateArguments(this.myContext);
            if (thatStructArgs.size() == myStructArgs.size()) {
                Iterator thatIterator = thatStructArgs.iterator();
                Iterator myIterator = myStructArgs.iterator();
                while (thatIterator.hasNext() && myIterator.hasNext()) {
                    OCTypeArgument thatSubst = (OCTypeArgument)thatIterator.next();
                    OCTypeArgument mySubst = (OCTypeArgument)myIterator.next();
                    if (mySubst == null || thatSubst == null) continue;
                    boolean save = this.myFunctionParametersMode;
                    this.myFunctionParametersMode = false;
                    UnificationResult cur = this.unify(thatSubst, mySubst);
                    this.myFunctionParametersMode = save;
                    if (cur == NOT_UNIFIED) {
                        return cur;
                    }
                    result2.add(result2);
                }
            }
        }
        return result2;
    }

    @Override
    public UnificationResult visitTypeParameterType(OCTypeParameterType type) {
        if (this.myArgument instanceof OCTypeParameterType && ((OCTypeParameterType)this.myArgument).getSymbol().equals(type.getSymbol())) {
            return UNIFIED;
        }
        if (type.getSymbol() instanceof OCTypeParameterValueSymbol ? !(this.myArgument instanceof OCExpressionTypeArgument) : this.isMagicType() && !(this.myArgument instanceof OCTypeParameterType)) {
            return UNKNOWN;
        }
        OCTypeArgument old = this.mySubstitutionMap.get(type.getSymbol());
        if (old != null) {
            boolean equal;
            boolean bl = equal = old instanceof OCType && this.myArgument instanceof OCType ? new OCTypeEqualityVisitor((OCType)old, this.myMagicTypesEqual, false, false, false, true, true, this.myContext).equal((OCType)this.myArgument) : old.equals(this.myArgument, this.myContext);
            if (!equal) {
                return NOT_UNIFIED;
            }
        }
        this.mySubstitutionMap.put(type.getSymbol(), this.myArgument);
        return UNKNOWN;
    }

    @Override
    public UnificationResult visitNull() {
        return null;
    }

    public static class UnificationResult {
        private final int numOfUnified;
        private int numOfNonSpecializedArgs;

        UnificationResult(int numOfUnified) {
            this.numOfUnified = numOfUnified;
        }

        public UnificationResult(int numOfUnified, int numOfNonSpecializedArgs) {
            this.numOfUnified = numOfUnified;
            this.numOfNonSpecializedArgs = numOfNonSpecializedArgs;
        }

        UnificationResult add(UnificationResult result2) {
            if (this == NOT_UNIFIED || result2 == NOT_UNIFIED) {
                return NOT_UNIFIED;
            }
            return new UnificationResult(this.numOfUnified + result2.numOfUnified, this.numOfNonSpecializedArgs + result2.numOfNonSpecializedArgs);
        }

        void incNumOfNonSpecializedArgs() {
            ++this.numOfNonSpecializedArgs;
        }

        public boolean isUnified() {
            return this.numOfUnified > 0;
        }

        boolean isBetter(UnificationResult other) {
            return this.numOfUnified > other.numOfUnified || this.numOfUnified == other.numOfUnified && this.numOfNonSpecializedArgs < other.numOfNonSpecializedArgs;
        }

        public String toString() {
            if (this == UNIFIED) {
                return "UNIFIED";
            }
            if (this == NOT_UNIFIED) {
                return "NOT_UNIFIED";
            }
            if (this == UNKNOWN) {
                return "UNKNOWN";
            }
            return "UnificationResult(" + this.numOfUnified + ")";
        }
    }
}

