/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types.visitors;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.HashSet;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.quickfixes.OCSetSuperclassIntentionAction;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OCTypeCompatibilityVisitor_OCIdType
extends OCTypeCompatibilityVisitor<OCIdType> {
    protected OCTypeCompatibilityVisitor_OCIdType(@NotNull OCIdType sourceType, OCExpression source, @Nullable PsiElement context, Set<OCType> processed, boolean allowImplicitConversions, boolean assumeNullSubstitutionsEquals, @NotNull OCResolveContext resolveContext) {
        if (sourceType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceType", "com/jetbrains/cidr/lang/types/visitors/OCTypeCompatibilityVisitor_OCIdType", "<init>"));
        }
        if (resolveContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveContext", "com/jetbrains/cidr/lang/types/visitors/OCTypeCompatibilityVisitor_OCIdType", "<init>"));
        }
        super(sourceType, source, context, processed, allowImplicitConversions, assumeNullSubstitutionsEquals, resolveContext);
    }

    @Override
    public OCType.TypeCheckResult visitFunctionType(OCFunctionType type) {
        return this.visitType(type);
    }

    @Override
    public OCType.TypeCheckResult visitObjectType(final OCObjectType type) {
        HashSet protocols = new HashSet(((OCIdType)this.mySourceType).getAllProtocols());
        if (!(type instanceof OCIdType)) {
            protocols.removeAll(type.getAllProtocols());
        }
        if (protocols.isEmpty()) {
            return OK_RESULT;
        }
        if (!type.isAncestorOf((OCObjectType)this.mySourceType)) {
            return new OCType.TypeCheckResult(OCType.TypeCheckState.WARNING, OCInspections.NotSuperclass.class, "CIDR", new IntentionAction[]{new OCSetSuperclassIntentionAction(((OCIdType)this.mySourceType).getInterface(), type.getInterface(), null)}){

                @Override
                public String getMessage() {
                    return "Interface '" + OCTypeCompatibilityVisitor_OCIdType.this.getSourceTypeName() + "' is not a successor of '" + type.getName(OCTypeCompatibilityVisitor_OCIdType.this.myContext) + "'";
                }
            };
        }
        return this.getProtocolCompatibilityCheckResult((OCObjectType)this.mySourceType, type);
    }

    @Override
    public OCType.TypeCheckResult visitPointerType(OCPointerType type) {
        return this.visitType(type);
    }

    @Override
    public OCType.TypeCheckResult visitStructType(OCStructType type) {
        return this.checkStructCompatibleCtor(type);
    }
}

