/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types.visitors;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.quickfixes.OCChangeTypeIntentionAction;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerHelper;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OCTypeCompatibilityVisitor_OCFunctionType
extends OCTypeCompatibilityVisitor<OCFunctionType> {
    protected OCTypeCompatibilityVisitor_OCFunctionType(@NotNull OCFunctionType sourceType, OCExpression source, @Nullable PsiElement context, Set<OCType> processed, boolean allowImplicitConversions, boolean assumeNullSubstitutionsEquals, @NotNull OCResolveContext resolveContext) {
        if (sourceType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceType", "com/jetbrains/cidr/lang/types/visitors/OCTypeCompatibilityVisitor_OCFunctionType", "<init>"));
        }
        if (resolveContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveContext", "com/jetbrains/cidr/lang/types/visitors/OCTypeCompatibilityVisitor_OCFunctionType", "<init>"));
        }
        super(sourceType, source, context, processed, allowImplicitConversions, assumeNullSubstitutionsEquals, resolveContext);
    }

    @Override
    public OCType.TypeCheckResult visitFunctionType(final OCFunctionType type) {
        final OCFunctionType functionType = (OCFunctionType)this.mySourceType;
        if (!this.isSuperTypeForFunctionChecks(type.getReturnType(), functionType.getReturnType())) {
            OCTypeElement annotationElement = null;
            OCSymbol blockSymbol = null;
            if (this.mySource instanceof OCBlockExpression) {
                annotationElement = ((OCBlockExpression)this.mySource).getReturnTypeElement();
                blockSymbol = ((OCBlockExpression)this.mySource).getSymbol();
            }
            return new OCType.TypeCheckResult(OCType.TypeCheckState.WARNING, OCInspections.IncompatiblePointers.class, "ext_typecheck_convert_incompatible_pointer", annotationElement, new IntentionAction[]{new OCChangeTypeIntentionAction(blockSymbol, type.getReturnType(), true)}){

                @Override
                public String getMessage() {
                    return "Incompatible function return types '" + type.getReturnType().getName(OCTypeCompatibilityVisitor_OCFunctionType.this.myContext) + "' and '" + functionType.getReturnType().getName(OCTypeCompatibilityVisitor_OCFunctionType.this.myContext) + "'";
                }
            };
        }
        if (OCCodeInsightUtil.isInPlainOldC(this.mySource) && type.getParameterTypes(true).isEmpty()) {
            return OK_RESULT;
        }
        if (type.getParameterTypes().size() != functionType.getParameterTypes().size()) {
            return new OCType.TypeCheckResult(OCType.TypeCheckState.WARNING, "Incompatible number of arguments in function types", OCInspections.IncompatiblePointers.class, "CIDRincompatible-function-pointer-arguments", new IntentionAction[0]);
        }
        for (int i = 0; i < type.getParameterTypes().size(); ++i) {
            List<OCDeclarator> parameters;
            final OCType selfArgumentType = type.getParameterTypes().get(i);
            final OCType hisArgumentType = functionType.getParameterTypes().get(i);
            if (this.isSuperTypeForFunctionChecks(hisArgumentType, selfArgumentType)) continue;
            PsiElement annotationElement = null;
            OCSymbol parameterSymbol = null;
            if (this.mySource instanceof OCBlockExpression && (parameters = ((OCBlockExpression)this.mySource).getParameters()) != null && parameters.size() == type.getParameterTypes().size()) {
                parameterSymbol = parameters.get(i).getSymbol();
                annotationElement = parameters.get(i).getParent();
            }
            return new OCType.TypeCheckResult(OCType.TypeCheckState.WARNING, OCInspections.IncompatiblePointers.class, "CIDRincompatible-function-pointer-arguments", annotationElement, new IntentionAction[]{new OCChangeTypeIntentionAction(parameterSymbol, selfArgumentType)}){

                @Override
                public String getMessage() {
                    return "Incompatible function parameter types '" + selfArgumentType.getName(OCTypeCompatibilityVisitor_OCFunctionType.this.myContext) + "' and '" + hisArgumentType.getName(OCTypeCompatibilityVisitor_OCFunctionType.this.myContext) + "'";
                }
            };
        }
        return OK_RESULT;
    }

    @Override
    public OCType.TypeCheckResult visitObjectType(OCObjectType type) {
        return this.visitType(type);
    }

    @Override
    public OCType.TypeCheckResult visitPointerType(final OCPointerType type) {
        OCType.TypeCheckResult result2;
        OCType lTerminalType = type.getTerminalType();
        if (!lTerminalType.isUnknown() && !(lTerminalType instanceof OCFunctionType) && type.isPointerToPointerToObjectCompatible() && OCCompilerHelper.isArcEnabled(this.myContext.getContainingFile()) && (result2 = this.checkArcBridgeCast(type, false)) != null) {
            return result2;
        }
        boolean isCpp = ((OCFile)this.myContext.getContainingFile()).isCpp();
        if (type.getRefType() instanceof OCFunctionType && !(type instanceof OCBlockPointerType)) {
            return type.getRefType().checkCompatible(this.mySourceType, this.mySource, this.myContext);
        }
        if (type.isPointerToVoid() && !isCpp) {
            return OK_RESULT;
        }
        return new OCType.TypeCheckResult(OCType.TypeCheckState.ERROR_IF_CPP, OCInspections.IncompatiblePointers.class, "ext_typecheck_convert_incompatible_pointer", new IntentionAction[0]){

            @Override
            public String getMessage() {
                return "Incompatible pointer types '" + type.getName(OCTypeCompatibilityVisitor_OCFunctionType.this.myResolveContext) + "' and '" + OCTypeCompatibilityVisitor_OCFunctionType.this.getSourceTypeName() + "'";
            }
        };
    }

    @Override
    public OCType.TypeCheckResult visitStructType(final OCStructType type) {
        if (type.getKind() == OCSymbolKind.ENUM && !type.isEnumClass()) {
            Computable<String> message = new Computable<String>(){

                public String compute() {
                    return "Taking enum type '" + type.getBestNameInContext(OCTypeCompatibilityVisitor_OCFunctionType.this.myContext) + "' from pointer";
                }
            };
            return this.checkAssignToEnum(type, message);
        }
        return this.checkStructCompatibleCtor(type);
    }
}

