/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types.visitors;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.psi.OCCastExpression;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCTollFreeBridges;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerHelper;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OCTypeCompatibilityVisitor_OCArrayType
extends OCTypeCompatibilityVisitor<OCArrayType> {
    protected OCTypeCompatibilityVisitor_OCArrayType(@NotNull OCArrayType sourceType, OCExpression source, @Nullable PsiElement context, Set<OCType> processed, boolean allowImplicitConversions, boolean assumeNullSubstitutionsEquals, @NotNull OCResolveContext resolveContext) {
        if (sourceType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceType", "com/jetbrains/cidr/lang/types/visitors/OCTypeCompatibilityVisitor_OCArrayType", "<init>"));
        }
        if (resolveContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveContext", "com/jetbrains/cidr/lang/types/visitors/OCTypeCompatibilityVisitor_OCArrayType", "<init>"));
        }
        super(sourceType, source, context, processed, allowImplicitConversions, assumeNullSubstitutionsEquals, resolveContext);
    }

    @Override
    public OCType.TypeCheckResult visitFunctionType(final OCFunctionType type) {
        return new OCType.TypeCheckResult(OCType.TypeCheckState.ERROR_IF_CPP, OCInspections.IncompatiblePointers.class, "ext_typecheck_convert_incompatible_pointer", new IntentionAction[0]){

            @Override
            public String getMessage() {
                return "Incompatible pointer types '" + type.getName(OCTypeCompatibilityVisitor_OCArrayType.this.myContext) + "' and '" + OCTypeCompatibilityVisitor_OCArrayType.this.getSourceTypeName() + "'";
            }
        };
    }

    @Override
    public OCType.TypeCheckResult visitObjectType(OCObjectType type) {
        return this.visitType(type);
    }

    @Override
    public OCType.TypeCheckResult visitPointerType(final OCPointerType type) {
        OCType lTerminalType = type.getTerminalType();
        OCType rTerminalType = ((OCArrayType)this.mySourceType).getTerminalType();
        int lPointersDepth = type.pointersDepth();
        int rPointersDepth = ((OCArrayType)this.mySourceType).pointersDepth();
        if (!(lTerminalType.isUnknown() || rTerminalType.isUnknown() || lTerminalType instanceof OCFunctionType && rTerminalType instanceof OCFunctionType || !(type.isPointerToPointerToObjectCompatible() ^ ((OCArrayType)this.mySourceType).isPointerToPointerToObjectCompatible()))) {
            boolean isTollFreeBridge = OCTollFreeBridges.isCompatible(type, this.mySourceType);
            if (OCCompilerHelper.isArcEnabled(this.myContext.getContainingFile())) {
                OCType.TypeCheckResult result2 = this.checkArcBridgeCast(type, isTollFreeBridge);
                if (result2 != null) {
                    return result2;
                }
            } else if (isTollFreeBridge) {
                return OK_RESULT;
            }
        }
        OCType.TypeCheckResult checkResult = type.validateConstPointers(this.mySourceType, this.myContext);
        boolean isCpp = ((OCFile)this.myContext.getContainingFile()).isCpp();
        if (!checkResult.getState().isError(this.myContext)) {
            return checkResult;
        }
        if (lTerminalType instanceof OCObjectType && rTerminalType instanceof OCObjectType && type.getRefType().isCompatible(((OCArrayType)this.mySourceType).getRefType(), this.myContext)) {
            return OK_RESULT;
        }
        if (type.isPointerToVoid() && !isCpp) {
            return OK_RESULT;
        }
        if (((OCArrayType)this.mySourceType).isPointerToVoid() && !isCpp) {
            return OK_RESULT;
        }
        if (lTerminalType instanceof OCObjectType && rTerminalType instanceof OCObjectType && lPointersDepth == rPointersDepth) {
            return type.getRefType().checkCompatible(((OCArrayType)this.mySourceType).getRefType(), this.mySource, this.myContext);
        }
        if (lTerminalType instanceof OCMagicType) {
            return OK_RESULT;
        }
        if (this.isCppClassType(lTerminalType) && this.isCppClassType(rTerminalType) && lPointersDepth == rPointersDepth) {
            OCType.TypeCheckResult result3 = type.getRefType().checkCompatible(((OCArrayType)this.mySourceType).getRefType(), this.mySource, this.myContext);
            if ((!isCpp || this.myContext instanceof OCCastExpression) && result3.getState().isError(this.myContext)) {
                result3.setState(OCType.TypeCheckState.WARNING);
            }
            return result3;
        }
        if (lTerminalType instanceof OCFunctionType && rTerminalType instanceof OCFunctionType && lPointersDepth == rPointersDepth) {
            return type.getRefType().checkCompatible(((OCArrayType)this.mySourceType).getRefType(), this.mySource, this.myContext);
        }
        if (type.getRefType() instanceof OCIdType && ((OCIdType)type.getRefType()).getAllProtocols().isEmpty() && ((OCArrayType)this.mySourceType).isPointerToObjectCompatible() || type.isPointerToObjectCompatible() && ((OCArrayType)this.mySourceType).isPointerToID() && ((OCArrayType)this.mySourceType).getTerminalType() instanceof OCObjectType && ((OCObjectType)((OCArrayType)this.mySourceType).getTerminalType()).getAllProtocols().isEmpty()) {
            return OK_RESULT;
        }
        if ((lTerminalType instanceof OCReferenceType || rTerminalType instanceof OCReferenceType) && type.getCanonicalName(this.myContext).equals(((OCArrayType)this.mySourceType).getCanonicalName(this.myContext))) {
            return OK_RESULT;
        }
        OCExpression innerSource = OCParenthesesUtils.diveIntoParentheses(this.mySource);
        if (isCpp && lPointersDepth == 1 && rPointersDepth == 1 && innerSource instanceof OCLiteralExpression && lTerminalType instanceof OCIntType && rTerminalType instanceof OCIntType) {
            boolean bothChars = this.bothTypesEquals(OCIntType.CHAR, lTerminalType, rTerminalType);
            boolean bothWide = this.bothTypesEquals(OCIntType.WCHAR, lTerminalType, rTerminalType);
            boolean bothChar16 = this.bothTypesEquals(OCIntType.CHAR16, lTerminalType, rTerminalType);
            boolean bothChar32 = this.bothTypesEquals(OCIntType.CHAR32, lTerminalType, rTerminalType);
            if ((bothChars || bothWide || bothChar16 || bothChar32) && !lTerminalType.isConst() && rTerminalType.isConst()) {
                return new OCType.TypeCheckResult(OCType.TypeCheckState.WARNING, OCInspections.IncompatiblePointers.class, "ext_deprecated_string_literal_conversion", new IntentionAction[0]){

                    @Override
                    public String getMessage() {
                        return "Deprecated conversion from string literal to '" + type.getName(OCTypeCompatibilityVisitor_OCArrayType.this.myResolveContext) + "'";
                    }
                };
            }
        }
        return new OCType.TypeCheckResult(OCType.TypeCheckState.ERROR_IF_CPP, OCInspections.IncompatiblePointers.class, "ext_typecheck_convert_incompatible_pointer", new IntentionAction[0]){

            @Override
            public String getMessage() {
                return "Incompatible pointer types '" + type.getName(OCTypeCompatibilityVisitor_OCArrayType.this.myResolveContext) + "' and '" + OCTypeCompatibilityVisitor_OCArrayType.this.getSourceTypeName() + "'";
            }
        };
    }

    @Override
    public OCType.TypeCheckResult visitArrayType(OCArrayType type) {
        OCType.TypeCheckResult result2 = this.checkAssignPointerToArray(type);
        return result2 != null ? result2 : super.visitArrayType(type);
    }

    @Override
    public OCType.TypeCheckResult visitStructType(final OCStructType type) {
        if (OCTollFreeBridges.isCompatible(this.mySourceType, type)) {
            return OK_RESULT;
        }
        if (type.getKind() == OCSymbolKind.ENUM && !type.isEnumClass()) {
            Computable<String> message = new Computable<String>(){

                public String compute() {
                    return "Taking enum type '" + type.getBestNameInContext(OCTypeCompatibilityVisitor_OCArrayType.this.myContext) + "' from pointer";
                }
            };
            return this.checkAssignToEnum(type, message);
        }
        return this.checkStructCompatibleCtor(type);
    }
}

