/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types.visitors;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.Annotation;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.OCArgumentsChecker;
import com.jetbrains.cidr.lang.daemon.OCCppChecker;
import com.jetbrains.cidr.lang.daemon.OCLValueVisitor;
import com.jetbrains.cidr.lang.inspections.OCInspection;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCastExpression;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.quickfixes.OCAddSuperProtocolIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangeElementIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangeTextIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCCreateNewDefinitionIntentionAction;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCLiteralExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCEllipsisType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCNumericType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor_AlwaysOk;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor_OCArrayType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor_OCAutoType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor_OCBlockPointerType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor_OCEllipsisType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor_OCFunctionType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor_OCIdType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor_OCIntType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor_OCObjectType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor_OCPointerType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor_OCRealType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor_OCReferenceType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor_OCStructType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor_OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityAfterResolvingVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCExpectedTypeUtil;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import com.jetbrains.cidr.lang.util.OCNumber;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCTypeCompatibilityVisitor<T extends OCType>
implements OCTypeVisitor<OCType.TypeCheckResult> {
    public static final OCType.TypeCheckResult OK_RESULT = new OCType.TypeCheckResult(OCType.TypeCheckState.OK);
    protected final Set<OCType> myProcessed;
    @NotNull
    protected final T mySourceType;
    protected final OCExpression mySource;
    @Nullable
    protected final PsiElement myContext;
    protected final boolean myAllowImplicitConversions;
    protected final boolean myAssumeNullSubstitutionsEquals;
    @NotNull
    protected final OCResolveContext myResolveContext;

    public static OCType.TypeCheckResult checkConvertible(OCType destType, OCType sourceType, @Nullable OCExpression source, @Nullable OCExpressionSymbol sourceExprSymbol, @Nullable PsiElement context, Set<OCType> processed, boolean allowImplicitConversions, boolean assumeNullSubstitutionsEquals, @NotNull OCResolveContext resolveContext) {
        OCType.TypeCheckResult result2;
        if (resolveContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveContext", "com/jetbrains/cidr/lang/types/visitors/OCTypeCompatibilityVisitor", "checkConvertible"));
        }
        boolean usingZeroAsNil = false;
        if (sourceType instanceof OCIntType) {
            if (source instanceof OCLiteralExpression) {
                sourceType = source.getResolvedType();
            }
            OCPointerType destTypePtr = null;
            if (destType instanceof OCPointerType) {
                destTypePtr = (OCPointerType)destType;
            } else if (destType instanceof OCCppReferenceType && ((OCCppReferenceType)destType).getRefType() instanceof OCPointerType) {
                destTypePtr = (OCPointerType)((OCCppReferenceType)destType).getRefType();
            }
            if (destTypePtr != null) {
                Object value;
                OCType pointerType = OCExpressionEvaluator.getPointerType(source, resolveContext);
                if (pointerType instanceof OCUnknownType || sourceExprSymbol instanceof OCLiteralExpressionSymbol && (value = OCExpressionEvaluator.evaluate(sourceExprSymbol, resolveContext)) != null && OCExpressionEvaluator.singAsInC(value) == 0) {
                    if (destTypePtr.isPointerToPointerToObjectCompatible()) {
                        usingZeroAsNil = true;
                    } else if (!(destTypePtr instanceof OCArrayType) || !((OCArrayType)destTypePtr).hasLength()) {
                        return OK_RESULT;
                    }
                } else if (pointerType != null) {
                    sourceType = pointerType;
                }
            }
        } else if (sourceType.isPointerToVoid() && OCExpressionEvaluator.isLikeNil(source, resolveContext)) {
            sourceType = destType;
        }
        if (source instanceof OCCompoundInitializer) {
            return OCTypeCompatibilityVisitor.checkCompoundInitializer((OCCompoundInitializer)source, destType, allowImplicitConversions, resolveContext);
        }
        OCTypeCompatibilityVisitor<OCType> visitor = OCTypeCompatibilityVisitor.createOCTypeCompatibilityVisitor(sourceType, source, context, processed, allowImplicitConversions, assumeNullSubstitutionsEquals, resolveContext);
        OCType.TypeCheckResult check = destType.accept(visitor);
        if (check.getState() == OCType.TypeCheckState.OK) {
            return check;
        }
        if (usingZeroAsNil && source != null) {
            if (OCCodeInsightUtil.isLikeNull(source.getTextWithMacros())) {
                return OK_RESULT;
            }
            result2 = new OCType.TypeCheckResult(OCType.TypeCheckState.WARNING, "Using zero as nil", OCInspections.UsingZeroAsNil.class, "CIDR", new IntentionAction[0]);
            TextRange range = OCElementUtil.getRangeWithMacros(source);
            OCChangeTextIntentionAction fix = new OCChangeTextIntentionAction(source.getContainingFile(), range.getStartOffset(), range.getLength(), "nil", "Change to 'nil'");
            result2.setQuickFixes(new IntentionAction[]{fix});
            return result2;
        }
        if (allowImplicitConversions && visitor.mySourceType instanceof OCStructType && (result2 = OCTypeCompatibilityVisitor.checkConversionOperators(destType, (OCStructType)visitor.mySourceType, visitor.mySource, visitor.myContext, check, context instanceof OCCastExpression, visitor.myProcessed, resolveContext)) != null) {
            return result2;
        }
        return check;
    }

    public static OCType.TypeCheckResult checkConversionOperators(final OCType destType, OCStructType sourceType, final OCExpression source, final PsiElement context, OCType.TypeCheckResult bestResult, final boolean isExplicitCast, final Set<OCType> processed, final @NotNull OCResolveContext resolveContext) {
        if (resolveContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveContext", "com/jetbrains/cidr/lang/types/visitors/OCTypeCompatibilityVisitor", "checkConversionOperators"));
        }
        final Ref result2 = Ref.create((Object)bestResult);
        if (sourceType.isSubclassOfMagic(source)) {
            return OK_RESULT;
        }
        sourceType.processMembers(null, new Processor<OCSymbol>(){

            public boolean process(OCSymbol symbol) {
                if (!(symbol instanceof OCFunctionSymbol) || !((OCFunctionSymbol)symbol).isCppConversionOperator() || !isExplicitCast && ((OCFunctionSymbol)symbol).isExplicit()) {
                    return true;
                }
                OCType returnType = symbol.getEffectiveResolvedType();
                if (destType instanceof OCCppReferenceType && ((OCCppReferenceType)destType).getRefType().isScalar() && !(returnType instanceof OCCppReferenceType)) {
                    return true;
                }
                OCTypeCompatibilityVisitor<OCType> visitor1 = OCTypeCompatibilityVisitor.createOCTypeCompatibilityVisitor(returnType, source, context, processed, false, true, resolveContext);
                final OCType.TypeCheckResult curResult = destType.accept(visitor1);
                if (curResult.getState().compareTo(((OCType.TypeCheckResult)result2.get()).getState()) < 0 || curResult.getState() == ((OCType.TypeCheckResult)result2.get()).getState() && OCTypeCompatibilityVisitor.getTypesDifference(returnType, destType, resolveContext) < OCTypeCompatibilityVisitor.getTypesDifference(((OCType.TypeCheckResult)result2.get()).getTypeAfterConversion(), destType, resolveContext)) {
                    if (curResult.getState() == OCType.TypeCheckState.OK) {
                        OCType.TypeCheckResult newResult = new OCType.TypeCheckResult(OCType.TypeCheckState.OK, curResult.getInspectionClass(), curResult.getClangID(), true, returnType, new IntentionAction[0]){

                            @Override
                            public String getMessage() {
                                return curResult.getMessage();
                            }
                        };
                        newResult.setImplicitConstructor((OCFunctionSymbol)symbol);
                        result2.set((Object)newResult);
                    } else {
                        result2.set((Object)curResult);
                    }
                }
                return true;
            }
        }, resolveContext);
        return (OCType.TypeCheckResult)result2.get();
    }

    protected OCTypeCompatibilityVisitor(@NotNull T sourceType, OCExpression source, @Nullable PsiElement context, Set<OCType> processed, boolean allowImplicitConversions, boolean assumeNullSubstitutionsEquals, @NotNull OCResolveContext resolveContext) {
        if (sourceType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceType", "com/jetbrains/cidr/lang/types/visitors/OCTypeCompatibilityVisitor", "<init>"));
        }
        if (resolveContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveContext", "com/jetbrains/cidr/lang/types/visitors/OCTypeCompatibilityVisitor", "<init>"));
        }
        this.mySourceType = sourceType;
        this.myResolveContext = resolveContext;
        this.mySource = source;
        this.myContext = context;
        this.myProcessed = processed;
        this.myAllowImplicitConversions = allowImplicitConversions;
        this.myAssumeNullSubstitutionsEquals = assumeNullSubstitutionsEquals;
    }

    public static OCTypeCompatibilityVisitor<? extends OCType> createOCTypeCompatibilityVisitor(@Nullable OCType sourceType, OCExpression source, @Nullable PsiElement context, Set<OCType> processed, boolean allowImplicitConversions, boolean assumeNullSubstitutionsEquals, @NotNull OCResolveContext resolveContext) {
        if (resolveContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveContext", "com/jetbrains/cidr/lang/types/visitors/OCTypeCompatibilityVisitor", "createOCTypeCompatibilityVisitor"));
        }
        if (sourceType == null) {
            sourceType = OCUnknownType.INSTANCE;
        }
        return sourceType.accept(new OCTypeCompatibilityVisitorCreator(source, context, processed, allowImplicitConversions, assumeNullSubstitutionsEquals, resolveContext));
    }

    @Override
    public OCType.TypeCheckResult visitCppReferenceType(final OCCppReferenceType type) {
        if (!(this.mySource == null || type.isReferenceToConst() || type.isRvalueRef() || OCLValueVisitor.isLvalue(this.mySource))) {
            return new OCType.TypeCheckResult(OCType.TypeCheckState.ERROR, "Expression must be lvalue", OCInspections.NotAssignable.class, "err_typecheck_convert_incompatible", new IntentionAction[0]);
        }
        if (this.mySource != null && type.isRvalueRef() && OCLValueVisitor.isLvalue(this.mySource)) {
            return new OCType.TypeCheckResult(OCType.TypeCheckState.ERROR, "Expression must be rvalue", OCInspections.NotAssignable.class, "err_typecheck_convert_incompatible", new IntentionAction[0]);
        }
        OCType refType = type.getRefType();
        if (((OCType)this.mySourceType).isConst() && !refType.isConst()) {
            return new OCType.TypeCheckResult(OCType.TypeCheckState.ERROR_IF_CPP, OCInspections.IncompatibleTypes.class, "err_typecheck_convert_incompatible", new IntentionAction[0]){

                @Override
                public String getMessage() {
                    return "Binding '" + OCTypeCompatibilityVisitor.this.getSourceTypeName() + "' to non-const reference";
                }
            };
        }
        if (!(!refType.isScalar() && !((OCType)this.mySourceType).isScalar() || refType.isConst() || type.isRvalueRef() || refType instanceof OCEllipsisType || this.myContext instanceof OCCastExpression)) {
            if (refType.equals(this.mySourceType, false, this.myResolveContext)) {
                return OK_RESULT;
            }
            return new OCType.TypeCheckResult(OCType.TypeCheckState.ERROR_IF_CPP, OCInspections.IncompatibleTypes.class, "err_typecheck_convert_incompatible", new IntentionAction[0]){

                @Override
                public String getMessage() {
                    return "Incompatible types '" + type.getName(OCTypeCompatibilityVisitor.this.myResolveContext) + "' and '" + OCTypeCompatibilityVisitor.this.getSourceTypeName() + "'";
                }
            };
        }
        return this.checkRefType(type);
    }

    protected OCType.TypeCheckResult checkRefType(OCCppReferenceType type) {
        return type.getRefType().accept(this);
    }

    public static int getTypesDifference(@Nullable OCType type1, @Nullable OCType type2, @NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/types/visitors/OCTypeCompatibilityVisitor", "getTypesDifference"));
        }
        if (type1 == null || type2 == null) {
            return -1;
        }
        if (!(type2.getClass().equals(type1.getClass()) || type1.equals((Object)OCIntType.INT, context) && type2 instanceof OCStructType && ((OCStructType)type2).isEnum() || type2.equals((Object)OCIntType.INT, context) && type1 instanceof OCStructType && ((OCStructType)type1).isEnum())) {
            return 1000;
        }
        if (!type2.equals((Object)type1, context)) {
            return type1.isUnknown() || type1.isMagicInside(context) ? 10 : 20;
        }
        return 0;
    }

    protected boolean bothTypesEquals(OCType type, OCType firstType, OCType secondType) {
        return type.equals(firstType, false, this.myResolveContext) && type.equals(secondType, false, this.myResolveContext);
    }

    protected OCType.TypeCheckResult visitType(final OCType type) {
        boolean unknown;
        if (this.mySourceType instanceof OCMagicType) {
            return OK_RESULT;
        }
        boolean bl = unknown = type.isUnknown() || ((OCType)this.mySourceType).isUnknown();
        if (unknown && type.getCanonicalName(this.myContext).equals(((OCType)this.mySourceType).getCanonicalName(this.myContext))) {
            return OK_RESULT;
        }
        return new OCType.TypeCheckResult(OCType.TypeCheckState.ERROR, OCInspections.IncompatibleTypes.class, "CIDR", new IntentionAction[0]){

            @Override
            public String getMessage() {
                return "Types '" + type.getName(OCTypeCompatibilityVisitor.this.myResolveContext) + "' and '" + OCTypeCompatibilityVisitor.this.getSourceTypeName() + "' are not compatible";
            }
        };
    }

    protected String getSourceTypeName() {
        return this.mySource != null ? this.mySource.findBestTypeName((OCType)this.mySourceType) : ((OCType)this.mySourceType).getName(this.myResolveContext);
    }

    @NotNull
    protected OCType.TypeCheckResult visitNumericType(final OCNumericType type) {
        if (this.mySourceType instanceof OCMagicType) {
            OCType.TypeCheckResult typeCheckResult = OK_RESULT;
            if (typeCheckResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/visitors/OCTypeCompatibilityVisitor", "visitNumericType"));
            }
            return typeCheckResult;
        }
        if (this.mySourceType instanceof OCNumericType) {
            OCNumericType numericType = (OCNumericType)this.mySourceType;
            if (OCIntType.isBool(type, this.myContext) && OCIntType.isBool(this.mySourceType, this.myContext)) {
                OCType.TypeCheckResult typeCheckResult = OK_RESULT;
                if (typeCheckResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/visitors/OCTypeCompatibilityVisitor", "visitNumericType"));
                }
                return typeCheckResult;
            }
            if (type.getRank(this.myContext) < numericType.getRank(this.myContext)) {
                OCExpression source;
                if (this.mySource != null && this.mySourceType instanceof OCIntType && type instanceof OCIntType) {
                    Number value = OCExpressionEvaluator.evaluate(this.mySource);
                    if (value != null && ((OCIntType)type).canRepresent(OCNumber.valueOf(value), this.myContext)) {
                        OCType.TypeCheckResult typeCheckResult = OK_RESULT;
                        if (typeCheckResult == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/visitors/OCTypeCompatibilityVisitor", "visitNumericType"));
                        }
                        return typeCheckResult;
                    }
                    if (value == null && type.getCTypeId().equals((Object)((OCIntType)this.mySourceType).getCTypeId())) {
                        OCType.TypeCheckResult typeCheckResult = OK_RESULT;
                        if (typeCheckResult == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/visitors/OCTypeCompatibilityVisitor", "visitNumericType"));
                        }
                        return typeCheckResult;
                    }
                }
                if (this.mySource != null && this.mySourceType instanceof OCRealType && type instanceof OCRealType && (source = OCParenthesesUtils.diveIntoParentheses(this.mySource)) instanceof OCLiteralExpression && OCRealType.narrowestLiteralType(((OCLiteralExpression)source).getUnescapedLiteralText()).getRank(this.myContext) == type.getRank(this.myContext)) {
                    OCType.TypeCheckResult typeCheckResult = OK_RESULT;
                    if (typeCheckResult == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/visitors/OCTypeCompatibilityVisitor", "visitNumericType"));
                    }
                    return typeCheckResult;
                }
                OCType.TypeCheckResult typeCheckResult = new OCType.TypeCheckResult(OCType.TypeCheckState.WARNING, OCInspections.ValueMayNotFitIntoReceiver.class, "warn_impcast_integer_precision", new IntentionAction[0]){

                    @Override
                    public String getMessage() {
                        return "Values of type '" + OCTypeCompatibilityVisitor.this.getSourceTypeName() + "' may not fit into the receiver type '" + type.getName(OCTypeCompatibilityVisitor.this.myContext) + "'";
                    }
                };
                if (typeCheckResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/visitors/OCTypeCompatibilityVisitor", "visitNumericType"));
                }
                return typeCheckResult;
            }
            if (!type.isComplex() && numericType.isComplex()) {
                OCType.TypeCheckResult typeCheckResult = new OCType.TypeCheckResult(OCType.TypeCheckState.WARNING, OCInspections.ValueMayNotFitIntoReceiver.class, "warn_impcast_complex_scalar", new IntentionAction[0]){

                    @Override
                    public String getMessage() {
                        return "Using '" + type.getName(OCTypeCompatibilityVisitor.this.myContext) + "' for complex values of type '" + OCTypeCompatibilityVisitor.this.getSourceTypeName() + "'";
                    }
                };
                if (typeCheckResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/visitors/OCTypeCompatibilityVisitor", "visitNumericType"));
                }
                return typeCheckResult;
            }
            if (!(type.isSigned() || !numericType.isSigned() || this.mySource != null && this.mySourceType instanceof OCIntType && OCExpressionEvaluator.isPositive(this.mySource, this.myResolveContext))) {
                OCType.TypeCheckResult typeCheckResult = new OCType.TypeCheckResult(OCType.TypeCheckState.WARNING, OCInspections.SignednessMismatch.class, "warn_impcast_integer_sign", new IntentionAction[0]){

                    @Override
                    public String getMessage() {
                        return "Using '" + type.getName(OCTypeCompatibilityVisitor.this.myContext) + "' for signed values of type '" + OCTypeCompatibilityVisitor.this.getSourceTypeName() + "'";
                    }
                };
                if (typeCheckResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/visitors/OCTypeCompatibilityVisitor", "visitNumericType"));
                }
                return typeCheckResult;
            }
            OCType.TypeCheckResult typeCheckResult = OK_RESULT;
            if (typeCheckResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/visitors/OCTypeCompatibilityVisitor", "visitNumericType"));
            }
            return typeCheckResult;
        }
        if (this.mySourceType instanceof OCStructType && ((OCStructType)this.mySourceType).getKind() == OCSymbolKind.ENUM) {
            if (((OCStructType)this.mySourceType).isEnumClass()) {
                OCType.TypeCheckResult typeCheckResult = new OCType.TypeCheckResult(OCType.TypeCheckState.ERROR_IF_CPP, OCInspections.ImplicitIntegerAndEnumConversion.class, "CIDR", new IntentionAction[0]){

                    @Override
                    public String getMessage() {
                        return "Taking integer from enum class '" + OCTypeCompatibilityVisitor.this.getSourceTypeName() + "' without a cast";
                    }
                };
                if (typeCheckResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/visitors/OCTypeCompatibilityVisitor", "visitNumericType"));
                }
                return typeCheckResult;
            }
            OCType.TypeCheckResult typeCheckResult = OK_RESULT;
            if (typeCheckResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/visitors/OCTypeCompatibilityVisitor", "visitNumericType"));
            }
            return typeCheckResult;
        }
        if (((OCType)this.mySourceType).isPointerCompatible(this.myContext, false)) {
            if (OCIntType.isBool(type, this.myContext)) {
                OCType.TypeCheckResult typeCheckResult = new OCType.TypeCheckResult(OCType.TypeCheckState.WARNING, OCInspections.ImplicitPointerAndIntegerConversion.class, "ext_typecheck_convert_pointer_int", new IntentionAction[0]){

                    @Override
                    public String getMessage() {
                        return "Taking boolean from pointer '" + OCTypeCompatibilityVisitor.this.getSourceTypeName() + "' without a cast";
                    }
                };
                if (typeCheckResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/visitors/OCTypeCompatibilityVisitor", "visitNumericType"));
                }
                return typeCheckResult;
            }
            if (type instanceof OCIntType) {
                OCType.TypeCheckResult typeCheckResult = new OCType.TypeCheckResult(OCType.TypeCheckState.ERROR_IF_CPP, OCInspections.ImplicitPointerAndIntegerConversion.class, "ext_typecheck_convert_pointer_int", new IntentionAction[0]){

                    @Override
                    public String getMessage() {
                        return "Taking integer from pointer '" + OCTypeCompatibilityVisitor.this.getSourceTypeName() + "' without a cast";
                    }
                };
                if (typeCheckResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/visitors/OCTypeCompatibilityVisitor", "visitNumericType"));
                }
                return typeCheckResult;
            }
            OCType.TypeCheckResult typeCheckResult = this.visitType(type);
            if (typeCheckResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/visitors/OCTypeCompatibilityVisitor", "visitNumericType"));
            }
            return typeCheckResult;
        }
        OCType.TypeCheckResult typeCheckResult = this.visitType(type);
        if (typeCheckResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/visitors/OCTypeCompatibilityVisitor", "visitNumericType"));
        }
        return typeCheckResult;
    }

    @NotNull
    protected OCType.TypeCheckResult checkStructCompatibleCtor(OCStructType type) {
        for (OCStructSymbol struct : type.getStructs()) {
            this.myProcessed.add(type);
            OCType.TypeCheckResult result2 = this.processTransparentUnion(struct, type);
            if (result2 != null) {
                OCType.TypeCheckResult typeCheckResult = result2;
                if (typeCheckResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/visitors/OCTypeCompatibilityVisitor", "checkStructCompatibleCtor"));
                }
                return typeCheckResult;
            }
            if (this.myAllowImplicitConversions) {
                result2 = this.processConstructors(struct);
            }
            if (result2 == null) continue;
            OCType.TypeCheckResult typeCheckResult = result2;
            if (typeCheckResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/visitors/OCTypeCompatibilityVisitor", "checkStructCompatibleCtor"));
            }
            return typeCheckResult;
        }
        OCType.TypeCheckResult result3 = this.visitType(type);
        if (result3 != OK_RESULT && this.isCppClassType(type)) {
            result3.setQuickFixes(new IntentionAction[]{this.getNewConstructorFix(type.getSymbol())});
        }
        OCType.TypeCheckResult typeCheckResult = result3;
        if (typeCheckResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/visitors/OCTypeCompatibilityVisitor", "checkStructCompatibleCtor"));
        }
        return typeCheckResult;
    }

    @NotNull
    protected OCType.TypeCheckResult checkAssignToEnum(OCStructType type, Computable<String> message) {
        OCType.TypeCheckState state = OCType.TypeCheckState.ERROR_IF_CPP;
        final Number value = OCExpressionEvaluator.evaluate(this.mySource);
        if (value != null) {
            OCSymbol enumConst = OCExpressionEvaluator.findMatchingEnumConst(type, value.intValue(), this.myResolveContext);
            if (enumConst != null) {
                OCExpression element = OCElementFactory.expressionFromText(enumConst.getName(), this.mySource, false);
                if (element != null) {
                    OCChangeElementIntentionAction quickFix = new OCChangeElementIntentionAction((PsiElement)this.mySource, (PsiElement)element, "Use constant '" + enumConst.getName() + "'", "Use enum constant");
                    Computable<String> finalMessage = message;
                    OCType.TypeCheckResult typeCheckResult = new OCType.TypeCheckResult(state, OCInspections.ImplicitIntegerAndEnumConversion.class, "CIDR", new IntentionAction[]{quickFix}, (Computable)finalMessage){
                        final /* synthetic */ Computable val$finalMessage;
                        {
                            this.val$finalMessage = computable;
                            super(state, (Class<? extends OCInspection>)inspectionClass, clangID, quickFixes);
                        }

                        @Override
                        public String getMessage() {
                            return (String)this.val$finalMessage.compute();
                        }
                    };
                    if (typeCheckResult == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/visitors/OCTypeCompatibilityVisitor", "checkAssignToEnum"));
                    }
                    return typeCheckResult;
                }
            } else {
                final String typeName = type.getBestNameInContext(this.myContext);
                if (value.intValue() == 0 && typeName.endsWith("Options")) {
                    OCType.TypeCheckResult typeCheckResult = OK_RESULT;
                    if (typeCheckResult == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/visitors/OCTypeCompatibilityVisitor", "checkAssignToEnum"));
                    }
                    return typeCheckResult;
                }
                message = new Computable<String>(){

                    public String compute() {
                        return "Enum '" + typeName + "' has no constant to represent the integer value '" + value + "'";
                    }
                };
            }
        }
        final Computable<String> finalMessage = message;
        OCType.TypeCheckResult typeCheckResult = new OCType.TypeCheckResult(state, OCInspections.ImplicitIntegerAndEnumConversion.class, "CIDR", new IntentionAction[0]){

            @Override
            public String getMessage() {
                return (String)finalMessage.compute();
            }
        };
        if (typeCheckResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/visitors/OCTypeCompatibilityVisitor", "checkAssignToEnum"));
        }
        return typeCheckResult;
    }

    @Override
    public OCType.TypeCheckResult visitEllipsisReferenceType(OCEllipsisType type) {
        return OK_RESULT;
    }

    protected boolean isSuperTypeForFunctionChecks(OCType left, OCType right) {
        if (left.isPointerToObject() && right.isPointerToObject()) {
            return left.isCompatible(right, this.myContext);
        }
        if (left instanceof OCIntType && right instanceof OCStructType && ((OCStructType)right).getKind() == OCSymbolKind.ENUM && !((OCStructType)right).isEnumClass()) {
            return true;
        }
        if (right instanceof OCIntType && left instanceof OCStructType && ((OCStructType)left).getKind() == OCSymbolKind.ENUM && !((OCStructType)left).isEnumClass()) {
            return true;
        }
        PsiFile file2 = this.myContext != null ? this.myContext.getContainingFile() : null;
        return new OCTypeEqualityAfterResolvingVisitor(right, false, true, false, false, true, new OCResolveContext((PsiElement)file2)).equal(left);
    }

    @Override
    public OCType.TypeCheckResult visitArrayType(OCArrayType type) {
        if (!type.hasLength()) {
            return (OCType.TypeCheckResult)this.visitPointerType(type);
        }
        return new OCType.TypeCheckResult(OCType.TypeCheckState.ERROR, OCInspections.NotAssignable.class, "err_typecheck_array_not_modifiable_lvalue", new IntentionAction[0]){

            @Override
            public String getMessage() {
                return "Array is not assignable";
            }
        };
    }

    protected boolean isCppClassType(OCType type) {
        return ((OCFile)this.myContext.getContainingFile()).isCpp() && type instanceof OCStructType && ((OCStructType)type).getKind() == OCSymbolKind.STRUCT;
    }

    @Nullable
    protected OCType.TypeCheckResult checkArcBridgeCast(final OCPointerType type, boolean tollFreeBridge) {
        boolean isCast;
        boolean bl = isCast = this.mySource != null && this.mySource.getParent() instanceof OCCastExpression;
        if (this.mySource instanceof OCLiteralExpression && ((OCType)this.mySourceType).isPointerToString()) {
            return null;
        }
        if (this.mySource instanceof OCSendMessageExpression && ((OCType)this.mySourceType).isPointerToVoid()) {
            return null;
        }
        if (type.getRefType().isVoid() && !((OCType)this.mySourceType).isPointerToObjectCompatible() && ((OCType)this.mySourceType).isPointerToPointerToObjectCompatible()) {
            return null;
        }
        if (isCast && ((OCType)this.mySourceType).isPointerToVoid() && !type.isPointerToObjectCompatible() && type.isPointerToPointerToObjectCompatible()) {
            return null;
        }
        if (isCast && (type.isPointerToObjectCompatible() || ((OCType)this.mySourceType).isPointerToObjectCompatible())) {
            if (type.isPointerToObject()) {
                OCSymbol symbol;
                if (this.mySource instanceof OCCallExpression) {
                    symbol = OCLValueVisitor.getSymbol(((OCCallExpression)this.mySource).getFunctionReferenceExpression());
                } else if (this.mySource instanceof OCSendMessageExpression) {
                    symbol = ((OCSendMessageExpression)this.mySource).getProbableResponders().getKnownResponder();
                    if (symbol != null) {
                        symbol = ((OCMethodSymbol)symbol).getGeneratedFromProperty();
                    }
                } else {
                    symbol = OCLValueVisitor.getSymbol(this.mySource);
                }
                if (symbol instanceof OCFunctionSymbol && symbol.hasAttribute("ImplicitBridging")) {
                    return null;
                }
                if (symbol instanceof OCPropertySymbol) {
                    return null;
                }
                if (symbol instanceof OCDeclaratorSymbol && !OCSearchScope.isInProjectSources(symbol) && symbol.getKind() == OCSymbolKind.GLOBAL_VARIABLE_PREDECLARATION) {
                    return null;
                }
            }
            OCTypeElement parent = ((OCCastExpression)this.mySource.getParent()).getTypeElement();
            IElementType[] types = OCTokenTypes.BRIDGE_CAST_KEYWORDS.getTypes();
            IntentionAction[] quickFixes = new IntentionAction[types.length];
            for (int i = 0; i < quickFixes.length; ++i) {
                String tokenName = ((OCElementType)types[i]).getName();
                quickFixes[i] = new OCChangeTextIntentionAction(this.mySource.getContainingFile(), parent.getTextOffset(), 0, tokenName + " ", "Add \"" + tokenName + "\"", "Add the bridge cast");
            }
            return new OCType.TypeCheckResult(OCType.TypeCheckState.ERROR, "ARC bridge cast is required", OCInspections.BridgeCastIssues.class, "CIDR", quickFixes);
        }
        if (tollFreeBridge) {
            String message = "ARC bridge cast is required for toll free bridge";
            return new OCType.TypeCheckResult(OCType.TypeCheckState.ERROR, message, OCInspections.BridgeCastIssues.class, "CIDR", new IntentionAction[0]);
        }
        return new OCType.TypeCheckResult(OCType.TypeCheckState.ERROR, OCInspections.IncompatibleTypes.class, "err_typecheck_convert_incompatible", new IntentionAction[0]){

            @Override
            public String getMessage() {
                return "Incompatible types '" + type.getName(OCTypeCompatibilityVisitor.this.myResolveContext) + "' and '" + OCTypeCompatibilityVisitor.this.getSourceTypeName() + "'";
            }
        };
    }

    @Override
    public OCType.TypeCheckResult visitBlockPointerType(OCBlockPointerType type) {
        return (OCType.TypeCheckResult)this.visitPointerType(type);
    }

    @Override
    public OCType.TypeCheckResult visitIdType(OCIdType type) {
        return (OCType.TypeCheckResult)this.visitObjectType(type);
    }

    @Override
    public OCType.TypeCheckResult visitIntType(OCIntType type) {
        return this.visitNumericType(type);
    }

    @Override
    public OCType.TypeCheckResult visitRealType(OCRealType type) {
        return this.visitNumericType(type);
    }

    @Override
    public OCType.TypeCheckResult visitReferenceType(OCReferenceType type) {
        return this.visitType(type);
    }

    @Override
    public OCType.TypeCheckResult visitAutoType(OCAutoType type) {
        return this.visitType(type);
    }

    protected OCCreateNewDefinitionIntentionAction getNewConstructorFix(OCStructSymbol struct) {
        return new OCCreateNewDefinitionIntentionAction(OCSymbolKind.CPP_CONSTRUCTOR_DECLARATION, this.myContext, struct, struct.getName(), new OCFunctionType(OCVoidType.instance(), Collections.singletonList(OCExpectedTypeUtil.getExpressionType(this.mySource, this.mySourceType, true))));
    }

    @Nullable
    protected OCType.TypeCheckResult processConstructors(OCStructSymbol struct) {
        final Ref result2 = Ref.create(null);
        struct.processConstructors((Processor<? super OCFunctionSymbol>)new Processor<OCFunctionSymbol>(){
            Boolean myExplicitConstructorCall;

            private boolean isExplicitConstructorCall() {
                if (this.myExplicitConstructorCall != null) {
                    return this.myExplicitConstructorCall;
                }
                if (OCTypeCompatibilityVisitor.this.myContext instanceof OCCallExpression) {
                    OCSymbol symbol = OCLValueVisitor.getSymbol(((OCCallExpression)OCTypeCompatibilityVisitor.this.myContext).getFunctionReferenceExpression());
                    this.myExplicitConstructorCall = symbol instanceof OCStructSymbol || symbol != null && symbol.getKind() == OCSymbolKind.TYPEDEF;
                    return this.myExplicitConstructorCall;
                }
                this.myExplicitConstructorCall = false;
                return this.myExplicitConstructorCall;
            }

            public boolean process(OCFunctionSymbol constructor) {
                OCType argumentType;
                List<? extends OCType> types;
                if (constructor.isCppConstructor() && (!constructor.isExplicit() || this.isExplicitConstructorCall()) && constructor.getNonInitializedParametersCount() <= 1 && (types = constructor.getType().getParameterTypes()).size() >= 1 && OCTypeCompatibilityVisitor.this.myProcessed.add(argumentType = types.get(0).resolve(OCTypeCompatibilityVisitor.this.myContext.getContainingFile()))) {
                    final OCType.TypeCheckResult curResult = OCTypeCompatibilityVisitor.checkConvertible(argumentType, OCTypeCompatibilityVisitor.this.mySourceType, OCTypeCompatibilityVisitor.this.mySource, null, OCTypeCompatibilityVisitor.this.myContext, OCTypeCompatibilityVisitor.this.myProcessed, false, OCTypeCompatibilityVisitor.this.myAssumeNullSubstitutionsEquals, OCTypeCompatibilityVisitor.this.myResolveContext);
                    if (curResult.getState() == OCType.TypeCheckState.OK) {
                        OCType.TypeCheckResult newResult = new OCType.TypeCheckResult(OCType.TypeCheckState.OK, curResult.getInspectionClass(), curResult.getClangID(), true, argumentType, new IntentionAction[0]){

                            @Override
                            public String getMessage() {
                                return curResult.getMessage();
                            }
                        };
                        result2.set((Object)newResult);
                        newResult.setImplicitConstructor(constructor);
                        return false;
                    }
                    if (!curResult.getState().isError(OCTypeCompatibilityVisitor.this.myContext) && result2.isNull()) {
                        result2.set((Object)curResult);
                        curResult.setImplicitConstructor(constructor);
                    }
                }
                return true;
            }
        });
        return (OCType.TypeCheckResult)result2.get();
    }

    @Nullable
    protected OCType.TypeCheckResult processTransparentUnion(final OCStructSymbol struct, OCStructType type) {
        if (type.getKind() != OCSymbolKind.UNION || !struct.isTransparentUnion()) {
            return null;
        }
        final Ref result2 = Ref.create(null);
        CommonProcessors.FindFirstProcessor<OCDeclaratorSymbol> finder = new CommonProcessors.FindFirstProcessor<OCDeclaratorSymbol>(){

            protected boolean accept(OCDeclaratorSymbol field) {
                OCType.TypeCheckResult curResult = field.getType().resolve(struct.getContainingOCFile()).checkCompatible((OCType)OCTypeCompatibilityVisitor.this.mySourceType, OCTypeCompatibilityVisitor.this.mySource, OCTypeCompatibilityVisitor.this.myContext);
                if (curResult.getState() == OCType.TypeCheckState.OK) {
                    result2.set((Object)curResult);
                    return true;
                }
                if (!curResult.getState().isError(OCTypeCompatibilityVisitor.this.myContext) && result2.isNull()) {
                    result2.set((Object)curResult);
                }
                return false;
            }
        };
        struct.processFields((Processor<OCDeclaratorSymbol>)finder);
        return (OCType.TypeCheckResult)result2.get();
    }

    @Override
    public OCType.TypeCheckResult visitUnknownType(OCUnknownType type) {
        return this.visitMagicType(type);
    }

    @Override
    public OCType.TypeCheckResult visitMagicType(OCMagicType type) {
        return OK_RESULT;
    }

    @Override
    public OCType.TypeCheckResult visitVoidType(final OCVoidType type) {
        if (((OCType)this.mySourceType).isVoid() || this.myContext instanceof OCCastExpression) {
            return OK_RESULT;
        }
        return new OCType.TypeCheckResult(OCType.TypeCheckState.ERROR, OCInspections.IncompatibleTypes.class, "err_typecheck_convert_incompatible", new IntentionAction[0]){

            @Override
            public String getMessage() {
                return "Types '" + type.getName(OCTypeCompatibilityVisitor.this.myResolveContext) + "' and '" + OCTypeCompatibilityVisitor.this.getSourceTypeName() + "' are not compatible";
            }
        };
    }

    @Override
    public OCType.TypeCheckResult visitTypeParameterType(OCTypeParameterType type) {
        return this.visitMagicType(type);
    }

    @Override
    public OCType.TypeCheckResult visitNull() {
        return null;
    }

    public static OCType.TypeCheckResult checkCompoundInitializer(final OCCompoundInitializer compInitializer, final OCType type, final boolean allowImplicitConversions, final @NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/types/visitors/OCTypeCompatibilityVisitor", "checkCompoundInitializer"));
        }
        final ArrayList results = new ArrayList();
        final OCArgumentsChecker checker = new OCArgumentsChecker(){

            @Override
            protected void checkAssignment(OCExpression rOperand, PsiElement element, OCType lType, OCType rType, OCSymbol lSymbol, OCType symbolRequiredType, boolean allowImplicitConversions, boolean onlyWarnings, String messagePrefix) {
                OCType.TypeCheckResult result2 = lType.checkCompatible(rType, rOperand, null, rOperand, allowImplicitConversions, true, context);
                if (!result2.getState().isOK() && result2.getAnnotationElement() == null) {
                    result2.setAnnotationElement(rOperand);
                }
                results.add(result2);
            }

            @Override
            protected void checkAssignment(OCExpression rOperand, PsiElement element, OCType lType, OCType rType, String messagePrefix) {
                OCType.TypeCheckResult result2 = lType.checkCompatible(rType, rOperand, rOperand);
                if (!result2.getState().isOK() && result2.getAnnotationElement() == null) {
                    result2.setAnnotationElement(rOperand);
                }
                results.add(result2);
            }

            @Override
            @Nullable
            protected Annotation addWarningAnnotation(@Nullable PsiElement element, @Nullable Class<? extends OCInspection> aClass, @Nullable String inspectionID, final @NotNull String message, @Nullable ProblemHighlightType highlightType, IntentionAction ... fixes) {
                if (message == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/cidr/lang/types/visitors/OCTypeCompatibilityVisitor$19", "addWarningAnnotation"));
                }
                if (highlightType == ProblemHighlightType.LIKE_UNUSED_SYMBOL) {
                    return null;
                }
                OCType.TypeCheckResult result2 = new OCType.TypeCheckResult(OCType.TypeCheckState.WARNING, aClass, inspectionID, element, new IntentionAction[0]){

                    @Override
                    public String getMessage() {
                        return message;
                    }
                };
                if (!result2.getState().isOK() && result2.getAnnotationElement() == null) {
                    result2.setAnnotationElement(element);
                }
                results.add(result2);
                return null;
            }

            @Override
            @Nullable
            protected Annotation addErrorAnnotation(@Nullable PsiElement element, @Nullable Class<? extends OCInspection> inspectionClass, @Nullable String clangID, final @NotNull String message, IntentionAction ... fixes) {
                if (message == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/cidr/lang/types/visitors/OCTypeCompatibilityVisitor$19", "addErrorAnnotation"));
                }
                OCType.TypeCheckResult result2 = new OCType.TypeCheckResult(OCType.TypeCheckState.ERROR, inspectionClass, clangID, element, new IntentionAction[0]){

                    @Override
                    public String getMessage() {
                        return message;
                    }
                };
                if (!result2.getState().isOK() && result2.getAnnotationElement() == null) {
                    result2.setAnnotationElement(element);
                }
                results.add(result2);
                return null;
            }

            @Override
            protected void checkConstructor(OCCompoundInitializer compInitializer, OCSymbol symbol) {
                if (symbol instanceof OCFunctionSymbol) {
                    OCFunctionType functionType = (OCFunctionType)symbol.getType().resolve(compInitializer.getContainingFile());
                    this.checkFunctionArguments(compInitializer, functionType, Collections.singletonList(compInitializer), symbol);
                } else if (symbol instanceof OCStructSymbol) {
                    List<OCExpression> expressions = compInitializer.getInitializerExpressions();
                    if (expressions.size() == 1) {
                        this.checkAssignment(expressions.get(0), compInitializer, symbol.getType(), expressions.get(0).getResolvedType(), "Parameter type mismatch: ");
                    } else if (expressions.size() > 0 || !((OCStructSymbol)symbol).hasDefaultConstructor()) {
                        List argumentTypes = ContainerUtil.map(expressions, (Function)new Function<OCExpression, OCType>(){

                            public OCType fun(OCExpression expression) {
                                return OCExpectedTypeUtil.getExpressionType(expression, true);
                            }
                        });
                        String message = OCCppChecker.getCantResolveCtorMessage(symbol, new OCFunctionType(OCVoidType.instance(), argumentTypes), compInitializer);
                        this.addErrorAnnotation(compInitializer, OCInspections.CannotResolve.class, "CIDR", message, new IntentionAction[0]);
                    }
                }
            }
        };
        RecursionManager.doPreventingRecursion((Object)new Pair((Object)compInitializer, (Object)allowImplicitConversions), (boolean)false, (Computable)new Computable<Void>(){

            public Void compute() {
                checker.checkCompoundInitializer(compInitializer, type, false, allowImplicitConversions);
                return null;
            }
        });
        OCType.TypeCheckResult worst = OK_RESULT;
        for (OCType.TypeCheckResult state : results) {
            if (state.getState().ordinal() <= worst.getState().ordinal()) continue;
            worst = state;
        }
        return worst;
    }

    @Nullable
    protected OCType.TypeCheckResult checkAssignPointerToArray(OCArrayType type) {
        if (type.getRefType() instanceof OCIntType) {
            OCIntType dstRefType = (OCIntType)type.getRefType();
            OCType refType = ((OCPointerType)this.mySourceType).getRefType();
            if ((OCIntType.CHAR.equals(dstRefType, false, this.myResolveContext) || OCIntType.UCHAR.equals(dstRefType, false, this.myResolveContext) || OCIntType.SCHAR.equals(dstRefType, false, this.myResolveContext)) && OCIntType.CHAR.equals(refType, false, this.myResolveContext)) {
                return OK_RESULT;
            }
            if (this.bothTypesEquals(OCIntType.WCHAR, dstRefType, refType)) {
                return OK_RESULT;
            }
            if (this.bothTypesEquals(OCIntType.CHAR16, dstRefType, refType)) {
                return OK_RESULT;
            }
            if (this.bothTypesEquals(OCIntType.CHAR32, dstRefType, refType)) {
                return OK_RESULT;
            }
        }
        return null;
    }

    @NotNull
    protected OCType.TypeCheckResult getProtocolCompatibilityCheckResult(@NotNull OCObjectType sourceType, @NotNull OCObjectType type) {
        if (sourceType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceType", "com/jetbrains/cidr/lang/types/visitors/OCTypeCompatibilityVisitor", "getProtocolCompatibilityCheckResult"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/cidr/lang/types/visitors/OCTypeCompatibilityVisitor", "getProtocolCompatibilityCheckResult"));
        }
        for (final OCProtocolSymbol protocol : type.getAllProtocols()) {
            if (sourceType.implementsProtocol(protocol)) continue;
            final OCImplementation implementation = (OCImplementation)PsiTreeUtil.getParentOfType((PsiElement)this.myContext, OCImplementation.class);
            final OCClassSymbol classSymbol = sourceType.getClassSymbol();
            OCType.TypeCheckResult typeCheckResult = new OCType.TypeCheckResult(OCType.TypeCheckState.WARNING, OCInspections.NotImplementsProtocol.class, "CIDR", new IntentionAction[]{new OCAddSuperProtocolIntentionAction(sourceType.getInterface(), protocol.getName(), false), new OCAddSuperProtocolIntentionAction(sourceType.getImplementation(), protocol.getName(), true){

                @Override
                protected boolean isAvailable(OCClassSymbol myInterface) {
                    return implementation != null && classSymbol != null && classSymbol.getName().equals(implementation.getName()) && super.isAvailable(myInterface);
                }
            }}){

                @Override
                public String getMessage() {
                    return "Interface '" + OCTypeCompatibilityVisitor.this.getSourceTypeName() + "' doesn't implement " + protocol.getNameWithKindLowercase();
                }
            };
            if (typeCheckResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/visitors/OCTypeCompatibilityVisitor", "getProtocolCompatibilityCheckResult"));
            }
            return typeCheckResult;
        }
        OCType.TypeCheckResult typeCheckResult = OK_RESULT;
        if (typeCheckResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/visitors/OCTypeCompatibilityVisitor", "getProtocolCompatibilityCheckResult"));
        }
        return typeCheckResult;
    }

    private static class OCTypeCompatibilityVisitorCreator
    implements OCTypeVisitor<OCTypeCompatibilityVisitor<? extends OCType>> {
        private final OCExpression mySource;
        @Nullable
        private final PsiElement myContext;
        private final Set<OCType> myProcessed;
        private final boolean myAllowImplicitConversions;
        private final boolean myAssumeNullSubstitutionsEquals;
        @NotNull
        private final OCResolveContext myResolveContext;

        public OCTypeCompatibilityVisitorCreator(OCExpression source, @Nullable PsiElement context, Set<OCType> processed, boolean allowImplicitConversions, boolean assumeNullSubstitutionsEquals, @NotNull OCResolveContext resolveContext) {
            if (resolveContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveContext", "com/jetbrains/cidr/lang/types/visitors/OCTypeCompatibilityVisitor$OCTypeCompatibilityVisitorCreator", "<init>"));
            }
            this.mySource = source;
            this.myContext = context;
            this.myProcessed = processed;
            this.myAllowImplicitConversions = allowImplicitConversions;
            this.myAssumeNullSubstitutionsEquals = assumeNullSubstitutionsEquals;
            this.myResolveContext = resolveContext;
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitEllipsisReferenceType(OCEllipsisType sourceType) {
            return new OCTypeCompatibilityVisitor_OCEllipsisType(sourceType, this.mySource, this.myContext, this.myProcessed, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitFunctionType(OCFunctionType sourceType) {
            return new OCTypeCompatibilityVisitor_OCFunctionType(sourceType, this.mySource, this.myContext, this.myProcessed, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitMagicType(OCMagicType sourceType) {
            return new OCTypeCompatibilityVisitor_AlwaysOk<OCMagicType>(sourceType, this.mySource, this.myContext, this.myProcessed, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitObjectType(OCObjectType sourceType) {
            return new OCTypeCompatibilityVisitor_OCObjectType(sourceType, this.mySource, this.myContext, this.myProcessed, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitArrayType(OCArrayType sourceType) {
            return new OCTypeCompatibilityVisitor_OCArrayType(sourceType, this.mySource, this.myContext, this.myProcessed, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitPointerType(OCPointerType sourceType) {
            return new OCTypeCompatibilityVisitor_OCPointerType(sourceType, this.mySource, this.myContext, this.myProcessed, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitBlockPointerType(OCBlockPointerType sourceType) {
            return new OCTypeCompatibilityVisitor_OCBlockPointerType(sourceType, this.mySource, this.myContext, this.myProcessed, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitCppReferenceType(OCCppReferenceType sourceType) {
            return sourceType.getRefType(this.myContext).accept(this);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitIdType(OCIdType sourceType) {
            return new OCTypeCompatibilityVisitor_OCIdType(sourceType, this.mySource, this.myContext, this.myProcessed, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitIntType(OCIntType sourceType) {
            return new OCTypeCompatibilityVisitor_OCIntType(sourceType, this.mySource, this.myContext, this.myProcessed, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitRealType(OCRealType sourceType) {
            return new OCTypeCompatibilityVisitor_OCRealType(sourceType, this.mySource, this.myContext, this.myProcessed, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitReferenceType(OCReferenceType sourceType) {
            return new OCTypeCompatibilityVisitor_OCReferenceType(sourceType, this.mySource, this.myContext, this.myProcessed, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitStructType(OCStructType sourceType) {
            return new OCTypeCompatibilityVisitor_OCStructType(sourceType, this.mySource, this.myContext, this.myProcessed, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitUnknownType(OCUnknownType sourceType) {
            return new OCTypeCompatibilityVisitor_AlwaysOk<OCUnknownType>(sourceType, this.mySource, this.myContext, this.myProcessed, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitVoidType(OCVoidType sourceType) {
            return new OCTypeCompatibilityVisitor_OCVoidType(sourceType, this.mySource, this.myContext, this.myProcessed, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitTypeParameterType(OCTypeParameterType sourceType) {
            return new OCTypeCompatibilityVisitor_AlwaysOk<OCTypeParameterType>(sourceType, this.mySource, this.myContext, this.myProcessed, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitAutoType(OCAutoType sourceType) {
            return new OCTypeCompatibilityVisitor_OCAutoType(sourceType, this.mySource, this.myContext, this.myProcessed, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitNull() {
            return null;
        }
    }
}

