/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types.visitors;

import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCEllipsisType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCReferenceTypeBuilder;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCTypeCloneVisitor
implements OCTypeVisitor<OCType> {
    private final boolean isShallow;
    @Nullable
    private final OCType myRootType;
    private final Boolean myForcedConst;
    private final Boolean myForcedVolatile;

    public OCTypeCloneVisitor(boolean shallow) {
        this(shallow, null, null, null);
    }

    public OCTypeCloneVisitor(boolean shallow, @Nullable OCType rootType, @Nullable Boolean forcedConstValue, @Nullable Boolean forcedVolatileValue) {
        this.isShallow = shallow;
        this.myRootType = rootType;
        this.myForcedConst = forcedConstValue;
        this.myForcedVolatile = forcedVolatileValue;
    }

    private OCType cloneKid(OCType kid) {
        return this.isShallow ? kid : kid.transformType(this);
    }

    private boolean isConstCopy(@NotNull OCType original) {
        boolean allowedToForceConst;
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/jetbrains/cidr/lang/types/visitors/OCTypeCloneVisitor", "isConstCopy"));
        }
        boolean bl = allowedToForceConst = this.myRootType != null && this.myRootType.getArrayElementType() == original.getArrayElementType();
        if (allowedToForceConst && this.myForcedConst != null) {
            return this.myForcedConst;
        }
        return original.isConst();
    }

    private boolean isVolatileCopy(@NotNull OCType original) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/jetbrains/cidr/lang/types/visitors/OCTypeCloneVisitor", "isVolatileCopy"));
        }
        return this.myForcedVolatile != null ? this.myForcedVolatile.booleanValue() : original.isVolatile();
    }

    @Override
    public OCType visitEllipsisReferenceType(OCEllipsisType type) {
        return OCEllipsisType.instance();
    }

    @Override
    public OCType visitFunctionType(OCFunctionType type) {
        List<? extends OCType> oldParamTypes = type.getParameterTypes(true);
        List<String> oldParamNames = type.getParameterNames(true);
        ArrayList<OCType> clonedArgs = new ArrayList<OCType>(oldParamTypes.size());
        for (OCType oCType : oldParamTypes) {
            clonedArgs.add(this.cloneKid(oCType));
        }
        ArrayList<String> clonedNames = oldParamNames != null ? new ArrayList<String>(oldParamNames) : null;
        return new OCFunctionType(this.cloneKid(type.getReturnType()), clonedArgs, clonedNames, this.isConstCopy(type), this.isVolatileCopy(type));
    }

    @Override
    public OCType visitMagicType(OCMagicType type) {
        return new OCMagicType(type.getName(), type.getGuessedType(), false, false);
    }

    @Override
    public OCType visitObjectType(OCObjectType type) {
        return new OCObjectType(type.getInterface(), type.getImplementation(), type.getAllProtocols(), type.getAugmentedProtocols(), type.getCategoryInterfaces(), type.getCategoryImplementations(), type.getSuperType(), this.isConstCopy(type), this.isVolatileCopy(type), type.isKindof());
    }

    @Override
    public OCType visitArrayType(OCArrayType type) {
        OCType forcedClone = type.getRefType().transformType(this);
        return OCArrayType.to(forcedClone, type.getLength(), type.getARCAttribute());
    }

    @Override
    public OCType visitPointerType(OCPointerType type) {
        OCType qualifier = type.getClassQualifier() != null ? this.cloneKid(type.getClassQualifier()) : null;
        OCPointerType clone = OCPointerType.to(this.cloneKid(type.getRefType()), type.getARCAttribute(), qualifier, this.isConstCopy(type), this.isVolatileCopy(type));
        clone.setLengthInBrackets(type.getLengthInBrackets());
        return clone;
    }

    @Override
    public OCType visitBlockPointerType(OCBlockPointerType type) {
        return OCBlockPointerType.blockPtr(this.cloneKid(type.getRefType()), type.getARCAttribute(), this.isConstCopy(type), this.isVolatileCopy(type));
    }

    @Override
    public OCType visitCppReferenceType(OCCppReferenceType type) {
        OCType inner = this.cloneKid(type.getRefType());
        boolean isConst = this.isConstCopy(type);
        boolean isVolatile = this.isVolatileCopy(type);
        return type.isRvalueRef() ? OCCppReferenceType.to(inner, true, isConst, isVolatile) : OCCppReferenceType.to(inner, false, isConst, isVolatile);
    }

    @Override
    public OCType visitIdType(OCIdType type) {
        return new OCIdType(type.getAllProtocols(), type.getAugmentedProtocols(), type.getProject(), this.isConstCopy(type), this.isVolatileCopy(type));
    }

    @Override
    public OCType visitIntType(OCIntType type) {
        return type.cloneType(this.isConstCopy(type), this.isVolatileCopy(type));
    }

    @Override
    public OCType visitRealType(OCRealType type) {
        return type.cloneType(this.isConstCopy(type), this.isVolatileCopy(type));
    }

    @Override
    public OCType visitReferenceType(OCReferenceType type) {
        OCReferenceTypeBuilder resultBuilder = new OCReferenceTypeBuilder(type.getReference());
        resultBuilder.setProtocolSubstitutionARCFromType(type);
        resultBuilder.setConstVolatile(this.isConstCopy(type), this.isVolatileCopy(type));
        resultBuilder.setFunctionParameterType(type.isFunctionParameterType());
        resultBuilder.setIsKindof(type.isKindof());
        return resultBuilder.build();
    }

    @Override
    public OCType visitStructType(OCStructType type) {
        return new OCStructType(type.getStructs(), type.getTypedefName(), this.isConstCopy(type), this.isVolatileCopy(type));
    }

    @Override
    public OCType visitUnknownType(OCUnknownType type) {
        return OCUnknownType.INSTANCE;
    }

    @Override
    public OCType visitVoidType(OCVoidType type) {
        return OCVoidType.instance(this.isConstCopy(type), this.isVolatileCopy(type));
    }

    @Override
    public OCType visitTypeParameterType(OCTypeParameterType type) {
        return new OCTypeParameterType(type.getSymbol(), this.isConstCopy(type), this.isVolatileCopy(type));
    }

    @Override
    public OCType visitAutoType(OCAutoType type) {
        return new OCAutoType(type.getExpressionSymbol(), type.getExpressionElement(), type.getIncompleteType(), this.isConstCopy(type), this.isVolatileCopy(type));
    }

    @Override
    public OCType visitNull() {
        return null;
    }
}

