/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types.visitors;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.visitors.OCSimpleTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class OCMultiTypeSubstitution
extends OCTypeSubstitution {
    private List<OCSimpleTypeSubstitution> mySubstitutions;

    public OCMultiTypeSubstitution(List<OCSimpleTypeSubstitution> substitutions) {
        this.mySubstitutions = substitutions;
    }

    @Override
    public OCType substitute(@NotNull OCType type, final @NotNull OCResolveContext context) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/cidr/lang/types/visitors/OCMultiTypeSubstitution", "substitute"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/types/visitors/OCMultiTypeSubstitution", "substitute"));
        }
        return type.accept(new OCTypeSubstitution.TypeSubstituteVisitor(this, context){

            @Override
            public OCType visitTypeParameterType(OCTypeParameterType type) {
                OCType partiallySubstitutedType = null;
                for (OCSimpleTypeSubstitution substitution : OCMultiTypeSubstitution.this.mySubstitutions) {
                    if (partiallySubstitutedType != null) {
                        partiallySubstitutedType = substitution.substitute(partiallySubstitutedType, context);
                        continue;
                    }
                    OCTypeArgument arg = substitution.getSubstitutionFor(type.getSymbol());
                    if (arg == null) continue;
                    if (arg instanceof OCType) {
                        if (arg instanceof OCReferenceType) {
                            OCReferenceType result2 = OCTypeSubstitution.substituteReferenceType((OCReferenceType)arg, OCMultiTypeSubstitution.this, context);
                            return result2.cloneWithAddedCVQualifiers(type.getCVQualifiers(), context.getProject());
                        }
                        partiallySubstitutedType = (OCType)arg;
                        continue;
                    }
                    return new OCMagicType(arg.getNameForPresentation(OCType.Presentation.FULL, null, true, 0));
                }
                return partiallySubstitutedType != null ? partiallySubstitutedType.cloneWithAddedCVQualifiers(type.getCVQualifiers(), context.getProject()) : type;
            }
        });
    }

    @Override
    public Collection<OCTypeArgument> getSubstitutedTypes() {
        Set<OCTypeArgument> arguments = OCTypeUtils.newTypeSet();
        for (OCSimpleTypeSubstitution substitution : this.mySubstitutions) {
            arguments.addAll(substitution.getSubstitutedTypes());
        }
        return arguments;
    }

    @Override
    public OCTypeArgument getSubstitutionFor(@NotNull OCTypeParameterSymbol argument) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "com/jetbrains/cidr/lang/types/visitors/OCMultiTypeSubstitution", "getSubstitutionFor"));
        }
        for (OCTypeSubstitution oCTypeSubstitution : this.mySubstitutions) {
            OCTypeArgument result2 = oCTypeSubstitution.getSubstitutionFor(argument);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    @Override
    public boolean hasSubstitutionForName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/cidr/lang/types/visitors/OCMultiTypeSubstitution", "hasSubstitutionForName"));
        }
        for (OCTypeSubstitution oCTypeSubstitution : this.mySubstitutions) {
            if (!oCTypeSubstitution.hasSubstitutionForName(name)) continue;
            return true;
        }
        return false;
    }

    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/jetbrains/cidr/lang/types/visitors/OCMultiTypeSubstitution", "deepEqualStep"));
        }
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/jetbrains/cidr/lang/types/visitors/OCMultiTypeSubstitution", "deepEqualStep"));
        }
        if (second == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "com/jetbrains/cidr/lang/types/visitors/OCMultiTypeSubstitution", "deepEqualStep"));
        }
        OCMultiTypeSubstitution f = (OCMultiTypeSubstitution)first;
        OCMultiTypeSubstitution s = (OCMultiTypeSubstitution)second;
        return c.equalIterable(f.mySubstitutions, s.mySubstitutions);
    }

    @Override
    public boolean equals(Object o, @NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/types/visitors/OCMultiTypeSubstitution", "equals"));
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OCMultiTypeSubstitution that = (OCMultiTypeSubstitution)o;
        if (this.mySubstitutions == null || that.mySubstitutions == null) {
            return this.mySubstitutions == that.mySubstitutions;
        }
        if (this.mySubstitutions.size() != that.mySubstitutions.size()) {
            return false;
        }
        for (int i = 0; i < this.mySubstitutions.size(); ++i) {
            if (this.mySubstitutions.get(i).equals(that.mySubstitutions.get(i), context)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean dependsOn(OCTypeSubstitution substitution, @NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/types/visitors/OCMultiTypeSubstitution", "dependsOn"));
        }
        for (OCTypeSubstitution oCTypeSubstitution : this.mySubstitutions) {
            if (!oCTypeSubstitution.dependsOn(substitution, context)) continue;
            return true;
        }
        return false;
    }

    @Override
    public OCTypeSubstitution getMinimalDependentSubstitution(Object reference, final @NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/types/visitors/OCMultiTypeSubstitution", "getMinimalDependentSubstitution"));
        }
        ArrayList<OCSimpleTypeSubstitution> list = new ArrayList<OCSimpleTypeSubstitution>();
        TObjectHashingStrategy<Object> strategy = new TObjectHashingStrategy<Object>(){

            public int computeHashCode(Object object) {
                return object.hashCode();
            }

            public boolean equals(Object o1, Object o2) {
                return o1 instanceof OCTypeSubstitution && o2 instanceof OCTypeSubstitution ? ((OCTypeSubstitution)o1).equals(o2, context) : o1.equals(o2);
            }
        };
        THashSet unusedSubstitutions = new THashSet(this.mySubstitutions, (TObjectHashingStrategy)strategy);
        THashSet workset = new THashSet((TObjectHashingStrategy)strategy);
        workset.add(reference);
        while (!workset.isEmpty()) {
            THashSet newWorkset = new THashSet((TObjectHashingStrategy)strategy);
            for (Object substitution : unusedSubstitutions) {
                if (!((OCSimpleTypeSubstitution)substitution).dependsOn((Collection<Object>)workset, context)) continue;
                list.add((OCSimpleTypeSubstitution)substitution);
                newWorkset.add(substitution);
            }
            unusedSubstitutions.removeAll((Collection<?>)newWorkset);
            workset = newWorkset;
        }
        return list.isEmpty() ? ID : new OCMultiTypeSubstitution(list);
    }

    public String toString() {
        Function<OCSimpleTypeSubstitution, String> converter = new Function<OCSimpleTypeSubstitution, String>(){

            public String fun(OCSimpleTypeSubstitution substitution) {
                return substitution.substList();
            }
        };
        return "{" + StringUtil.join((Collection)ContainerUtil.map(this.mySubstitutions, (Function)converter), (String)" // ") + "}";
    }

    public int hashCode() {
        return this.mySubstitutions != null ? this.mySubstitutions.hashCode() : 0;
    }

    public List<OCSimpleTypeSubstitution> getSubstitutions() {
        return this.mySubstitutions;
    }
}

