/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.types.ARCAttribute;
import com.jetbrains.cidr.lang.types.OCReferenceTypeBuilder;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;
import java.io.Serializable;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCReferenceType
extends OCType
implements Serializable {
    @NotNull
    private OCSymbolReference myReference;
    @NotNull
    private List<String> myProtocolNames;
    @NotNull
    private OCTypeSubstitution mySubstitution;
    @Nullable
    private ARCAttribute myARCAttribute;
    private boolean myIsKindof;
    private boolean myFunctionParameterType;

    public OCReferenceType() {
        this.mySubstitution = OCTypeSubstitution.ID;
        this.myFunctionParameterType = false;
    }

    public OCReferenceType(boolean isConst, boolean isVolatile, @NotNull OCSymbolReference reference, @NotNull List<String> protocolNames, @NotNull OCTypeSubstitution substitution, @Nullable ARCAttribute arcAttribute, boolean functionParameterType, boolean isKindof) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/jetbrains/cidr/lang/types/OCReferenceType", "<init>"));
        }
        if (protocolNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "protocolNames", "com/jetbrains/cidr/lang/types/OCReferenceType", "<init>"));
        }
        if (substitution == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitution", "com/jetbrains/cidr/lang/types/OCReferenceType", "<init>"));
        }
        super(isConst, isVolatile);
        this.mySubstitution = OCTypeSubstitution.ID;
        this.myFunctionParameterType = false;
        this.myReference = reference;
        this.myProtocolNames = protocolNames;
        this.mySubstitution = substitution;
        this.myARCAttribute = arcAttribute;
        this.myFunctionParameterType = functionParameterType;
        this.myIsKindof = isKindof;
    }

    @Override
    public <T> T accept(OCTypeVisitor<T> visitor) {
        return visitor.visitReferenceType(this);
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/jetbrains/cidr/lang/types/OCReferenceType", "deepEqualStep"));
        }
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/jetbrains/cidr/lang/types/OCReferenceType", "deepEqualStep"));
        }
        if (second == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "com/jetbrains/cidr/lang/types/OCReferenceType", "deepEqualStep"));
        }
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCReferenceType f = (OCReferenceType)first;
        OCReferenceType s = (OCReferenceType)second;
        if (f.myARCAttribute != s.myARCAttribute) {
            return false;
        }
        if (f.myIsKindof != s.myIsKindof) {
            return false;
        }
        if (!f.myProtocolNames.equals(s.myProtocolNames)) {
            return false;
        }
        if (!c.equalObjects(f.myReference, s.myReference)) {
            return false;
        }
        return c.equalObjects(f.mySubstitution, s.mySubstitution);
    }

    @Override
    public int hashCode() {
        int result2 = this.baseHashCode();
        result2 = 31 * result2 + this.myReference.hashCode();
        result2 = 31 * result2 + (this.myARCAttribute == null ? 0 : this.myARCAttribute.hashCode());
        result2 = 31 * result2 + this.myProtocolNames.hashCode();
        result2 = 31 * result2 + this.mySubstitution.hashCode();
        result2 = 31 * result2 + Boolean.valueOf(this.myIsKindof).hashCode();
        return result2;
    }

    @NotNull
    public List<String> getProtocolNames() {
        List<String> list = this.myProtocolNames;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCReferenceType", "getProtocolNames"));
        }
        return list;
    }

    @Override
    public boolean isUnknown() {
        return true;
    }

    @Override
    public boolean isUnresolved(@NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/types/OCReferenceType", "isUnresolved"));
        }
        return true;
    }

    @NotNull
    public OCTypeSubstitution getSubstitution() {
        OCTypeSubstitution oCTypeSubstitution = this.mySubstitution;
        if (oCTypeSubstitution == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCReferenceType", "getSubstitution"));
        }
        return oCTypeSubstitution;
    }

    @NotNull
    public static OCType resolvedFromText(String name, @Nullable PsiFile file2) {
        OCType oCType = OCReferenceType.fromText(name).resolve(file2);
        if (oCType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCReferenceType", "resolvedFromText"));
        }
        return oCType;
    }

    @NotNull
    public static OCType resolvedFromText(String name, @NotNull String protocolName, @Nullable PsiFile file2) {
        if (protocolName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "protocolName", "com/jetbrains/cidr/lang/types/OCReferenceType", "resolvedFromText"));
        }
        OCType oCType = OCReferenceType.fromText(name, protocolName).resolve(file2);
        if (oCType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCReferenceType", "resolvedFromText"));
        }
        return oCType;
    }

    @NotNull
    public static OCType resolvedFromText(String name, PsiFile file2, boolean ignoreImports) {
        OCType oCType = OCReferenceType.fromText(name).resolve(file2, ignoreImports);
        if (oCType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCReferenceType", "resolvedFromText"));
        }
        return oCType;
    }

    @NotNull
    public static OCReferenceType fromText(String name) {
        OCReferenceType oCReferenceType = new OCReferenceTypeBuilder(name).build();
        if (oCReferenceType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCReferenceType", "fromText"));
        }
        return oCReferenceType;
    }

    @NotNull
    public static OCReferenceType fromText(String name, @NotNull String protocolName) {
        if (protocolName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "protocolName", "com/jetbrains/cidr/lang/types/OCReferenceType", "fromText"));
        }
        OCReferenceType oCReferenceType = new OCReferenceTypeBuilder(name).setSingleProtocolName(protocolName).build();
        if (oCReferenceType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCReferenceType", "fromText"));
        }
        return oCReferenceType;
    }

    @NotNull
    public static OCReferenceType fromText(String name, @NotNull List<String> protocolNames) {
        if (protocolNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "protocolNames", "com/jetbrains/cidr/lang/types/OCReferenceType", "fromText"));
        }
        OCReferenceType oCReferenceType = new OCReferenceTypeBuilder(name).setProtocolNames(protocolNames).build();
        if (oCReferenceType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCReferenceType", "fromText"));
        }
        return oCReferenceType;
    }

    public static OCReferenceType fromLocalText(OCQualifiedName name) {
        return new OCReferenceTypeBuilder(name, null).build();
    }

    @NotNull
    public OCSymbolReference getReference() {
        OCSymbolReference oCSymbolReference = this.myReference;
        if (oCSymbolReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCReferenceType", "getReference"));
        }
        return oCSymbolReference;
    }

    @Nullable
    public ARCAttribute getARCAttribute() {
        return this.myARCAttribute;
    }

    public boolean isFunctionParameterType() {
        return this.myFunctionParameterType;
    }

    public void setFunctionParameterType(boolean functionParameterType) {
        this.myFunctionParameterType = functionParameterType;
    }

    public boolean isKindof() {
        return this.myIsKindof;
    }
}

