/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.types.OCNumericType;
import com.jetbrains.cidr.lang.types.OCTypeMapper;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;
import java.math.BigDecimal;
import java.math.MathContext;
import org.jetbrains.annotations.NotNull;

public class OCRealType
extends OCNumericType {
    public static final OCRealType FLOAT = new OCRealType(OCTypeMapper.CTypeId.FLOAT, "float", "%f", false);
    public static final OCRealType DOUBLE = new OCRealType(OCTypeMapper.CTypeId.DOUBLE, "double", "%lf", false);
    public static final OCRealType LONG_DOUBLE = new OCRealType(OCTypeMapper.CTypeId.LONG_DOUBLE, "long double", "%Lf", false);
    public static final OCRealType COMPLEX_FLOAT = new OCRealType(OCTypeMapper.CTypeId.FLOAT, "float", null, true);
    public static final OCRealType COMPLEX_DOUBLE = new OCRealType(OCTypeMapper.CTypeId.DOUBLE, "double", null, true);
    public static final OCRealType COMPLEX_LONG_DOUBLE = new OCRealType(OCTypeMapper.CTypeId.LONG_DOUBLE, "long double", null, true);
    private boolean myComplex;
    private String myText;
    private String myFormatString;

    public OCRealType() {
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/jetbrains/cidr/lang/types/OCRealType", "deepEqualStep"));
        }
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/jetbrains/cidr/lang/types/OCRealType", "deepEqualStep"));
        }
        if (second == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "com/jetbrains/cidr/lang/types/OCRealType", "deepEqualStep"));
        }
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCRealType f = (OCRealType)first;
        OCRealType s = (OCRealType)second;
        if (!f.myTypeId.equals((Object)s.myTypeId)) {
            return false;
        }
        return Comparing.equal((String)f.myText, (String)s.myText);
    }

    @NotNull
    public static OCRealType literalType(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/cidr/lang/types/OCRealType", "literalType"));
        }
        char suffix = text.charAt(text.length() - 1);
        if (suffix == 'l' || suffix == 'L') {
            OCRealType oCRealType = LONG_DOUBLE;
            if (oCRealType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCRealType", "literalType"));
            }
            return oCRealType;
        }
        if (suffix == 'f' || suffix == 'F') {
            OCRealType oCRealType = FLOAT;
            if (oCRealType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCRealType", "literalType"));
            }
            return oCRealType;
        }
        OCRealType oCRealType = DOUBLE;
        if (oCRealType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCRealType", "literalType"));
        }
        return oCRealType;
    }

    public static OCRealType narrowestLiteralType(String text) {
        if (!Character.isDigit(text.charAt(text.length() - 1))) {
            return OCRealType.literalType(text);
        }
        try {
            BigDecimal dbl = new BigDecimal(text, MathContext.DECIMAL64);
            BigDecimal flt = new BigDecimal(text, MathContext.DECIMAL32);
            if (dbl.equals(flt)) {
                return FLOAT;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return DOUBLE;
    }

    private OCRealType(OCTypeMapper.CTypeId precision, String text, String formatString, boolean complex) {
        this(precision, text, formatString, complex, false, false);
    }

    private OCRealType(OCTypeMapper.CTypeId precision, String text, String formatString, boolean complex, boolean isConst, boolean isVolatile) {
        super(isConst, isVolatile);
        this.myFormatString = formatString;
        this.myTypeId = precision;
        this.myText = text;
        this.myComplex = complex;
    }

    public OCRealType cloneType(boolean isConst, boolean isVolatile) {
        return new OCRealType(this.getCTypeId(), this.getText(), this.getFormatString(), this.isComplex(), isConst, isVolatile);
    }

    @Override
    public boolean isComplex() {
        return this.myComplex;
    }

    public String getText() {
        return this.myText;
    }

    public OCRealType cloneWithComplexModifier() {
        if (this.myComplex) {
            return this;
        }
        OCRealType clone = (OCRealType)this.getShallowCopy();
        clone.myComplex = true;
        return clone;
    }

    public OCRealType cloneWithoutComplexModifier() {
        if (!this.myComplex) {
            return this;
        }
        OCRealType clone = (OCRealType)this.getShallowCopy();
        clone.myComplex = false;
        return clone;
    }

    @Override
    public <T> T accept(OCTypeVisitor<T> visitor) {
        return visitor.visitRealType(this);
    }

    @Override
    public int getRank(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/types/OCRealType", "getRank"));
        }
        return this.getSizeInBytes(element.getContainingFile(), null) << 6;
    }

    @Override
    public boolean isSigned() {
        return true;
    }

    @Override
    public String getFormatString() {
        return this.myFormatString;
    }

    @Override
    public String getDefaultValue(PsiElement context) {
        return "0";
    }

    @Override
    public int hashCode() {
        return (this.myComplex ? 997 : 991) * super.hashCode();
    }
}

