/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.types.ARCAttribute;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCPointerType
extends OCType {
    protected OCType myRefType;
    private ARCAttribute myARCAttribute;
    private OCType myClassQualifier;
    private Integer lengthInBrackets = null;

    public OCPointerType() {
    }

    protected OCPointerType(OCType ref, @Nullable ARCAttribute attribute, @Nullable OCType classQualifier, boolean isConst, boolean isVolatile) {
        super(isConst, isVolatile);
        this.myRefType = ref;
        this.myARCAttribute = attribute;
        this.myClassQualifier = classQualifier;
    }

    public static OCPointerType to(@NotNull OCType ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/jetbrains/cidr/lang/types/OCPointerType", "to"));
        }
        return new OCPointerType(ref, null, null, false, false);
    }

    public static OCPointerType to(@NotNull OCType ref, @Nullable ARCAttribute attribute) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/jetbrains/cidr/lang/types/OCPointerType", "to"));
        }
        return new OCPointerType(ref, attribute, null, false, false);
    }

    public static OCPointerType to(@NotNull OCType ref, @Nullable ARCAttribute attribute, @Nullable OCType classQualifier) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/jetbrains/cidr/lang/types/OCPointerType", "to"));
        }
        return new OCPointerType(ref, attribute, classQualifier, false, false);
    }

    public static OCPointerType to(@NotNull OCType ref, @Nullable ARCAttribute attribute, @Nullable OCType classQualifier, boolean isConst, boolean isVolatile) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/jetbrains/cidr/lang/types/OCPointerType", "to"));
        }
        return new OCPointerType(ref, attribute, classQualifier, isConst, isVolatile);
    }

    public static OCType to(@NotNull OCType ref, int nTimes) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/jetbrains/cidr/lang/types/OCPointerType", "to"));
        }
        for (int i = 0; i < nTimes; ++i) {
            ref = OCPointerType.to(ref);
        }
        return ref;
    }

    public boolean isPointerToConst() {
        return this.myRefType.isConst();
    }

    public boolean isPointerToVolatile() {
        return this.myRefType.isVolatile();
    }

    @NotNull
    public OCType getRefType() {
        OCType oCType = this.myRefType;
        if (oCType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCPointerType", "getRefType"));
        }
        return oCType;
    }

    @Override
    @NotNull
    public OCType getTerminalType() {
        OCType oCType = this.myRefType.getTerminalType();
        if (oCType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCPointerType", "getTerminalType"));
        }
        return oCType;
    }

    @Override
    public int pointersDepth() {
        return this.myRefType.pointersDepth() + 1;
    }

    public OCType getClassQualifier() {
        return this.myClassQualifier;
    }

    @Override
    public int hashCode() {
        return this.baseHashCode() * 31 + this.myRefType.hashCode();
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/jetbrains/cidr/lang/types/OCPointerType", "deepEqualStep"));
        }
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/jetbrains/cidr/lang/types/OCPointerType", "deepEqualStep"));
        }
        if (second == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "com/jetbrains/cidr/lang/types/OCPointerType", "deepEqualStep"));
        }
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCPointerType f = (OCPointerType)first;
        OCPointerType s = (OCPointerType)second;
        if (f.myARCAttribute != s.myARCAttribute) {
            return false;
        }
        return c.equalObjects(f.myRefType, s.myRefType);
    }

    @Override
    public boolean isPointerCompatible(PsiElement context, boolean checkCppConvertible) {
        return true;
    }

    @Override
    public boolean isPointer() {
        return true;
    }

    public ARCAttribute getARCAttribute() {
        return this.myARCAttribute;
    }

    @Override
    public <T> T accept(OCTypeVisitor<T> visitor) {
        return visitor.visitPointerType(this);
    }

    @Override
    @NotNull
    protected OCType doGetLeastCommonType(OCType type, PsiElement context) {
        if (this.equals((Object)type, context)) {
            OCPointerType oCPointerType = this;
            if (oCPointerType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCPointerType", "doGetLeastCommonType"));
            }
            return oCPointerType;
        }
        if (type instanceof OCMagicType) {
            OCType oCType = type;
            if (oCType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCPointerType", "doGetLeastCommonType"));
            }
            return oCType;
        }
        if (this.isPointerToObject() && type.isPointerToObject() || type instanceof OCPointerType && this.myRefType.equals(((OCPointerType)type).getRefType(), false, new OCResolveContext(context))) {
            OCPointerType oCPointerType = OCPointerType.to(this.myRefType.getLeastCommonType(((OCPointerType)type).getRefType(), context));
            if (oCPointerType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCPointerType", "doGetLeastCommonType"));
            }
            return oCPointerType;
        }
        if (type.isNumberCompatible(context)) {
            OCPointerType oCPointerType = this;
            if (oCPointerType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCPointerType", "doGetLeastCommonType"));
            }
            return oCPointerType;
        }
        if (type.isPointerCompatible(context)) {
            OCPointerType oCPointerType = OCPointerType.to(OCVoidType.instance());
            if (oCPointerType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCPointerType", "doGetLeastCommonType"));
            }
            return oCPointerType;
        }
        OCUnknownType oCUnknownType = OCUnknownType.INSTANCE;
        if (oCUnknownType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCPointerType", "doGetLeastCommonType"));
        }
        return oCUnknownType;
    }

    public OCType.TypeCheckResult validateConstPointers(OCType type, PsiElement context) {
        OCType lType = this;
        OCType rType = type;
        boolean arrayToPointerCastsAvailable = true;
        boolean hasConstMismatch = false;
        boolean hasVolatileMismatch = false;
        boolean hasLengthMismatch = false;
        boolean incompatibleType = false;
        boolean unassignableArray = false;
        boolean isEquals = true;
        int pointersCnt = 0;
        while (lType instanceof OCPointerType && rType instanceof OCPointerType) {
            ++pointersCnt;
            OCPointerType lPtrType = lType;
            OCPointerType rPtrType = (OCPointerType)rType;
            if (!lPtrType.isPointerToConst() && rPtrType.isPointerToConst()) {
                hasConstMismatch = true;
            }
            if (!lPtrType.isPointerToVolatile() && rPtrType.isPointerToVolatile()) {
                hasVolatileMismatch = true;
            }
            if (pointersCnt > 1 && lPtrType.isPointerToConst() && !rPtrType.isPointerToConst()) {
                hasConstMismatch = true;
            }
            if (pointersCnt > 1 && lPtrType.isPointerToVolatile() && !rPtrType.isPointerToVolatile()) {
                hasVolatileMismatch = true;
            }
            if (lPtrType instanceof OCBlockPointerType != rPtrType instanceof OCBlockPointerType) {
                isEquals = false;
            }
            if (lPtrType instanceof OCArrayType) {
                OCArrayType lArrayType = (OCArrayType)lPtrType;
                if (pointersCnt > 1 && rPtrType instanceof OCArrayType) {
                    OCArrayType rArrayType = (OCArrayType)rPtrType;
                    if (lArrayType.getLength() != rArrayType.getLength()) {
                        hasLengthMismatch = true;
                    }
                } else if (lArrayType.hasLength()) {
                    unassignableArray = true;
                }
            } else if (rPtrType instanceof OCArrayType) {
                if (pointersCnt > 1 || !arrayToPointerCastsAvailable) {
                    incompatibleType = true;
                }
                arrayToPointerCastsAvailable = false;
            }
            lType = lPtrType.myRefType;
            rType = rPtrType.myRefType;
            if (lType instanceof OCCppReferenceType) {
                lType = ((OCCppReferenceType)lType).getRefType();
            }
            if (!(rType instanceof OCCppReferenceType)) continue;
            rType = ((OCCppReferenceType)rType).getRefType();
        }
        isEquals = lType instanceof OCIntType && rType instanceof OCIntType ? (isEquals &= lType.equals(rType, false, new OCResolveContext(context))) : (isEquals &= context != null && lType.equals(rType, false, new OCResolveContext(context)));
        boolean isLTypeVoidPtr = lType.isVoid() && pointersCnt == 1;
        OCType.TypeCheckResult generalErrorResult = new OCType.TypeCheckResult(OCType.TypeCheckState.ERROR, "", null, null, new IntentionAction[0]);
        if (!(isEquals || isLTypeVoidPtr || lType instanceof OCMagicType || rType instanceof OCMagicType)) {
            return generalErrorResult;
        }
        if (hasConstMismatch || hasVolatileMismatch) {
            final String message = "Assigning '" + type.getName(context) + "' to '" + this.getName(context) + "' discards " + (hasConstMismatch ? "const" : "volatile") + " qualifier";
            return new OCType.TypeCheckResult(OCType.TypeCheckState.ERROR_IF_CPP, OCInspections.IncompatiblePointers.class, "ext_typecheck_convert_discards_qualifiers", new IntentionAction[0]){

                @Override
                public String getMessage() {
                    return message;
                }
            };
        }
        if (hasLengthMismatch || incompatibleType || unassignableArray) {
            return generalErrorResult;
        }
        return OCTypeCompatibilityVisitor.OK_RESULT;
    }

    @Override
    public boolean isScalar() {
        return true;
    }

    @Override
    public boolean isCppStructType() {
        return false;
    }

    @Override
    public boolean isInstanceable() {
        return true;
    }

    @Override
    public boolean isUnresolved(@NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/types/OCPointerType", "isUnresolved"));
        }
        return this.myRefType.isUnresolved(context) || this.myClassQualifier != null && !(this.myClassQualifier instanceof OCStructType);
    }

    @Override
    public boolean isMagicInside(@NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/types/OCPointerType", "isMagicInside"));
        }
        return this.myRefType.isMagicInside(context);
    }

    @Override
    public boolean isSubclassOfMagic(PsiElement context) {
        return this.myRefType.isSubclassOfMagic(context);
    }

    @Override
    @NotNull
    public OCType getGuessedUnmagicType() {
        OCPointerType oCPointerType = OCPointerType.to(this.myRefType.getGuessedUnmagicType());
        if (oCPointerType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCPointerType", "getGuessedUnmagicType"));
        }
        return oCPointerType;
    }

    @Override
    public boolean isPointerToObject() {
        return this.myRefType instanceof OCObjectType;
    }

    @Override
    public boolean isPointerToCppStructType() {
        return this.myRefType.isCppStructType();
    }

    @Override
    public boolean isPointerToID() {
        return this.myRefType instanceof OCIdType;
    }

    @Override
    public boolean isPointerToChar() {
        OCResolveContext context = new OCResolveContext();
        return this.myRefType.equals(OCIntType.CHAR, false, context) || this.myRefType.equals(OCIntType.UCHAR, false, context) || this.myRefType.equals(OCIntType.SCHAR, false, context);
    }

    @Override
    public boolean isCString() {
        OCResolveContext context = new OCResolveContext();
        return this.myRefType.equals(OCIntType.CHAR, false, context) || this.myRefType.equals(OCIntType.UCHAR, false, context) || this.myRefType.equals(OCIntType.SCHAR, false, context) || this.myRefType.equals(OCIntType.WCHAR, false, context) || this.myRefType.equals(OCIntType.CHAR16, false, context) || this.myRefType.equals(OCIntType.CHAR32, false, context);
    }

    @Override
    public boolean isPointerToVoid() {
        return this.myRefType.isVoid();
    }

    @Override
    public String getFormatString() {
        if (this.isClassType()) {
            return "%@";
        }
        if (this.myRefType.isChar()) {
            return "%s";
        }
        if (OCIntType.WCHAR.equals(this.myRefType, false, new OCResolveContext())) {
            return "%ls";
        }
        if (this.isPointerToObject()) {
            return this.getRefType().getFormatString();
        }
        return "%p";
    }

    @Override
    public int getSizeInBytes(@Nullable PsiFile file2, @Nullable OCInclusionContext context) {
        return OCIntType.INT.getSizeInBytes(file2, context);
    }

    public Integer getLengthInBrackets() {
        return this.lengthInBrackets;
    }

    public void setLengthInBrackets(Integer lengthInBrackets) {
        this.lengthInBrackets = lengthInBrackets;
    }
}

