/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.search.OCMemberInheritorsSearch;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCObjectTypeContext {
    private StaticMode myStaticMode;
    private OCObjectType myType;
    private OCType myOriginalType;

    public OCObjectTypeContext(StaticMode staticMode, OCObjectType type, OCType originalType) {
        this.myStaticMode = staticMode;
        this.myType = type;
        this.myOriginalType = originalType;
    }

    public OCObjectTypeContext(boolean aStatic, boolean staticDoesntMatter, OCObjectType type, OCType originalType) {
        this(staticDoesntMatter ? StaticMode.NO_MATTER : (aStatic ? StaticMode.STATIC : StaticMode.INSTANCE), type, originalType);
    }

    public StaticMode getStaticMode() {
        return this.myStaticMode;
    }

    public boolean fitsStaticness(OCMethodSymbol responder) {
        return this.myStaticMode.fitsStaticness(responder);
    }

    public void setStaticDoesntMatter() {
        this.myStaticMode = StaticMode.NO_MATTER;
    }

    public OCObjectType getType() {
        return this.myType;
    }

    public OCType getOriginalType() {
        return this.myOriginalType;
    }

    @Nullable
    public OCMethodSymbol getKnownResponder(String selector, boolean searchInInterfaces) {
        CommonProcessors.FindFirstProcessor<OCMethodSymbol> finder = new CommonProcessors.FindFirstProcessor<OCMethodSymbol>(){

            protected boolean accept(OCMethodSymbol method) {
                return OCObjectTypeContext.this.fitsStaticness(method);
            }
        };
        if (searchInInterfaces) {
            this.myType.processMembers(selector, OCMethodSymbol.class, finder, true, false);
        }
        if (!finder.isFound()) {
            this.myType.processMembers(selector, OCMethodSymbol.class, finder, false, true);
        }
        return (OCMethodSymbol)finder.getFoundValue();
    }

    private static List<OCMethodSymbol> calcProbableResponders(OCObjectTypeContext receiverContext, String selector, Project project) {
        OCMemberInheritorsSearch.SearchParameters<OCMethodSymbol> parameters = OCMemberInheritorsSearch.getParameters(selector, receiverContext.getType().getClassSymbol(), project, OCMethodSymbol.class, StaticMode.NO_MATTER);
        parameters.setIncludeSelfImplementation(true);
        parameters.setInterfacesThenImplementations(true);
        parameters.setIncludeFromID(true);
        parameters.setInheritors(true);
        parameters.setAncestors(true);
        ArrayList<OCMethodSymbol> result2 = new ArrayList<OCMethodSymbol>(OCMemberInheritorsSearch.search(parameters).findAll());
        Collections.sort(result2, new Comparator<OCMethodSymbol>(){

            @Override
            public int compare(OCMethodSymbol o1, OCMethodSymbol o2) {
                return ((OCClassSymbol)o1.getParent()).compareTo(o2.getParent());
            }
        });
        return result2;
    }

    @NotNull
    public OCSendMessageExpression.ProbableResponders getProbableResponders(String selector, Project project) {
        OCMethodSymbol knownResponder = this.getKnownResponder(selector, true);
        List<OCMethodSymbol> allResponders = knownResponder == null ? OCObjectTypeContext.calcProbableResponders(this, selector, project) : Collections.singletonList(knownResponder);
        ArrayList<OCMethodSymbol> filteredResponders = new ArrayList<OCMethodSymbol>();
        for (OCMethodSymbol responder : allResponders) {
            if (!this.fitsStaticness(responder)) continue;
            filteredResponders.add(responder);
        }
        OCSendMessageExpression.ProbableResponders probableResponders = new OCSendMessageExpression.ProbableResponders(allResponders, filteredResponders, knownResponder, this);
        if (probableResponders == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCObjectTypeContext", "getProbableResponders"));
        }
        return probableResponders;
    }

    @Nullable
    public static OCMethodSymbol findSimilarResponder(@Nullable OCObjectType type, List<String> selectors, final List<OCType> argumentTypes, final PsiFile context) {
        if (selectors.size() == 1 && !selectors.get(0).endsWith(":")) {
            return null;
        }
        for (int i = argumentTypes.size() - 1; i >= 0; --i) {
            final int argumentsCnt = i;
            StringBuilder selectorBuilder = new StringBuilder();
            if (i > 0) {
                for (int j = 0; j < argumentsCnt; ++j) {
                    selectorBuilder.append(selectors.get(j));
                }
            } else {
                String firstSelector = selectors.get(0);
                if (firstSelector.isEmpty()) {
                    return null;
                }
                selectorBuilder.append(firstSelector.substring(0, firstSelector.length() - 1));
            }
            String selector = selectorBuilder.toString();
            CommonProcessors.FindFirstProcessor<OCMethodSymbol> finder = new CommonProcessors.FindFirstProcessor<OCMethodSymbol>(){

                protected boolean accept(OCMethodSymbol symbol) {
                    if (symbol.isVararg()) {
                        return false;
                    }
                    List<OCMethodSymbol.SelectorPartSymbol> symbolSelectors = symbol.getSelectors();
                    if (symbolSelectors.size() < argumentsCnt) {
                        return false;
                    }
                    for (int i = 0; i < argumentsCnt; ++i) {
                        OCType argumentType = (OCType)argumentTypes.get(i);
                        OCDeclaratorSymbol parameter = symbolSelectors.get(i).getParameter();
                        if (argumentType == null || parameter == null || parameter.getType().resolve(context).isCompatible(argumentType, (PsiElement)context)) continue;
                        return false;
                    }
                    return true;
                }
            };
            if (type != null) {
                type.processMembers(selector, OCMethodSymbol.class, finder, true, true);
            } else {
                OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(context.getProject(), new OCCommonProcessors.TypeFilteredProcessor((Processor<OCMethodSymbol>)finder, OCMethodSymbol.class), selector);
            }
            if (!finder.isFound()) continue;
            return (OCMethodSymbol)finder.getFoundValue();
        }
        return null;
    }

    public static enum StaticMode {
        STATIC,
        INSTANCE,
        NO_MATTER;


        public boolean fitsStaticness(OCMethodSymbol responder) {
            if (responder == null) {
                return false;
            }
            switch (this) {
                case STATIC: {
                    return responder.isStatic() || ((OCClassSymbol)responder.getParent()).getName().equals("NSObject");
                }
                case INSTANCE: {
                    return !responder.isStatic();
                }
                case NO_MATTER: {
                    return true;
                }
            }
            return false;
        }
    }
}

