/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCSymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCObjectType
extends OCType {
    @Nullable
    private OCInterfaceSymbol myInterface;
    @Nullable
    private OCImplementationSymbol myImplementation;
    private List<OCProtocolSymbol> myAugmentedProtocols;
    private List<OCProtocolSymbol> myAllProtocols;
    private List<OCInterfaceSymbol> myCategoryInterfaces;
    private List<OCImplementationSymbol> myCategoryImplementations;
    @Nullable
    private OCObjectType mySuperType;
    private boolean myIsKindof = false;

    public OCObjectType() {
    }

    public OCObjectType(@Nullable OCInterfaceSymbol anInterface, @Nullable OCImplementationSymbol implementation, List<OCProtocolSymbol> allProtocols, List<OCProtocolSymbol> augmentedProtocols, List<OCInterfaceSymbol> categoryInterfaces, List<OCImplementationSymbol> categoryImplementations, @Nullable OCObjectType superType, boolean isConst, boolean isVolatile, boolean isKindof) {
        super(isConst, isVolatile);
        this.myInterface = anInterface;
        this.myImplementation = implementation;
        this.myAllProtocols = allProtocols;
        this.myAugmentedProtocols = augmentedProtocols;
        this.myCategoryInterfaces = categoryInterfaces;
        this.myCategoryImplementations = categoryImplementations;
        this.mySuperType = superType;
        this.myIsKindof = isKindof;
    }

    public OCObjectType(@Nullable OCInterfaceSymbol anInterface, List<OCProtocolSymbol> allProtocols, List<OCProtocolSymbol> augmentedProtocols, boolean isConst, boolean isVolatile) {
        this(anInterface, null, allProtocols, augmentedProtocols, Collections.emptyList(), Collections.emptyList(), null, isConst, isVolatile, false);
    }

    public OCObjectType(@Nullable OCInterfaceSymbol anInterface, @Nullable OCObjectType superType) {
        this(anInterface, null, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), superType, false, false, false);
    }

    @Nullable
    public OCClassSymbol getClassSymbol() {
        return this.myInterface != null ? this.myInterface : this.myImplementation;
    }

    @Nullable
    public OCInterfaceSymbol getInterface() {
        return this.myInterface;
    }

    @Nullable
    public OCImplementationSymbol getImplementation() {
        return this.myImplementation;
    }

    public List<OCInterfaceSymbol> getCategoryInterfaces() {
        return this.myCategoryInterfaces;
    }

    public List<OCImplementationSymbol> getCategoryImplementations() {
        return this.myCategoryImplementations;
    }

    @NotNull
    public List<OCProtocolSymbol> getAllProtocols() {
        List<OCProtocolSymbol> list = this.myAllProtocols;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCObjectType", "getAllProtocols"));
        }
        return list;
    }

    public List<OCProtocolSymbol> getAugmentedProtocols() {
        return this.myAugmentedProtocols;
    }

    @Nullable
    public OCObjectType getSuperType() {
        return this.mySuperType;
    }

    @Override
    public <T> T accept(OCTypeVisitor<T> visitor) {
        return visitor.visitObjectType(this);
    }

    @Nullable
    public <T extends OCMemberSymbol> T findMember(String name, Class<T> memberClass) {
        CommonProcessors.FindFirstProcessor processor2 = new CommonProcessors.FindFirstProcessor();
        this.processMembers(name, memberClass, (Processor<? super T>)processor2);
        return (T)((OCMemberSymbol)processor2.getFoundValue());
    }

    public <T extends OCMemberSymbol> boolean processMembers(Class<T> memberClass, Processor<? super T> processor2) {
        return this.processMembers(null, memberClass, processor2);
    }

    public <T extends OCMemberSymbol> boolean processMembers(@Nullable String name, Class<T> memberClass, Processor<? super T> processor2) {
        return this.processMembers(this.myInterface, name, memberClass, processor2, true, true);
    }

    public <T extends OCMemberSymbol> boolean processMembers(@Nullable String name, Class<T> memberClass, Processor<? super T> processor2, boolean processIntf, boolean processImpl) {
        return this.processMembers(this.myInterface, name, memberClass, processor2, processIntf, processImpl);
    }

    public <T extends OCMemberSymbol> boolean processMembers(OCClassSymbol intfSymbol, @Nullable String name, Class<T> memberClass, Processor<? super T> processor2, boolean processIntf, boolean processImpl) {
        if (processIntf && intfSymbol != null && !OCObjectType.doProcessMembers(name, memberClass, Collections.singletonList(intfSymbol), processor2)) {
            return false;
        }
        if (processImpl && this.myImplementation != null && !OCObjectType.doProcessMembers(name, memberClass, Collections.singletonList(this.myImplementation), processor2)) {
            return false;
        }
        if (processIntf) {
            if (intfSymbol == this.myInterface && !OCObjectType.doProcessMembers(name, memberClass, this.myCategoryInterfaces, processor2)) {
                return false;
            }
            if (this.mySuperType != null && !this.mySuperType.processMembers(name, memberClass, processor2, true, false)) {
                return false;
            }
            if (!OCObjectType.doProcessMembers(name, memberClass, this.myAllProtocols, processor2)) {
                return false;
            }
        }
        if (processImpl) {
            if (intfSymbol == this.myInterface && !OCObjectType.doProcessMembers(name, memberClass, this.myCategoryImplementations, processor2)) {
                return false;
            }
            if (this.mySuperType != null && !this.mySuperType.processMembers(name, memberClass, processor2, false, true)) {
                return false;
            }
        }
        return true;
    }

    private static <T extends OCMemberSymbol> boolean doProcessMembers(@Nullable String selector, Class<T> memberClass, List<? extends OCClassSymbol> classes, Processor<? super T> processor2) {
        for (OCClassSymbol oCClassSymbol : classes) {
            if (oCClassSymbol.processMembers(selector, memberClass, processor2)) continue;
            return false;
        }
        return true;
    }

    public boolean processInterfaceMethods(OCClassSymbol intfSymbol, @Nullable String method, Processor<OCMethodSymbol> processor2, PsiElement context, boolean processBaseProtocols) {
        HashSet<String> baseProtocols = new HashSet<String>();
        LinkedHashSet<OCProtocolSymbol> baseProtocolSymbols = new LinkedHashSet<OCProtocolSymbol>();
        if (intfSymbol == null) {
            return true;
        }
        for (OCObjectType type = this.mySuperType; type != null; type = type.getSuperType()) {
            for (OCProtocolSymbol protocol : type.getAllProtocols()) {
                baseProtocols.add(protocol.getName());
                baseProtocolSymbols.add(protocol);
            }
        }
        if (!intfSymbol.processAllMethods(method, processor2, baseProtocols, context)) {
            return false;
        }
        if (intfSymbol.getCategoryName() != null) {
            return true;
        }
        for (OCInterfaceSymbol category : this.myCategoryInterfaces) {
            if (!"".equals(category.getCategoryName()) || category.processAllMethods(method, processor2, baseProtocols, context)) continue;
            return false;
        }
        if (processBaseProtocols) {
            for (OCProtocolSymbol protocol : baseProtocolSymbols) {
                if (protocol.processAllMethods(method, processor2, baseProtocols, context)) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    public String getClassName() {
        String string = OCSymbolImpl.getSymbolName(this.getClassSymbol());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCObjectType", "getClassName"));
        }
        return string;
    }

    @Override
    public int hashCode() {
        int result2 = this.baseHashCode();
        result2 = 31 * result2 + (this.myInterface == null ? 0 : this.myInterface.hashCode());
        result2 = 31 * result2 + (this.myImplementation == null ? 0 : this.myImplementation.hashCode());
        result2 = 31 * result2 + this.myAllProtocols.hashCode();
        result2 = 31 * result2 + Boolean.valueOf(this.myIsKindof).hashCode();
        return result2;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/jetbrains/cidr/lang/types/OCObjectType", "deepEqualStep"));
        }
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/jetbrains/cidr/lang/types/OCObjectType", "deepEqualStep"));
        }
        if (second == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "com/jetbrains/cidr/lang/types/OCObjectType", "deepEqualStep"));
        }
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCObjectType f = (OCObjectType)first;
        OCObjectType s = (OCObjectType)second;
        if (f.isKindof() != s.isKindof()) {
            return false;
        }
        if (!c.equalIterable(f.myAllProtocols, s.myAllProtocols)) {
            return false;
        }
        if (!c.equalIterable(f.myAugmentedProtocols, s.myAugmentedProtocols)) {
            return false;
        }
        if (!c.equalIterable(f.myCategoryImplementations, s.myCategoryImplementations)) {
            return false;
        }
        if (!c.equalIterable(f.myCategoryInterfaces, s.myCategoryInterfaces)) {
            return false;
        }
        if (!c.equalObjects(f.myImplementation, s.myImplementation)) {
            return false;
        }
        if (!c.equalObjects(f.myInterface, s.myInterface)) {
            return false;
        }
        return c.equalObjects(f.mySuperType, s.mySuperType);
    }

    @Override
    @NotNull
    protected OCType doGetLeastCommonType(OCType type, PsiElement context) {
        if (type == null) {
            OCUnknownType oCUnknownType = OCUnknownType.INSTANCE;
            if (oCUnknownType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCObjectType", "doGetLeastCommonType"));
            }
            return oCUnknownType;
        }
        if (type instanceof OCObjectType) {
            if (this instanceof OCIdType && this.getAllProtocols().isEmpty()) {
                OCType oCType = type;
                if (oCType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCObjectType", "doGetLeastCommonType"));
                }
                return oCType;
            }
            if (type instanceof OCIdType && ((OCIdType)type).getAllProtocols().isEmpty()) {
                OCObjectType oCObjectType = this;
                if (oCObjectType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCObjectType", "doGetLeastCommonType"));
                }
                return oCObjectType;
            }
            if (this.checkCompatible(type, context).getState() == OCType.TypeCheckState.OK) {
                OCObjectType oCObjectType = this;
                if (oCObjectType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCObjectType", "doGetLeastCommonType"));
                }
                return oCObjectType;
            }
            if (type.checkCompatible(this, context).getState() == OCType.TypeCheckState.OK) {
                OCType oCType = type;
                if (oCType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCObjectType", "doGetLeastCommonType"));
                }
                return oCType;
            }
            if (this.mySuperType != null) {
                OCType result2 = this.mySuperType.getLeastCommonType(type, context);
                if (result2 instanceof OCObjectType) {
                    for (OCProtocolSymbol protocol : this.myAllProtocols) {
                        if (!((OCObjectType)type).implementsProtocol(protocol)) continue;
                        result2 = ((OCObjectType)result2).augmentWithProtocol(protocol);
                    }
                }
                OCType oCType = result2;
                if (oCType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCObjectType", "doGetLeastCommonType"));
                }
                return oCType;
            }
            OCClassSymbol classSymbol = ((OCObjectType)type).getClassSymbol();
            Project project = classSymbol != null ? classSymbol.getProject() : null;
            OCType oCType = project != null ? OCIdType.pointerToID(project).getRefType() : OCUnknownType.INSTANCE;
            if (oCType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCObjectType", "doGetLeastCommonType"));
            }
            return oCType;
        }
        if (type.isPointerCompatible(context)) {
            OCPointerType oCPointerType = OCPointerType.to(OCVoidType.instance());
            if (oCPointerType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCObjectType", "doGetLeastCommonType"));
            }
            return oCPointerType;
        }
        OCUnknownType oCUnknownType = OCUnknownType.INSTANCE;
        if (oCUnknownType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCObjectType", "doGetLeastCommonType"));
        }
        return oCUnknownType;
    }

    public boolean isAncestorOf(@Nullable OCObjectType type) {
        if (this instanceof OCIdType) {
            return true;
        }
        OCClassSymbol classSymbol = this.getClassSymbol();
        if (classSymbol == null) {
            return false;
        }
        while (!(type == null || type.getClassSymbol() != null && classSymbol.isSameClass(type.getClassSymbol()))) {
            type = type.mySuperType;
        }
        return type != null;
    }

    public boolean implementsProtocol(@Nullable OCProtocolSymbol protocol) {
        return this.myAllProtocols.contains(protocol) || this.mySuperType != null && this.mySuperType.implementsProtocol(protocol);
    }

    public OCObjectType augmentWithProtocol(@NotNull OCProtocolSymbol protocolSymbol) {
        if (protocolSymbol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "protocolSymbol", "com/jetbrains/cidr/lang/types/OCObjectType", "augmentWithProtocol"));
        }
        if (this.implementsProtocol(protocolSymbol)) {
            return this;
        }
        OCObjectType copy = (OCObjectType)this.getShallowCopy();
        copy.myAugmentedProtocols = OCObjectType.cloneWithAddedProtocol(copy.myAugmentedProtocols, protocolSymbol);
        copy.myAllProtocols = OCObjectType.cloneWithAddedProtocol(copy.myAllProtocols, protocolSymbol);
        return copy;
    }

    @NotNull
    private static List<OCProtocolSymbol> cloneWithAddedProtocol(@NotNull List<OCProtocolSymbol> protocols, @NotNull OCProtocolSymbol protocolSymbol) {
        if (protocols == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "protocols", "com/jetbrains/cidr/lang/types/OCObjectType", "cloneWithAddedProtocol"));
        }
        if (protocolSymbol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "protocolSymbol", "com/jetbrains/cidr/lang/types/OCObjectType", "cloneWithAddedProtocol"));
        }
        ArrayList<OCProtocolSymbol> newProtocols = new ArrayList<OCProtocolSymbol>(protocols.size() + 1);
        newProtocols.addAll(protocols);
        newProtocols.add(protocolSymbol);
        ArrayList<OCProtocolSymbol> arrayList = newProtocols;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCObjectType", "cloneWithAddedProtocol"));
        }
        return arrayList;
    }

    @Override
    public boolean isScalar() {
        return true;
    }

    public boolean isKindof() {
        return this.myIsKindof;
    }

    @Override
    public String getFormatString() {
        return "%@";
    }
}

