/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeMapper;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCNumericType
extends OCType {
    protected OCTypeMapper.CTypeId myTypeId;

    public abstract int getRank(@NotNull PsiElement var1);

    public abstract boolean isSigned();

    public abstract boolean isComplex();

    public int getBits(@Nullable PsiElement element, @Nullable OCInclusionContext context) {
        return this.getSizeInBytes(element == null ? null : element.getContainingFile(), context) * 8;
    }

    @Override
    public int getSizeInBytes(@Nullable PsiFile file2, @Nullable OCInclusionContext context) {
        return this.myTypeId.getBytes(file2, context);
    }

    @NotNull
    public OCTypeMapper.CTypeId getCTypeId() {
        OCTypeMapper.CTypeId cTypeId = this.myTypeId;
        if (cTypeId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCNumericType", "getCTypeId"));
        }
        return cTypeId;
    }

    public OCNumericType() {
    }

    public OCNumericType(boolean isConst, boolean isVolatile) {
        super(isConst, isVolatile);
    }

    @Override
    @NotNull
    protected OCType doGetLeastCommonType(OCType type, @NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/types/OCNumericType", "doGetLeastCommonType"));
        }
        if (type == null) {
            OCUnknownType oCUnknownType = OCUnknownType.INSTANCE;
            if (oCUnknownType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCNumericType", "doGetLeastCommonType"));
            }
            return oCUnknownType;
        }
        if (type instanceof OCNumericType) {
            OCType result2;
            OCType oCType = result2 = this.getRank(context) < ((OCNumericType)type).getRank(context) ? type : this;
            if (this.isComplex() || ((OCNumericType)type).isComplex()) {
                OCRealType oCRealType = ((OCRealType)result2).cloneWithComplexModifier();
                if (oCRealType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCNumericType", "doGetLeastCommonType"));
                }
                return oCRealType;
            }
            OCType oCType2 = result2;
            if (oCType2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCNumericType", "doGetLeastCommonType"));
            }
            return oCType2;
        }
        if (type.isPointerCompatible(context)) {
            OCType oCType = type;
            if (oCType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCNumericType", "doGetLeastCommonType"));
            }
            return oCType;
        }
        if (type instanceof OCStructType && ((OCStructType)type).getKind() == OCSymbolKind.ENUM) {
            OCNumericType oCNumericType = this;
            if (oCNumericType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCNumericType", "doGetLeastCommonType"));
            }
            return oCNumericType;
        }
        OCUnknownType oCUnknownType = OCUnknownType.INSTANCE;
        if (oCUnknownType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCNumericType", "doGetLeastCommonType"));
        }
        return oCUnknownType;
    }

    @Override
    @Nullable
    public String getAliasName() {
        return this.myAliasName != null && this.myAliasName.contains("<") ? null : this.myAliasName;
    }

    @Override
    public boolean isNumberCompatible(PsiElement context) {
        return true;
    }

    @Override
    public boolean isScalar() {
        return true;
    }

    @Override
    public boolean isInstanceable() {
        return true;
    }

    @Override
    public int hashCode() {
        return this.baseHashCode() * 31 + this.myTypeId.hashCode();
    }
}

