/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCMagicType
extends OCType {
    public static final String UNKNOWN = "<unknown>";
    @NotNull
    private String myName;
    @Nullable
    private OCType myGuessedType;

    public OCMagicType(@NotNull String name, @Nullable OCType guessedType, boolean isConst, boolean isVolatile) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/cidr/lang/types/OCMagicType", "<init>"));
        }
        super(isConst, isVolatile);
        this.myName = name;
        this.myGuessedType = guessedType;
    }

    public OCMagicType(String name) {
        this(name, false, false);
    }

    public OCMagicType(String name, boolean isConst, boolean isVolatile) {
        this(name != null ? name : UNKNOWN, null, isConst, isVolatile);
    }

    public OCMagicType() {
        this(UNKNOWN, null, false, false);
    }

    public OCMagicType(OCType inner) {
        this(inner.getName(), inner, false, false);
    }

    @Override
    public <T> T accept(OCTypeVisitor<T> visitor) {
        return visitor.visitMagicType(this);
    }

    @NotNull
    public String getMagicName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCMagicType", "getMagicName"));
        }
        return string;
    }

    @Override
    public boolean isInstanceable() {
        return true;
    }

    @Override
    public boolean isUnknown() {
        return true;
    }

    @Override
    public boolean isCppStructType() {
        return true;
    }

    public OCType getRefType() {
        OCType guessedUnmagicType = this.getGuessedUnmagicType();
        if (guessedUnmagicType instanceof OCPointerType) {
            return new OCMagicType(((OCPointerType)guessedUnmagicType).getRefType());
        }
        return this;
    }

    @Override
    @NotNull
    public OCType getTerminalType() {
        OCType guessedUnmagicType = this.getGuessedUnmagicType();
        if (guessedUnmagicType instanceof OCPointerType) {
            OCMagicType oCMagicType = new OCMagicType(guessedUnmagicType.getTerminalType());
            if (oCMagicType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCMagicType", "getTerminalType"));
            }
            return oCMagicType;
        }
        OCMagicType oCMagicType = this;
        if (oCMagicType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCMagicType", "getTerminalType"));
        }
        return oCMagicType;
    }

    @Override
    @NotNull
    public OCType getGuessedUnmagicType() {
        OCType oCType = this.myGuessedType != null ? this.myGuessedType.getGuessedUnmagicType() : this;
        if (oCType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCMagicType", "getGuessedUnmagicType"));
        }
        return oCType;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/jetbrains/cidr/lang/types/OCMagicType", "deepEqualStep"));
        }
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/jetbrains/cidr/lang/types/OCMagicType", "deepEqualStep"));
        }
        if (second == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "com/jetbrains/cidr/lang/types/OCMagicType", "deepEqualStep"));
        }
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCMagicType f = (OCMagicType)first;
        OCMagicType s = (OCMagicType)second;
        if (!f.myName.equals(s.myName)) {
            return false;
        }
        return c.equalObjects(f.myGuessedType, s.myGuessedType);
    }

    @Override
    public int hashCode() {
        return this.baseHashCode() * 31 + this.myName.hashCode();
    }
}

