/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.types.ARCAttribute;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCBlockPointerType
extends OCPointerType {
    public OCBlockPointerType() {
    }

    public OCBlockPointerType(OCType refType, ARCAttribute attribute, boolean isConst, boolean isVolatile) {
        super(refType, attribute, null, isConst, isVolatile);
    }

    public static OCBlockPointerType blockPtr(@NotNull OCType refType) {
        if (refType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refType", "com/jetbrains/cidr/lang/types/OCBlockPointerType", "blockPtr"));
        }
        return OCBlockPointerType.blockPtr(refType, null, false, false);
    }

    public static OCBlockPointerType blockPtr(@NotNull OCType refType, ARCAttribute attribute, boolean isConst, boolean isVolatile) {
        if (refType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refType", "com/jetbrains/cidr/lang/types/OCBlockPointerType", "blockPtr"));
        }
        return new OCBlockPointerType(refType, attribute, isConst, isVolatile);
    }

    @Override
    public <T> T accept(OCTypeVisitor<T> visitor) {
        return visitor.visitBlockPointerType(this);
    }

    @Override
    public String getDefaultValue(PsiElement context) {
        OCType ref = this.getRefType();
        if (ref instanceof OCFunctionType) {
            List<? extends OCType> argumentTypes;
            OCFunctionType fun = (OCFunctionType)ref;
            StringBuilder builder = new StringBuilder();
            builder.append("^");
            OCType returnType = fun.getReturnType();
            String returnTypeName = returnType.getName();
            if (!"void".equals(returnTypeName)) {
                builder.append(returnTypeName);
            }
            if (!(argumentTypes = fun.getParameterTypes()).isEmpty()) {
                builder.append("(");
                List<String> names = fun.getParameterNames();
                for (int i = 0; i < argumentTypes.size(); ++i) {
                    String name;
                    if (i > 0) {
                        builder.append(", ");
                    }
                    OCType argType = argumentTypes.get(i);
                    String string = name = names != null ? names.get(i) : "<unnamed>";
                    if ("<unnamed>".equals(name)) {
                        Collection<String> possibilities = OCNameSuggester.suggestForType(argType, null, Collections.<String>emptyList());
                        name = possibilities.isEmpty() ? "" : (String)ContainerUtil.getFirstItem(possibilities);
                    }
                    builder.append(OCElementFactory.declarationText(name != null ? name : "", argType, context));
                }
                builder.append(") ");
            }
            builder.append("{\n");
            if (!returnType.isVoid()) {
                builder.append("return ");
                builder.append(returnType.getDefaultValue(context));
                builder.append(";\n");
            }
            builder.append("}");
            return builder.toString();
        }
        return super.getDefaultValue(context);
    }
}

