/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCAutoType
extends OCType {
    @Nullable
    private OCType myIncompleteType;
    private OCTypeSubstitution mySubstitution;
    private OCExpressionSymbol myExpressionSymbol;
    private OCExpression myExpressionElement;

    public OCAutoType(@Nullable OCExpressionSymbol expressionSymbol, @Nullable OCExpression expressionElement, @Nullable OCType incompleteType, boolean isConst, boolean isVolatile) {
        super(isConst, isVolatile);
        this.mySubstitution = OCTypeSubstitution.ID;
        this.myExpressionSymbol = expressionSymbol;
        this.myExpressionElement = expressionElement;
        this.myIncompleteType = incompleteType;
    }

    public OCAutoType(@NotNull OCAutoType origin, OCTypeSubstitution substitution, @NotNull OCResolveContext context) {
        if (origin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "origin", "com/jetbrains/cidr/lang/types/OCAutoType", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/types/OCAutoType", "<init>"));
        }
        this.mySubstitution = OCTypeSubstitution.ID;
        this.myIncompleteType = origin.getIncompleteType();
        this.myExpressionSymbol = origin.getExpressionSymbol();
        this.myExpressionElement = origin.getExpressionElement();
        this.mySubstitution = OCTypeSubstitution.compose(origin.mySubstitution, substitution, context);
    }

    public OCAutoType() {
        this.mySubstitution = OCTypeSubstitution.ID;
    }

    public OCTypeSubstitution getSubstitution() {
        return this.mySubstitution;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/jetbrains/cidr/lang/types/OCAutoType", "deepEqualStep"));
        }
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/jetbrains/cidr/lang/types/OCAutoType", "deepEqualStep"));
        }
        if (second == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "com/jetbrains/cidr/lang/types/OCAutoType", "deepEqualStep"));
        }
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCAutoType f = (OCAutoType)first;
        OCAutoType s = (OCAutoType)second;
        return c.equalObjects(f.myExpressionSymbol, s.myExpressionSymbol);
    }

    @Nullable
    public OCType getIncompleteType() {
        return this.myIncompleteType;
    }

    @Nullable
    public OCExpressionSymbol getExpressionSymbol() {
        return this.myExpressionSymbol;
    }

    @Nullable
    public OCExpression getExpressionElement() {
        return this.myExpressionElement;
    }

    @Override
    public <T> T accept(OCTypeVisitor<T> visitor) {
        return visitor.visitAutoType(this);
    }

    @Override
    public int hashCode() {
        int result2 = this.baseHashCode();
        result2 = 31 * result2 + (this.myIncompleteType != null ? this.myIncompleteType.hashCode() : 0);
        result2 = 31 * result2 + (this.mySubstitution != null ? this.mySubstitution.hashCode() : 0);
        result2 = 31 * result2 + (this.myExpressionSymbol != null ? this.myExpressionSymbol.hashCode() : 0);
        return result2;
    }
}

