/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeNameVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CVQualifiers {
    public static CVQualifiers EMPTY = new CVQualifiers(false, false);
    private final boolean myConst;
    private final boolean myVolatile;

    public CVQualifiers(boolean isConst, boolean isVolatile) {
        this.myConst = isConst;
        this.myVolatile = isVolatile;
    }

    public boolean isConst() {
        return this.myConst;
    }

    public boolean isVolatile() {
        return this.myVolatile;
    }

    @NotNull
    public CVQualifiers or(@NotNull CVQualifiers modifiers) {
        if (modifiers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifiers", "com/jetbrains/cidr/lang/types/CVQualifiers", "or"));
        }
        CVQualifiers cVQualifiers = new CVQualifiers(this.myConst || modifiers.isConst(), this.myVolatile || modifiers.isVolatile());
        if (cVQualifiers == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/CVQualifiers", "or"));
        }
        return cVQualifiers;
    }

    public void appendCVQualifiers(@NotNull StringBuilder buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/jetbrains/cidr/lang/types/CVQualifiers", "appendCVQualifiers"));
        }
        if (this.isConst()) {
            buffer.append(" const");
        }
        if (this.isVolatile()) {
            buffer.append(" volatile");
        }
    }

    @NotNull
    public static String appendCVQualifiers(@NotNull String typeString, @NotNull OCType type, @Nullable Project project) {
        if (typeString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeString", "com/jetbrains/cidr/lang/types/CVQualifiers", "appendCVQualifiers"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/cidr/lang/types/CVQualifiers", "appendCVQualifiers"));
        }
        if (type.isConst()) {
            typeString = OCTypeNameVisitor.addTypeQualifier(typeString, type, project, "const");
        }
        if (type.isVolatile()) {
            typeString = OCTypeNameVisitor.addTypeQualifier(typeString, type, project, "volatile");
        }
        String string = typeString;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/CVQualifiers", "appendCVQualifiers"));
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CVQualifiers that = (CVQualifiers)o;
        if (this.myConst != that.myConst) {
            return false;
        }
        return this.myVolatile == that.myVolatile;
    }

    public int hashCode() {
        int result2 = this.myConst ? 1 : 0;
        result2 = 31 * result2 + (this.myVolatile ? 1 : 0);
        return result2;
    }
}

