/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.toolchains;

import com.intellij.openapi.util.Pair;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrSwitchBuilder {
    private final ArrayList<String> myCommandLineArgs = new ArrayList();
    private final ArrayList<String> myFileArgs = new ArrayList();

    @NotNull
    public CidrSwitchBuilder addSingle(@Nullable String option) {
        if (option != null) {
            if (option.isEmpty()) {
                this.myCommandLineArgs.add("\"\"");
                this.myFileArgs.add("\"\"");
            } else {
                Pair<List<String>, List<String>> escaped = CidrSwitchBuilder.parseParameters(option, Format.COMMAND_LINE_ARGS, true);
                this.myCommandLineArgs.addAll((Collection)escaped.first);
                this.myFileArgs.addAll((Collection)escaped.second);
            }
        }
        CidrSwitchBuilder cidrSwitchBuilder = this;
        if (cidrSwitchBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/toolchains/CidrSwitchBuilder", "addSingle"));
        }
        return cidrSwitchBuilder;
    }

    public CidrSwitchBuilder addAll(@Nullable String options, @NotNull Format format) {
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/jetbrains/cidr/lang/toolchains/CidrSwitchBuilder", "addAll"));
        }
        if (options != null) {
            Pair<List<String>, List<String>> parsed = CidrSwitchBuilder.parseParameters(options, format, false);
            this.myCommandLineArgs.addAll((Collection)parsed.first);
            this.myFileArgs.addAll((Collection)parsed.second);
        }
        return this;
    }

    @NotNull
    public CidrSwitchBuilder addAll(@Nullable CidrCompilerSwitches switches) {
        if (switches != null) {
            this.myCommandLineArgs.addAll(switches.getCommandLineArgs());
            this.myFileArgs.addAll(switches.getFileArgs());
        }
        CidrSwitchBuilder cidrSwitchBuilder = this;
        if (cidrSwitchBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/toolchains/CidrSwitchBuilder", "addAll"));
        }
        return cidrSwitchBuilder;
    }

    @NotNull
    public CidrCompilerSwitches build() {
        CidrCompilerSwitches cidrCompilerSwitches = new CidrCompilerSwitches(new ArrayList<String>(this.myCommandLineArgs), new ArrayList<String>(this.myFileArgs));
        if (cidrCompilerSwitches == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/toolchains/CidrSwitchBuilder", "build"));
        }
        return cidrCompilerSwitches;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Pair<List<String>, List<String>> parseParameters(@NotNull String options, @NotNull Format format, boolean single) {
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/jetbrains/cidr/lang/toolchains/CidrSwitchBuilder", "parseParameters"));
        }
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/jetbrains/cidr/lang/toolchains/CidrSwitchBuilder", "parseParameters"));
        }
        ArrayList<String> cmArgs = new ArrayList<String>();
        ArrayList<String> fileArgs = new ArrayList<String>();
        StringBuilder cmArg = new StringBuilder();
        StringBuilder fileArg = new StringBuilder();
        int escapeCount = 0;
        char inQuotes = '\u0000';
        int length = options.length();
        for (int i = 0; i < length; ++i) {
            boolean escaped;
            char c = options.charAt(i);
            boolean bl = escaped = !(format != Format.FILE_ARGS && escapeCount == 0 || format != Format.COMMAND_LINE_ARGS && !(escapeCount & true));
            if (!escaped) {
                if (inQuotes != '\u0000' && c == inQuotes) {
                    cmArg.append(c);
                    fileArg.append(c);
                    inQuotes = '\u0000';
                    continue;
                }
                if (inQuotes == '\u0000' && (c == '\"' || c == '\'')) {
                    cmArg.append(c);
                    fileArg.append(c);
                    inQuotes = c;
                    continue;
                }
                if (inQuotes == '\u0000' && " \t\n\r\f".indexOf(c) != -1) {
                    if (single) {
                        cmArg.append('\\');
                        fileArg.append('\\');
                    } else {
                        if (cmArg.length() > 0) {
                            cmArgs.add(cmArg.toString());
                            fileArgs.add(fileArg.toString());
                        }
                        cmArg.setLength(0);
                        fileArg.setLength(0);
                        continue;
                    }
                }
            } else if (format == Format.COMMAND_LINE_ARGS && inQuotes != '\u0000' && escapeCount % 2 != 0 && c == ' ') {
                fileArg.append('\\');
            }
            escapeCount = c == '\\' ? ++escapeCount : 0;
            cmArg.append(c);
            fileArg.append(c);
        }
        if (cmArg.length() > 0) {
            cmArgs.add(cmArg.toString());
        }
        if (fileArg.length() > 0) {
            fileArgs.add(fileArg.toString());
        }
        return Pair.create(cmArgs, fileArgs);
    }

    public static enum Format {
        COMMAND_LINE_ARGS,
        FILE_ARGS;

    }
}

