/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.OCSymbolTablesBuildingActivity;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SymbolTableProvider<FILE extends PsiFile> {
    private static final Logger LOG = Logger.getInstance(SymbolTableProvider.class);
    public static final ExtensionPointName<SymbolTableProvider> INSTANCE = ExtensionPointName.create((String)"cidr.lang.symbolTableProvider");

    protected abstract boolean isSource(@NotNull PsiFile var1);

    public abstract boolean isSource(@NotNull VirtualFile var1);

    @NotNull
    public abstract FileSymbolTable calcTableUsingPSI(@NotNull FILE var1, @NotNull VirtualFile var2, @NotNull OCInclusionContext var3);

    @NotNull
    public abstract FileSymbolTable calcTable(@NotNull FILE var1, @NotNull VirtualFile var2, @NotNull OCInclusionContext var3);

    @Nullable
    public List<OCSymbolTablesBuildingActivity.TaskProvider<?>> getItemProviderAndWorkerForAdditionalSymbolLoading(@NotNull Project project, @NotNull ProgressIndicator indicator, @NotNull Collection<VirtualFile> allFiles) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/symbols/symtable/SymbolTableProvider", "getItemProviderAndWorkerForAdditionalSymbolLoading"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/cidr/lang/symbols/symtable/SymbolTableProvider", "getItemProviderAndWorkerForAdditionalSymbolLoading"));
        }
        if (allFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allFiles", "com/jetbrains/cidr/lang/symbols/symtable/SymbolTableProvider", "getItemProviderAndWorkerForAdditionalSymbolLoading"));
        }
        return null;
    }

    @NotNull
    public static <FILE extends PsiFile> SymbolTableProvider<FILE> getProvider(FILE file2) {
        SymbolTableProvider[] providers;
        for (SymbolTableProvider provider : providers = (SymbolTableProvider[])INSTANCE.getExtensions()) {
            if (!provider.isSource(file2)) continue;
            SymbolTableProvider symbolTableProvider = provider;
            if (symbolTableProvider == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/symtable/SymbolTableProvider", "getProvider"));
            }
            return symbolTableProvider;
        }
        LOG.error(file2.getClass());
        if (null == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/symtable/SymbolTableProvider", "getProvider"));
        }
        return null;
    }

    public static boolean isSourceFile(@Nullable VirtualFile virtualFile) {
        if (virtualFile == null || !virtualFile.isValid()) {
            return false;
        }
        for (SymbolTableProvider provider : (SymbolTableProvider[])INSTANCE.getExtensions()) {
            if (!provider.isSource(virtualFile)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSourceFile(@Nullable PsiFile file2) {
        if (file2 == null) {
            return false;
        }
        for (SymbolTableProvider provider : (SymbolTableProvider[])INSTANCE.getExtensions()) {
            if (!provider.isSource(file2)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    protected static String getFileText(@NotNull PsiFile file2, @NotNull VirtualFile virtualFile) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/symbols/symtable/SymbolTableProvider", "getFileText"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/jetbrains/cidr/lang/symbols/symtable/SymbolTableProvider", "getFileText"));
        }
        PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)file2.getProject());
        Document document = manager.getCachedDocument(file2);
        if (document != null) {
            String string = document.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/symtable/SymbolTableProvider", "getFileText"));
            }
            return string;
        }
        String string = LoadTextUtil.loadText(virtualFile).toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/symtable/SymbolTableProvider", "getFileText"));
        }
        return string;
    }
}

