/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.NotNullFunction;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.jetbrains.cidr.lang.inspections.OCGlobalUnusedInspection;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCEnum;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCIncludeDirective;
import com.jetbrains.cidr.lang.psi.OCLocalSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCMacroCallArgument;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCTemplateParameterList;
import com.jetbrains.cidr.lang.psi.impl.symbols.OCFileGlobalSymbols;
import com.jetbrains.cidr.lang.psi.impl.symbols.OCFileGlobalSymbolsCache;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFileSymbols
extends OCRecursiveVisitor {
    private MostlySingularMultiMap<String, OCSymbol> myLocalSymbolsMap = new MostlySingularMultiMap();
    private List<OCSymbol> myLocalNamespaceUsings = new ArrayList<OCSymbol>();
    private boolean myIsInsideLocalScope = false;
    private Set<VirtualFile> myUsedFiles = new HashSet<VirtualFile>();
    private static final NotNullLazyKey<OCFileSymbols, AnnotationSession> CACHE = NotNullLazyKey.create((String)"LOCAL_SYMBOL_TABLE_DURING_ANNOTATION", (NotNullFunction)new NotNullFunction<AnnotationSession, OCFileSymbols>(){

        @NotNull
        public OCFileSymbols fun(AnnotationSession dom) {
            PsiFile file2 = dom.getFile();
            OCFileSymbols symbols = new OCFileSymbols();
            file2.accept((PsiElementVisitor)symbols);
            for (String key : symbols.myLocalSymbolsMap.keySet()) {
                Iterable iterable = symbols.myLocalSymbolsMap.get((Object)key);
                if (!(iterable instanceof List) || ((List)iterable).size() <= 1) continue;
                Collections.sort((List)iterable, OCSymbolOffsetUtil.SYMBOL_COMPARATOR_BY_SCOPE);
            }
            Collections.sort(symbols.myLocalNamespaceUsings, OCSymbolOffsetUtil.SYMBOL_COMPARATOR_BY_SCOPE);
            OCFileSymbols oCFileSymbols = symbols;
            if (oCFileSymbols == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/symtable/OCFileSymbols$1", "fun"));
            }
            return oCFileSymbols;
        }
    });

    private OCFileSymbols() {
    }

    @Override
    public void visitOCElement(OCElement scopeElement) {
        if (scopeElement instanceof OCCallable || scopeElement instanceof OCTemplateParameterList) {
            boolean old = this.myIsInsideLocalScope;
            this.myIsInsideLocalScope = true;
            super.visitOCElement(scopeElement);
            this.myIsInsideLocalScope = old;
        } else {
            super.visitOCElement(scopeElement);
        }
    }

    @Override
    public void visitLocalSymbolDeclarator(OCLocalSymbolDeclarator declarator) {
        if (!this.myIsInsideLocalScope) {
            super.visitLocalSymbolDeclarator(declarator);
        } else {
            Object symbol = declarator.getLocalSymbol();
            if (symbol != null && symbol.getScope() != null) {
                if (symbol.getKind() == OCSymbolKind.NAMESPACE_USING_SYMBOL) {
                    this.myLocalNamespaceUsings.add((OCSymbol)symbol);
                } else {
                    this.myLocalSymbolsMap.add((Object)symbol.getName(), symbol);
                }
            }
        }
    }

    @Override
    public void visitStructLike(OCStructLike struct) {
        if (!this.myIsInsideLocalScope) {
            super.visitStructLike(struct);
        } else {
            this.visitLocalSymbolDeclarator(struct);
            final OCStructSymbol structSymbol = (OCStructSymbol)struct.getLocalSymbol();
            if (struct instanceof OCEnum) {
                ((OCEnum)struct).processEnumConsts(new Processor<OCSymbol>(){

                    public boolean process(OCSymbol symbol) {
                        if (symbol != null && symbol.getScope() != null) {
                            if (structSymbol != null && structSymbol.getKind() == OCSymbolKind.ENUM) {
                                ((OCDeclaratorSymbol)symbol).setType(structSymbol.getType());
                            } else {
                                ((OCDeclaratorSymbol)symbol).setType(OCIntType.INT);
                            }
                            OCFileSymbols.this.myLocalSymbolsMap.add((Object)symbol.getName(), (Object)symbol);
                        }
                        return true;
                    }
                });
            } else {
                this.visitElement(struct);
            }
        }
    }

    @Override
    public void visitMacroCallArgument(OCMacroCallArgument argument) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canBeLocalSymbol(@NotNull OCFile file2, String name) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/symbols/symtable/OCFileSymbols", "canBeLocalSymbol"));
        }
        Object object = file2.getAnnotationSessionLock();
        synchronized (object) {
            AnnotationSession annotationSession = file2.getCurrentAnnotationSession();
            if (annotationSession != null) {
                OCFileSymbols localSymbols = (OCFileSymbols)((Object)CACHE.getValue((UserDataHolder)annotationSession));
                return localSymbols.myLocalSymbolsMap.containsKey((Object)name) || !localSymbols.myLocalNamespaceUsings.isEmpty();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Iterable<OCSymbol> getLocalSymbols(@NotNull OCFile file2, String name) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/symbols/symtable/OCFileSymbols", "getLocalSymbols"));
        }
        Object object = file2.getAnnotationSessionLock();
        synchronized (object) {
            AnnotationSession annotationSession = file2.getCurrentAnnotationSession();
            if (annotationSession != null) {
                OCFileSymbols localSymbols = (OCFileSymbols)((Object)CACHE.getValue((UserDataHolder)annotationSession));
                if (localSymbols.myLocalNamespaceUsings.size() == 0) {
                    return localSymbols.myLocalSymbolsMap.get((Object)name);
                }
                Iterable iterable = localSymbols.myLocalSymbolsMap.get((Object)name);
                if (iterable instanceof Set) {
                    ArrayList named = new ArrayList(1);
                    named.add(iterable.iterator().next());
                    return ContainerUtil.mergeSortedLists(localSymbols.myLocalNamespaceUsings, named, OCSymbolOffsetUtil.SYMBOL_COMPARATOR_BY_SCOPE, (boolean)false);
                }
                if (iterable instanceof List) {
                    return ContainerUtil.mergeSortedLists(localSymbols.myLocalNamespaceUsings, (List)((List)iterable), OCSymbolOffsetUtil.SYMBOL_COMPARATOR_BY_SCOPE, (boolean)false);
                }
                return localSymbols.myLocalNamespaceUsings;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isImportUsed(OCFile currentFile, VirtualFile filePath) {
        if (currentFile.getContext() != null) {
            return true;
        }
        Object object = currentFile.getAnnotationSessionLock();
        synchronized (object) {
            AnnotationSession annotationSession = currentFile.getCurrentAnnotationSession();
            if (annotationSession != null) {
                return ((OCFileSymbols)((Object)OCFileSymbols.CACHE.getValue((UserDataHolder)annotationSession))).myUsedFiles.contains(filePath);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void markImportNeeded(OCFile currentFile, VirtualFile importedFile) {
        Object object = currentFile.getAnnotationSessionLock();
        synchronized (object) {
            AnnotationSession annotationSession = currentFile.getCurrentAnnotationSession();
            if (annotationSession != null && importedFile != null) {
                ((OCFileSymbols)((Object)OCFileSymbols.CACHE.getValue((UserDataHolder)annotationSession))).myUsedFiles.add(importedFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void markImportsNeeded(OCFile currentFile, Collection<VirtualFile> importedFiles) {
        if (importedFiles.isEmpty()) {
            return;
        }
        Object object = currentFile.getAnnotationSessionLock();
        synchronized (object) {
            AnnotationSession annotationSession = currentFile.getCurrentAnnotationSession();
            if (annotationSession != null) {
                OCFileSymbols ss = (OCFileSymbols)((Object)CACHE.getValue((UserDataHolder)annotationSession));
                for (VirtualFile importedFile : importedFiles) {
                    if (importedFile == null) continue;
                    ss.myUsedFiles.add(importedFile);
                }
            }
        }
    }

    public static void markImportNeeded(OCFile currentFile, OCSymbol symbol) {
        OCFileSymbols.markImportNeeded(currentFile, OCFileSymbols.getFileToImport(currentFile, symbol));
    }

    public static void markSymbolAsUsed(OCFile currentFile, OCSymbol symbol, PsiElement usage) {
        Object parent;
        if (symbol == null || currentFile.getContext() != null) {
            return;
        }
        OCGlobalUnusedInspection.markSymbolAsUsed(symbol, usage);
        if (symbol instanceof OCSymbolWithParent && (parent = ((OCSymbolWithParent)symbol).getParent()) != null) {
            symbol = parent;
        }
        OCFileSymbols.markImportNeeded(currentFile, symbol);
    }

    public static boolean isSymbolImported(@NotNull OCFile currentFile, @Nullable OCSymbol symbol) {
        if (currentFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentFile", "com/jetbrains/cidr/lang/symbols/symtable/OCFileSymbols", "isSymbolImported"));
        }
        return OCFileSymbols.isSymbolImported(currentFile, symbol, null);
    }

    public static boolean isSymbolImported(@NotNull OCFile currentFile, @Nullable OCSymbol symbol, @Nullable PsiElement before) {
        if (currentFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentFile", "com/jetbrains/cidr/lang/symbols/symtable/OCFileSymbols", "isSymbolImported"));
        }
        if (symbol == null || currentFile.getContext() != null) {
            return false;
        }
        if (Comparing.equal((Object)symbol.getContainingFile(), (Object)currentFile.getVirtualFile())) {
            return true;
        }
        VirtualFile file2 = OCFileSymbols.getFileToImport(currentFile, symbol);
        if (file2 != null && before != null) {
            OCIncludeDirective directive = currentFile.findIncludeDirective(file2);
            return directive == null || directive.getRangeWithMacros().getStartOffset() <= OCElementUtil.getRangeWithMacros(before).getStartOffset();
        }
        return file2 != null;
    }

    @NotNull
    private static OCFileGlobalSymbols getSymbols(@NotNull OCFile currentFile) {
        if (currentFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentFile", "com/jetbrains/cidr/lang/symbols/symtable/OCFileSymbols", "getSymbols"));
        }
        OCFileGlobalSymbols oCFileGlobalSymbols = OCFileGlobalSymbolsCache.getInstance(currentFile.getProject()).forFile(currentFile);
        if (oCFileGlobalSymbols == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/symtable/OCFileSymbols", "getSymbols"));
        }
        return oCFileGlobalSymbols;
    }

    public static boolean isImportRequired(@NotNull OCFile currentFile, @Nullable VirtualFile filePath) {
        if (currentFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentFile", "com/jetbrains/cidr/lang/symbols/symtable/OCFileSymbols", "isImportRequired"));
        }
        if (filePath == null) {
            return false;
        }
        return currentFile.getContext() != null || OCFileSymbols.getSymbols(currentFile).getRequiredImports().contains(filePath);
    }

    @Nullable
    public static VirtualFile getFileToImport(@NotNull OCFile currentFile, @Nullable OCSymbol symbol) {
        if (currentFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentFile", "com/jetbrains/cidr/lang/symbols/symtable/OCFileSymbols", "getFileToImport"));
        }
        if (symbol == null) {
            return null;
        }
        return OCFileSymbols.getSymbols(currentFile).getSymbolToImport().get(symbol);
    }
}

