/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCIncludeSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileSymbolTablesPack
implements Function<OCSymbol, OCSymbol> {
    @NotNull
    private final ArrayList<FileSymbolTable> myTables = new ArrayList();
    @Nullable
    private transient Map<OCSymbol, OCSymbol> myInternary;
    @Nullable
    private transient DeepEqual.Resolver myEqualityResolver;

    public boolean isEmpty() {
        return this.myTables.isEmpty();
    }

    public List<FileSymbolTable> tablesView() {
        return Collections.unmodifiableList(this.myTables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compactSynchronized() {
        Object object = this.getTablesAccessLock();
        synchronized (object) {
            this.myTables.trimToSize();
            for (FileSymbolTable pack : this.myTables) {
                pack.compact();
            }
            this.myInternary = null;
            this.myEqualityResolver = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCompactSynchronized(@NotNull FileSymbolTable table, boolean compact) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/jetbrains/cidr/lang/symbols/symtable/FileSymbolTablesPack", "addCompactSynchronized"));
        }
        Object object = this.getTablesAccessLock();
        synchronized (object) {
            table.internSymbols(this);
            this.myTables.add(table);
            table.setPackStamp(this.getTimeStamp());
            FileSymbolTablesPack.addToImportGraph(table);
            if (compact && this.myEqualityResolver != null) {
                this.myEqualityResolver.clearCaches();
            }
        }
    }

    private int getTimeStamp() {
        return this.myTables.size();
    }

    private static void addToImportGraph(final @NotNull FileSymbolTable table) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/jetbrains/cidr/lang/symbols/symtable/FileSymbolTablesPack", "addToImportGraph"));
        }
        table.processIncludes(new Processor<OCIncludeSymbol>(){

            public boolean process(OCIncludeSymbol symbol) {
                VirtualFile header = symbol.getTargetFile();
                if (header != null && header.isValid()) {
                    OCImportGraph.addHeaderIncluder(table.getProject(), header, table.getContainingFile());
                }
                return true;
            }
        });
    }

    private static void removeFromImportGraph(final @NotNull FileSymbolTable table) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/jetbrains/cidr/lang/symbols/symtable/FileSymbolTablesPack", "removeFromImportGraph"));
        }
        table.processIncludes(new Processor<OCIncludeSymbol>(){

            public boolean process(OCIncludeSymbol symbol) {
                VirtualFile header = symbol.getTargetFile();
                if (header != null) {
                    OCImportGraph.removeHeaderIncluder(table.getProject(), header, table.getContainingFile());
                }
                return true;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRemove() {
        ArrayList<FileSymbolTable> arrayList = this.myTables;
        synchronized (arrayList) {
            for (FileSymbolTable table : this.myTables) {
                FileSymbolTablesPack.removeFromImportGraph(table);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmptySynchronized() {
        Object object = this.getTablesAccessLock();
        synchronized (object) {
            return this.myTables.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public ArrayList<FileSymbolTable> getTablesSynchronized() {
        Object object = this.getTablesAccessLock();
        // MONITORENTER : object
        ArrayList<FileSymbolTable> arrayList = new ArrayList<FileSymbolTable>(this.myTables);
        // MONITOREXIT : object
        if (arrayList != null) return arrayList;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/symtable/FileSymbolTablesPack", "getTablesSynchronized"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTablesCountSynchronized() {
        Object object = this.getTablesAccessLock();
        synchronized (object) {
            return this.myTables.size();
        }
    }

    @NotNull
    public Object getTablesAccessLock() {
        ArrayList<FileSymbolTable> arrayList = this.myTables;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/symtable/FileSymbolTablesPack", "getTablesAccessLock"));
        }
        return arrayList;
    }

    public OCSymbol fun(OCSymbol symbol) {
        OCSymbol same;
        if (this.myInternary == null || this.myEqualityResolver == null) {
            this.myEqualityResolver = DeepEqual.newResolver();
            this.myInternary = new THashMap((TObjectHashingStrategy)new TObjectHashingStrategy<OCSymbol>(){

                public int computeHashCode(OCSymbol object) {
                    return object.hashCodeExcludingOffset();
                }

                public boolean equals(OCSymbol o1, OCSymbol o2) {
                    ProgressManager.checkCanceled();
                    return FileSymbolTablesPack.this.myEqualityResolver.equalObjects(o1, o2);
                }
            });
        }
        if ((same = this.myInternary.get(symbol)) != null) {
            return same;
        }
        symbol.compact();
        this.myInternary.put(symbol, symbol);
        return symbol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateOffsetsSynchronized(int start, int end, int lengthShift) {
        THashSet processed = new THashSet((TObjectHashingStrategy)new TObjectHashingStrategy<OCSymbol>(){

            public int computeHashCode(OCSymbol object) {
                return System.identityHashCode(object);
            }

            public boolean equals(OCSymbol o1, OCSymbol o2) {
                return o1 == o2;
            }
        });
        Object object = this.getTablesAccessLock();
        synchronized (object) {
            for (FileSymbolTable table : this.myTables) {
                table.updateOffsets(start, end, lengthShift, (THashSet<OCSymbol>)processed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public FileSymbolTable findConformingTable(@NotNull OCInclusionContext context, int sinceTimeStamp, @Nullable Ref<Integer> outCurrentTimeStamp) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/symbols/symtable/FileSymbolTablesPack", "findConformingTable"));
        }
        Object object = this.getTablesAccessLock();
        synchronized (object) {
            int timeStamp = this.getTimeStamp();
            if (outCurrentTimeStamp != null) {
                outCurrentTimeStamp.set((Object)timeStamp);
            }
            if (timeStamp > sinceTimeStamp) {
                for (int i = 0; i < this.myTables.size(); ++i) {
                    FileSymbolTable table = this.myTables.get(i);
                    if (table.getPackStamp() <= sinceTimeStamp || !context.checkConformanceAndFillSignatures(table)) continue;
                    int usingCount = table.incUsageCount();
                    if (usingCount < 0) {
                        for (FileSymbolTable t : this.myTables) {
                            t.resetUsageCount();
                        }
                    } else {
                        for (int prev = i - 1; prev >= 0 && this.myTables.get(prev).getUsageCount() + 2 < usingCount; --prev) {
                            Collections.swap(this.myTables, prev, prev + 1);
                        }
                    }
                    return table;
                }
            }
            return null;
        }
    }

    static class FileSymbolsPackSerializer
    extends FieldSerializer<FileSymbolTablesPack> {
        public FileSymbolsPackSerializer(Kryo kryo) {
            super(kryo, FileSymbolTablesPack.class);
        }

        protected FileSymbolTablesPack create(Kryo kryo, Input input, Class<FileSymbolTablesPack> type) {
            return new FileSymbolTablesPack();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FileSymbolTablesPack read(Kryo kryo, Input input, Class<FileSymbolTablesPack> type) {
            FileSymbolTablesPack result2 = (FileSymbolTablesPack)super.read(kryo, input, type);
            Object object = result2.getTablesAccessLock();
            synchronized (object) {
                for (FileSymbolTable table : result2.myTables) {
                    FileSymbolTablesPack.addToImportGraph(table);
                }
            }
            return result2;
        }
    }
}

