/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.OCSymbolTablesBuildingActivity;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractGlobalProjectSymbolsCache<T extends OCSymbol, S extends Symbols<T>>
extends AbstractProjectComponent {
    private final CachedValue<S> myGlobalSymbols;
    private final Object myGlobalSymbolsLock;
    private final CachedValue<MultiValuesMap<String, T>> myGlobalShortNames;
    private final Object myGlobalShortNamesLock;

    protected <Impl extends AbstractGlobalProjectSymbolsCache> AbstractGlobalProjectSymbolsCache(final @NotNull Class<Impl> clazz, final Project project) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/jetbrains/cidr/lang/symbols/symtable/AbstractGlobalProjectSymbolsCache", "<init>"));
        }
        super(project);
        CachedValuesManager manager = CachedValuesManager.getManager((Project)project);
        this.myGlobalSymbolsLock = new Object();
        this.myGlobalSymbols = manager.createCachedValue(new CachedValueProvider<S>(){

            public CachedValueProvider.Result<S> compute() {
                assert (FileSymbolTablesCache.areSymbolsLoaded(project)) : "Symbols must be loaded";
                Object symbols = AbstractGlobalProjectSymbolsCache.this.buildGlobalSymbols(project);
                return CachedValueProvider.Result.create(symbols, (Object[])new Object[]{OCSymbolTablesBuildingActivity.getInstance(project).getModificationTracker(), PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
            }
        }, false);
        this.myGlobalShortNamesLock = new Object();
        this.myGlobalShortNames = manager.createCachedValue(new CachedValueProvider<MultiValuesMap<String, T>>(){

            public CachedValueProvider.Result<MultiValuesMap<String, T>> compute() {
                assert (FileSymbolTablesCache.areSymbolsLoaded(project)) : "Symbols must be loaded";
                final MultiValuesMap result2 = new MultiValuesMap();
                AbstractGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(clazz, project, new Processor<T>(){

                    public boolean process(T symbol) {
                        result2.put((Object)symbol.getName(), symbol);
                        return true;
                    }
                }, null);
                return CachedValueProvider.Result.create((Object)result2, (Object[])new Object[]{OCSymbolTablesBuildingActivity.getInstance(project).getModificationTracker(), PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
            }
        }, false);
    }

    @Nullable
    protected static <Impl extends AbstractGlobalProjectSymbolsCache, T extends OCSymbol> T findNearestTopLevelSymbol(@NotNull Class<Impl> clazz, Project project, @Nullable String name, final @Nullable Condition<? super T> condition, final @Nullable VirtualFile contextFile) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/jetbrains/cidr/lang/symbols/symtable/AbstractGlobalProjectSymbolsCache", "findNearestTopLevelSymbol"));
        }
        final OCWorkspace workspace = OCWorkspaceManager.getWorkspace(project);
        CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
        final OCCommonProcessors.OrderedProcessor orderedProcessor = new OCCommonProcessors.OrderedProcessor<T>((Processor)finder, true, new Condition[]{new Condition<T>(){

            public boolean value(T symbol) {
                return contextFile != null && Comparing.equal((Object)symbol.getContainingFile(), (Object)contextFile);
            }
        }, new Condition<T>(){

            public boolean value(T symbol) {
                VirtualFile file2 = symbol.getContainingFile();
                return contextFile != null && file2 != null && Comparing.equal((String)file2.getNameWithoutExtension(), (String)contextFile.getNameWithoutExtension());
            }
        }, new Condition<T>(){

            public boolean value(T symbol) {
                VirtualFile file2 = symbol.getContainingFile();
                return contextFile != null && file2 != null && Comparing.equal((Object)file2.getParent(), (Object)contextFile.getParent());
            }
        }, new Condition<T>(){

            public boolean value(T symbol) {
                VirtualFile symbolFile = symbol.getContainingFile();
                return workspace.areFromSameProject(contextFile, symbolFile);
            }
        }, Conditions.alwaysTrue()}){

            @Override
            public Collection<T> sort(Collection<T> collection) {
                ArrayList list = new ArrayList(collection);
                Collections.sort(list, new Comparator<OCSymbol>(){

                    @Override
                    public int compare(OCSymbol o1, OCSymbol o2) {
                        return o1.hashCode() - o2.hashCode();
                    }
                });
                return list;
            }
        };
        AbstractGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(clazz, project, new Processor<T>(){

            public boolean process(T symbol) {
                if (condition != null && !condition.value(symbol)) {
                    return true;
                }
                if (workspace.isFromWrongSDK((OCSymbol)symbol, contextFile)) {
                    return true;
                }
                return orderedProcessor.process(symbol);
            }
        }, name, true);
        orderedProcessor.finish();
        return (T)((OCSymbol)finder.getFoundValue());
    }

    @NotNull
    public static <T> T getInstance(@NotNull Class<T> clazz, @NotNull Project project) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/jetbrains/cidr/lang/symbols/symtable/AbstractGlobalProjectSymbolsCache", "getInstance"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/symbols/symtable/AbstractGlobalProjectSymbolsCache", "getInstance"));
        }
        Object object = project.getComponent(clazz);
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/symtable/AbstractGlobalProjectSymbolsCache", "getInstance"));
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    protected S getGlobalSymbols() {
        Object object = this.myGlobalSymbolsLock;
        // MONITORENTER : object
        Symbols symbols = (Symbols)this.myGlobalSymbols.getValue();
        // MONITOREXIT : object
        if (symbols != null) return (S)symbols;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/symtable/AbstractGlobalProjectSymbolsCache", "getGlobalSymbols"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    protected MultiValuesMap<String, T> getGlobalShortNames() {
        Object object = this.myGlobalShortNamesLock;
        // MONITORENTER : object
        MultiValuesMap multiValuesMap = (MultiValuesMap)this.myGlobalShortNames.getValue();
        // MONITOREXIT : object
        if (multiValuesMap != null) return multiValuesMap;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/symtable/AbstractGlobalProjectSymbolsCache", "getGlobalShortNames"));
    }

    protected abstract S buildGlobalSymbols(Project var1);

    protected static <Impl extends AbstractGlobalProjectSymbolsCache, T extends OCSymbol> boolean processTopLevelSymbols(@NotNull Class<Impl> clazz, @NotNull Project project, Processor<? super T> processor2, @Nullable String name) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/jetbrains/cidr/lang/symbols/symtable/AbstractGlobalProjectSymbolsCache", "processTopLevelSymbols"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/symbols/symtable/AbstractGlobalProjectSymbolsCache", "processTopLevelSymbols"));
        }
        return AbstractGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(clazz, project, processor2, name, true);
    }

    protected static <Impl extends AbstractGlobalProjectSymbolsCache, T extends OCSymbol> boolean processTopLevelAndMemberSymbols(@NotNull Class<Impl> clazz, Project project, Processor<? super T> processor2, @Nullable String name) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/jetbrains/cidr/lang/symbols/symtable/AbstractGlobalProjectSymbolsCache", "processTopLevelAndMemberSymbols"));
        }
        return AbstractGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(clazz, project, processor2, name, false);
    }

    protected static <Impl extends AbstractGlobalProjectSymbolsCache, T extends OCSymbol> boolean processByQualifiedName(@NotNull Class<Impl> clazz, Project project, Processor<? super T> processor2, @NotNull String name) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/jetbrains/cidr/lang/symbols/symtable/AbstractGlobalProjectSymbolsCache", "processByQualifiedName"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/cidr/lang/symbols/symtable/AbstractGlobalProjectSymbolsCache", "processByQualifiedName"));
        }
        Collection iterable = ((AbstractGlobalProjectSymbolsCache)((Object)AbstractGlobalProjectSymbolsCache.getInstance(clazz, project))).getGlobalShortNames().get((Object)name);
        return iterable == null || ContainerUtil.process((Iterable)iterable, processor2);
    }

    protected static <Impl extends AbstractGlobalProjectSymbolsCache> boolean processAliasNamesForType(@NotNull Class<Impl> clazz, @NotNull Project project, @NotNull String name, @NotNull Processor<String> processor2) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/jetbrains/cidr/lang/symbols/symtable/AbstractGlobalProjectSymbolsCache", "processAliasNamesForType"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/symbols/symtable/AbstractGlobalProjectSymbolsCache", "processAliasNamesForType"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/cidr/lang/symbols/symtable/AbstractGlobalProjectSymbolsCache", "processAliasNamesForType"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/cidr/lang/symbols/symtable/AbstractGlobalProjectSymbolsCache", "processAliasNamesForType"));
        }
        FileSymbolTablesCache.getInstance(project).ensurePendingFilesProcessed();
        return ((AbstractGlobalProjectSymbolsCache)((Object)AbstractGlobalProjectSymbolsCache.getInstance(clazz, project))).getGlobalSymbols().processAliasNamesForType(name, processor2);
    }

    protected static <Impl extends AbstractGlobalProjectSymbolsCache, T extends OCSymbol> boolean processTopLevelAndMemberSymbols(@NotNull Class<Impl> clazz, @NotNull Project project, @NotNull Processor<? super T> processor2, @Nullable String name, boolean topLevelOnly) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/jetbrains/cidr/lang/symbols/symtable/AbstractGlobalProjectSymbolsCache", "processTopLevelAndMemberSymbols"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/symbols/symtable/AbstractGlobalProjectSymbolsCache", "processTopLevelAndMemberSymbols"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/cidr/lang/symbols/symtable/AbstractGlobalProjectSymbolsCache", "processTopLevelAndMemberSymbols"));
        }
        FileSymbolTablesCache.getInstance(project).ensurePendingFilesProcessed();
        Object symbols = ((AbstractGlobalProjectSymbolsCache)((Object)AbstractGlobalProjectSymbolsCache.getInstance(clazz, project))).getGlobalSymbols();
        if (topLevelOnly) {
            return symbols.processTopLevel(processor2, name);
        }
        return symbols.processAllSymbols(processor2, name);
    }

    public static <Impl extends AbstractGlobalProjectSymbolsCache> Set<String> getAllSymbolNames(@NotNull Class<Impl> clazz, Project project) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/jetbrains/cidr/lang/symbols/symtable/AbstractGlobalProjectSymbolsCache", "getAllSymbolNames"));
        }
        return ((AbstractGlobalProjectSymbolsCache)((Object)AbstractGlobalProjectSymbolsCache.getInstance(clazz, project))).getGlobalShortNames().keySet();
    }

    public static interface Symbols<T>
    extends Processor<T> {
        public boolean processAliasNamesForType(@NotNull String var1, @NotNull Processor<String> var2);

        public boolean processTopLevel(Processor<? super T> var1, String var2);

        public boolean processAllSymbols(Processor<? super T> var1, String var2);

        public boolean isEmpty();
    }
}

