/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.objc;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.search.OCSearchUtil;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCSynthesizeSymbol;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerHelper;
import icons.CidrLangIcons;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCPropertySymbolImpl
extends OCMemberSymbolImpl
implements OCPropertySymbol {
    private OCType myType;
    @Nullable
    private EnumSet<OCPropertySymbol.PropertyAttribute> myAttributesSet;
    private EnumMap<OCPropertySymbol.PropertyAttribute, String> myStringAttributes;
    private boolean myOptional;
    private OCTypeSubstitution mySubstitution;

    public OCPropertySymbolImpl() {
        this.mySubstitution = OCTypeSubstitution.ID;
    }

    public OCPropertySymbolImpl(Project project, VirtualFile file2, int offset, String name, @NotNull List<String> attributes, OCClassSymbol parent, @NotNull OCType type, boolean isOptional, @Nullable EnumSet<OCPropertySymbol.PropertyAttribute> propertyAttributesSet, EnumMap<OCPropertySymbol.PropertyAttribute, String> propertyStringAttributes) {
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/jetbrains/cidr/lang/symbols/objc/OCPropertySymbolImpl", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/cidr/lang/symbols/objc/OCPropertySymbolImpl", "<init>"));
        }
        super(project, file2, offset, name, attributes, parent);
        this.mySubstitution = OCTypeSubstitution.ID;
        this.myType = type;
        this.myOptional = isOptional;
        this.myStringAttributes = propertyStringAttributes;
        this.myAttributesSet = propertyAttributesSet != null && !propertyAttributesSet.isEmpty() ? propertyAttributesSet : null;
    }

    public OCPropertySymbolImpl(@NotNull OCPropertySymbolImpl origin, @NotNull OCTypeSubstitution substitution, OCResolveContext context) {
        if (origin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "origin", "com/jetbrains/cidr/lang/symbols/objc/OCPropertySymbolImpl", "<init>"));
        }
        if (substitution == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitution", "com/jetbrains/cidr/lang/symbols/objc/OCPropertySymbolImpl", "<init>"));
        }
        this(origin.getProject(), origin.getContainingFile(), origin.getOffset(), origin.getName(), origin.getAttributes(), origin.getParent(), origin.myType, origin.myOptional, origin.myAttributesSet, origin.myStringAttributes);
        this.mySubstitution = OCTypeSubstitution.compose(origin.mySubstitution, substitution, context);
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/jetbrains/cidr/lang/symbols/objc/OCPropertySymbolImpl", "deepEqualStep"));
        }
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/jetbrains/cidr/lang/symbols/objc/OCPropertySymbolImpl", "deepEqualStep"));
        }
        if (second == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "com/jetbrains/cidr/lang/symbols/objc/OCPropertySymbolImpl", "deepEqualStep"));
        }
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCPropertySymbolImpl f = (OCPropertySymbolImpl)first;
        OCPropertySymbolImpl s = (OCPropertySymbolImpl)second;
        if (!Comparing.equal(f.myAttributesSet, s.myAttributesSet)) {
            return false;
        }
        if (!Comparing.equal(f.myStringAttributes, s.myStringAttributes)) {
            return false;
        }
        if (!c.equalObjects(f.mySubstitution, s.mySubstitution)) {
            return false;
        }
        return c.equalObjects(f.myType, s.myType);
    }

    public static OCPropertySymbol.PropertySemantics getDefaultSemanticsForType(OCType type, PsiElement context) {
        if ("NSString *".equals(type.getName()) || type instanceof OCBlockPointerType) {
            return OCPropertySymbol.PropertySemantics.COPY;
        }
        if (type.isPointerToObjectCompatible()) {
            return OCCompilerHelper.isArcEnabled(context.getContainingFile()) ? OCPropertySymbol.PropertySemantics.STRONG : OCPropertySymbol.PropertySemantics.RETAIN;
        }
        return OCPropertySymbol.PropertySemantics.ASSIGN;
    }

    @Nullable
    public static OCPropertySymbol.PropertyAttribute parseAttribute(@NotNull String string) {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/jetbrains/cidr/lang/symbols/objc/OCPropertySymbolImpl", "parseAttribute"));
        }
        for (OCPropertySymbol.PropertyAttribute attribute : OCPropertySymbol.PropertyAttribute.values()) {
            if (!string.equals(attribute.getTokenName())) continue;
            return attribute;
        }
        return null;
    }

    @Override
    @NotNull
    public OCType getType() {
        OCType oCType = this.mySubstitution.substitute(this.myType, new OCResolveContext());
        if (oCType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/objc/OCPropertySymbolImpl", "getType"));
        }
        return oCType;
    }

    @Override
    @NotNull
    public OCSymbolKind getKind() {
        OCSymbolKind oCSymbolKind = OCSymbolKind.PROPERTY;
        if (oCSymbolKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/objc/OCPropertySymbolImpl", "getKind"));
        }
        return oCSymbolKind;
    }

    @Override
    public boolean hasAttribute(OCPropertySymbol.PropertyAttribute attribute) {
        return this.myAttributesSet != null && this.myAttributesSet.contains((Object)attribute) || this.myStringAttributes.containsKey((Object)attribute);
    }

    @Override
    public String getAttributeValue(OCPropertySymbol.PropertyAttribute attribute) {
        return this.myStringAttributes.get((Object)attribute);
    }

    @Override
    public OCPropertySymbol.PropertyAttribute getAttributeOfGroup(OCPropertySymbol.PropertyAttribute defaultAttribute, OCType type, PsiElement context) {
        if (this.myAttributesSet != null) {
            for (OCPropertySymbol.PropertyAttribute attribute : this.myAttributesSet) {
                if (attribute.getGroup() != defaultAttribute.getGroup()) continue;
                return attribute;
            }
        }
        if (defaultAttribute.getGroup() == OCPropertySymbol.PropertyAttribute.ASSIGN.getGroup()) {
            if (type.isPointerToObjectCompatible() && OCCompilerHelper.isArcEnabled(context.getContainingFile())) {
                return OCPropertySymbol.PropertyAttribute.STRONG;
            }
            return OCPropertySymbol.PropertyAttribute.ASSIGN;
        }
        return defaultAttribute;
    }

    @Override
    @Nullable
    public Icon getBaseIcon() {
        return this.isOptional() ? CidrLangIcons.CodeAssistantPropertyOptional : super.getBaseIcon();
    }

    @Override
    public boolean isOptional() {
        return this.myOptional;
    }

    @Override
    public boolean isReadonly() {
        return this.hasAttribute(OCPropertySymbol.PropertyAttribute.READONLY);
    }

    @Override
    public boolean isRetained() {
        return this.hasAttribute(OCPropertySymbol.PropertyAttribute.RETAIN) || this.hasAttribute(OCPropertySymbol.PropertyAttribute.COPY);
    }

    @Override
    @NotNull
    public String getGetterName() {
        String getter = this.getAttributeValue(OCPropertySymbol.PropertyAttribute.GETTER);
        String string = getter != null ? getter : this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/objc/OCPropertySymbolImpl", "getGetterName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getSetterName() {
        String setter = this.getAttributeValue(OCPropertySymbol.PropertyAttribute.SETTER);
        String string = setter != null ? setter + ':' : OCNameSuggester.getObjCSetterFromGetter(this.myName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/objc/OCPropertySymbolImpl", "getSetterName"));
        }
        return string;
    }

    @Override
    @NotNull
    public OCTypeSubstitution getSubstitution() {
        OCTypeSubstitution oCTypeSubstitution = this.mySubstitution;
        if (oCTypeSubstitution == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/objc/OCPropertySymbolImpl", "getSubstitution"));
        }
        return oCTypeSubstitution;
    }

    @Override
    public boolean processAccessorMethods(Processor<? super OCMethodSymbol> processor2, final boolean searchSubclasses) {
        final OCCommonProcessors.OrderedProcessor<? super OCMethodSymbol> methodProcessor = new OCCommonProcessors.OrderedProcessor<OCMethodSymbol>(processor2, new Condition<OCMethodSymbol>(){

            public boolean value(OCMethodSymbol methodSymbol) {
                return methodSymbol.isGetter();
            }
        }, Conditions.alwaysTrue());
        this.getParent().processMembers(null, OCMethodSymbol.class, new Processor<OCMethodSymbol>(){

            public boolean process(OCMethodSymbol symbol) {
                if (symbol.getGeneratedFromProperty() == OCPropertySymbolImpl.this) {
                    if (searchSubclasses) {
                        return OCSearchUtil.processMembersHierarchy(symbol, new Processor<OCMethodSymbol>(){

                            public boolean process(OCMethodSymbol symbol) {
                                if (symbol.getGeneratedFromProperty() == null) {
                                    return methodProcessor.process(symbol);
                                }
                                return true;
                            }
                        }, false, true);
                    }
                    OCMethodSymbol methAssociate = symbol.getAssociatedSymbol();
                    if (methAssociate != null) {
                        return methodProcessor.process(methAssociate);
                    }
                    return true;
                }
                return true;
            }
        });
        return methodProcessor.finish();
    }

    @Override
    public boolean processSynthesizes(final Processor<? super OCSynthesizeSymbol> processor2) {
        OCImplementationSymbol implementation = this.getParent().getImplementation();
        if (implementation == null) {
            return false;
        }
        return implementation.processMembers(OCSynthesizeSymbol.class, new Processor<OCSynthesizeSymbol>(){

            public boolean process(OCSynthesizeSymbol symbol) {
                return !OCPropertySymbolImpl.this.getName().equals(symbol.getName()) || processor2.process((Object)symbol);
            }
        });
    }

    @Override
    @Nullable
    public OCInstanceVariableSymbol getAssociatedIvar() {
        CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
        this.processSynthesizes((Processor<? super OCSynthesizeSymbol>)finder);
        if (!finder.isFound()) {
            if (OCCompilerHelper.supportsAutosynthesis(this.getContainingOCFile())) {
                String ivarName = OCNameSuggester.getClang4ImplicitIvarName(this.myName);
                CommonProcessors.FindFirstProcessor ivarFinder = new CommonProcessors.FindFirstProcessor();
                OCCommonProcessors.OrderedProcessor orderedProcessor = new OCCommonProcessors.OrderedProcessor(ivarFinder, (Condition<T>[])new Condition[]{new Condition<OCInstanceVariableSymbol>(){

                    public boolean value(OCInstanceVariableSymbol symbol) {
                        return !symbol.isClang4ImplicitIvar();
                    }
                }, Conditions.alwaysTrue()});
                this.myParent.processMembersInAllCategories(ivarName, OCInstanceVariableSymbol.class, orderedProcessor, false);
                orderedProcessor.finish();
                return (OCInstanceVariableSymbol)ivarFinder.getFoundValue();
            }
            return null;
        }
        return ((OCSynthesizeSymbol)finder.getFoundValue()).getIvarSymbol();
    }

    @Override
    public boolean hasAllAccessorsImplemented(final boolean treatSynthesizeAsAccessors) {
        String setter;
        OCImplementationSymbol implementation = this.getParent().getImplementation();
        if (implementation == null) {
            return false;
        }
        final String getter = this.getGetterName();
        return !implementation.processMembers((String)null, new Processor<OCMemberSymbol>(setter = this.getSetterName()){
            boolean wasGetter;
            boolean wasSetter;
            final /* synthetic */ String val$setter;
            {
                this.val$setter = string2;
            }

            public boolean process(OCMemberSymbol symbol) {
                if (treatSynthesizeAsAccessors && symbol instanceof OCSynthesizeSymbol && OCPropertySymbolImpl.this.myName.equals(symbol.getName())) {
                    return false;
                }
                if (symbol instanceof OCMethodSymbol) {
                    if (getter.equals(symbol.getName()) && ((OCMethodSymbol)symbol).isGetter()) {
                        this.wasGetter = true;
                    }
                    if (this.val$setter.equals(symbol.getName()) && ((OCMethodSymbol)symbol).isSetter()) {
                        this.wasSetter = true;
                    }
                    return !this.wasGetter || !OCPropertySymbolImpl.this.isReadonly() && !this.wasSetter;
                }
                return true;
            }
        });
    }

    @Override
    @Nullable
    public OCPropertySymbol getAssociatedPropertyInPrivateCategory() {
        if ("".equals(this.getParent().getCategoryName())) {
            return null;
        }
        CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
        this.getParent().processMembers("", this.getName(), OCPropertySymbol.class, finder, true);
        return (OCPropertySymbol)finder.getFoundValue();
    }

    @Override
    @Nullable
    public OCPropertySymbol getAssociatedPropertyInMainInterface() {
        if (this.getParent().getCategoryName() == null) {
            return null;
        }
        CommonProcessors.FindFirstProcessor<OCPropertySymbol> finder = new CommonProcessors.FindFirstProcessor<OCPropertySymbol>(){

            protected boolean accept(OCPropertySymbol propertySymbol) {
                return ((OCClassSymbol)propertySymbol.getParent()).getCategoryName() == null;
            }
        };
        OCInterfaceSymbol mainInterface = this.getParent().getMainInterface();
        if (mainInterface != null) {
            mainInterface.processMembers(this.getName(), OCPropertySymbol.class, finder);
        }
        return (OCPropertySymbol)finder.getFoundValue();
    }
}

