/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.objc;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.psi.OCLocalizedString;
import com.jetbrains.cidr.lang.psi.OCStringsFile;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolImpl;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCLocalizedStringSymbol
extends OCSymbolImpl<OCLocalizedString> {
    public OCLocalizedStringSymbol(@Nullable Project project, @Nullable VirtualFile file2, int offset, @Nullable String name, @NotNull List<String> attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/jetbrains/cidr/lang/symbols/objc/OCLocalizedStringSymbol", "<init>"));
        }
        super(project, file2, offset, name, attributes);
    }

    @Override
    @NotNull
    public OCSymbolKind getKind() {
        OCSymbolKind oCSymbolKind = OCSymbolKind.LOCALIZED_STRING;
        if (oCSymbolKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/objc/OCLocalizedStringSymbol", "getKind"));
        }
        return oCSymbolKind;
    }

    @Override
    public boolean processSameSymbols(Processor<OCSymbol> processor2) {
        for (PsiFile each : FilenameIndex.getFilesByName(this.myProject, this.myFile.getName(), OCSearchScope.getProjectSourcesScope(this.myProject))) {
            OCLocalizedStringSymbol symbol;
            ProgressManager.checkCanceled();
            if (!(each instanceof OCStringsFile)) continue;
            OCLocalizedString pair = ((OCStringsFile)each).findStringPair(this.myName);
            OCLocalizedStringSymbol oCLocalizedStringSymbol = symbol = pair != null ? (OCLocalizedStringSymbol)pair.getSymbol() : null;
            if (symbol == null || processor2.process((Object)symbol)) continue;
            return false;
        }
        return true;
    }
}

