/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.objc;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCQualifiedNameWithArguments;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCGenericParameterSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCReferenceTypeBuilder;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCInterfaceSymbolImpl
extends OCClassSymbolImpl
implements OCInterfaceSymbol {
    private List<OCGenericParameterSymbol> myGenericParameters;
    @NotNull
    private OCTypeSubstitution mySubstitution;

    public OCInterfaceSymbolImpl() {
        this.mySubstitution = OCTypeSubstitution.ID;
    }

    /*
     * WARNING - void declaration
     */
    public OCInterfaceSymbolImpl(@NotNull Project project, @Nullable VirtualFile file2, long offset, @NotNull String name, @NotNull List<String> attributes, @Nullable String category, @Nullable MostlySingularMultiMap<String, OCMemberSymbol> members, @NotNull List<String> protocolNames, @Nullable OCReferenceType superType, @NotNull List<OCGenericParameterSymbol> list) {
        void genericParameters;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/symbols/objc/OCInterfaceSymbolImpl", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/cidr/lang/symbols/objc/OCInterfaceSymbolImpl", "<init>"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/jetbrains/cidr/lang/symbols/objc/OCInterfaceSymbolImpl", "<init>"));
        }
        if (protocolNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "protocolNames", "com/jetbrains/cidr/lang/symbols/objc/OCInterfaceSymbolImpl", "<init>"));
        }
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "genericParameters", "com/jetbrains/cidr/lang/symbols/objc/OCInterfaceSymbolImpl", "<init>"));
        }
        super(project, file2, offset, name, attributes, category, members, protocolNames, superType);
        this.mySubstitution = OCTypeSubstitution.ID;
        this.myGenericParameters = genericParameters;
    }

    public OCInterfaceSymbolImpl(@NotNull OCInterfaceSymbolImpl origin, @NotNull OCTypeSubstitution substitution, boolean overwriteSubstitution, @NotNull OCResolveContext context) {
        if (origin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "origin", "com/jetbrains/cidr/lang/symbols/objc/OCInterfaceSymbolImpl", "<init>"));
        }
        if (substitution == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitution", "com/jetbrains/cidr/lang/symbols/objc/OCInterfaceSymbolImpl", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/symbols/objc/OCInterfaceSymbolImpl", "<init>"));
        }
        this(origin.getProject(), origin.getContainingFile(), origin.getOffset(), origin.getName(), origin.getAttributes(), origin.getCategoryName(), origin.getMembers(), origin.getProtocolNames(), origin.getSuperType(), origin.getGenericParameters());
        this.mySubstitution = OCTypeSubstitution.compose(origin.mySubstitution, substitution, overwriteSubstitution, context);
    }

    @Override
    @NotNull
    public OCSymbolKind getKind() {
        OCSymbolKind oCSymbolKind = OCSymbolKind.INTERFACE;
        if (oCSymbolKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/objc/OCInterfaceSymbolImpl", "getKind"));
        }
        return oCSymbolKind;
    }

    @Override
    @NotNull
    public OCType getType() {
        OCQualifiedName qualifiedName;
        if (this.myGenericParameters.isEmpty() || this.mySubstitution == OCTypeSubstitution.ID) {
            qualifiedName = this.getQualifiedName();
        } else {
            ArrayList arguments = ContainerUtil.newArrayList();
            for (OCGenericParameterSymbol parameter : this.myGenericParameters) {
                OCTypeArgument argument = this.mySubstitution.getSubstitutionFor(parameter);
                arguments.add(argument != null ? argument : parameter.getDefaultValue());
            }
            qualifiedName = new OCQualifiedNameWithArguments(null, this.myName, arguments);
        }
        OCReferenceType oCReferenceType = new OCReferenceTypeBuilder(qualifiedName).setSubstitution(this.mySubstitution).build();
        if (oCReferenceType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/objc/OCInterfaceSymbolImpl", "getType"));
        }
        return oCReferenceType;
    }

    @Override
    @NotNull
    public OCReferenceType getSuperType() {
        OCReferenceType oCReferenceType = (OCReferenceType)this.mySubstitution.substitute(super.getSuperType(), new OCResolveContext());
        if (oCReferenceType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/objc/OCInterfaceSymbolImpl", "getSuperType"));
        }
        return oCReferenceType;
    }

    @Override
    public OCInterfaceSymbol getInterface() {
        return this;
    }

    @Override
    public OCSymbol getAssociatedSymbol() {
        return this.getImplementation();
    }

    @Override
    @Nullable
    public OCImplementationSymbol getImplementation() {
        OCImplementationSymbol symbol = this.getImplementation(this.getCategoryName());
        if (symbol == null && this.getCategoryName() != null) {
            symbol = this.getImplementation(null);
        }
        return symbol;
    }

    @Override
    @Nullable
    public OCImplementationSymbol getImplementation(final @Nullable String category) {
        final boolean isInProject = OCSearchScope.isInProjectSources(this);
        Condition<OCSymbol> condition = new Condition<OCSymbol>(){

            public boolean value(OCSymbol symbol) {
                return symbol instanceof OCImplementationSymbol && isInProject == OCSearchScope.isInProjectSources(symbol) && !symbol.isPredeclaration() && Comparing.equal((String)category, (String)((OCImplementationSymbol)symbol).getCategoryName());
            }
        };
        CommonProcessors.FindFirstProcessor<OCSymbol> processor2 = new CommonProcessors.FindFirstProcessor<OCSymbol>((Condition)condition){
            final /* synthetic */ Condition val$condition;
            {
                this.val$condition = condition;
            }

            protected boolean accept(OCSymbol symbol) {
                return this.val$condition.value((Object)symbol);
            }
        };
        OCFile containingFile = this.getContainingOCFile();
        if (containingFile != null) {
            OCResolveUtil.processGlobalSymbols(this.myName, containingFile, (Processor<OCSymbol>)processor2);
        }
        if (!processor2.isFound()) {
            return (OCImplementationSymbol)OCGlobalProjectSymbolsCache.findNearestTopLevelSymbol(this.myProject, this.myName, condition, this.myFile);
        }
        return (OCImplementationSymbol)processor2.getFoundValue();
    }

    @Override
    @NotNull
    public List<OCGenericParameterSymbol> getGenericParameters() {
        List list = ContainerUtil.newUnmodifiableList(this.myGenericParameters);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/objc/OCInterfaceSymbolImpl", "getGenericParameters"));
        }
        return list;
    }

    @Override
    @NotNull
    public OCTypeSubstitution getSubstitution() {
        OCTypeSubstitution oCTypeSubstitution = this.mySubstitution;
        if (oCTypeSubstitution == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/objc/OCInterfaceSymbolImpl", "getSubstitution"));
        }
        return oCTypeSubstitution;
    }

    @Override
    public <T extends OCMemberSymbol> boolean processMembers(@Nullable String memberName, @NotNull Class<? extends T> memberClass, final @NotNull Processor<? super T> processor2) {
        if (memberClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberClass", "com/jetbrains/cidr/lang/symbols/objc/OCInterfaceSymbolImpl", "processMembers"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/cidr/lang/symbols/objc/OCInterfaceSymbolImpl", "processMembers"));
        }
        Processor<OCMemberSymbol> inner = this.mySubstitution != OCTypeSubstitution.ID ? new Processor<OCMemberSymbol>(){

            public boolean process(OCMemberSymbol symbol) {
                OCMemberSymbol substitute = OCInterfaceSymbolImpl.this.mySubstitution.substitute(symbol, OCInterfaceSymbolImpl.this, false, new OCResolveContext());
                return processor2.process((Object)substitute);
            }
        } : processor2;
        return super.processMembers(memberName, memberClass, inner);
    }

    @Override
    @NotNull
    public List<OCTypeParameterSymbol> getTemplateParameters() {
        List<OCTypeParameterSymbol> list = this.getGenericParameters();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/objc/OCInterfaceSymbolImpl", "getTemplateParameters"));
        }
        return list;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/jetbrains/cidr/lang/symbols/objc/OCInterfaceSymbolImpl", "deepEqualStep"));
        }
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/jetbrains/cidr/lang/symbols/objc/OCInterfaceSymbolImpl", "deepEqualStep"));
        }
        if (second == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "com/jetbrains/cidr/lang/symbols/objc/OCInterfaceSymbolImpl", "deepEqualStep"));
        }
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCInterfaceSymbolImpl f = (OCInterfaceSymbolImpl)first;
        OCInterfaceSymbolImpl s = (OCInterfaceSymbolImpl)second;
        if (!c.equalObjects(f.mySubstitution, s.mySubstitution)) {
            return false;
        }
        return c.equalIterable(f.myGenericParameters, s.myGenericParameters);
    }
}

