/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.objc;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCIcons;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCSynthesizeSymbol;
import com.jetbrains.cidr.lang.types.ARCAttribute;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerHelper;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCInstanceVariableSymbolImpl
extends OCMemberSymbolImpl
implements OCInstanceVariableSymbol {
    private OCType myType;
    private String myGeneratedFromProperty;
    private OCVisibility myVisibility;

    public OCInstanceVariableSymbolImpl() {
    }

    /*
     * WARNING - void declaration
     */
    public OCInstanceVariableSymbolImpl(Project project, VirtualFile file2, long offset, String name, @NotNull List<String> attributes, OCClassSymbol parent, @NotNull OCType type, @NotNull OCVisibility visibility, @Nullable String string) {
        void generatedFromProperty;
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/jetbrains/cidr/lang/symbols/objc/OCInstanceVariableSymbolImpl", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/cidr/lang/symbols/objc/OCInstanceVariableSymbolImpl", "<init>"));
        }
        if (visibility == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibility", "com/jetbrains/cidr/lang/symbols/objc/OCInstanceVariableSymbolImpl", "<init>"));
        }
        super(project, file2, offset, name, attributes, parent);
        this.myType = type;
        this.myVisibility = visibility;
        this.myGeneratedFromProperty = generatedFromProperty;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/jetbrains/cidr/lang/symbols/objc/OCInstanceVariableSymbolImpl", "deepEqualStep"));
        }
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/jetbrains/cidr/lang/symbols/objc/OCInstanceVariableSymbolImpl", "deepEqualStep"));
        }
        if (second == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "com/jetbrains/cidr/lang/symbols/objc/OCInstanceVariableSymbolImpl", "deepEqualStep"));
        }
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCInstanceVariableSymbolImpl f = (OCInstanceVariableSymbolImpl)first;
        OCInstanceVariableSymbolImpl s = (OCInstanceVariableSymbolImpl)second;
        if (f.myVisibility != s.myVisibility) {
            return false;
        }
        if (!Comparing.equal((String)f.myGeneratedFromProperty, (String)f.myGeneratedFromProperty)) {
            return false;
        }
        return c.equalObjects(f.myType, s.myType);
    }

    @Override
    @NotNull
    public OCType getType() {
        if (this.myGeneratedFromProperty != null) {
            OCInterfaceSymbol intfSymbol = this.getParent().getInterface();
            if (intfSymbol == null) {
                OCType oCType = this.myType;
                if (oCType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/objc/OCInstanceVariableSymbolImpl", "getType"));
                }
                return oCType;
            }
            CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
            OCType parentType = this.getParent().getResolvedType();
            if (!(parentType instanceof OCObjectType)) {
                OCType oCType = this.myType;
                if (oCType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/objc/OCInstanceVariableSymbolImpl", "getType"));
                }
                return oCType;
            }
            ((OCObjectType)parentType).processMembers(this.myGeneratedFromProperty, OCPropertySymbol.class, finder, true, false);
            if (finder.getFoundValue() != null) {
                OCType oCType = ((OCPropertySymbol)finder.getFoundValue()).getType();
                if (oCType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/objc/OCInstanceVariableSymbolImpl", "getType"));
                }
                return oCType;
            }
            OCType oCType = this.myType;
            if (oCType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/objc/OCInstanceVariableSymbolImpl", "getType"));
            }
            return oCType;
        }
        OCType oCType = this.myType;
        if (oCType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/objc/OCInstanceVariableSymbolImpl", "getType"));
        }
        return oCType;
    }

    @Override
    @NotNull
    public OCSymbolKind getKind() {
        OCSymbolKind oCSymbolKind = OCSymbolKind.INSTANCE_VARIABLE;
        if (oCSymbolKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/objc/OCInstanceVariableSymbolImpl", "getKind"));
        }
        return oCSymbolKind;
    }

    @Override
    @NotNull
    public OCVisibility getVisibility() {
        OCVisibility oCVisibility = this.myVisibility;
        if (oCVisibility == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/objc/OCInstanceVariableSymbolImpl", "getVisibility"));
        }
        return oCVisibility;
    }

    @Override
    public void updateVisibility(@NotNull OCVisibility visibility) {
        if (visibility == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibility", "com/jetbrains/cidr/lang/symbols/objc/OCInstanceVariableSymbolImpl", "updateVisibility"));
        }
        this.myVisibility = visibility;
    }

    @Override
    public Icon getBaseIcon() {
        return OCIcons.getVisibilityIcon(this.getVisibility(), super.getBaseIcon());
    }

    @Override
    @NotNull
    public ARCAttribute getARCAttribute(PsiElement context) {
        OCType type = this.getResolvedType();
        if (this.myGeneratedFromProperty != null) {
            OCPropertySymbol property = this.getAssociatedProperty();
            if (property != null) {
                ARCAttribute aRCAttribute = property.getAttributeOfGroup(OCPropertySymbol.PropertyAttribute.ASSIGN, type, context).getIvarCompatibleARCAttribute();
                if (aRCAttribute == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/objc/OCInstanceVariableSymbolImpl", "getARCAttribute"));
                }
                return aRCAttribute;
            }
            ARCAttribute aRCAttribute = ARCAttribute.DEFAULT;
            if (aRCAttribute == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/objc/OCInstanceVariableSymbolImpl", "getARCAttribute"));
            }
            return aRCAttribute;
        }
        ARCAttribute arcAttribute = type instanceof OCPointerType ? ((OCPointerType)type).getARCAttribute() : null;
        ARCAttribute aRCAttribute = arcAttribute != null ? arcAttribute : ARCAttribute.DEFAULT;
        if (aRCAttribute == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/objc/OCInstanceVariableSymbolImpl", "getARCAttribute"));
        }
        return aRCAttribute;
    }

    @Override
    protected Class<? extends PsiElement> getPsiElementClass() {
        return this.myGeneratedFromProperty != null ? OCReferenceElement.class : super.getPsiElementClass();
    }

    @Override
    public String getGeneratedFromProperty() {
        return this.myGeneratedFromProperty;
    }

    @Override
    public boolean processSynthesizes(final Processor<OCSynthesizeSymbol> processor2) {
        OCImplementationSymbol implementation = this.getParent().getMainImplementation();
        if (implementation == null) {
            return false;
        }
        return implementation.processMembers(OCSynthesizeSymbol.class, new Processor<OCSynthesizeSymbol>(){

            public boolean process(OCSynthesizeSymbol symbol) {
                return !OCInstanceVariableSymbolImpl.this.getName().equals(symbol.getIvarName()) || processor2.process((Object)symbol);
            }
        });
    }

    @Override
    @Nullable
    public OCPropertySymbol getAssociatedProperty() {
        CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
        this.processSynthesizes((Processor<OCSynthesizeSymbol>)finder);
        if (!finder.isFound()) {
            if (OCCompilerHelper.supportsAutosynthesis(this.getContainingOCFile())) {
                OCInterfaceSymbol anInterface = this.myParent.getInterface();
                String propertyName = OCNameSuggester.getClang4PropertyName(this.myName);
                CommonProcessors.FindFirstProcessor propFinder = new CommonProcessors.FindFirstProcessor();
                if (propertyName != null && anInterface != null) {
                    anInterface.processMembers(propertyName, OCPropertySymbol.class, propFinder);
                }
                return (OCPropertySymbol)propFinder.getFoundValue();
            }
            return null;
        }
        return ((OCSynthesizeSymbol)finder.getFoundValue()).getAssociatedProperty();
    }

    @Override
    public boolean isSynthetic() {
        return this.myGeneratedFromProperty != null && this.myComplexOffset == 0x100000000L;
    }

    @Override
    public boolean isClang4ImplicitIvar(@Nullable PsiFile context) {
        return this.myGeneratedFromProperty != null && this.myComplexOffset == 0x100000000L && OCCompilerHelper.supportsAutosynthesis(context);
    }

    @Override
    public boolean isClang4ImplicitIvar() {
        return this.isClang4ImplicitIvar(this.getContainingOCFile());
    }

    @Override
    public boolean isForbiddenClang4ImplicitIvar() {
        return this.isForbiddenClang4ImplicitIvar(this.getContainingOCFile());
    }

    @Override
    public boolean isForbiddenClang4ImplicitIvar(@Nullable PsiFile context) {
        if (this.myGeneratedFromProperty == null || this.myComplexOffset != 0x100000000L) {
            return false;
        }
        if (context != null && !OCCompilerHelper.supportsAutosynthesis(context)) {
            return true;
        }
        if (OCNameSuggester.getClang4PropertyName(this.myName) == null) {
            return false;
        }
        OCPropertySymbol property = this.getAssociatedProperty();
        return property != null && property.hasAllAccessorsImplemented(true);
    }
}

