/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.objc;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.jetbrains.cidr.lang.OCIcons;
import com.jetbrains.cidr.lang.OCTestFrameworks;
import com.jetbrains.cidr.lang.psi.OCClassDeclarationBase;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import icons.CidrLangIcons;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCClassSymbolImpl
extends OCSymbolWithQualifiedName<OCClassDeclarationBase>
implements OCClassSymbol {
    private String myCategoryName;
    private MostlySingularMultiMap<String, OCMemberSymbol> myMembers;
    private List<String> myProtocolNames;
    private OCReferenceType mySuperType;

    /*
     * WARNING - void declaration
     */
    public OCClassSymbolImpl(@NotNull Project project, @Nullable VirtualFile file2, long offset, @NotNull String name, @NotNull List<String> attributes, @Nullable String categoryName, @Nullable MostlySingularMultiMap<String, OCMemberSymbol> members, @NotNull List<String> protocolNames, @Nullable OCReferenceType oCReferenceType) {
        void superType;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/symbols/objc/OCClassSymbolImpl", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/cidr/lang/symbols/objc/OCClassSymbolImpl", "<init>"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/jetbrains/cidr/lang/symbols/objc/OCClassSymbolImpl", "<init>"));
        }
        if (protocolNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "protocolNames", "com/jetbrains/cidr/lang/symbols/objc/OCClassSymbolImpl", "<init>"));
        }
        super(project, file2, offset, null, OCQualifiedName.interned(name), attributes, null);
        this.myCategoryName = categoryName;
        this.myMembers = members;
        this.myProtocolNames = ContainerUtil.trimToSize(protocolNames);
        this.mySuperType = superType;
    }

    public OCClassSymbolImpl() {
    }

    @Override
    public String getCategoryName() {
        return this.myCategoryName;
    }

    @Override
    public void setSuperType(@NotNull OCReferenceType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/cidr/lang/symbols/objc/OCClassSymbolImpl", "setSuperType"));
        }
        assert (this.mySuperType == null) : "Super type is already set";
        this.mySuperType = type;
    }

    @Override
    @NotNull
    public OCReferenceType getSuperType() {
        assert (this.mySuperType != null) : "Super type has to be set in symbol builder";
        OCReferenceType oCReferenceType = this.mySuperType;
        if (oCReferenceType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/objc/OCClassSymbolImpl", "getSuperType"));
        }
        return oCReferenceType;
    }

    @Override
    @NotNull
    public String getSuperClassName() {
        String string = StringUtil.notNullize((String)this.getSuperType().getReference().getQualifiedName().getName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/objc/OCClassSymbolImpl", "getSuperClassName"));
        }
        return string;
    }

    @Override
    public void updateOffset(final int start, final int end, final int lengthShift) {
        super.updateOffset(start, end, lengthShift);
        if (this.myMembers != null) {
            this.myMembers.processAllValues((Processor)new Processor<OCMemberSymbol>(){

                public boolean process(OCMemberSymbol member) {
                    member.updateOffset(start, end, lengthShift);
                    return true;
                }
            });
        }
    }

    @Override
    public void compact() {
        super.compact();
        if (this.myMembers != null) {
            this.myMembers.processAllValues((Processor)new Processor<OCMemberSymbol>(){

                public boolean process(OCMemberSymbol member) {
                    member.compact();
                    return true;
                }
            });
        }
    }

    @Override
    @NotNull
    public List<String> getProtocolNames() {
        List<String> list = this.myProtocolNames;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/objc/OCClassSymbolImpl", "getProtocolNames"));
        }
        return list;
    }

    @Override
    public boolean isDefinition() {
        return false;
    }

    @Override
    public boolean isPredeclaration() {
        return this.myMembers == null;
    }

    @Override
    public int getMembersCount() {
        return this.myMembers != null ? this.myMembers.size() : 0;
    }

    @Override
    public int hashCodeExcludingOffset() {
        int result2 = super.hashCodeExcludingOffset();
        result2 = 31 * result2 + this.getMembersCount();
        return result2;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && this.getMembersCount() == ((OCClassSymbol)o).getMembersCount();
    }

    @Override
    public boolean isGlobal() {
        return true;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/jetbrains/cidr/lang/symbols/objc/OCClassSymbolImpl", "deepEqualStep"));
        }
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/jetbrains/cidr/lang/symbols/objc/OCClassSymbolImpl", "deepEqualStep"));
        }
        if (second == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "com/jetbrains/cidr/lang/symbols/objc/OCClassSymbolImpl", "deepEqualStep"));
        }
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCClassSymbolImpl f = (OCClassSymbolImpl)first;
        OCClassSymbolImpl s = (OCClassSymbolImpl)second;
        if (!Comparing.equal((String)f.myCategoryName, (String)s.myCategoryName)) {
            return false;
        }
        if (!Comparing.equal(f.myProtocolNames, s.myProtocolNames)) {
            return false;
        }
        if (!c.equalObjects(f.mySuperType, s.mySuperType)) {
            return false;
        }
        return c.equalMultiMaps(f.myMembers, s.myMembers);
    }

    @Override
    public boolean processMembers(String memberName, @NotNull Processor<OCMemberSymbol> processor2) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/cidr/lang/symbols/objc/OCClassSymbolImpl", "processMembers"));
        }
        if (this.myMembers == null) {
            return true;
        }
        if (memberName == null) {
            return this.myMembers.processAllValues(processor2);
        }
        return this.myMembers.processForKey((Object)memberName, processor2);
    }

    @Override
    public <T extends OCMemberSymbol> boolean processMembers(Class<T> memberClass, Processor<? super T> processor2) {
        return this.processMembers(null, memberClass, processor2);
    }

    @Override
    public <T extends OCMemberSymbol> boolean processMembers(@Nullable String memberName, final @NotNull Class<? extends T> memberClass, final Processor<? super T> processor2) {
        if (memberClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberClass", "com/jetbrains/cidr/lang/symbols/objc/OCClassSymbolImpl", "processMembers"));
        }
        if (this.myMembers == null) {
            return true;
        }
        Processor<OCMemberSymbol> myProcessor = new Processor<OCMemberSymbol>(){

            public boolean process(OCMemberSymbol member) {
                return !memberClass.isAssignableFrom(member.getClass()) || processor2.process((Object)member);
            }
        };
        if (memberName == null) {
            return this.myMembers.processAllValues((Processor)myProcessor);
        }
        return this.myMembers.processForKey((Object)memberName, (Processor)myProcessor);
    }

    @Override
    public <T extends OCMemberSymbol> boolean processMembersInAllCategories(@Nullable String memberName, Class<? extends T> memberClass, Processor<? super T> processor2) {
        return this.processMembersInAllCategories(memberName, memberClass, processor2, true);
    }

    @Override
    public <T extends OCMemberSymbol> boolean processMembersInAllCategories(final @Nullable String memberName, final Class<? extends T> memberClass, final Processor<? super T> processor2, boolean fromSameParentClass) {
        return this.processCategories((Processor<? super OCClassSymbol>)new Processor<OCClassSymbol>(){

            public boolean process(OCClassSymbol clazz) {
                return clazz.processMembers(memberName, memberClass, processor2);
            }
        }, fromSameParentClass, null);
    }

    @Override
    public <T extends OCMemberSymbol> boolean processMembers(final @Nullable String categoryName, final @Nullable String memberName, final @NotNull Class<? extends T> memberClass, final @NotNull Processor<? super T> processor2, boolean fromSameParentClass) {
        if (memberClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberClass", "com/jetbrains/cidr/lang/symbols/objc/OCClassSymbolImpl", "processMembers"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/cidr/lang/symbols/objc/OCClassSymbolImpl", "processMembers"));
        }
        return this.processCategories((Processor<? super OCClassSymbol>)new Processor<OCClassSymbol>(){

            public boolean process(OCClassSymbol clazz) {
                return !Comparing.equal((String)categoryName, (String)clazz.getCategoryName()) || clazz.processMembers(memberName, memberClass, processor2);
            }
        }, fromSameParentClass, null);
    }

    @Override
    public boolean processAllMethods(@Nullable String methodName, final @NotNull Processor<OCMethodSymbol> processor2, @Nullable Set<String> baseProtocols, @Nullable PsiElement context) {
        boolean isAmongBaseProtocols;
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/cidr/lang/symbols/objc/OCClassSymbolImpl", "processAllMethods"));
        }
        boolean bl = isAmongBaseProtocols = this instanceof OCProtocolSymbol && baseProtocols != null && baseProtocols.contains(this.getName());
        if (!this.processMembers(methodName, OCMethodSymbol.class, new Processor<OCMethodSymbol>(){

            public boolean process(OCMethodSymbol symbol) {
                return isAmongBaseProtocols && !symbol.isOptional() || processor2.process((Object)symbol);
            }
        })) {
            return false;
        }
        if (isAmongBaseProtocols) {
            baseProtocols.addAll(this.myProtocolNames);
        }
        for (String protocolName : this.myProtocolNames) {
            CommonProcessors.FindFirstProcessor<OCSymbol> resolver = new CommonProcessors.FindFirstProcessor<OCSymbol>(){

                protected boolean accept(OCSymbol symbol) {
                    return symbol instanceof OCProtocolSymbol && !symbol.isPredeclaration();
                }
            };
            OCResolveUtil.processGlobalSymbols(protocolName, context, (Processor<OCSymbol>)resolver);
            if (!resolver.isFound() || ((OCProtocolSymbol)resolver.getFoundValue()).processAllMethods(methodName, processor2, baseProtocols, context)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean processCategories(final Processor<? super OCClassSymbol> processor2, final boolean fromSameParentClass, @Nullable PsiElement context) {
        if (!processor2.process((Object)this)) {
            return false;
        }
        Processor<OCSymbol> filterProcessor = new Processor<OCSymbol>(){

            public boolean process(OCSymbol symbol) {
                if (!(!(symbol instanceof OCClassSymbol) || fromSameParentClass && !symbol.getClass().equals(OCClassSymbolImpl.this.getClass()) || symbol.isPredeclaration() || symbol.equals(OCClassSymbolImpl.this))) {
                    return processor2.process((Object)((OCClassSymbol)symbol));
                }
                return true;
            }
        };
        if (context == null) {
            return OCGlobalProjectSymbolsCache.processTopLevelSymbols(this.myProject, filterProcessor, this.myName);
        }
        return OCResolveUtil.processGlobalSymbols(this.myName, null, (OCFile)context.getContainingFile(), this.getOffset(), filterProcessor);
    }

    @Override
    public boolean processSameSymbols(final Processor<OCSymbol> processor2) {
        return OCGlobalProjectSymbolsCache.processTopLevelSymbols(this.myProject, new Processor<OCSymbol>(){

            public boolean process(OCSymbol symbol) {
                return !(symbol instanceof OCClassSymbolImpl) || !OCClassSymbolImpl.this.isSameClass((OCClassSymbolImpl)symbol) || processor2.process((Object)symbol);
            }
        }, this.myName);
    }

    @Override
    @Nullable
    public OCClassSymbol getDefinitionSymbol() {
        return (OCClassSymbol)super.getDefinitionSymbol();
    }

    @Override
    @Nullable
    public OCInterfaceSymbol getInterface() {
        return null;
    }

    @Override
    @Nullable
    public OCClassSymbol getInterfaceOrProtocol() {
        return this.getInterface();
    }

    @Override
    @Nullable
    public OCImplementationSymbol getImplementation() {
        return null;
    }

    @Override
    @Nullable
    public OCInterfaceSymbol getMainInterface() {
        return this.getMainSymbol(this.getInterface());
    }

    @Override
    @Nullable
    public OCImplementationSymbol getMainImplementation() {
        return this.getMainSymbol(this.getImplementation());
    }

    protected MostlySingularMultiMap<String, OCMemberSymbol> getMembers() {
        return this.myMembers;
    }

    @Nullable
    private <T extends OCClassSymbol> T getMainSymbol(@Nullable T symbol) {
        if (symbol == null) {
            return null;
        }
        if (this.myCategoryName == null) {
            return symbol;
        }
        CommonProcessors.FindFirstProcessor<OCClassSymbol> finder = new CommonProcessors.FindFirstProcessor<OCClassSymbol>(){

            protected boolean accept(OCClassSymbol each) {
                return each.getCategoryName() == null;
            }
        };
        symbol.processCategories((Processor<OCClassSymbol>)finder, true, null);
        return (T)((OCClassSymbol)finder.getFoundValue());
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = OCCodeInsightUtil.getClassNameWithCategory(super.getPresentableName(), this.myCategoryName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/objc/OCClassSymbolImpl", "getPresentableName"));
        }
        return string;
    }

    @Override
    @Nullable
    public Icon getBaseIcon() {
        return this.myCategoryName == null ? super.getBaseIcon() : CidrLangIcons.CodeAssistantClassExtension;
    }

    @Override
    public Icon computeFullIcon(@Nullable OCClassDeclarationBase symbolElement) {
        Icon result2;
        Icon icon = result2 = this.myCategoryName == null ? super.computeFullIcon(symbolElement) : CidrLangIcons.CodeAssistantClassExtension;
        if (result2 != null) {
            boolean isTestClass;
            boolean bl = isTestClass = symbolElement != null ? OCTestFrameworks.isTestClass(symbolElement) : OCTestFrameworks.isTestClass(this);
            if (isTestClass) {
                result2 = OCIcons.getTestIcon(result2);
            }
        }
        return result2;
    }

    @Override
    @NotNull
    public OCType getType() {
        OCReferenceType oCReferenceType = OCReferenceType.fromText(this.getName());
        if (oCReferenceType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/objc/OCClassSymbolImpl", "getType"));
        }
        return oCReferenceType;
    }

    @Override
    @Nullable
    public OCObjectType getResolvedType(boolean ignoringImports) {
        OCType type = super.getResolvedType(ignoringImports);
        return type instanceof OCObjectType ? (OCObjectType)type : null;
    }

    @Override
    public boolean isSameClass(OCClassSymbol symbol) {
        return Comparing.equal((String)this.myName, (String)symbol.getName()) && this instanceof OCProtocolSymbol == symbol instanceof OCProtocolSymbol;
    }

    @Override
    public boolean isSameSymbol(OCSymbol symbol) {
        return symbol instanceof OCClassSymbolImpl && this.isSameClass((OCClassSymbolImpl)symbol);
    }

    @Override
    public boolean isSameCategory(OCSymbol symbol) {
        if (symbol instanceof OCClassSymbolImpl && this.myName.equals(symbol.getName())) {
            String myCategory = this.myCategoryName == null ? "" : this.myCategoryName;
            String hisCategory = ((OCClassSymbol)symbol).getCategoryName() == null ? "" : ((OCClassSymbol)symbol).getCategoryName();
            return myCategory.equals(hisCategory);
        }
        return false;
    }

    @Override
    public boolean isSubclass(final OCClassSymbol ancestor) {
        final String ancestorName = ancestor.getName();
        if (this.isSameClass(ancestor) || ancestorName.equals("id")) {
            return true;
        }
        boolean ancestorIsInLibraries = OCSearchScope.isInLibraries(ancestor);
        if (!ancestorIsInLibraries && ancestor.getCategoryName() != null) {
            OCInterfaceSymbol mainInterface = ancestor.getMainInterface();
            ancestorIsInLibraries = OCSearchScope.isInLibraries(mainInterface);
        }
        class DFS {
            Set<OCClassSymbol> processedClasses = new HashSet<OCClassSymbol>();
            Stack<OCClassSymbol> stack = new Stack();
            boolean wasProcessed;

            DFS() {
            }

            <T extends OCClassSymbol> boolean traverse(String name, Class<T> clazz) {
                if (name.equals(ancestorName) && clazz == OCProtocolSymbol.class == ancestor instanceof OCProtocolSymbol) {
                    return true;
                }
                this.wasProcessed = false;
                Project project = OCClassSymbolImpl.this.getProject();
                if (project == null) {
                    return false;
                }
                OCGlobalProjectSymbolsCache.processTopLevelSymbols(project, new OCCommonProcessors.TypeFilteredProcessor(new Processor<T>(){

                    public boolean process(T t) {
                        if (!t.isPredeclaration()) {
                            wasProcessed = true;
                            if (!processedClasses.contains(t)) {
                                processedClasses.add((OCClassSymbol)t);
                                stack.push((OCClassSymbol)t);
                            }
                        }
                        return true;
                    }
                }, clazz), name);
                return false;
            }
        }
        DFS dfs = new DFS();
        if (this instanceof OCProtocolSymbol) {
            if (dfs.traverse(this.getName(), OCProtocolSymbol.class)) {
                return true;
            }
        } else {
            if (dfs.traverse(this.getName(), OCInterfaceSymbol.class)) {
                return true;
            }
            if (!dfs.wasProcessed && dfs.traverse(this.getName(), OCImplementationSymbol.class)) {
                return true;
            }
        }
        while (!dfs.stack.isEmpty()) {
            OCClassSymbol curClass = dfs.stack.pop();
            if (!ancestorIsInLibraries && OCSearchScope.isInLibraries(curClass)) continue;
            if (curClass instanceof OCInterfaceSymbol || curClass instanceof OCImplementationSymbol) {
                if (dfs.traverse(curClass.getSuperClassName(), OCInterfaceSymbol.class)) {
                    return true;
                }
                if (!dfs.wasProcessed && dfs.traverse(curClass.getSuperClassName(), OCImplementationSymbol.class)) {
                    return true;
                }
            }
            for (String protocolName : curClass.getProtocolNames()) {
                if (!dfs.traverse(protocolName, OCProtocolSymbol.class)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isTemplateSymbol() {
        return false;
    }

    @Override
    @NotNull
    public List<OCTypeParameterSymbol> getTemplateParameters() {
        List<OCTypeParameterSymbol> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/objc/OCClassSymbolImpl", "getTemplateParameters"));
        }
        return list;
    }
}

