/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.expression;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.psi.impl.OCUnaryExpressionImpl;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCUnaryExpressionSymbol
extends OCExpressionSymbol {
    private OCElementType myOperator;
    private OCExpressionSymbol myOperand;

    public OCUnaryExpressionSymbol() {
    }

    /*
     * WARNING - void declaration
     */
    public OCUnaryExpressionSymbol(@Nullable Project project, @Nullable VirtualFile file2, long offset, @Nullable String name, @NotNull OCElementType operator, @NotNull OCExpressionSymbol oCExpressionSymbol) {
        void operand;
        if (operator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operator", "com/jetbrains/cidr/lang/symbols/expression/OCUnaryExpressionSymbol", "<init>"));
        }
        if (oCExpressionSymbol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "com/jetbrains/cidr/lang/symbols/expression/OCUnaryExpressionSymbol", "<init>"));
        }
        super(project, file2, offset, name);
        this.myOperator = operator;
        this.myOperand = operand;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/jetbrains/cidr/lang/symbols/expression/OCUnaryExpressionSymbol", "deepEqualStep"));
        }
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/jetbrains/cidr/lang/symbols/expression/OCUnaryExpressionSymbol", "deepEqualStep"));
        }
        if (second == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "com/jetbrains/cidr/lang/symbols/expression/OCUnaryExpressionSymbol", "deepEqualStep"));
        }
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCUnaryExpressionSymbol firstSymbol = (OCUnaryExpressionSymbol)first;
        OCUnaryExpressionSymbol secondSymbol = (OCUnaryExpressionSymbol)second;
        if (firstSymbol.myOperator != secondSymbol.myOperator) {
            return false;
        }
        return c.equalObjects(firstSymbol.myOperand, secondSymbol.myOperand);
    }

    @Override
    @Nullable
    public <T> T evaluate(@NotNull OCExpressionEvaluator.CachingEvaluator<T> evaluator) {
        if (evaluator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "com/jetbrains/cidr/lang/symbols/expression/OCUnaryExpressionSymbol", "evaluate"));
        }
        return evaluator.evalUnary(this.myOperator, this.myOperand.evaluate(evaluator));
    }

    @Override
    @Nullable
    public OCType getResolvedType(@NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/symbols/expression/OCUnaryExpressionSymbol", "getResolvedType"));
        }
        OCType opType = this.myOperand.getResolvedType(context);
        return opType != null ? OCUnaryExpressionImpl.getUnaryExprType(this.myOperator, opType, (PsiElement)context.getFile()) : null;
    }
}

