/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.expression;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCQualifiedNameWithArguments;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerHelper;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCInitializerListExpressionSymbol
extends OCExpressionSymbol {
    private List<OCExpressionSymbol> myInitializers;

    public OCInitializerListExpressionSymbol() {
    }

    public OCInitializerListExpressionSymbol(@Nullable Project project, @Nullable VirtualFile file2, long offset, @Nullable String name, List<OCExpressionSymbol> initializers) {
        super(project, file2, offset, name);
        this.myInitializers = initializers;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/jetbrains/cidr/lang/symbols/expression/OCInitializerListExpressionSymbol", "deepEqualStep"));
        }
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/jetbrains/cidr/lang/symbols/expression/OCInitializerListExpressionSymbol", "deepEqualStep"));
        }
        if (second == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "com/jetbrains/cidr/lang/symbols/expression/OCInitializerListExpressionSymbol", "deepEqualStep"));
        }
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCInitializerListExpressionSymbol firstSymbol = (OCInitializerListExpressionSymbol)first;
        OCInitializerListExpressionSymbol secondSymbol = (OCInitializerListExpressionSymbol)second;
        return c.equalObjects(firstSymbol.myInitializers, secondSymbol.myInitializers);
    }

    @Override
    @Nullable
    public <T> T evaluate(@NotNull OCExpressionEvaluator.CachingEvaluator<T> evaluator) {
        if (evaluator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "com/jetbrains/cidr/lang/symbols/expression/OCInitializerListExpressionSymbol", "evaluate"));
        }
        return this.myInitializers.size() == 1 ? (T)this.myInitializers.get(0).evaluate(evaluator) : null;
    }

    @Override
    @Nullable
    public OCType getResolvedType(@NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/symbols/expression/OCInitializerListExpressionSymbol", "getResolvedType"));
        }
        if (!OCCompilerHelper.supportsInitializerLists(this.getContainingOCFile())) {
            return OCUnknownType.INSTANCE;
        }
        OCType type = null;
        for (OCExpressionSymbol initializer : this.myInitializers) {
            OCType exprType = initializer.getResolvedType(context);
            type = type == null ? exprType : type.getLeastCommonType(exprType, context.getElement());
        }
        List<OCTypeArgument> typeArguments = type != null ? Collections.singletonList(type) : Collections.emptyList();
        return OCReferenceType.fromLocalText(new OCQualifiedNameWithArguments(OCQualifiedName.parse("std::initializer_list"), typeArguments)).resolve(context);
    }
}

