/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.expression;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolImpl;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCExpressionSymbol
extends OCSymbolImpl<OCExpression> {
    public OCExpressionSymbol() {
    }

    public OCExpressionSymbol(@Nullable Project project, @Nullable VirtualFile file2, long offset, @Nullable String name) {
        super(project, file2, offset, name, ContainerUtil.emptyList());
    }

    @Override
    @NotNull
    public OCSymbolKind getKind() {
        OCSymbolKind oCSymbolKind = OCSymbolKind.EXPRESSION;
        if (oCSymbolKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/expression/OCExpressionSymbol", "getKind"));
        }
        return oCSymbolKind;
    }

    @Override
    @Nullable
    public OCExpression locateDefinition() {
        OCExpression expression = (OCExpression)super.locateDefinition();
        if (expression == null) {
            return null;
        }
        PsiElement parent = expression.getParent();
        while (parent instanceof OCExpression && OCSymbolOffsetUtil.getVirtualComplexOffset(parent) == this.myComplexOffset) {
            expression = (OCExpression)parent;
            parent = expression.getParent();
        }
        return expression;
    }

    @Nullable
    public abstract <T> T evaluate(@NotNull OCExpressionEvaluator.CachingEvaluator<T> var1);

    @Nullable
    public abstract OCType getResolvedType(@NotNull OCResolveContext var1);
}

