/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.expression;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.psi.impl.OCCallExpressionImpl;
import com.jetbrains.cidr.lang.psi.impl.OCReferenceExpressionImpl;
import com.jetbrains.cidr.lang.resolve.OCResolveOverloadsUtil;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCReferenceExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCallExpressionSymbol
extends OCExpressionSymbol {
    private OCExpressionSymbol myCallerSymbol;
    private List<OCExpressionSymbol> myArguments;

    public OCCallExpressionSymbol() {
    }

    public OCCallExpressionSymbol(@Nullable Project project, @Nullable VirtualFile file2, long offset, @Nullable String name, OCExpressionSymbol callerSymbol, List<OCExpressionSymbol> arguments) {
        super(project, file2, offset, name);
        this.myCallerSymbol = callerSymbol;
        this.myArguments = arguments;
    }

    public OCExpressionSymbol getCallerSymbol() {
        return this.myCallerSymbol;
    }

    public List<OCExpressionSymbol> getArguments() {
        return this.myArguments;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/jetbrains/cidr/lang/symbols/expression/OCCallExpressionSymbol", "deepEqualStep"));
        }
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/jetbrains/cidr/lang/symbols/expression/OCCallExpressionSymbol", "deepEqualStep"));
        }
        if (second == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "com/jetbrains/cidr/lang/symbols/expression/OCCallExpressionSymbol", "deepEqualStep"));
        }
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCCallExpressionSymbol firstSymbol = (OCCallExpressionSymbol)first;
        OCCallExpressionSymbol secondSymbol = (OCCallExpressionSymbol)second;
        if (!c.equalObjects(firstSymbol.myCallerSymbol, secondSymbol.myCallerSymbol)) {
            return false;
        }
        return c.equalObjects(firstSymbol.myArguments, secondSymbol.myArguments);
    }

    @Override
    @Nullable
    public <T> T evaluate(@NotNull OCExpressionEvaluator.CachingEvaluator<T> evaluator) {
        if (evaluator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "com/jetbrains/cidr/lang/symbols/expression/OCCallExpressionSymbol", "evaluate"));
        }
        return evaluator.evalCall(this);
    }

    @Override
    @Nullable
    public OCType getResolvedType(@NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/symbols/expression/OCCallExpressionSymbol", "getResolvedType"));
        }
        OCSymbol callerSymbol = null;
        OCType callerType = this.myCallerSymbol instanceof OCReferenceExpressionSymbol ? ((callerSymbol = ((OCReferenceExpressionSymbol)this.myCallerSymbol).resolveToSymbol(context)) != null ? OCReferenceExpressionImpl.getReferenceExpressionType(callerSymbol).resolve(context) : null) : this.myCallerSymbol.getResolvedType(context);
        return callerType != null ? OCCallExpressionImpl.getCallExprType(callerType, callerSymbol) : null;
    }

    @Nullable
    public OCSymbol resolveOverloads(List<OCSymbol> symbols, OCResolveContext context) {
        ArrayList<OCType> argTypes = new ArrayList<OCType>(this.myArguments.size());
        for (OCExpressionSymbol argument : this.myArguments) {
            OCType argType = argument.getResolvedType(context);
            if (argType != null) {
                argTypes.add(argType);
                continue;
            }
            return null;
        }
        return OCResolveOverloadsUtil.resolveOverloads(symbols, argTypes, this.myArguments, null, context, null, false, false, false);
    }
}

