/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.cpp;

import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.lexer.OCLexer;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCSymbolImpl;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.symtable.OCNamesInternary;
import com.jetbrains.cidr.lang.util.OCImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCMacroSymbol
extends OCSymbolImpl<OCDefineDirective>
implements Iconable {
    public static final String VA_ARGS_PARAM_NAME = "__VA_ARGS__...";
    private OCImmutableList<String> myParameterNames;
    private String mySubstitution;
    private boolean myHasParameterList;

    public OCMacroSymbol() {
    }

    public OCMacroSymbol(@Nullable Project project, @Nullable VirtualFile file2, int offset, String name, @Nullable OCImmutableList<String> parameterNames, @NotNull String substitution) {
        if (substitution == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitution", "com/jetbrains/cidr/lang/symbols/cpp/OCMacroSymbol", "<init>"));
        }
        super(project, file2, offset, name, Collections.<String>emptyList());
        this.myHasParameterList = parameterNames != null;
        this.myParameterNames = this.myHasParameterList ? parameterNames : OCImmutableList.emptyList();
        this.mySubstitution = substitution;
    }

    public static OCMacroSymbol inclusionGuard(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/cidr/lang/symbols/cpp/OCMacroSymbol", "inclusionGuard"));
        }
        return new OCMacroSymbol(null, null, 0, OCNamesInternary.intern(name), null, "");
    }

    @NotNull
    public OCImmutableList<String> getParameterNames() {
        OCImmutableList<String> oCImmutableList = this.myParameterNames;
        if (oCImmutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/cpp/OCMacroSymbol", "getParameterNames"));
        }
        return oCImmutableList;
    }

    @NotNull
    public List<String> getUserFriendlyParameterNames() {
        List list = ContainerUtil.map(this.myParameterNames, (Function)new Function<String, String>(){

            public String fun(String name) {
                return OCMacroSymbol.VA_ARGS_PARAM_NAME.equals(name) ? "..." : name;
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/cpp/OCMacroSymbol", "getUserFriendlyParameterNames"));
        }
        return list;
    }

    @Override
    public boolean isGlobal() {
        return true;
    }

    @NotNull
    public String getSubstitution() {
        String string = this.mySubstitution;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/cpp/OCMacroSymbol", "getSubstitution"));
        }
        return string;
    }

    public int getSubstitutionHash() {
        return this.mySubstitution.hashCode();
    }

    public boolean hasParameterList() {
        return this.myHasParameterList;
    }

    public String getParametersSignature() {
        if (!this.myHasParameterList) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append('(');
        boolean isFirst = true;
        Iterator iterator = this.myParameterNames.iterator();
        while (iterator.hasNext()) {
            String param = (String)iterator.next();
            if (!isFirst) {
                buffer.append(", ");
            }
            buffer.append(param);
            isFirst = false;
        }
        buffer.append(')');
        return buffer.toString();
    }

    public boolean isVararg() {
        return this.myParameterNames.size() > 0 && this.myParameterNames.get(this.myParameterNames.size() - 1).endsWith("...");
    }

    public String getPresentableSignature() {
        return this.getName() + this.getParametersSignature();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("#define ").append(this.myName);
        if (this.myHasParameterList) {
            builder.append('(');
            StringUtil.join(this.myParameterNames, (String)", ", (StringBuilder)builder);
            builder.append(')');
        }
        builder.append(' ').append(this.mySubstitution);
        return builder.toString();
    }

    @Nullable
    public static OCMacroSymbol parseFromDirectiveContent(CharSequence content, OCFile file2, int offset) {
        OCLexer contentLexer = new OCLexer(OCLanguageKind.C, false, false);
        contentLexer.start(content);
        while (OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(contentLexer.getTokenType())) {
            contentLexer.advance();
        }
        IElementType tt = contentLexer.getTokenType();
        if (tt == OCTokenTypes.IDENTIFIER || OCTokenTypes.KEYWORDS.contains(tt)) {
            IElementType t;
            ArrayList<String> params;
            String name = OCNamesInternary.intern(LexerUtil.getTokenText((Lexer)contentLexer).toString());
            contentLexer.advance();
            if (contentLexer.getTokenType() == OCTokenTypes.LPAR) {
                IElementType t2;
                params = new ArrayList<String>();
                contentLexer.advance();
                while ((t2 = contentLexer.getTokenType()) == OCTokenTypes.COMMA || t2 == OCTokenTypes.IDENTIFIER || OCTokenTypes.KEYWORDS.contains(t2) || OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(t2) || t2 == OCTokenTypes.ELLIPSIS) {
                    if (t2 == OCTokenTypes.IDENTIFIER || OCTokenTypes.KEYWORDS.contains(t2)) {
                        String paramName = OCNamesInternary.intern(LexerUtil.getTokenText((Lexer)contentLexer).toString());
                        contentLexer.advance();
                        if (contentLexer.getTokenType() == OCTokenTypes.ELLIPSIS) {
                            contentLexer.advance();
                            paramName = paramName + "...";
                        }
                        params.add(paramName);
                        continue;
                    }
                    if (t2 == OCTokenTypes.ELLIPSIS) {
                        contentLexer.advance();
                        params.add(VA_ARGS_PARAM_NAME);
                        continue;
                    }
                    contentLexer.advance();
                }
                if (contentLexer.getTokenType() == OCTokenTypes.RPAR) {
                    contentLexer.advance();
                }
            } else {
                params = null;
            }
            if (contentLexer.getTokenType() == TokenType.WHITE_SPACE) {
                contentLexer.advance();
            }
            StringBuilder replacement = new StringBuilder();
            while ((t = contentLexer.getTokenType()) != null) {
                CharSequence token = LexerUtil.getTokenText((Lexer)contentLexer);
                if (t == TokenType.WHITE_SPACE) {
                    replacement.append(token.toString().replace('\\', ' '));
                } else if (t == OCTokenTypes.EOL_ESCAPE) {
                    replacement.append(' ');
                } else {
                    replacement.append(token);
                }
                contentLexer.advance();
            }
            OCImmutableList<String> parameterNames = params == null ? null : new OCImmutableList<String>(params);
            return new OCMacroSymbol(file2 != null ? file2.getProject() : null, OCInclusionContextUtil.getVirtualFile(file2), offset, name, parameterNames, OCNamesInternary.intern(replacement.toString().trim()));
        }
        return null;
    }

    public Icon getIcon(int flags) {
        return this.getIcon();
    }

    @Override
    @NotNull
    public OCSymbolKind getKind() {
        OCSymbolKind oCSymbolKind = OCSymbolKind.MACRO;
        if (oCSymbolKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/cpp/OCMacroSymbol", "getKind"));
        }
        return oCSymbolKind;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/jetbrains/cidr/lang/symbols/cpp/OCMacroSymbol", "deepEqualStep"));
        }
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/jetbrains/cidr/lang/symbols/cpp/OCMacroSymbol", "deepEqualStep"));
        }
        if (second == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "com/jetbrains/cidr/lang/symbols/cpp/OCMacroSymbol", "deepEqualStep"));
        }
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCMacroSymbol f = (OCMacroSymbol)first;
        OCMacroSymbol s = (OCMacroSymbol)second;
        if (f.myHasParameterList != s.myHasParameterList) {
            return false;
        }
        if (!Comparing.equal((String)f.mySubstitution, (String)s.mySubstitution)) {
            return false;
        }
        return Comparing.equal(f.myParameterNames, s.myParameterNames);
    }
}

