/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.cpp;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCIcons;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithSubstitution;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeParameterResolveVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCDeclaratorSymbol
extends OCSymbolWithQualifiedName<PsiNameIdentifierOwner>
implements OCSymbolWithSubstitution {
    private OCType myType;
    private OCSymbolKind mySymbolKind;
    private int[] myArrayLengths;
    private int myDeclaratorAttributes;
    @Nullable
    private TextRange myScope;
    @NotNull
    private List<OCTypeParameterSymbol> myTemplateParameters;
    @Nullable
    private OCMethodSymbol myParentMethod;
    protected OCExpressionSymbol myInitializer;
    @NotNull
    private OCTypeSubstitution mySubstitution;

    public OCDeclaratorSymbol() {
        this.mySubstitution = OCTypeSubstitution.ID;
    }

    /*
     * WARNING - void declaration
     */
    public OCDeclaratorSymbol(Project project, VirtualFile file2, long offset, @Nullable OCSymbolWithQualifiedName parent, @NotNull OCQualifiedName name, @NotNull List<String> attributes, @NotNull OCType type, OCSymbolKind declaratorType, int[] arrayLengths, @Nullable OCExpressionSymbol initializer, @NotNull List<OCTypeParameterSymbol> templateParameters, int declaratorAttributes, @Nullable TextRange scope, @Nullable OCVisibility oCVisibility) {
        void visibility;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/cidr/lang/symbols/cpp/OCDeclaratorSymbol", "<init>"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/jetbrains/cidr/lang/symbols/cpp/OCDeclaratorSymbol", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/cidr/lang/symbols/cpp/OCDeclaratorSymbol", "<init>"));
        }
        if (templateParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateParameters", "com/jetbrains/cidr/lang/symbols/cpp/OCDeclaratorSymbol", "<init>"));
        }
        super(project, file2, offset, parent, name, attributes, (OCVisibility)visibility);
        this.mySubstitution = OCTypeSubstitution.ID;
        this.myType = type;
        this.myArrayLengths = arrayLengths.length > 0 ? arrayLengths : ArrayUtil.EMPTY_INT_ARRAY;
        this.myInitializer = initializer;
        this.mySymbolKind = declaratorType;
        this.myDeclaratorAttributes = declaratorAttributes;
        this.myTemplateParameters = templateParameters;
        this.myScope = scope;
        assert (this.myScope == null || !this.mySymbolKind.isTemplateParameter());
    }

    public OCDeclaratorSymbol(Project project, VirtualFile file2, int offset, OCSymbolWithQualifiedName parent, String name, @NotNull List<String> attributes, @NotNull OCType type, OCSymbolKind declaratorType) {
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/jetbrains/cidr/lang/symbols/cpp/OCDeclaratorSymbol", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/cidr/lang/symbols/cpp/OCDeclaratorSymbol", "<init>"));
        }
        this(project, file2, offset, parent, OCQualifiedName.interned(name), attributes, type, declaratorType, ArrayUtil.EMPTY_INT_ARRAY, null, Collections.emptyList(), 0, null, null);
    }

    public OCDeclaratorSymbol(OCDeclaratorSymbol origin, OCTypeSubstitution substitution, OCQualifiedName name, OCSymbolWithQualifiedName parent, @NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/symbols/cpp/OCDeclaratorSymbol", "<init>"));
        }
        super(origin.getProject(), origin.getContainingFile(), origin.getOffset(), parent, name, origin.getAttributes(), origin.getVisibility());
        this.mySubstitution = OCTypeSubstitution.ID;
        this.myType = origin.getType();
        this.myArrayLengths = origin.getArrayLengths();
        this.myInitializer = origin.getInitializer();
        this.mySymbolKind = origin.getKind();
        this.myDeclaratorAttributes = origin.myDeclaratorAttributes;
        this.myScope = origin.getScope();
        this.mySubstitution = OCTypeSubstitution.compose(origin.mySubstitution, substitution, context);
        this.myTemplateParameters = origin.getTemplateParameters();
        assert (this.myScope == null || !this.mySymbolKind.isTemplateParameter());
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/jetbrains/cidr/lang/symbols/cpp/OCDeclaratorSymbol", "deepEqualStep"));
        }
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/jetbrains/cidr/lang/symbols/cpp/OCDeclaratorSymbol", "deepEqualStep"));
        }
        if (second == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "com/jetbrains/cidr/lang/symbols/cpp/OCDeclaratorSymbol", "deepEqualStep"));
        }
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCDeclaratorSymbol f = (OCDeclaratorSymbol)first;
        OCDeclaratorSymbol s = (OCDeclaratorSymbol)second;
        if (f.mySymbolKind != s.mySymbolKind) {
            return false;
        }
        if (f.myDeclaratorAttributes != s.myDeclaratorAttributes) {
            return false;
        }
        if (!Comparing.equal((Object)f.myScope, (Object)s.myScope)) {
            return false;
        }
        if (!Arrays.equals(f.myArrayLengths, s.myArrayLengths)) {
            return false;
        }
        if (!c.equalObjects(f.myInitializer, s.myInitializer)) {
            return false;
        }
        if (!c.equalObjects(f.myParentMethod, s.myParentMethod)) {
            return false;
        }
        if (!c.equalObjects(f.mySubstitution, s.mySubstitution)) {
            return false;
        }
        if (!c.equalIterable(f.myTemplateParameters, s.myTemplateParameters)) {
            return false;
        }
        return c.equalObjects(f.myType, s.myType);
    }

    @Override
    public boolean isGlobal() {
        return this.myScope == null;
    }

    @Override
    public boolean isTopLevel() {
        return this.myScope == null && this.getParent() == null;
    }

    @Override
    @NotNull
    public OCType getType() {
        OCType oCType = this.mySubstitution.substitute(this.myType, new OCResolveContext());
        if (oCType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/cpp/OCDeclaratorSymbol", "getType"));
        }
        return oCType;
    }

    public void setType(OCFunctionType type) {
        this.myType = type;
    }

    @Override
    @NotNull
    public OCTypeSubstitution getSubstitution() {
        OCTypeSubstitution oCTypeSubstitution = this.mySubstitution;
        if (oCTypeSubstitution == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/cpp/OCDeclaratorSymbol", "getSubstitution"));
        }
        return oCTypeSubstitution;
    }

    @Override
    public boolean isTemplateSymbol() {
        return !this.myTemplateParameters.isEmpty();
    }

    @Override
    @NotNull
    public List<OCTypeParameterSymbol> getTemplateParameters() {
        List<OCTypeParameterSymbol> list = this.myTemplateParameters;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/cpp/OCDeclaratorSymbol", "getTemplateParameters"));
        }
        return list;
    }

    @Override
    @NotNull
    public String getSignature() {
        StringBuilder buffer = new StringBuilder();
        String typeText = this.getType().accept(new OCTypeParameterResolveVisitor(this.getContainingOCFile())).getName();
        buffer.append(typeText);
        if (!this.isUnnamed()) {
            if (!typeText.endsWith("*")) {
                buffer.append(" ");
            }
            buffer.append(this.getName());
        }
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/cpp/OCDeclaratorSymbol", "getSignature"));
        }
        return string;
    }

    @Override
    protected Class<? extends PsiNameIdentifierOwner> getPsiElementClass() {
        return this.myParentMethod != null ? OCMethodSelectorPart.class : super.getPsiElementClass();
    }

    public void setType(@NotNull OCType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/cidr/lang/symbols/cpp/OCDeclaratorSymbol", "setType"));
        }
        this.myType = type;
    }

    @Override
    @NotNull
    public OCSymbolKind getKind() {
        OCSymbolKind oCSymbolKind = this.mySymbolKind;
        if (oCSymbolKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/cpp/OCDeclaratorSymbol", "getKind"));
        }
        return oCSymbolKind;
    }

    @Override
    public boolean isConst() {
        return (this.myDeclaratorAttributes & 1) != 0 || this.isConstexpr() || this.mySymbolKind == OCSymbolKind.ENUM_CONST;
    }

    public boolean isConstexpr() {
        return (this.myDeclaratorAttributes & 0x80) != 0;
    }

    public boolean isMutable() {
        return (this.myDeclaratorAttributes & 0x40) != 0;
    }

    @Override
    public boolean isStatic() {
        return (this.myDeclaratorAttributes & 2) != 0;
    }

    public boolean isExtern() {
        return (this.myDeclaratorAttributes & 4) != 0;
    }

    public boolean isBlockModifiable() {
        return (this.myDeclaratorAttributes & 8) != 0;
    }

    public boolean isPassByReference() {
        return (this.myDeclaratorAttributes & 0x10) != 0;
    }

    public boolean hasInitializer() {
        return (this.myDeclaratorAttributes & 0x20) != 0;
    }

    @Override
    @Nullable
    public TextRange getScope() {
        return this.myScope;
    }

    @Override
    public boolean isDefinition() {
        return super.isDefinition() && this.myScope == null;
    }

    @NotNull
    public int[] getArrayLengths() {
        if (this.myArrayLengths == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/cpp/OCDeclaratorSymbol", "getArrayLengths"));
        }
        return this.myArrayLengths;
    }

    public OCExpressionSymbol getInitializer() {
        return this.myInitializer;
    }

    @Nullable
    public OCDeclaratorSymbol getDeclarationInParent() {
        if (this.getQualifier() == null) {
            return this;
        }
        OCSymbolWithQualifiedName owner = this.getResolvedOwner();
        final Ref result2 = new Ref(null);
        if (owner instanceof OCStructSymbol) {
            ((OCStructSymbol)owner).processMembers(this.getName(), new Processor<OCSymbol>(){

                public boolean process(OCSymbol symbol) {
                    if (symbol instanceof OCDeclaratorSymbol) {
                        result2.set((Object)((OCDeclaratorSymbol)symbol));
                        return false;
                    }
                    return true;
                }
            });
        }
        return (OCDeclaratorSymbol)result2.get();
    }

    public boolean resolveIsStatic() {
        if (this.isStatic() || this.getQualifier() == null) {
            return this.isStatic();
        }
        OCDeclaratorSymbol predef = this.getDeclarationInParent();
        return predef != null && predef.isStatic();
    }

    @Override
    public Icon getBaseIcon() {
        Icon icon = this.getKind().getIcon();
        if (this.isConst() && this.getKind() != OCSymbolKind.ENUM_CONST) {
            icon = OCIcons.getConstIcon(icon);
        }
        if (this.isStatic()) {
            icon = OCIcons.getStaticIcon(icon);
        }
        return OCIcons.getVisibilityIcon(this.getVisibility(), icon);
    }

    public void setParentMethod(@Nullable OCMethodSymbol parentMethod) {
        this.myParentMethod = parentMethod;
    }

    @Override
    public boolean processAssociatedSymbols(final Processor<OCSymbol> processor2) {
        if (this.mySymbolKind != OCSymbolKind.PARAMETER) {
            return super.processAssociatedSymbols(processor2);
        }
        if (this.myParentMethod != null) {
            OCMethodSymbol parentAssociate = this.myParentMethod.getAssociatedSymbol();
            if (parentAssociate == null) {
                return true;
            }
            int indexInParent = 0;
            for (OCMethodSymbol.SelectorPartSymbol selector : this.myParentMethod.getSelectors()) {
                if (this.equals(selector.getParameter())) break;
                ++indexInParent;
            }
            if (indexInParent >= this.myParentMethod.getSelectors().size()) {
                return true;
            }
            return processor2.process((Object)parentAssociate.getSelectors().get(indexInParent).getParameter());
        }
        if (this.myParent instanceof OCFunctionSymbol) {
            final int parameterIndex = ((OCFunctionSymbol)this.myParent).getParameterSymbols().indexOf(this);
            return this.myParent.processAssociatedSymbols(new Processor<OCSymbol>(){

                public boolean process(OCSymbol symbol) {
                    if (symbol instanceof OCFunctionSymbol && parameterIndex != -1 && parameterIndex < ((OCFunctionSymbol)symbol).getParameterSymbols().size()) {
                        return processor2.process((Object)((OCFunctionSymbol)symbol).getParameterSymbols().get(parameterIndex));
                    }
                    return true;
                }
            });
        }
        return true;
    }

    @Override
    public boolean processSameSymbols(Processor<OCSymbol> processor2, PsiFile file2) {
        if (this.mySymbolKind == OCSymbolKind.PARAMETER) {
            if (this.myParentMethod != null) {
                OCSymbol associatedSymbol = this.getAssociatedSymbol();
                return processor2.process((Object)this) && (associatedSymbol == null || processor2.process((Object)associatedSymbol));
            }
            if (this.myParent instanceof OCFunctionSymbol) {
                return processor2.process((Object)this) && this.processAssociatedSymbols(processor2);
            }
        }
        return super.processSameSymbols(processor2, file2);
    }

    public static class Attributes {
        private static final int IS_CONST = 1;
        private static final int IS_STATIC = 2;
        private static final int IS_EXTERN = 4;
        private static final int IS_BLOCK_MODIFIABLE = 8;
        private static final int IS_PASS_BY_REF = 16;
        private static final int IS_HAS_INITIALIZER = 32;
        private static final int IS_MUTABLE = 64;
        private static final int IS_CONSTEEXPR = 128;
        protected static final int DEFAULT = 0;

        private Attributes() {
        }

        public static int create(boolean isConst, boolean isConstexpr, boolean isMutable, boolean isStatic, boolean isExtern, boolean isBlockModifiable, boolean isPassByRef, boolean isHasInitializer) {
            int result2 = 0;
            if (isConst) {
                result2 |= 1;
            }
            if (isConstexpr) {
                result2 |= 0x80;
            }
            if (isMutable) {
                result2 |= 0x40;
            }
            if (isStatic) {
                result2 |= 2;
            }
            if (isExtern) {
                result2 |= 4;
            }
            if (isBlockModifiable) {
                result2 |= 8;
            }
            if (isPassByRef) {
                result2 |= 0x10;
            }
            if (isHasInitializer) {
                result2 |= 0x20;
            }
            return result2;
        }
    }
}

