/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceQualifier;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCQualifiedNameWithArguments;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReferenceResolver;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceAliasSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCThisSelfSuperSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterTypeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCUsingSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCFileSymbols;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.visitors.OCSimpleTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCSymbolReference
implements Serializable,
DeepEqual.Equality<OCSymbolReference> {
    public static final OCElementType[] TYPE_TOKENS = new OCElementType[]{OCTokenTypes.STRUCT_KEYWORD, OCTokenTypes.ENUM_KEYWORD, OCTokenTypes.UNION_KEYWORD, OCTokenTypes.CLASS_KEYWORD};
    @NotNull
    private OCQualifiedName myQualifiedName;
    @NotNull
    protected SymbolFilter myFilter;
    private static final Key<CachedValue<Map<ReferenceInfo, ResultInfo>>>[] RESOLVE_CACHES = new Key[12];

    @NotNull
    public SymbolFilter getFilter() {
        SymbolFilter symbolFilter = this.myFilter;
        if (symbolFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/OCSymbolReference", "getFilter"));
        }
        return symbolFilter;
    }

    public static SymbolFilter compose(SymbolFilter filter1, SymbolFilter filter2) {
        if (filter1 == null || filter1 == SymbolFilter.NONE) {
            return filter2;
        }
        if (filter2 == null || filter2 == SymbolFilter.NONE) {
            return filter1;
        }
        return new SymbolFilterComposition(filter1, filter2);
    }

    public OCSymbolReference(@NotNull OCQualifiedName qualifiedName, @NotNull SymbolFilter filter) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/jetbrains/cidr/lang/symbols/OCSymbolReference", "<init>"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/jetbrains/cidr/lang/symbols/OCSymbolReference", "<init>"));
        }
        this.myQualifiedName = qualifiedName;
        this.myFilter = filter;
    }

    public OCSymbolReference() {
    }

    @NotNull
    public OCQualifiedName getQualifiedName() {
        OCQualifiedName oCQualifiedName = this.myQualifiedName;
        if (oCQualifiedName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/OCSymbolReference", "getQualifiedName"));
        }
        return oCQualifiedName;
    }

    public boolean processPossibleSymbols(Processor<OCSymbol> processor2, @NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/symbols/OCSymbolReference", "processPossibleSymbols"));
        }
        return ContainerUtil.process(this.resolveToSymbols(false, false, true, context), processor2);
    }

    public boolean processPossibleSymbols(Processor<OCSymbol> processor2, @NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/symbols/OCSymbolReference", "processPossibleSymbols"));
        }
        return ContainerUtil.process(this.resolveToSymbols(file2), processor2);
    }

    @NotNull
    public List<OCSymbol> resolveToSymbols(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/symbols/OCSymbolReference", "resolveToSymbols"));
        }
        List<OCSymbol> list = this.resolveToSymbols(this.getMemoization(file2));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/OCSymbolReference", "resolveToSymbols"));
        }
        return list;
    }

    @NotNull
    public List<OCSymbol> resolveToSymbols(@NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/symbols/OCSymbolReference", "resolveToSymbols"));
        }
        List<OCSymbol> list = this.resolveToSymbols(context, false, false, true);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/OCSymbolReference", "resolveToSymbols"));
        }
        return list;
    }

    @NotNull
    public List<OCSymbol> resolveToSymbols(boolean processTypedefs, boolean onlyTypes, PsiFile file2) {
        List<OCSymbol> list = this.resolveToSymbols(processTypedefs, onlyTypes, true, this.getMemoization(file2));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/OCSymbolReference", "resolveToSymbols"));
        }
        return list;
    }

    @NotNull
    public List<OCSymbol> resolveToSymbols(boolean processTypedefs, boolean onlyTypes, boolean resolveSpecialization, @NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/symbols/OCSymbolReference", "resolveToSymbols"));
        }
        List<OCSymbol> symbols = this.resolveToSymbols(context, false, onlyTypes, resolveSpecialization);
        List<OCSymbol> list = OCSymbolReference.lookupUsingsAndTypedefs(processTypedefs, onlyTypes, context, symbols, this, true);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/OCSymbolReference", "resolveToSymbols"));
        }
        return list;
    }

    @NotNull
    public static List<OCSymbol> lookupUsingsAndTypedefs(boolean processTypedefs, boolean onlyTypes, @NotNull OCResolveContext context, @NotNull List<OCSymbol> symbols, @NotNull OCSymbolReference reference, boolean processTypeParameters) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/symbols/OCSymbolReference", "lookupUsingsAndTypedefs"));
        }
        if (symbols == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbols", "com/jetbrains/cidr/lang/symbols/OCSymbolReference", "lookupUsingsAndTypedefs"));
        }
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/jetbrains/cidr/lang/symbols/OCSymbolReference", "lookupUsingsAndTypedefs"));
        }
        boolean oldNonImportedMode = OCResolveContext.setNonImportedFlag(context, false);
        OCQualifiedName qualifiedName = reference.getQualifiedName();
        List<OCTypeArgument> args = null;
        if (qualifiedName instanceof OCQualifiedNameWithArguments) {
            args = ((OCQualifiedNameWithArguments)qualifiedName).getArguments();
        }
        UsingAndTypedefSymbolsResolver resolver = new UsingAndTypedefSymbolsResolver(processTypedefs, processTypeParameters, onlyTypes, args, context);
        ContainerUtil.process(symbols, (Processor)resolver);
        OCResolveContext.setNonImportedFlag(context, oldNonImportedMode);
        List<OCSymbol> list = resolver.getAnswer();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/OCSymbolReference", "lookupUsingsAndTypedefs"));
        }
        return list;
    }

    private OCResolveContext getMemoization(PsiFile file2) {
        PsiElement element = this instanceof LocalReference ? ((LocalReference)this).getLocalContext() : null;
        return new OCResolveContext((PsiElement)(element != null ? element : file2));
    }

    public static OCSymbolReference getGlobalReference(@NotNull OCQualifiedName qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/jetbrains/cidr/lang/symbols/OCSymbolReference", "getGlobalReference"));
        }
        return new GlobalReference(qualifiedName, null, SymbolFilter.NONE);
    }

    public static OCSymbolReference getGlobalReference(@NotNull OCQualifiedName qualifiedName, SymbolFilter filter) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/jetbrains/cidr/lang/symbols/OCSymbolReference", "getGlobalReference"));
        }
        return new GlobalReference(qualifiedName, null, filter);
    }

    public static OCSymbolReference getGlobalReference(String qualifiedName, OCSymbolWithQualifiedName symbolContext) {
        return new GlobalReference(OCQualifiedName.with(qualifiedName), symbolContext, SymbolFilter.NONE);
    }

    public static OCSymbolReference getGlobalReference(String qualifiedName, OCSymbolWithQualifiedName symbolContext, SymbolFilter filter) {
        return new GlobalReference(OCQualifiedName.with(qualifiedName), symbolContext, filter);
    }

    public static OCSymbolReference getGlobalReference(@NotNull OCQualifiedName qualifiedName, OCSymbolWithQualifiedName symbolContext) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/jetbrains/cidr/lang/symbols/OCSymbolReference", "getGlobalReference"));
        }
        return new GlobalReference(qualifiedName, symbolContext, SymbolFilter.NONE);
    }

    public static OCSymbolReference getBaseClauseReference(@NotNull OCQualifiedName qualifiedName, @Nullable OCSymbolWithQualifiedName symbolContext) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/jetbrains/cidr/lang/symbols/OCSymbolReference", "getBaseClauseReference"));
        }
        return new BaseClauseReference(qualifiedName, symbolContext, SymbolFilter.NONE);
    }

    public static OCSymbolReference getTemplateParamsReference(@NotNull OCQualifiedName qualifiedName, @Nullable OCSymbolWithQualifiedName symbolContext) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/jetbrains/cidr/lang/symbols/OCSymbolReference", "getTemplateParamsReference"));
        }
        return new TemplateParamsReference(qualifiedName, symbolContext, SymbolFilter.NONE);
    }

    public static OCSymbolReference getGlobalReference(@NotNull OCQualifiedName qualifiedName, OCSymbolWithQualifiedName symbolContext, SymbolFilter filter) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/jetbrains/cidr/lang/symbols/OCSymbolReference", "getGlobalReference"));
        }
        return new GlobalReference(qualifiedName, symbolContext, filter);
    }

    public static OCSymbolReference getLocalReference(@NotNull OCQualifiedName qualifiedName, PsiElement localContext) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/jetbrains/cidr/lang/symbols/OCSymbolReference", "getLocalReference"));
        }
        return new LocalReference(qualifiedName, localContext, SymbolFilter.NONE);
    }

    public static OCSymbolReference getLocalReference(@NotNull OCQualifiedName qualifiedName, PsiElement localContext, SymbolFilter filter) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/jetbrains/cidr/lang/symbols/OCSymbolReference", "getLocalReference"));
        }
        return new LocalReference(qualifiedName, localContext, filter);
    }

    public static OCSymbolReference getLocalReference(String name, PsiElement element) {
        return OCSymbolReference.getLocalReference(OCQualifiedName.with(name), element, (SymbolFilter)SymbolFilter.NONE);
    }

    public static OCSymbolReference getLocalReference(String name, PsiElement element, SymbolFilter filter) {
        return OCSymbolReference.getLocalReference(OCQualifiedName.with(name), element, filter);
    }

    public static OCSymbolReference getLocalReference(OCReferenceElement element, SymbolFilter filter, @NotNull OCResolveContext context, @Nullable OCExpressionEvaluator.CachingEvaluator evaluator) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/symbols/OCSymbolReference", "getLocalReference"));
        }
        OCQualifiedName qualifiedName = OCSymbolReferenceResolver.getQualifiedName(element, context, evaluator);
        return OCSymbolReference.getLocalReference(qualifiedName, (PsiElement)element, filter);
    }

    public static OCSymbolReference getLocalReference(OCReferenceElement element, PsiElement resolveContext, SymbolFilter filter) {
        OCQualifiedName qualifiedName = OCSymbolReferenceResolver.getQualifiedName(element);
        return OCSymbolReference.getLocalReference(qualifiedName, resolveContext, filter);
    }

    public static OCSymbolReference getLocalReference(OCCppNamespaceQualifier element, SymbolFilter filter) {
        OCQualifiedName qualifiedName = OCSymbolReferenceResolver.getQualifiedName(element);
        return OCSymbolReference.getLocalReference(qualifiedName, (PsiElement)element, filter);
    }

    protected abstract OCSymbolReference getSymbolReferenceToQualifier();

    @NotNull
    protected SymbolKindFilter getFilterForQualifier() {
        SymbolKindFilter symbolKindFilter = this.myFilter == SymbolKindFilter.ONLY_NAMESPACE ? SymbolKindFilter.ONLY_NAMESPACE : SymbolKindFilter.ONLY_NAMESPACE_LIKE;
        if (symbolKindFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/OCSymbolReference", "getFilterForQualifier"));
        }
        return symbolKindFilter;
    }

    protected abstract OCSymbolReference applyTypeArguments(List<OCTypeArgument> var1);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OCSymbolReference that = (OCSymbolReference)o;
        if (!this.myQualifiedName.equals(that.myQualifiedName)) {
            return false;
        }
        return this.myFilter.equals(that.myFilter);
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull OCSymbolReference first, @NotNull OCSymbolReference second) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/jetbrains/cidr/lang/symbols/OCSymbolReference", "deepEqualStep"));
        }
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/jetbrains/cidr/lang/symbols/OCSymbolReference", "deepEqualStep"));
        }
        if (second == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "com/jetbrains/cidr/lang/symbols/OCSymbolReference", "deepEqualStep"));
        }
        return c.equalObjects(first.myQualifiedName, second.myQualifiedName);
    }

    public int hashCode() {
        return this.myQualifiedName.hashCode();
    }

    @NotNull
    List<OCSymbol> resolveToSymbols(@NotNull OCResolveContext context, boolean onlySimpleNamespaces, boolean onlyTypes, boolean resolveSpecialization) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/symbols/OCSymbolReference", "resolveToSymbols"));
        }
        if (context.getFile() == null) {
            List<OCSymbol> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/OCSymbolReference", "resolveToSymbols"));
            }
            return list;
        }
        boolean ignoreImports = context.isProcessNonImported();
        Map cache = (Map)OCSymbolReference.getCache(context.getFile(), onlySimpleNamespaces, onlyTypes, ignoreImports, this.getCacheDependency()).getValue();
        OCTypeSubstitution substitution = context.getSubstitution();
        substitution = substitution.getMinimalDependentSubstitution(this, context);
        ProgressManager.checkCanceled();
        ResultInfo cachedResolve = (ResultInfo)cache.get(new ReferenceInfo(this, substitution, context));
        if (cachedResolve != null) {
            context.setContextWasUsed(cachedResolve.contextWasUsed);
        }
        if (cachedResolve == null) {
            List<OCSymbol> results = this.doResolve(context, onlySimpleNamespaces, onlyTypes, resolveSpecialization);
            cachedResolve = new ResultInfo(results, context.wasContextUsed());
            if (resolveSpecialization && (!context.wasCollision() || context.myInsideUsingNamespaceCounter == 0 && !results.isEmpty())) {
                cache.put(new ReferenceInfo(this, substitution, null), cachedResolve);
            }
        }
        List<OCSymbol> list = Collections.unmodifiableList(cachedResolve.symbols);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/OCSymbolReference", "resolveToSymbols"));
        }
        return list;
    }

    protected Key getCacheDependency() {
        return PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT;
    }

    @NotNull
    private static CachedValue<Map<ReferenceInfo, ResultInfo>> getCache(@NotNull PsiFile file2, boolean onlySimpleNamespaces, boolean onlyTypes, boolean ignoreImports, @NotNull Key dependency) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/symbols/OCSymbolReference", "getCache"));
        }
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/jetbrains/cidr/lang/symbols/OCSymbolReference", "getCache"));
        }
        Key<CachedValue<Map<ReferenceInfo, ResultInfo>>> cacheKey = OCSymbolReference.getCacheKey(onlySimpleNamespaces, onlyTypes, ignoreImports, dependency);
        CachedValue<Map<ReferenceInfo, ResultInfo>> cache = (CachedValue<Map<ReferenceInfo, ResultInfo>>)file2.getUserData(cacheKey);
        if (cache == null) {
            cache = OCSymbolReference.createCache(file2.getProject(), dependency);
            file2.putUserData(cacheKey, cache);
        }
        CachedValue<Map<ReferenceInfo, ResultInfo>> cachedValue = cache;
        if (cachedValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/OCSymbolReference", "getCache"));
        }
        return cachedValue;
    }

    @NotNull
    private static CachedValue<Map<ReferenceInfo, ResultInfo>> createCache(Project project, final @NotNull Key dependency) {
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/jetbrains/cidr/lang/symbols/OCSymbolReference", "createCache"));
        }
        CachedValue cachedValue = CachedValuesManager.getManager((Project)project).createCachedValue((CachedValueProvider)new CachedValueProvider<Map<ReferenceInfo, ResultInfo>>(){

            public CachedValueProvider.Result<Map<ReferenceInfo, ResultInfo>> compute() {
                ConcurrentMap cache = ContainerUtil.newConcurrentMap();
                return CachedValueProvider.Result.create((Object)cache, (Object[])new Object[]{dependency});
            }
        }, false);
        if (cachedValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/OCSymbolReference", "createCache"));
        }
        return cachedValue;
    }

    @NotNull
    private static Key<CachedValue<Map<ReferenceInfo, ResultInfo>>> getCacheKey(boolean expandNamespaceUsings, boolean onlyTypes, boolean ignoreImports, Key dependency) {
        int cacheIndex = ignoreImports ? 0 : (onlyTypes ? 1 : 2);
        cacheIndex = (cacheIndex * 2 + (expandNamespaceUsings ? 1 : 0)) * 2 + (dependency == PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT ? 1 : 0);
        Key<CachedValue<Map<ReferenceInfo, ResultInfo>>> key = RESOLVE_CACHES[cacheIndex];
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/OCSymbolReference", "getCacheKey"));
        }
        return key;
    }

    @NotNull
    public List<OCSymbol> doResolve(@NotNull OCResolveContext context, boolean onlySimpleNamespaces, boolean onlyTypes, boolean resolveSpecialization) {
        boolean skipImmediateContext;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/symbols/OCSymbolReference", "doResolve"));
        }
        ProgressManager.checkCanceled();
        OCSymbolReferenceResolver referenceResolver = new OCSymbolReferenceResolver(!onlySimpleNamespaces, onlyTypes, context);
        CommonProcessors.CollectProcessor<OCSymbol> processor2 = this.createSubstitutingProcessor(context);
        SymbolFilter filter = this.myFilter;
        NameWithToken nameWithToken = OCSymbolReference.removeTypeToken(this.myQualifiedName.getName());
        String name = nameWithToken.name;
        if (nameWithToken.typeToken != null) {
            filter = SymbolKindFilter.parse(nameWithToken.typeToken);
        }
        OCQualifiedName qualifiedName = this.myQualifiedName.getQualifier();
        boolean bl = skipImmediateContext = this instanceof BaseClauseReference || this instanceof TemplateParamsReference;
        if (qualifiedName != null) {
            if (qualifiedName.equals(OCQualifiedName.GLOBAL)) {
                referenceResolver.processSymbolsForGlobalRef(name, filter, null, skipImmediateContext, (Processor<OCSymbol>)processor2);
            } else {
                OCSymbolReference qualifier = this.getSymbolReferenceToQualifier();
                List<OCSymbol> iterable = context.resolveToSymbols(qualifier, true, true, onlySimpleNamespaces, onlyTypes);
                boolean old = OCResolveContext.setNonImportedFlag(context, false);
                OCCommonProcessors.OrderedProcessor<OCSymbol> orderedProcessor = referenceResolver.getFilteredByKindProcessor(filter, (Processor<OCSymbol>)processor2);
                ContainerUtil.process(iterable, (Processor)new SymbolMembersProcessor(name, orderedProcessor, onlySimpleNamespaces, onlyTypes, context));
                orderedProcessor.finish();
                OCResolveContext.setNonImportedFlag(context, old);
            }
        } else if (this instanceof LocalReference) {
            PsiElement localContext = ((LocalReference)this).getLocalContext();
            if (localContext != null && localContext.isValid()) {
                referenceResolver.processSymbolsForLocalRef(name, filter, localContext, (Processor<OCSymbol>)processor2);
            }
        } else {
            OCSymbolWithQualifiedName symbolContext = ((GlobalReference)this).getSymbolContext();
            referenceResolver.processSymbolsForGlobalRef(name, filter, symbolContext, skipImmediateContext, (Processor<OCSymbol>)processor2);
        }
        Collection<OCSymbol> results = processor2.getResults();
        if (resolveSpecialization) {
            results = this.resolveTemplateSpecialization(context, results);
        }
        List<OCSymbol> list = OCSymbolReference.findDefinitions(referenceResolver, results);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/OCSymbolReference", "doResolve"));
        }
        return list;
    }

    @NotNull
    public static NameWithToken removeTypeToken(@Nullable String name) {
        String typeToken = null;
        if (name != null) {
            String nameWithoutTypeQualifiers = name;
            boolean changes = true;
            while (changes) {
                changes = false;
                for (OCElementType oCElementType : OCTokenTypes.TYPE_QUALIFIERS.getTypes()) {
                    String tokenName = oCElementType.getName();
                    if (!nameWithoutTypeQualifiers.startsWith(tokenName + " ")) continue;
                    nameWithoutTypeQualifiers = nameWithoutTypeQualifiers.substring(tokenName.length() + 1);
                    changes = true;
                }
            }
            for (OCElementType oCElementType : TYPE_TOKENS) {
                if (!nameWithoutTypeQualifiers.startsWith(oCElementType.getName() + " ")) continue;
                name = name.substring(0, name.length() - nameWithoutTypeQualifiers.length()) + nameWithoutTypeQualifiers.substring(oCElementType.getName().length() + 1);
                typeToken = oCElementType.getName();
                break;
            }
        }
        NameWithToken nameWithToken = new NameWithToken(name, typeToken);
        if (nameWithToken == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/OCSymbolReference", "removeTypeToken"));
        }
        return nameWithToken;
    }

    protected CommonProcessors.CollectProcessor<OCSymbol> createSubstitutingProcessor(final @NotNull OCResolveContext resolver) {
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "com/jetbrains/cidr/lang/symbols/OCSymbolReference", "createSubstitutingProcessor"));
        }
        final HashSet set = new HashSet();
        CommonProcessors.CollectProcessor processor2 = new CommonProcessors.CollectProcessor<OCSymbol>(){

            protected boolean accept(OCSymbol symbol) {
                return set.add(symbol);
            }
        };
        if (!(this.myQualifiedName instanceof OCQualifiedNameWithArguments) && resolver.getSubstitution() != OCTypeSubstitution.ID) {
            processor2 = new CommonProcessors.CollectProcessor<OCSymbol>(){

                protected boolean accept(OCSymbol symbol) {
                    return set.add(symbol);
                }

                public boolean process(OCSymbol symbol) {
                    OCSymbol afterSubstitution = resolver.getSubstitution().substitute(symbol, resolver);
                    return super.process((Object)afterSubstitution);
                }
            };
        }
        return processor2;
    }

    protected Collection<OCSymbol> resolveTemplateSpecialization(@NotNull OCResolveContext resolver, Collection<OCSymbol> symbols) {
        Collection<OCSymbol> results;
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "com/jetbrains/cidr/lang/symbols/OCSymbolReference", "resolveTemplateSpecialization"));
        }
        if (this.myQualifiedName instanceof OCQualifiedNameWithArguments && !symbols.isEmpty()) {
            results = new ArrayList<OCSymbol>();
            ArrayList<OCSymbol> candidates = new ArrayList<OCSymbol>(symbols);
            OCSymbolWithQualifiedName symbolContext = this instanceof GlobalReference ? ((GlobalReference)this).getSymbolContext() : null;
            List<OCTypeArgument> arguments = ((OCQualifiedNameWithArguments)this.myQualifiedName).getArguments();
            for (OCSymbol spec : OCSimpleTypeSubstitution.resolveTemplateSpecialization(candidates, arguments, symbolContext, resolver)) {
                OCSymbol afterSubstitution = resolver.getSubstitution().substitute(spec, resolver);
                results.add(afterSubstitution);
            }
        } else {
            results = symbols;
        }
        return results;
    }

    protected static List<OCSymbol> findDefinitions(OCSymbolReferenceResolver referenceResolver, Collection<OCSymbol> results) {
        if (!results.isEmpty()) {
            Collection<OCSymbol> implementations;
            for (OCSymbol collected : results) {
                if (collected.isPredeclaration()) continue;
                return (List)results;
            }
            OCSymbol collected = results.iterator().next();
            if (collected instanceof OCSymbolWithQualifiedName && !(implementations = referenceResolver.getImplementationsOfSymbol((OCSymbolWithQualifiedName)collected, false)).isEmpty()) {
                results.addAll(implementations);
                return (List)results;
            }
        }
        return (List)results;
    }

    static {
        for (int i = 0; i < RESOLVE_CACHES.length; ++i) {
            OCSymbolReference.RESOLVE_CACHES[i] = Key.create((String)("SYMBOL_RESOLVE_CACHE_IN_FILE" + i));
        }
    }

    public static class UsingAndTypedefSymbolsResolver
    implements Processor<OCSymbol> {
        private final Set<OCSymbol> myProcessedSymbols;
        private final ArrayList<OCSymbol> myAnswer;
        @NotNull
        private OCResolveContext myMemoization;
        private final boolean myProcessTypdefs;
        private final boolean myProcessTypeParameters;
        private final boolean myOnlyTypes;
        private List<OCTypeArgument> myArguments;

        public UsingAndTypedefSymbolsResolver(boolean processTypedefs, boolean processTypeParameters, boolean onlyTypes, @Nullable List<OCTypeArgument> arguments, @NotNull OCResolveContext context) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/symbols/OCSymbolReference$UsingAndTypedefSymbolsResolver", "<init>"));
            }
            this.myProcessedSymbols = new HashSet<OCSymbol>();
            this.myAnswer = new ArrayList();
            this.myProcessTypdefs = processTypedefs;
            this.myProcessTypeParameters = processTypeParameters;
            this.myOnlyTypes = onlyTypes;
            this.myMemoization = context;
            this.myArguments = arguments;
        }

        public boolean process(OCSymbol symbol) {
            if (this.myProcessedSymbols.add(symbol)) {
                OCFile currentFile = (OCFile)this.myMemoization.getFile();
                if (currentFile == null) {
                    return true;
                }
                if (symbol instanceof OCUsingSymbol) {
                    OCFileSymbols.markImportNeeded(currentFile, symbol);
                    OCSymbolReference reference = ((OCUsingSymbol)symbol).getSymbolReference();
                    if (this.myArguments != null) {
                        reference = reference.applyTypeArguments(this.myArguments);
                    }
                    OCResolveContext contextForUsing = this.myMemoization.substitute(((OCUsingSymbol)symbol).getSubstitution());
                    Collection<OCSymbol> symbols = contextForUsing.doResolveToSymbols(reference, false, this.myOnlyTypes);
                    symbols = reference.resolveTemplateSpecialization(contextForUsing, symbols);
                    ContainerUtil.process(symbols, (Processor)this);
                } else if (symbol.getKind().isTypedefOrAlias() && this.myProcessTypdefs) {
                    OCFileSymbols.markImportNeeded(currentFile, symbol);
                    this.processType(symbol, symbol.getType());
                } else if (symbol instanceof OCNamespaceAliasSymbol && this.myProcessTypdefs) {
                    OCFileSymbols.markImportNeeded(currentFile, symbol);
                    OCSymbolReference reference = ((OCNamespaceAliasSymbol)symbol).getNamespaceReference();
                    ContainerUtil.process(this.myMemoization.doResolveToSymbols(reference, false, this.myOnlyTypes), (Processor)this);
                } else if (symbol instanceof OCTypeParameterSymbol && this.myProcessTypeParameters) {
                    OCTypeArgument argument = this.myMemoization.getSubstitution().getSubstitutionFor((OCTypeParameterSymbol)((Object)symbol));
                    if (argument instanceof OCType) {
                        this.processType(symbol, (OCType)argument);
                    } else {
                        this.myAnswer.add(symbol);
                    }
                } else {
                    this.myAnswer.add(symbol);
                }
            }
            return true;
        }

        protected void processType(OCSymbol symbol, OCType type) {
            if (type instanceof OCStructType) {
                this.myAnswer.addAll(((OCStructType)type).getStructs());
            } else if (type instanceof OCReferenceType) {
                OCSymbolReference reference = ((OCReferenceType)type).getReference();
                if (symbol instanceof OCDeclaratorSymbol) {
                    this.myMemoization = this.myMemoization.substitute(((OCDeclaratorSymbol)symbol).getSubstitution());
                }
                Collection<OCSymbol> symbols = this.myMemoization.doResolveToSymbols(reference, false, this.myOnlyTypes);
                symbols = reference.resolveTemplateSpecialization(this.myMemoization, symbols);
                List<OCTypeArgument> oldArguments = this.myArguments;
                if (this.myArguments == null && reference.getQualifiedName() instanceof OCQualifiedNameWithArguments) {
                    this.myArguments = ((OCQualifiedNameWithArguments)reference.getQualifiedName()).getArguments();
                }
                ContainerUtil.process(symbols, (Processor)this);
                this.myArguments = oldArguments;
            } else if (type instanceof OCMagicType) {
                this.myAnswer.add(new OCTypeParameterTypeSymbol(null, null, 0L, symbol.getName(), null, Collections.<String>emptyList(), null, false));
            }
        }

        @NotNull
        public List<OCSymbol> getAnswer() {
            if (this.myAnswer.size() == 0) {
                List<OCSymbol> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/OCSymbolReference$UsingAndTypedefSymbolsResolver", "getAnswer"));
                }
                return list;
            }
            this.myAnswer.trimToSize();
            ArrayList<OCSymbol> arrayList = this.myAnswer;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/OCSymbolReference$UsingAndTypedefSymbolsResolver", "getAnswer"));
            }
            return arrayList;
        }
    }

    private static class SymbolMembersProcessor
    implements Processor<OCSymbol> {
        private final String myName;
        private final Processor<OCSymbol> myProcessor;
        private final boolean myOnlySimpleNamespaces;
        private final boolean myOnlyTypes;
        private OCResolveContext myMemoization;
        private final THashSet<OCSymbol> myProcessed;

        public SymbolMembersProcessor(@Nullable String name, Processor<OCSymbol> processor2, boolean onlySimpleNamespaces, boolean onlyTypes, @NotNull OCResolveContext context) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/symbols/OCSymbolReference$SymbolMembersProcessor", "<init>"));
            }
            this.myName = name;
            this.myProcessor = processor2;
            this.myOnlySimpleNamespaces = onlySimpleNamespaces;
            this.myOnlyTypes = onlyTypes;
            this.myMemoization = context;
            this.myProcessed = new THashSet((TObjectHashingStrategy)new TObjectHashingStrategy<OCSymbol>(){

                public int computeHashCode(OCSymbol object) {
                    return object.hashCode();
                }

                public boolean equals(OCSymbol o1, OCSymbol o2) {
                    return o1 == o2;
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean process(OCSymbol symbol) {
            if (!this.myProcessed.add((Object)symbol)) {
                return true;
            }
            OCResolveContext oldMemoization = this.myMemoization;
            try {
                this.myMemoization = this.myMemoization.useFor(symbol);
                if (symbol instanceof OCNamespaceSymbol) {
                    boolean bl = OCStructType.processMembersOfNamespace((OCNamespaceSymbol)symbol, this.myName, !this.myOnlySimpleNamespaces, this.myOnlyTypes, this.myProcessor, this.myMemoization);
                    return bl;
                }
                if (symbol instanceof OCTypeParameterSymbol) {
                    if (!this.myProcessor.process((Object)new OCTypeParameterTypeSymbol(null, null, 0L, this.myName, null, Collections.<String>emptyList(), null, false))) {
                        boolean bl = false;
                        return bl;
                    }
                    if (!this.myProcessor.process((Object)new OCDeclaratorSymbol(null, null, 0, null, this.myName, Collections.<String>emptyList(), new OCMagicType(this.myName), OCSymbolKind.TEMPLATE_VALUE_PARAMETER))) {
                        boolean bl = false;
                        return bl;
                    }
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.myMemoization = oldMemoization;
            }
        }
    }

    public static class NameWithToken {
        public final String name;
        public final String typeToken;

        public NameWithToken(String name, String typeToken) {
            this.name = name;
            this.typeToken = typeToken;
        }
    }

    private static class ResultInfo {
        final List<OCSymbol> symbols;
        final boolean contextWasUsed;

        private ResultInfo(@NotNull List<OCSymbol> symbols, boolean contextWasUsed) {
            if (symbols == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbols", "com/jetbrains/cidr/lang/symbols/OCSymbolReference$ResultInfo", "<init>"));
            }
            this.symbols = symbols;
            this.contextWasUsed = contextWasUsed;
        }
    }

    private static class ReferenceInfo {
        final OCSymbolReference symbolReference;
        final OCTypeSubstitution substitution;
        final OCResolveContext context;

        private ReferenceInfo(@NotNull OCSymbolReference symbolReference, @NotNull OCTypeSubstitution substitution, @Nullable OCResolveContext context) {
            if (symbolReference == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbolReference", "com/jetbrains/cidr/lang/symbols/OCSymbolReference$ReferenceInfo", "<init>"));
            }
            if (substitution == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitution", "com/jetbrains/cidr/lang/symbols/OCSymbolReference$ReferenceInfo", "<init>"));
            }
            this.symbolReference = symbolReference;
            this.substitution = substitution;
            this.context = context;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ReferenceInfo)) {
                return false;
            }
            ReferenceInfo other = (ReferenceInfo)obj;
            return this.context != null && this.symbolReference.equals(other.symbolReference) && this.substitution.equals(other.substitution, this.context);
        }

        public int hashCode() {
            return this.symbolReference.hashCode() * 31 + this.substitution.hashCode();
        }
    }

    public static class TemplateParamsReference
    extends GlobalReference {
        public TemplateParamsReference() {
        }

        public TemplateParamsReference(@NotNull OCQualifiedName qualifiedName, @Nullable OCSymbolWithQualifiedName symbolContext, SymbolFilter filter) {
            if (qualifiedName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/jetbrains/cidr/lang/symbols/OCSymbolReference$TemplateParamsReference", "<init>"));
            }
            super(qualifiedName, symbolContext, filter);
        }

        @Override
        protected OCSymbolReference getSymbolReferenceToQualifier() {
            SymbolKindFilter filter = this.getFilterForQualifier();
            return new TemplateParamsReference(this.getQualifiedName().getQualifier(), this.getSymbolContext(), filter);
        }

        @Override
        protected OCSymbolReference applyTypeArguments(List<OCTypeArgument> arguments) {
            return new TemplateParamsReference(new OCQualifiedNameWithArguments(this.getQualifiedName(), arguments), this.getSymbolContext(), this.myFilter);
        }

        @Override
        public String toString() {
            return "TEMPLATE (" + this.getQualifiedName() + "):" + this.getSymbolContext();
        }
    }

    public static class BaseClauseReference
    extends GlobalReference {
        public BaseClauseReference() {
        }

        public BaseClauseReference(@NotNull OCQualifiedName qualifiedName, @Nullable OCSymbolWithQualifiedName symbolContext, SymbolFilter filter) {
            if (qualifiedName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/jetbrains/cidr/lang/symbols/OCSymbolReference$BaseClauseReference", "<init>"));
            }
            super(qualifiedName, symbolContext, filter);
        }

        @Override
        protected OCSymbolReference getSymbolReferenceToQualifier() {
            SymbolKindFilter filter = this.getFilterForQualifier();
            return new BaseClauseReference(this.getQualifiedName().getQualifier(), this.getSymbolContext(), filter);
        }

        @Override
        protected OCSymbolReference applyTypeArguments(List<OCTypeArgument> arguments) {
            return new BaseClauseReference(new OCQualifiedNameWithArguments(this.getQualifiedName(), arguments), this.getSymbolContext(), this.myFilter);
        }

        @Override
        public String toString() {
            return "BASE CLAUSE (" + this.getQualifiedName() + "):" + this.getSymbolContext();
        }
    }

    public static class LocalReference
    extends OCSymbolReference {
        @Nullable
        private PsiElement myLocalContext;

        private LocalReference(@NotNull OCQualifiedName qualifiedName, @Nullable PsiElement localContext, SymbolFilter filter) {
            if (qualifiedName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/jetbrains/cidr/lang/symbols/OCSymbolReference$LocalReference", "<init>"));
            }
            super(qualifiedName, filter);
            this.myLocalContext = localContext;
        }

        @Override
        protected Key getCacheDependency() {
            return PsiModificationTracker.MODIFICATION_COUNT;
        }

        @Nullable
        public PsiElement getLocalContext() {
            return this.myLocalContext;
        }

        @Override
        protected OCSymbolReference getSymbolReferenceToQualifier() {
            SymbolKindFilter filter = this.getFilterForQualifier();
            return new LocalReference(this.getQualifiedName().getQualifier(), this.myLocalContext, filter);
        }

        @Override
        protected OCSymbolReference applyTypeArguments(List<OCTypeArgument> arguments) {
            return new LocalReference(new OCQualifiedNameWithArguments(this.getQualifiedName(), arguments), this.myLocalContext, this.myFilter);
        }

        @Override
        public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull OCSymbolReference first, @NotNull OCSymbolReference second) {
            if (c == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/jetbrains/cidr/lang/symbols/OCSymbolReference$LocalReference", "deepEqualStep"));
            }
            if (first == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/jetbrains/cidr/lang/symbols/OCSymbolReference$LocalReference", "deepEqualStep"));
            }
            if (second == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "com/jetbrains/cidr/lang/symbols/OCSymbolReference$LocalReference", "deepEqualStep"));
            }
            if (!super.deepEqualStep(c, first, second)) {
                return false;
            }
            LocalReference f = (LocalReference)first;
            LocalReference s = (LocalReference)second;
            return Comparing.equal((Object)f.myLocalContext, (Object)s.myLocalContext);
        }

        @Override
        public int hashCode() {
            int result2 = super.hashCode();
            result2 = 31 * result2 + (this.myLocalContext != null ? this.myLocalContext.hashCode() : 0);
            return result2;
        }

        @Override
        @NotNull
        public List<OCSymbol> doResolve(@NotNull OCResolveContext context, boolean onlySimpleNamespaces, boolean onlyTypes, boolean resolveSpecialization) {
            OCSymbol thisSelfSuper;
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/symbols/OCSymbolReference$LocalReference", "doResolve"));
            }
            if (this.myLocalContext != null && (thisSelfSuper = OCThisSelfSuperSymbol.tryResolveThisSelfSuper(this.getQualifiedName().toString(), this.myLocalContext, context)) != null) {
                List<OCSymbol> list = Collections.singletonList(thisSelfSuper);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/OCSymbolReference$LocalReference", "doResolve"));
                }
                return list;
            }
            PsiElement oldElement = context.getElement();
            context.setElement(this.myLocalContext != null ? this.myLocalContext : oldElement);
            List<OCSymbol> symbols = super.doResolve(context, onlySimpleNamespaces, onlyTypes, resolveSpecialization);
            context.setElement(oldElement);
            List<OCSymbol> list = symbols;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/OCSymbolReference$LocalReference", "doResolve"));
            }
            return list;
        }

        public String toString() {
            return "LOCAL (" + this.getQualifiedName() + "):" + this.myLocalContext;
        }
    }

    public static class GlobalReference
    extends OCSymbolReference {
        @Nullable
        private OCSymbolWithQualifiedName mySymbolContext;

        public GlobalReference() {
        }

        public GlobalReference(@NotNull OCQualifiedName qualifiedName, @Nullable OCSymbolWithQualifiedName symbolContext, SymbolFilter filter) {
            if (qualifiedName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/jetbrains/cidr/lang/symbols/OCSymbolReference$GlobalReference", "<init>"));
            }
            super(qualifiedName, filter);
            if (symbolContext instanceof OCDeclaratorSymbol || symbolContext instanceof OCFunctionSymbol) {
                List<OCTypeParameterSymbol> templateParameters = symbolContext.getTemplateParameters();
                if (symbolContext.getQualifier() == null && templateParameters.isEmpty()) {
                    this.mySymbolContext = symbolContext.getParent();
                }
            }
            if (this.mySymbolContext == null) {
                this.mySymbolContext = symbolContext;
            }
        }

        @Nullable
        public OCSymbolWithQualifiedName getSymbolContext() {
            return this.mySymbolContext;
        }

        public void setSymbolContext(@Nullable OCSymbolWithQualifiedName symbolContext) {
            this.mySymbolContext = symbolContext;
        }

        @Override
        protected OCSymbolReference getSymbolReferenceToQualifier() {
            SymbolKindFilter filter = this.getFilterForQualifier();
            return new GlobalReference(this.getQualifiedName().getQualifier(), this.mySymbolContext, filter);
        }

        @Override
        protected OCSymbolReference applyTypeArguments(List<OCTypeArgument> arguments) {
            return new GlobalReference(new OCQualifiedNameWithArguments(this.getQualifiedName(), arguments), this.mySymbolContext, this.myFilter);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            GlobalReference that = (GlobalReference)o;
            return !(this.mySymbolContext != null ? !this.mySymbolContext.equals(that.mySymbolContext) : that.mySymbolContext != null);
        }

        @Override
        public int hashCode() {
            int result2 = super.hashCode();
            result2 = 31 * result2 + (this.mySymbolContext != null ? this.mySymbolContext.hashCode() : 0);
            return result2;
        }

        public String toString() {
            return "GLOBAL (" + this.getQualifiedName() + "):" + this.mySymbolContext;
        }

        @Override
        public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull OCSymbolReference first, @NotNull OCSymbolReference second) {
            if (c == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/jetbrains/cidr/lang/symbols/OCSymbolReference$GlobalReference", "deepEqualStep"));
            }
            if (first == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/jetbrains/cidr/lang/symbols/OCSymbolReference$GlobalReference", "deepEqualStep"));
            }
            if (second == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "com/jetbrains/cidr/lang/symbols/OCSymbolReference$GlobalReference", "deepEqualStep"));
            }
            if (!super.deepEqualStep(c, first, second)) {
                return false;
            }
            GlobalReference f = (GlobalReference)first;
            GlobalReference s = (GlobalReference)second;
            return c.equalObjects(f.mySymbolContext, s.mySymbolContext);
        }
    }

    private static class SymbolFilterComposition
    implements SymbolFilter {
        @NotNull
        private final SymbolFilter myFilter1;
        @NotNull
        private final SymbolFilter myFilter2;

        public SymbolFilterComposition(@NotNull SymbolFilter filter1, @NotNull SymbolFilter filter2) {
            if (filter1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter1", "com/jetbrains/cidr/lang/symbols/OCSymbolReference$SymbolFilterComposition", "<init>"));
            }
            if (filter2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter2", "com/jetbrains/cidr/lang/symbols/OCSymbolReference$SymbolFilterComposition", "<init>"));
            }
            this.myFilter1 = filter1;
            this.myFilter2 = filter2;
        }

        @Override
        public boolean accept(OCSymbol symbol) {
            return this.myFilter1.accept(symbol) && this.myFilter2.accept(symbol);
        }

        public String toString() {
            return "(" + this.myFilter1 + ") && (" + this.myFilter2 + ")";
        }
    }

    public static enum SymbolKindFilter implements SymbolFilter
    {
        NONE,
        ONLY_NAMESPACE,
        ONLY_NAMESPACE_LIKE,
        ONLY_STRUCT,
        ONLY_ENUM,
        ONLY_UNION;


        public static SymbolFilter parse(String name) {
            if (name == null) {
                return NONE;
            }
            if (name.equals("struct") || name.equals("class")) {
                return ONLY_STRUCT;
            }
            if (name.equals("enum")) {
                return ONLY_ENUM;
            }
            if (name.equals("union")) {
                return ONLY_UNION;
            }
            return NONE;
        }

        @Override
        public boolean accept(OCSymbol symbol) {
            OCSymbolKind kind = symbol.getKind();
            switch (this) {
                case NONE: {
                    return true;
                }
                case ONLY_NAMESPACE: {
                    return kind == OCSymbolKind.NAMESPACE || kind == OCSymbolKind.NAMESPACE_ALIAS;
                }
                case ONLY_NAMESPACE_LIKE: {
                    return kind.canBeNamespace() || kind == OCSymbolKind.USING_SYMBOL_ALIAS || kind == OCSymbolKind.SYMBOL_USING_SYMBOL;
                }
                case ONLY_STRUCT: {
                    return kind == OCSymbolKind.STRUCT;
                }
                case ONLY_ENUM: {
                    return kind == OCSymbolKind.ENUM;
                }
                case ONLY_UNION: {
                    return kind == OCSymbolKind.UNION;
                }
            }
            return false;
        }

        public String toString() {
            return super.toString().toLowerCase();
        }
    }

    public static class TrueSymbolFilter
    implements SymbolFilter {
        @Override
        public boolean accept(OCSymbol symbol) {
            return true;
        }

        public String toString() {
            return "*any symbol*";
        }
    }

    public static interface SymbolFilter {
        public static final TrueSymbolFilter NONE = new TrueSymbolFilter();

        public boolean accept(OCSymbol var1);
    }
}

