/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.FilteringProcessor;
import com.intellij.util.Processor;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolderVirtualPsiElement;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerHelper;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCSymbolImpl<T extends PsiElement>
implements OCSymbol<T> {
    private static final String ATTRIBUTE_FORBIDDEN_BY_ARC_MESSAGE = "\"not available in automatic reference counting mode\"";
    @Nullable
    protected transient Project myProject;
    @Nullable
    protected transient VirtualFile myFile;
    protected long myComplexOffset;
    @NotNull
    protected String myName;
    @NotNull
    private volatile List<String> myAttributes;

    /*
     * WARNING - void declaration
     */
    public OCSymbolImpl(@Nullable Project project, @Nullable VirtualFile file2, long complexOffset, @Nullable String name, @NotNull List<String> list) {
        void attributes;
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/jetbrains/cidr/lang/symbols/OCSymbolImpl", "<init>"));
        }
        this.myProject = project;
        this.myFile = file2;
        this.myComplexOffset = complexOffset;
        this.myName = name == null ? "<unnamed>" : name;
        this.myAttributes = attributes;
    }

    public OCSymbolImpl() {
    }

    @Nullable
    public static PsiElement locateDefinition(@Nullable OCSymbol symbol) {
        return symbol != null ? (PsiElement)symbol.locateDefinition() : null;
    }

    public static List<PsiElement> locateDefinitions(List<? extends OCSymbol> symbols) {
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>(symbols.size());
        for (OCSymbol oCSymbol : symbols) {
            Object element = oCSymbol.locateDefinition();
            if (element == null) continue;
            result2.add((PsiElement)element);
        }
        return result2;
    }

    @NotNull
    public static String getSymbolName(@Nullable OCSymbol symbol) {
        String string = symbol == null ? "<unnamed>" : symbol.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/OCSymbolImpl", "getSymbolName"));
        }
        return string;
    }

    @NotNull
    public static String getTagOfStructLike(OCSymbol symbol) {
        String kind = symbol.getKind().getNameLowercase() + " ";
        String name = symbol.getPresentableName();
        if (name.startsWith(kind)) {
            String string = name.substring(kind.length());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/OCSymbolImpl", "getTagOfStructLike"));
            }
            return string;
        }
        String string = name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/OCSymbolImpl", "getTagOfStructLike"));
        }
        return string;
    }

    @Nullable
    public static <T extends OCSymbol> T findSymbolDefinition(String name, OCSymbolKind symbolKind, Project project, VirtualFile context) {
        return OCSymbolImpl.findSymbolDefinition(name, symbolKind, project, context, null);
    }

    @Nullable
    public static <T extends OCSymbol> T findSymbolDefinition(String name, final OCSymbolKind symbolKind, Project project, VirtualFile context, final @Nullable Condition<T> condition) {
        return (T)OCGlobalProjectSymbolsCache.findNearestTopLevelSymbol(project, name, new Condition<OCSymbol>(){

            public boolean value(OCSymbol symbol) {
                return symbol.getKind() == symbolKind && !symbol.isPredeclaration() && (condition == null || condition.value((Object)symbol));
            }
        }, context);
    }

    @Override
    public void init(@Nullable Project project, @Nullable VirtualFile file2) {
        this.myProject = project;
        this.myFile = file2;
    }

    @Override
    @NotNull
    public OCType getType() {
        OCUnknownType oCUnknownType = OCUnknownType.INSTANCE;
        if (oCUnknownType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/OCSymbolImpl", "getType"));
        }
        return oCUnknownType;
    }

    @Override
    @NotNull
    public OCType getResolvedType() {
        OCType oCType = this.getType().resolve(this.getContainingOCFile());
        if (oCType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/OCSymbolImpl", "getResolvedType"));
        }
        return oCType;
    }

    @Override
    public OCType getResolvedType(boolean ignoringImports) {
        return this.getType().resolve(this.getContainingOCFile(), ignoringImports);
    }

    @Override
    public boolean isGlobal() {
        return false;
    }

    @Override
    public boolean isTopLevel() {
        return this.isGlobal();
    }

    @Override
    public boolean isCallable() {
        return this.getKind().isCallable();
    }

    @Override
    public boolean isDefinition() {
        return !this.isPredeclaration();
    }

    @Override
    public boolean isPredeclaration() {
        return this.getKind().isPredeclaration();
    }

    @Override
    @NotNull
    public List<String> getAttributes() {
        List<String> list = this.myAttributes;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/OCSymbolImpl", "getAttributes"));
        }
        return list;
    }

    @Override
    public void addAttributes(List<String> attributes) {
        if (this.myAttributes.isEmpty()) {
            this.myAttributes = attributes;
        } else {
            ArrayList<String> newAttributes = new ArrayList<String>(this.myAttributes.size() + attributes.size());
            newAttributes.addAll(this.myAttributes);
            newAttributes.addAll(attributes);
            this.myAttributes = newAttributes;
        }
    }

    @Override
    public boolean isUnnamed() {
        return "<unnamed>".equals(this.myName);
    }

    protected Class<? extends T> getPsiElementClass() {
        return this.getKind().getPsiElementClass();
    }

    @Override
    public Object getData(@NonNls String dataId) {
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            return new OCSymbolHolderVirtualPsiElement(this);
        }
        return null;
    }

    @Override
    @Nullable
    public T locateDefinition() {
        Class<T> elementClass = this.getPsiElementClass();
        if (this.myFile == null || this.myProject == null || !this.myFile.isValid()) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(this.myFile);
        if (psiFile == null) {
            return null;
        }
        PsiElement cur = psiFile.findElementAt(this.getOffset());
        if (cur == null) {
            return null;
        }
        cur = PsiTreeUtil.getDeepestLast((PsiElement)cur);
        while (cur != null) {
            long symbolComplexOffset;
            long curComplexOffset = OCSymbolOffsetUtil.getComplexOffset(cur);
            if (curComplexOffset == (symbolComplexOffset = this.getComplexOffset())) {
                if (this.isUnnamed()) {
                    cur = PsiTreeUtil.prevLeaf((PsiElement)cur);
                }
                PsiElement parent = cur;
                do {
                    if (!elementClass.isInstance(parent) || OCSymbolOffsetUtil.getVirtualComplexOffset(parent) != symbolComplexOffset) continue;
                    return (T)parent;
                } while ((parent = PsiTreeUtil.getParentOfType((PsiElement)parent, elementClass, (boolean)true)) != null);
                return null;
            }
            if (OCSymbolOffsetUtil.getTextOffset(curComplexOffset) != OCSymbolOffsetUtil.getTextOffset(symbolComplexOffset)) {
                return null;
            }
            cur = PsiTreeUtil.prevLeaf((PsiElement)cur);
        }
        return null;
    }

    @Override
    public void updateOffset(int start, int end, int lengthShift) {
        if (this.getOffset() > start) {
            this.myComplexOffset += (long)lengthShift;
        }
    }

    @Override
    public void compact() {
        this.myAttributes = ContainerUtil.trimToSize(this.myAttributes);
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/OCSymbolImpl", "getName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getSignature() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/OCSymbolImpl", "getSignature"));
        }
        return string;
    }

    @Override
    @Nullable
    public TextRange getScope() {
        return null;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/OCSymbolImpl", "getPresentableName"));
        }
        return string;
    }

    @Override
    @Nullable
    public String getLocationString() {
        return this.myFile == null ? null : this.myFile.getName();
    }

    @Override
    public boolean isSynthetic() {
        return this.myProject == null;
    }

    public String toString() {
        return (Object)((Object)this.getKind()) + "[" + this.getName() + "]@" + this.getOffset();
    }

    @Override
    @NotNull
    public abstract OCSymbolKind getKind();

    @Override
    @NotNull
    public String getNameWithKindLowercase() {
        String string = this.getKindLowercase() + " '" + this.getPresentableName() + "'";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/OCSymbolImpl", "getNameWithKindLowercase"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getNameWithKindUppercase() {
        String string = this.getKindUppercase() + " '" + this.getPresentableName() + "'";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/OCSymbolImpl", "getNameWithKindUppercase"));
        }
        return string;
    }

    @Override
    public String getKindLowercase() {
        return StringUtil.decapitalize((String)this.getKindUppercase());
    }

    @Override
    public String getKindUppercase() {
        return this.getKind().getNameUppercase();
    }

    @Override
    @Nullable
    public OCSymbol getDefinitionSymbol() {
        if (this.isPredeclaration()) {
            return OCSymbolImpl.findSymbolDefinition(this.myName, this.getKind(), this.myProject, this.myFile);
        }
        return this;
    }

    @Override
    public boolean processAssociatedSymbols(Processor<OCSymbol> processor2) {
        OCSymbol associatedSymbol = this.getAssociatedSymbol();
        return associatedSymbol == null || processor2.process((Object)associatedSymbol);
    }

    @Override
    @Nullable
    public OCSymbol getAssociatedSymbol() {
        return null;
    }

    @Override
    public OCSymbol getFirstPredeclaration() {
        CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
        this.processPredeclarations((Processor<OCSymbol>)finder);
        return (OCSymbol)finder.getFoundValue();
    }

    @Override
    public boolean processPredeclarations(Processor<OCSymbol> processor2) {
        return this.processSameSymbols((Processor<OCSymbol>)new FilteringProcessor(PREDIFINITION_CONDITION, processor2));
    }

    @Override
    public boolean processSameSymbols(final Processor<OCSymbol> processor2) {
        return OCGlobalProjectSymbolsCache.processTopLevelSymbols(this.myProject, new Processor<OCSymbol>(){

            public boolean process(OCSymbol symbol) {
                return symbol.getClass() != OCSymbolImpl.this.getClass() || processor2.process((Object)symbol);
            }
        }, this.myName);
    }

    @Override
    @Nullable
    public VirtualFile getContainingFile() {
        return this.myFile;
    }

    @Override
    @Nullable
    public PsiFile getContainingPsiFile() {
        VirtualFile containingFile = this.getContainingFile();
        Project project = this.getProject();
        if (project != null && containingFile != null && containingFile.isValid()) {
            return PsiManager.getInstance((Project)project).findFile(containingFile);
        }
        return null;
    }

    @Override
    @Nullable
    public OCFile getContainingOCFile() {
        PsiFile file2 = this.getContainingPsiFile();
        return file2 instanceof OCFile ? (OCFile)file2 : null;
    }

    @Override
    public int getOffset() {
        return OCSymbolOffsetUtil.getTextOffset(this.myComplexOffset);
    }

    @Override
    public long getComplexOffset() {
        return this.myComplexOffset;
    }

    @Deprecated
    public PsiElement getTargetElement() {
        return new OCSymbolHolderVirtualPsiElement(this);
    }

    @Override
    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    public void navigate(boolean requestFocus) {
        PsiNavigateUtil.navigate(this.locateDefinition());
    }

    public boolean canNavigate() {
        return this.locateDefinition() != null;
    }

    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return this.computeFullIcon(null);
    }

    @Override
    @Nullable
    public Icon getBaseIcon() {
        return this.getKind().getIcon();
    }

    @Override
    @Nullable
    public Icon computeFullIcon(@Nullable T symbolElement) {
        return this.getBaseIcon();
    }

    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            public String getPresentableText() {
                return OCSymbolImpl.this.getPresentableName();
            }

            public String getLocationString() {
                return OCSymbolImpl.this.getLocationString();
            }

            public Icon getIcon(boolean open2) {
                return OCSymbolImpl.this.getIcon();
            }
        };
    }

    @Override
    public boolean isSameSymbol(@Nullable OCSymbol symbol) {
        return this.equals(symbol);
    }

    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/jetbrains/cidr/lang/symbols/OCSymbolImpl", "deepEqualStep"));
        }
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/jetbrains/cidr/lang/symbols/OCSymbolImpl", "deepEqualStep"));
        }
        if (second == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "com/jetbrains/cidr/lang/symbols/OCSymbolImpl", "deepEqualStep"));
        }
        OCSymbolImpl f = (OCSymbolImpl)first;
        OCSymbolImpl s = (OCSymbolImpl)second;
        if (f.myComplexOffset != s.myComplexOffset) {
            return false;
        }
        if (!f.myName.equals(s.myName)) {
            return false;
        }
        if (!Comparing.equal((Object)f.myFile, (Object)s.myFile)) {
            return false;
        }
        if (!Comparing.equal((Object)f.myProject, (Object)s.myProject)) {
            return false;
        }
        return f.myAttributes.equals(s.myAttributes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OCSymbolImpl symbol = (OCSymbolImpl)o;
        if (this.myComplexOffset != symbol.myComplexOffset) {
            return false;
        }
        if (!this.myAttributes.equals(symbol.myAttributes)) {
            return false;
        }
        VirtualFile file2 = this.myFile;
        if (file2 != null ? !file2.equals(symbol.myFile) : symbol.myFile != null) {
            return false;
        }
        if (!this.myName.equals(symbol.myName)) {
            return false;
        }
        Project project = this.myProject;
        return !(project != null ? !project.equals(symbol.myProject) : symbol.myProject != null);
    }

    public int hashCode() {
        int result2 = this.hashCodeExcludingOffset();
        result2 = 31 * result2 + this.getOffset();
        return result2;
    }

    @Override
    public int hashCodeExcludingOffset() {
        int result2 = this.myProject != null ? this.myProject.hashCode() : 0;
        result2 = 31 * result2 + OCSymbolOffsetUtil.getSubstOffset(this.myComplexOffset);
        result2 = 31 * result2 + (this.myFile != null ? this.myFile.hashCode() : 0);
        result2 = 31 * result2 + (this.myName != null ? this.myName.hashCode() : 0);
        result2 = 31 * result2 + (this.myAttributes != null ? this.myAttributes.hashCode() : 0);
        return result2;
    }

    @Override
    public int compareTo(OCSymbol symbol) {
        return this.getPresentableName().compareTo(symbol.getPresentableName());
    }

    @Override
    public OCType getEffectiveType() {
        return this.getType();
    }

    @Override
    @NotNull
    public OCType getEffectiveResolvedType() {
        OCType oCType = this.getResolvedType();
        if (oCType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/OCSymbolImpl", "getEffectiveResolvedType"));
        }
        return oCType;
    }

    @Override
    public boolean isDeprecated() {
        return this.hasAttribute("deprecated");
    }

    @Override
    public String getDeprecatedMessage() {
        String message = this.getNameWithKindUppercase() + " is deprecated";
        String parameters = this.getAttributeParameters("deprecated");
        return parameters != null ? message + ": " + StringUtil.unquoteString((String)parameters) : message;
    }

    @Override
    public boolean isUnavailable() {
        return this.hasAttribute("unavailable") && !ATTRIBUTE_FORBIDDEN_BY_ARC_MESSAGE.equals(this.getAttributeParameters("unavailable"));
    }

    @Override
    public String getUnavailableMessage() {
        String message = this.getNameWithKindUppercase() + " is unavailable";
        String parameters = this.getAttributeParameters("unavailable");
        return parameters != null ? message + ": " + StringUtil.unquoteString((String)parameters) : message;
    }

    @Override
    public boolean isForbiddenByARC(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/symbols/OCSymbolImpl", "isForbiddenByARC"));
        }
        return this.hasAttribute("unavailable") && ATTRIBUTE_FORBIDDEN_BY_ARC_MESSAGE.equals(this.getAttributeParameters("unavailable")) && OCCompilerHelper.isArcEnabled(context.getContainingFile());
    }

    @Override
    public boolean isTransparentUnion() {
        return this.hasAttribute("transparent_union");
    }

    @Override
    public boolean hasAttribute(String attribute) {
        List<String> attributes = this.getAttributes();
        return attributes.contains(attribute) || attributes.contains("__" + attribute + "__");
    }

    @Override
    @Nullable
    public String getAttributeParameters(String attribute) {
        List<String> attributes = this.getAttributes();
        for (String curAttribute : attributes) {
            if (!curAttribute.startsWith(attribute + '#')) continue;
            return curAttribute.substring(attribute.length() + 1);
        }
        return null;
    }
}

