/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithSubstitution;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCResolveContext
extends UserDataHolderBase {
    @Nullable
    private PsiElement myElement;
    @NotNull
    private final OCTypeSubstitution mySubstitution;
    @NotNull
    private final Set<Pair<OCSymbolReference, OCTypeSubstitution>> myResolving;
    private final HashMap<OCFunctionSymbol, OCStructSymbol> myOperatorParentsCache;
    private final Set<OCType> myResolvingTypes;
    @Nullable
    private OCResolveContext myOriginalContext;
    public int myInsideUsingNamespaceCounter;
    private Ref<Integer> myTypeResolveCounter;
    private Stack<Integer> myUsingNamespaceIndex;
    private boolean myWasCollision;
    private boolean myWasDependentType;
    private boolean myProcessNonImported;
    private boolean myOriginallyProcessNonImported;
    private boolean myContextWasUsed;
    private boolean myInSFINAE;

    public OCResolveContext() {
        this((PsiElement)null, (OCTypeSubstitution)OCTypeSubstitution.ID);
    }

    public OCResolveContext(@Nullable PsiElement element) {
        this(element, (OCTypeSubstitution)OCTypeSubstitution.ID);
    }

    private OCResolveContext(@NotNull OCResolveContext origin, @NotNull OCTypeSubstitution substitution) {
        if (origin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "origin", "com/jetbrains/cidr/lang/symbols/OCResolveContext", "<init>"));
        }
        if (substitution == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitution", "com/jetbrains/cidr/lang/symbols/OCResolveContext", "<init>"));
        }
        this.myInsideUsingNamespaceCounter = 0;
        this.myTypeResolveCounter = Ref.create((Object)0);
        this.myUsingNamespaceIndex = new Stack();
        this.myOriginalContext = origin;
        this.myElement = origin.myElement;
        this.mySubstitution = substitution;
        this.myResolving = origin.myResolving;
        this.myResolvingTypes = origin.myResolvingTypes;
        this.myOperatorParentsCache = origin.myOperatorParentsCache;
        this.myUsingNamespaceIndex = origin.myUsingNamespaceIndex;
        this.myTypeResolveCounter = origin.myTypeResolveCounter;
    }

    public OCResolveContext(@Nullable PsiElement element, @NotNull OCTypeSubstitution subst) {
        if (subst == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subst", "com/jetbrains/cidr/lang/symbols/OCResolveContext", "<init>"));
        }
        this.myInsideUsingNamespaceCounter = 0;
        this.myTypeResolveCounter = Ref.create((Object)0);
        this.myUsingNamespaceIndex = new Stack();
        this.myUsingNamespaceIndex.push(Integer.MAX_VALUE);
        this.myElement = element;
        this.mySubstitution = subst;
        this.myResolving = OCTypeUtils.newReferenceWithSubstitutionSet();
        this.myResolvingTypes = OCTypeUtils.newTypeSet();
        this.myOperatorParentsCache = new HashMap();
        this.myWasCollision = false;
    }

    public String toString() {
        String element;
        if (this.myElement instanceof OCFile) {
            OCFile file2 = (OCFile)this.myElement;
            element = "file " + file2.getName();
        } else {
            element = this.myElement != null ? "element " + this.myElement.getClass().getSimpleName() + ": " + this.myElement.getText() : "<null>";
        }
        return "OCResolveContext(" + element + ")";
    }

    public List<OCSymbol> doResolveToSymbols(OCSymbolReference reference, boolean onlySimpleNamespaces, boolean onlyTypes) {
        Pair pair = Pair.create((Object)reference, (Object)this.mySubstitution.getMinimalDependentSubstitution(reference, this));
        if (this.myResolving.contains(pair)) {
            this.setWasCollision(true);
            return Collections.emptyList();
        }
        this.myResolving.add((Pair<OCSymbolReference, OCTypeSubstitution>)pair);
        List<OCSymbol> result2 = reference.resolveToSymbols(this, onlySimpleNamespaces, onlyTypes, true);
        this.myResolving.remove(pair);
        return result2;
    }

    public List<OCSymbol> resolveToSymbols(OCSymbolReference reference) {
        return this.resolveToSymbols(reference, false, false);
    }

    public List<OCSymbol> resolveToSymbols(OCSymbolReference reference, boolean processTypedefs, boolean onlyTypes) {
        return this.resolveToSymbols(reference, processTypedefs, true, false, onlyTypes);
    }

    public List<OCSymbol> resolveToSymbols(OCSymbolReference reference, boolean processTypedefs, boolean processTypeParameters, boolean onlySimpleNamespaces, boolean onlyTypes) {
        List<OCSymbol> symbols = this.doResolveToSymbols(reference, onlySimpleNamespaces, onlyTypes);
        return OCSymbolReference.lookupUsingsAndTypedefs(processTypedefs, onlyTypes, this, symbols, reference, processTypeParameters);
    }

    public Set<OCType> getResolvingTypes() {
        return this.myResolvingTypes;
    }

    @Nullable
    public OCStructSymbol getNonMemberOperatorParent(OCSymbol operator) {
        if (operator instanceof OCFunctionSymbol) {
            OCFunctionSymbol function = (OCFunctionSymbol)operator;
            List<OCDeclaratorSymbol> params = function.getParameterSymbols();
            if (function.isCppNonMemberOperator(this)) {
                if (this.myOperatorParentsCache.containsKey(function)) {
                    return this.myOperatorParentsCache.get(function);
                }
                OCStructSymbol result2 = null;
                boolean wasUnknown = false;
                this.myOperatorParentsCache.put(function, null);
                for (int i = 0; i < params.size(); ++i) {
                    OCDeclaratorSymbol parameter = operator.getName().equals("operator<<") ? params.get(params.size() - i - 1) : params.get(i);
                    OCType paramType = parameter.getType().resolve(this).getTerminalType();
                    if (paramType instanceof OCStructType) {
                        result2 = ((OCStructType)paramType).getSymbol();
                        break;
                    }
                    if (!(paramType instanceof OCUnknownType)) continue;
                    wasUnknown = true;
                }
                if (result2 == null && wasUnknown) {
                    this.myOperatorParentsCache.remove(function);
                } else {
                    this.myOperatorParentsCache.put(function, result2);
                }
                return result2;
            }
        }
        return null;
    }

    @Nullable
    public PsiFile getFile() {
        if (this.myElement == null || !this.myElement.isValid()) {
            return null;
        }
        PsiFile file2 = this.myElement.getContainingFile();
        while (file2 instanceof OCCodeFragment) {
            PsiElement context = file2.getContext();
            if (context == null) {
                return file2;
            }
            file2 = context.getContainingFile();
        }
        return file2;
    }

    @Nullable
    public PsiElement getElement() {
        return this.myElement != null && this.myElement.isValid() ? this.myElement : null;
    }

    @Nullable
    public Project getProject() {
        return this.myElement != null ? this.myElement.getProject() : null;
    }

    public void setElement(@Nullable PsiElement element) {
        this.myElement = element;
    }

    @NotNull
    public OCTypeSubstitution getSubstitution() {
        OCTypeSubstitution oCTypeSubstitution = this.mySubstitution;
        if (oCTypeSubstitution == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/OCResolveContext", "getSubstitution"));
        }
        return oCTypeSubstitution;
    }

    @NotNull
    public OCResolveContext substitute(OCTypeSubstitution substitution) {
        if (substitution != OCTypeSubstitution.ID) {
            OCResolveContext result2 = new OCResolveContext(this, OCTypeSubstitution.compose(this.mySubstitution, substitution, false, this));
            result2.setProcessNonImported(this.myProcessNonImported);
            OCResolveContext oCResolveContext = result2;
            if (oCResolveContext == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/OCResolveContext", "substitute"));
            }
            return oCResolveContext;
        }
        OCResolveContext oCResolveContext = this;
        if (oCResolveContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/OCResolveContext", "substitute"));
        }
        return oCResolveContext;
    }

    public OCResolveContext substituteFirst(OCTypeSubstitution substitution) {
        if (substitution != OCTypeSubstitution.ID) {
            OCResolveContext result2 = new OCResolveContext(this, OCTypeSubstitution.compose(substitution, this.mySubstitution, false, this));
            result2.setProcessNonImported(this.myProcessNonImported);
            return result2;
        }
        return this;
    }

    @NotNull
    public OCResolveContext useFor(OCSymbol symbol) {
        OCTypeSubstitution substitution = symbol instanceof OCSymbolWithSubstitution ? OCTypeSubstitution.compose(this.mySubstitution, ((OCSymbolWithSubstitution)((Object)symbol)).getSubstitution(), false, this) : this.mySubstitution;
        if ((substitution = substitution.getMinimalDependentSubstitution(symbol, this)) != OCTypeSubstitution.ID) {
            OCResolveContext result2 = new OCResolveContext(this, substitution);
            result2.setProcessNonImported(this.myProcessNonImported);
            OCResolveContext oCResolveContext = result2;
            if (oCResolveContext == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/OCResolveContext", "useFor"));
            }
            return oCResolveContext;
        }
        OCResolveContext oCResolveContext = this;
        if (oCResolveContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/OCResolveContext", "useFor"));
        }
        return oCResolveContext;
    }

    public void startResolvingNamespaceUsing(int usingIndex) {
        ++this.myInsideUsingNamespaceCounter;
        if (usingIndex >= 0) {
            this.myUsingNamespaceIndex.push(Math.min(usingIndex, this.myUsingNamespaceIndex.peek()));
        } else {
            this.myUsingNamespaceIndex.push(this.myUsingNamespaceIndex.peek());
        }
    }

    public void stopResolvingNamespaceUsing() {
        --this.myInsideUsingNamespaceCounter;
        this.myUsingNamespaceIndex.pop();
    }

    public int getCurrentUsingIndex() {
        return this.myUsingNamespaceIndex.peek();
    }

    public boolean isProcessNonImported() {
        return this.myProcessNonImported || this.myOriginalContext != null && this.myOriginalContext.isProcessNonImported();
    }

    public boolean isInSFINAE() {
        return this.myInSFINAE || this.myOriginalContext != null && this.myOriginalContext.isInSFINAE();
    }

    public boolean isOriginallyProcessNonImported() {
        return this.myOriginallyProcessNonImported || this.myOriginalContext != null && this.myOriginalContext.isOriginallyProcessNonImported();
    }

    public boolean wasContextUsed() {
        return this.myContextWasUsed || this.myOriginalContext != null && this.myOriginalContext.wasContextUsed();
    }

    public boolean wasCollision() {
        return this.myWasCollision || this.myOriginalContext != null && this.myOriginalContext.wasCollision();
    }

    public boolean wasDependentType() {
        return this.myWasDependentType || this.myOriginalContext != null && this.myOriginalContext.wasDependentType();
    }

    public int getTypeResolveCounter() {
        return (Integer)this.myTypeResolveCounter.get();
    }

    public void incTypeResolveCounter() {
        this.myTypeResolveCounter.set((Object)((Integer)this.myTypeResolveCounter.get() + 1));
    }

    public void setProcessNonImported(boolean processNonImported) {
        this.myProcessNonImported = processNonImported;
        if (this.myProcessNonImported) {
            this.myOriginallyProcessNonImported = true;
        }
        if (this.myOriginalContext != null) {
            this.myOriginalContext.setProcessNonImported(processNonImported);
        }
    }

    public void setInSFINAE(boolean inSFINAE) {
        this.myInSFINAE = inSFINAE;
        if (this.myOriginalContext != null) {
            this.myOriginalContext.setInSFINAE(inSFINAE);
        }
    }

    public void setContextWasUsed(boolean contextWasUsed) {
        this.myContextWasUsed = contextWasUsed;
        if (this.myOriginalContext != null) {
            this.myOriginalContext.setContextWasUsed(contextWasUsed);
        }
    }

    public void setWasCollision(boolean wasCollision) {
        this.myWasCollision = wasCollision;
        if (this.myOriginalContext != null) {
            this.myOriginalContext.setWasCollision(wasCollision);
        }
    }

    public void setWasDependentType(boolean wasDependentType) {
        this.myWasDependentType = wasDependentType;
        if (this.myOriginalContext != null) {
            this.myOriginalContext.setWasDependentType(wasDependentType);
        }
    }

    public static boolean setNonImportedFlag(@NotNull OCResolveContext context, boolean value) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/symbols/OCResolveContext", "setNonImportedFlag"));
        }
        boolean result2 = context.isProcessNonImported();
        context.setProcessNonImported(value);
        return result2;
    }

    public static boolean setInSFINAEFlag(@NotNull OCResolveContext context, boolean value) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/symbols/OCResolveContext", "setInSFINAEFlag"));
        }
        boolean result2 = context.isInSFINAE();
        context.setInSFINAE(value);
        return result2;
    }
}

