/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.StringBuilderSpinAllocator;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCQualifiedNameWithArguments
extends OCQualifiedName {
    @NotNull
    private List<OCTypeArgument> myArguments;

    public OCQualifiedNameWithArguments(@Nullable OCQualifiedName qualifier, @Nullable String name, @NotNull List<OCTypeArgument> arguments) {
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/jetbrains/cidr/lang/symbols/OCQualifiedNameWithArguments", "<init>"));
        }
        this.myQualifier = qualifier;
        this.myName = name;
        this.myArguments = arguments;
    }

    public OCQualifiedNameWithArguments() {
    }

    public OCQualifiedNameWithArguments(@NotNull OCQualifiedName qualifiedName, @NotNull List<OCTypeArgument> arguments) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/jetbrains/cidr/lang/symbols/OCQualifiedNameWithArguments", "<init>"));
        }
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/jetbrains/cidr/lang/symbols/OCQualifiedNameWithArguments", "<init>"));
        }
        this(qualifiedName.getQualifier(), qualifiedName.getName(), arguments);
    }

    @NotNull
    public List<OCTypeArgument> getArguments() {
        List<OCTypeArgument> list = this.myArguments;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/OCQualifiedNameWithArguments", "getArguments"));
        }
        return list;
    }

    @Override
    public OCQualifiedName dropArguments() {
        return OCQualifiedName.with(this.myQualifier, this.myName);
    }

    @Override
    @NotNull
    public OCQualifiedName changeQualifier(@Nullable OCQualifiedName qualifier) {
        OCQualifiedNameWithArguments oCQualifiedNameWithArguments = new OCQualifiedNameWithArguments(qualifier, this.myName, this.myArguments);
        if (oCQualifiedNameWithArguments == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/OCQualifiedNameWithArguments", "changeQualifier"));
        }
        return oCQualifiedNameWithArguments;
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + this.myArguments.hashCode();
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull OCQualifiedName first, @NotNull OCQualifiedName second) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/jetbrains/cidr/lang/symbols/OCQualifiedNameWithArguments", "deepEqualStep"));
        }
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/jetbrains/cidr/lang/symbols/OCQualifiedNameWithArguments", "deepEqualStep"));
        }
        if (second == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "com/jetbrains/cidr/lang/symbols/OCQualifiedNameWithArguments", "deepEqualStep"));
        }
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCQualifiedNameWithArguments f = (OCQualifiedNameWithArguments)first;
        OCQualifiedNameWithArguments s = (OCQualifiedNameWithArguments)second;
        return c.equalIterable(f.myArguments, s.myArguments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCanonicalName(final @NotNull OCType.Presentation presentation, final boolean includeGlobalQualifier, final @NotNull OCResolveContext context, final int templateDepth) {
        String result2;
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/jetbrains/cidr/lang/symbols/OCQualifiedNameWithArguments", "getCanonicalName"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/symbols/OCQualifiedNameWithArguments", "getCanonicalName"));
        }
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        try {
            builder.append(super.getCanonicalName(presentation, includeGlobalQualifier, context, templateDepth));
            builder.append('<');
            if (templateDepth < 10) {
                String args = StringUtil.join(this.myArguments, (Function)new Function<OCTypeArgument, String>(){

                    public String fun(OCTypeArgument argument) {
                        return argument.getNameForPresentation(presentation, context, includeGlobalQualifier, templateDepth + 1);
                    }
                }, (String)", ");
                if (args.startsWith("::")) {
                    builder.append(" ");
                }
                builder.append(args);
            } else {
                builder.append("...");
            }
            builder.append('>');
            result2 = builder.toString();
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)builder);
        }
        return result2;
    }
}

