/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.openapi.util.Comparing;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.symtable.OCNamesInternary;
import com.jetbrains.cidr.lang.types.OCType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCQualifiedName
implements Serializable,
DeepEqual.Equality<OCQualifiedName> {
    @NotNull
    private static final String GLOBAL_NAME = "";
    @NotNull
    public static final OCQualifiedName GLOBAL = new OCQualifiedName(null, "");
    @Nullable
    protected OCQualifiedName myQualifier;
    @Nullable
    protected String myName;

    protected OCQualifiedName() {
    }

    private OCQualifiedName(@Nullable OCQualifiedName qualifier, @Nullable String name) {
        this.myQualifier = qualifier;
        this.myName = name;
    }

    public static OCQualifiedName interned(@Nullable OCQualifiedName qualifier, @Nullable String name) {
        OCQualifiedName result2 = OCQualifiedName.with(qualifier, name);
        return result2 == GLOBAL ? result2 : OCNamesInternary.intern(result2);
    }

    public static OCQualifiedName with(@Nullable OCQualifiedName qualifier, @Nullable String name) {
        if (qualifier == null && GLOBAL_NAME.equals(name)) {
            return GLOBAL;
        }
        return new OCQualifiedName(qualifier, name);
    }

    public static OCQualifiedName interned(@Nullable String name) {
        return OCQualifiedName.interned(null, name);
    }

    public static OCQualifiedName with(@Nullable String name) {
        return OCQualifiedName.with(null, name);
    }

    @Nullable
    public OCQualifiedName getQualifier() {
        return this.myQualifier;
    }

    @Nullable
    public String getName() {
        return this.myName;
    }

    public OCQualifiedName dropArguments() {
        return this;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull OCQualifiedName first, @NotNull OCQualifiedName second) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/jetbrains/cidr/lang/symbols/OCQualifiedName", "deepEqualStep"));
        }
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/jetbrains/cidr/lang/symbols/OCQualifiedName", "deepEqualStep"));
        }
        if (second == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "com/jetbrains/cidr/lang/symbols/OCQualifiedName", "deepEqualStep"));
        }
        if (!Comparing.equal((String)first.myName, (String)second.myName)) {
            return false;
        }
        return c.equalObjects(first.myQualifier, second.myQualifier);
    }

    public final boolean equals(@Nullable Object o) {
        return DeepEqual.equalObjects(this, o);
    }

    public int hashCode() {
        int result2 = this.myQualifier != null ? this.myQualifier.hashCode() : 0;
        result2 = 31 * result2 + (this.myName != null ? this.myName.hashCode() : 0);
        return result2;
    }

    public String getSuperQualifier() {
        return this.myQualifier == null ? this.myName : this.myQualifier.getSuperQualifier();
    }

    @NotNull
    public OCQualifiedName dropSuperQualifier() {
        if (this.myQualifier == null) {
            OCQualifiedName oCQualifiedName = this;
            if (oCQualifiedName == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/OCQualifiedName", "dropSuperQualifier"));
            }
            return oCQualifiedName;
        }
        if (this.myQualifier.myQualifier == null) {
            OCQualifiedName oCQualifiedName = OCQualifiedName.with(null, this.myName);
            if (oCQualifiedName == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/OCQualifiedName", "dropSuperQualifier"));
            }
            return oCQualifiedName;
        }
        OCQualifiedName oCQualifiedName = OCQualifiedName.with(this.myQualifier.dropSuperQualifier(), this.myName);
        if (oCQualifiedName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/OCQualifiedName", "dropSuperQualifier"));
        }
        return oCQualifiedName;
    }

    @NotNull
    public OCQualifiedName changeName(@Nullable String name) {
        if (Comparing.equal((String)this.myName, (String)name)) {
            OCQualifiedName oCQualifiedName = this;
            if (oCQualifiedName == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/OCQualifiedName", "changeName"));
            }
            return oCQualifiedName;
        }
        OCQualifiedName oCQualifiedName = OCQualifiedName.with(this.myQualifier, name);
        if (oCQualifiedName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/OCQualifiedName", "changeName"));
        }
        return oCQualifiedName;
    }

    @NotNull
    public OCQualifiedName changeQualifier(@Nullable OCQualifiedName qualifier) {
        OCQualifiedName oCQualifiedName = OCQualifiedName.with(qualifier, this.myName);
        if (oCQualifiedName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/OCQualifiedName", "changeQualifier"));
        }
        return oCQualifiedName;
    }

    public OCQualifiedName append(OCQualifiedName name) {
        OCQualifiedName appended = OCQualifiedName.with(this, name.getSuperQualifier());
        return name.getQualifier() == null ? appended : appended.append(name.dropSuperQualifier());
    }

    public String getCanonicalName(boolean fullName) {
        return this.getCanonicalName(fullName, true);
    }

    public String getCanonicalName(boolean fullName, boolean includeGlobalQualifier) {
        return this.getCanonicalName(fullName ? OCType.Presentation.FULL : OCType.Presentation.SHORT, includeGlobalQualifier, new OCResolveContext(null), 0);
    }

    public String getCanonicalName(@NotNull OCType.Presentation presentation, boolean includeGlobalQualifier, @NotNull OCResolveContext context, int templateDepth) {
        String name;
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/jetbrains/cidr/lang/symbols/OCQualifiedName", "getCanonicalName"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/symbols/OCQualifiedName", "getCanonicalName"));
        }
        String string = name = this.myName != null ? this.myName : "<anonymous>";
        if (presentation != OCType.Presentation.SHORT) {
            return this.myQualifier != null && (includeGlobalQualifier || this.myQualifier != GLOBAL) ? this.myQualifier.getCanonicalName(presentation, includeGlobalQualifier, context, templateDepth) + "::" + name : name;
        }
        return name;
    }

    public String getNameWithParent() {
        String name = this.getCanonicalName(false);
        return this.myQualifier != null && this.myQualifier != GLOBAL ? this.myQualifier.getCanonicalName(false) + "::" + name : name;
    }

    public static OCQualifiedName parse(String qualifiedName) {
        OCQualifiedName result2 = null;
        for (String name : qualifiedName.split("::")) {
            result2 = OCQualifiedName.with(result2, name);
        }
        return result2;
    }

    public String toString() {
        return this.getCanonicalName(true);
    }

    public List<String> flatten() {
        ArrayList<String> result2 = new ArrayList<String>();
        for (OCQualifiedName current = this; current != null; current = current.getQualifier()) {
            result2.add(current.getName());
        }
        Collections.reverse(result2);
        return result2;
    }
}

