/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.resolve.OCResolveOverloadsUtil;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCNonStaticOperatorType {
    public static final OCNonStaticOperatorType DEREF_OPERATOR = new OCNonStaticOperatorType("operator->");
    public static final OCNonStaticOperatorType MUL_OPERATOR = new OCNonStaticOperatorType("operator*");
    public static final OCNonStaticOperatorType ASSIGNMENT_OPERATOR = new OCNonStaticOperatorType("operator=");
    public static final OCNonStaticOperatorType SUBSCRIPT_OPERATOR = new OCNonStaticOperatorType("operator[]");
    public static final OCNonStaticOperatorType CALL_OPERATOR = new OCNonStaticOperatorType("operator()");
    private final String myName;

    private OCNonStaticOperatorType(String name) {
        this.myName = name;
    }

    public String getName() {
        return this.myName;
    }

    public static OCFunctionSymbol resolveAssignmentOperator(@NotNull OCElement element, @NotNull OCStructType struct, @Nullable OCType indexerType) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/symbols/OCNonStaticOperatorType", "resolveAssignmentOperator"));
        }
        if (struct == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "struct", "com/jetbrains/cidr/lang/symbols/OCNonStaticOperatorType", "resolveAssignmentOperator"));
        }
        OCResolveContext context = new OCResolveContext(element);
        Collection<OCSymbol> symbols = struct.collectMethods(ASSIGNMENT_OPERATOR.getName(), context);
        if (indexerType != null) {
            List<OCType> types = Arrays.asList(struct, indexerType);
            OCSymbol result2 = OCResolveOverloadsUtil.resolveOverloads(symbols, types, context, new OCOperatorReference(element, "=", element.getTextRange(), new OCExpression[0]));
            return (OCFunctionSymbol)result2;
        }
        for (OCSymbol result3 : symbols) {
            if (!(result3 instanceof OCFunctionSymbol)) continue;
            return (OCFunctionSymbol)result3;
        }
        return null;
    }

    @Nullable
    public static OCFunctionSymbol resolveDerefOperator(@NotNull OCElement element, @NotNull OCStructType struct) {
        List<OCType> types;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/symbols/OCNonStaticOperatorType", "resolveDerefOperator"));
        }
        if (struct == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "struct", "com/jetbrains/cidr/lang/symbols/OCNonStaticOperatorType", "resolveDerefOperator"));
        }
        OCResolveContext context = new OCResolveContext(element);
        Collection<OCSymbol> symbols = struct.collectMethods(DEREF_OPERATOR.getName(), context);
        OCSymbol result2 = OCResolveOverloadsUtil.resolveOverloads(symbols, types = Collections.singletonList(struct), context, new OCOperatorReference(element, "->", element.getTextRange(), new OCExpression[0]));
        return result2 instanceof OCFunctionSymbol ? (OCFunctionSymbol)result2 : null;
    }

    @Nullable
    public static OCFunctionSymbol resolveUnaryMulOperator(@NotNull OCElement element, @NotNull OCStructType struct) {
        List<OCType> types;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/symbols/OCNonStaticOperatorType", "resolveUnaryMulOperator"));
        }
        if (struct == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "struct", "com/jetbrains/cidr/lang/symbols/OCNonStaticOperatorType", "resolveUnaryMulOperator"));
        }
        OCResolveContext context = new OCResolveContext(element);
        Collection<OCSymbol> symbols = struct.collectMethods(MUL_OPERATOR.getName(), context);
        OCSymbol result2 = OCResolveOverloadsUtil.resolveOverloads(symbols, types = Collections.singletonList(struct), context, new OCOperatorReference(element, "*", element.getTextRange(), new OCExpression[0]));
        return result2 instanceof OCFunctionSymbol ? (OCFunctionSymbol)result2 : null;
    }
}

