/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ForeignLeafType;
import com.intellij.lang.NodeStructure;
import com.intellij.lang.TokenWrapper;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCMacroForeignLeafElement;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.symtable.OCNamesInternary;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuilderDriverBase<T, FILE extends PsiFile> {
    private static final String LOG_UNRESOLVED_SYMBOLS_PROPERTY = "appCode.LogUnresolvedSymbols";
    protected static final boolean LOG_UNRESOLVED_SYMBOLS = Comparing.equal((String)System.getProperty("appCode.LogUnresolvedSymbols"), (String)"true");
    public static NamedNodeStructure<ASTNode> AST_NAMED_NODE_STRUCTURE = new NamedNodeStructure<ASTNode>(){

        public int getStartOffset(ASTNode node) {
            if (node instanceof OCMacroForeignLeafElement) {
                return ((OCMacroForeignLeafElement)node).getRealStartOffset();
            }
            return node.getStartOffset();
        }

        public int getEndOffset(ASTNode node) {
            return node.getTextRange().getEndOffset();
        }

        public IElementType getTokenType(ASTNode node) {
            return node.getElementType();
        }

        @Override
        public String getNodeText(ASTNode node) {
            return node.getText();
        }
    };
    protected final FILE file;
    protected final OCInclusionContext context;
    protected final String text;
    protected final FlyweightCapableTreeStructure<T> structure;
    protected final NodeStructure<T> nodeStructure;
    protected final Processor<OCSymbol> builder;
    protected final Project project;
    protected final OCLanguageKind myLanguageKind;
    protected final VirtualFile myVirtualFile;

    protected int offset(@NotNull T nameElement) {
        if (nameElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameElement", "com/jetbrains/cidr/lang/symbols/BuilderDriverBase", "offset"));
        }
        return this.nodeStructure.getStartOffset(nameElement);
    }

    public BuilderDriverBase(@NotNull FILE file2, @NotNull OCInclusionContext context, @Nullable String text, @NotNull FlyweightCapableTreeStructure<T> structure, @NotNull NodeStructure<T> nodeStructure, @NotNull Processor<OCSymbol> builder, @Nullable VirtualFile virtualFile) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/symbols/BuilderDriverBase", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/symbols/BuilderDriverBase", "<init>"));
        }
        if (structure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "structure", "com/jetbrains/cidr/lang/symbols/BuilderDriverBase", "<init>"));
        }
        if (nodeStructure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeStructure", "com/jetbrains/cidr/lang/symbols/BuilderDriverBase", "<init>"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/jetbrains/cidr/lang/symbols/BuilderDriverBase", "<init>"));
        }
        this.file = file2;
        this.context = context;
        this.text = text;
        this.structure = structure;
        this.nodeStructure = nodeStructure;
        this.builder = builder;
        this.project = file2.getProject();
        this.myLanguageKind = context.getLanguageKind();
        this.myVirtualFile = virtualFile;
    }

    @NotNull
    protected Iterable<T> getChildren(@NotNull T node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/lang/symbols/BuilderDriverBase", "getChildren"));
        }
        final Ref childrenRef = Ref.create(null);
        final int count = this.structure.getChildren(this.structure.prepareForGetChildren(node), childrenRef);
        Iterable iterable = new Iterable<T>(){

            @Override
            @NotNull
            public Iterator<T> iterator() {
                Iterator iterator = new Iterator<T>(){
                    int idx = 0;

                    @Override
                    public boolean hasNext() {
                        return !childrenRef.isNull() && this.idx < count;
                    }

                    @Override
                    public T next() {
                        ProgressManager.checkCanceled();
                        return ((Object[])childrenRef.get())[this.idx++];
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
                if (iterator == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/BuilderDriverBase$2", "iterator"));
                }
                return iterator;
            }
        };
        if (iterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/BuilderDriverBase", "getChildren"));
        }
        return iterable;
    }

    @NotNull
    protected IElementType type(@NotNull T child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/jetbrains/cidr/lang/symbols/BuilderDriverBase", "type"));
        }
        IElementType type = this.nodeStructure.getTokenType(child);
        if (type instanceof ForeignLeafType) {
            type = ((ForeignLeafType)type).getDelegate();
        }
        IElementType iElementType = type;
        if (iElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/BuilderDriverBase", "type"));
        }
        return iElementType;
    }

    @NotNull
    protected String nodeText(@NotNull T node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/lang/symbols/BuilderDriverBase", "nodeText"));
        }
        String string = OCNamesInternary.intern(this.nodeTextNoIntern(node, false));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/BuilderDriverBase", "nodeText"));
        }
        return string;
    }

    @NotNull
    protected String nodeTextNoIntern(@NotNull T node, boolean withDirectives) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/lang/symbols/BuilderDriverBase", "nodeTextNoIntern"));
        }
        String text = this.nodeText(node, null, withDirectives);
        assert (text != null);
        String string = text;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/BuilderDriverBase", "nodeTextNoIntern"));
        }
        return string;
    }

    @Nullable
    private String nodeText(@NotNull T node, @Nullable StringBuilder acc, boolean withDirectives) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/lang/symbols/BuilderDriverBase", "nodeText"));
        }
        IElementType unwrappedType = this.type(node);
        IElementType tt = this.nodeStructure.getTokenType(node);
        if (!withDirectives && (OCElementTypes.DIRECTIVES.contains(unwrappedType) || OCElementTypes.MACRO_CALL == unwrappedType)) {
            return "";
        }
        if (OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(unwrappedType)) {
            if (acc != null) {
                acc.append(" ");
            }
            return " ";
        }
        if (tt instanceof ForeignLeafType) {
            String value = ((ForeignLeafType)tt).getValue();
            if (acc != null) {
                acc.append(value);
            }
            return value;
        }
        if (node instanceof ForeignLeafPsiElement) {
            String value = ((ForeignLeafPsiElement)node).getText();
            if (acc != null) {
                acc.append(value);
            }
            return value;
        }
        if (tt instanceof TokenWrapper) {
            if (this.text != null) {
                return this.text.substring(this.nodeStructure.getStartOffset(node), this.nodeStructure.getEndOffset(node));
            }
            return ((NamedNodeStructure)this.nodeStructure).getNodeText(node);
        }
        List children2 = ContainerUtil.collect(this.getChildren(node).iterator());
        if (children2.size() == 1) {
            return this.nodeText(children2.get(0), acc, withDirectives);
        }
        if (children2.size() > 1) {
            boolean needReturnString = false;
            if (acc == null) {
                needReturnString = true;
                acc = new StringBuilder();
            }
            for (Object child : children2) {
                this.nodeText(child, acc, withDirectives);
            }
            return needReturnString ? acc.toString() : null;
        }
        String value = this.text != null ? this.text.substring(this.nodeStructure.getStartOffset(node), this.nodeStructure.getEndOffset(node)) : ((NamedNodeStructure)this.nodeStructure).getNodeText(node);
        if (acc != null) {
            acc.append(value);
        }
        return value;
    }

    public static class DeclarationContext<T> {
        private OCSymbolKind declaratorType;
        private Object parent;
        protected OCSymbolWithQualifiedName myParentSymbol;
        private OCVisibility visibility;
        private boolean isVirtual;
        private boolean isConstExpr;
        private boolean isBlockModifiable;
        private boolean isStatic;
        private boolean isExplicit;
        private boolean isDefault;
        private boolean isDelete;
        private boolean isExtern;
        private boolean isFriend;
        protected boolean isDeclarationWithoutDeclarators;
        protected boolean isDeclarationWithoutType;
        private boolean myMutable;
        private boolean isBaseClause;
        private boolean isTemplateValueParameter;
        private List<String> attributes;
        private PsiElement localContext;
        protected T myKRParamterList;
        private ASTNode forCollection;
        private Stack<List<OCSymbolReference>> referencesInDeclaration = new Stack();
        private List<T> myTemplateParameters = new ArrayList<T>();
        private boolean myInsideTemplateParams;

        public DeclarationContext(OCSymbolKind declaratorType, Object parent, OCSymbolWithQualifiedName parentSymbol, OCVisibility visibility, PsiElement localContext) {
            this.declaratorType = declaratorType;
            this.parent = parent;
            this.myParentSymbol = parentSymbol;
            this.visibility = visibility;
            this.localContext = localContext;
        }

        public DeclarationContext(OCSymbolKind declaratorType) {
            this.declaratorType = declaratorType;
        }

        public DeclarationContext() {
        }

        public OCSymbolKind getDeclaratorType() {
            return this.declaratorType;
        }

        public void setDeclaratorType(OCSymbolKind declaratorType) {
            this.declaratorType = declaratorType;
        }

        public Object getParent() {
            return this.parent;
        }

        public OCSymbolWithQualifiedName getParentSymbol() {
            return this.myParentSymbol;
        }

        public OCVisibility getVisibility() {
            return this.visibility;
        }

        public boolean isExtern() {
            return this.isExtern;
        }

        public void setExtern(boolean extern) {
            this.isExtern = extern;
        }

        public boolean isFriend() {
            return this.isFriend;
        }

        public void setFriend(boolean friend) {
            this.isFriend = friend;
        }

        public boolean isVirtual() {
            return this.isVirtual;
        }

        public void setVirtual(boolean virtual) {
            this.isVirtual = virtual;
        }

        public boolean isConstexpr() {
            return this.isConstExpr;
        }

        public void setConstexpr(boolean constexpr) {
            this.isConstExpr = constexpr;
        }

        public boolean isBaseClause() {
            return this.isBaseClause;
        }

        public void setBaseClause(boolean isBaseClause) {
            this.isBaseClause = isBaseClause;
        }

        public boolean isBlockModifiable() {
            return this.isBlockModifiable;
        }

        public void setBlockModifiable(boolean blockModifiable) {
            this.isBlockModifiable = blockModifiable;
        }

        public boolean isStatic() {
            return this.isStatic;
        }

        public void setStatic(boolean aStatic) {
            this.isStatic = aStatic;
        }

        public boolean isExplicit() {
            return this.isExplicit;
        }

        public void setExplicit(boolean explicit) {
            this.isExplicit = explicit;
        }

        public boolean isDefault() {
            return this.isDefault;
        }

        public void setDefault(boolean isDefault) {
            this.isDefault = isDefault;
        }

        public boolean isDelete() {
            return this.isDelete;
        }

        public void setDelete(boolean isDelete) {
            this.isDelete = isDelete;
        }

        public boolean isTemplateValueParameter() {
            return this.isTemplateValueParameter;
        }

        public void setTemplateValueParameter(boolean isTemplateValueParameter) {
            this.isTemplateValueParameter = isTemplateValueParameter;
        }

        public List<String> getAttributes() {
            return this.attributes;
        }

        public void addAttributes(List<String> attributes) {
            if (this.attributes == null) {
                this.attributes = attributes;
            } else {
                this.attributes.addAll(attributes);
            }
        }

        public PsiElement getLocalContext() {
            return this.localContext;
        }

        public List<T> getTemplateParameters() {
            return this.myTemplateParameters;
        }

        public boolean isMutable() {
            return this.myMutable;
        }

        public void setMutable(boolean mutable) {
            this.myMutable = mutable;
        }

        public void setDeclarationWithoutDeclarators(boolean declarationWithoutDeclarators) {
            this.isDeclarationWithoutDeclarators = declarationWithoutDeclarators;
        }

        public void setDeclarationWithoutType(boolean declarationWithoutType) {
            this.isDeclarationWithoutType = declarationWithoutType;
        }

        public ASTNode getForCollection() {
            return this.forCollection;
        }

        public void setForCollection(ASTNode forCollection) {
            this.forCollection = forCollection;
        }

        @NotNull
        public List<OCSymbolReference> getReferencesInDeclaration() {
            List list = (List)this.referencesInDeclaration.peek();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/BuilderDriverBase$DeclarationContext", "getReferencesInDeclaration"));
            }
            return list;
        }

        public void addSymbolReference(@NotNull OCSymbolReference reference) {
            if (reference == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/jetbrains/cidr/lang/symbols/BuilderDriverBase$DeclarationContext", "addSymbolReference"));
            }
            if (!this.referencesInDeclaration.isEmpty()) {
                ((List)this.referencesInDeclaration.peek()).add(reference);
            }
        }

        public void pushDeclaration() {
            this.referencesInDeclaration.push(new ArrayList());
        }

        public void popDeclaration() {
            this.referencesInDeclaration.pop();
        }

        public boolean isInsideTemplateParams() {
            return this.myInsideTemplateParams;
        }

        public void setInsideTemplateParams(boolean insideTemplateParams) {
            this.myInsideTemplateParams = insideTemplateParams;
        }
    }

    public static interface NamedNodeStructure<T>
    extends NodeStructure<T> {
        public String getNodeText(T var1);
    }
}

