/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.settings.formatter.extractor;

import com.jetbrains.cidr.lang.settings.formatter.extractor.FUtils;
import com.jetbrains.cidr.lang.settings.formatter.extractor.FValue;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class FGens {
    @NotNull
    private final List<FValue> myValues;

    public FGens(@NotNull List<FValue> values) {
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/jetbrains/cidr/lang/settings/formatter/extractor/FGens", "<init>"));
        }
        this.myValues = values;
    }

    public FGens(@NotNull FGens gens) {
        if (gens == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gens", "com/jetbrains/cidr/lang/settings/formatter/extractor/FGens", "<init>"));
        }
        this.myValues = gens.copy().getValues();
    }

    public FGens mutate(int averageMutationCount) {
        if (averageMutationCount > 0) {
            int commonMutagen = 0;
            for (FValue value : this.myValues) {
                commonMutagen += value.getMutagenFactor();
            }
            for (FValue value : this.myValues) {
                if (FUtils.getRandomLess(commonMutagen) >= value.getMutagenFactor() * averageMutationCount) continue;
                Object[] possibleValues = value.getPossibleValues();
                value.value = possibleValues[FUtils.getRandomLess(possibleValues.length)];
            }
        }
        return this;
    }

    public FGens dropToInitial() {
        ArrayList values = new ArrayList();
        for (FValue value : this.myValues) {
            Object[] possibleValues = value.getPossibleValues();
            if (possibleValues.length <= 0) continue;
            value.value = possibleValues[0];
        }
        return this;
    }

    @NotNull
    public FGens copy() {
        ArrayList<FValue> values = new ArrayList<FValue>();
        for (FValue value : this.myValues) {
            values.add(new FValue(value));
        }
        FGens fGens = new FGens(values);
        if (fGens == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/settings/formatter/extractor/FGens", "copy"));
        }
        return fGens;
    }

    public FGens diff(FGens newGens) {
        List<FValue> newValues = newGens.getValues();
        int size = this.myValues.size();
        assert (size == newValues.size());
        ArrayList<FValue> diff = new ArrayList<FValue>();
        for (int i = 0; i < size; ++i) {
            FValue value = this.myValues.get(i);
            FValue newValue = newValues.get(i);
            assert (value.name.equals(newValue.name));
            if (value.value.equals(newValue.value)) continue;
            diff.add(new FValue(value.name, value.value + "->" + newValue.value, value.serializer));
        }
        return new FGens(diff);
    }

    @NotNull
    public static FGens breed(@NotNull FGens p1, @NotNull FGens p2, int averageMutationCount) {
        if (p1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p1", "com/jetbrains/cidr/lang/settings/formatter/extractor/FGens", "breed"));
        }
        if (p2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p2", "com/jetbrains/cidr/lang/settings/formatter/extractor/FGens", "breed"));
        }
        int size = p1.myValues.size();
        assert (size == p2.myValues.size());
        int crossover = size / 2;
        ArrayList<FValue> values = new ArrayList<FValue>(size);
        for (int i = 0; i < size; ++i) {
            FValue value1 = p1.myValues.get(i);
            FValue value2 = p2.myValues.get(i);
            if (value1.kind == FValue.VAR_KIND.INDENT) {
                values.add(new FValue(value1));
                continue;
            }
            if (value1.kind == FValue.VAR_KIND.BRACE_STYLE) {
                values.add(new FValue(value2));
                continue;
            }
            if ((i & 1) == 1) {
                values.add(new FValue(value1));
                continue;
            }
            values.add(new FValue(value2));
        }
        FGens fGens = new FGens(values).mutate(averageMutationCount);
        if (fGens == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/settings/formatter/extractor/FGens", "breed"));
        }
        return fGens;
    }

    @Contract(value="false -> null")
    public FGens apply(boolean retPrevValue) {
        if (retPrevValue) {
            ArrayList<FValue> orig = new ArrayList<FValue>();
            for (FValue value : this.myValues) {
                FValue old = value.write(true);
                if (old == null) continue;
                orig.add(old);
            }
            return new FGens(orig);
        }
        for (FValue value : this.myValues) {
            value.write(false);
        }
        return null;
    }

    @NotNull
    public List<FValue> getValues() {
        List<FValue> list = this.myValues;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/settings/formatter/extractor/FGens", "getValues"));
        }
        return list;
    }

    public void applySelected() {
        for (FValue value : this.myValues) {
            if (value.state != FValue.STATE.SELECTED) continue;
            value.write(false);
        }
    }

    public void copyFrom(FGens gens) {
        if (this.myValues == gens.myValues) {
            return;
        }
        this.myValues.clear();
        this.myValues.addAll(gens.myValues);
    }
}

