/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.settings.formatter.extractor;

import com.intellij.openapi.util.Pair;
import com.jetbrains.cidr.lang.settings.formatter.extractor.FDiffer;
import com.jetbrains.cidr.lang.settings.formatter.extractor.FGens;
import com.jetbrains.cidr.lang.settings.formatter.extractor.FUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FGeneration {
    private static int GENERATION_POOL_SIZE = 45;
    private static int MUTATION_PER_GEN = 10;
    public static int GEN_COUNT = 40;
    private List<FGens> myGensPool;
    private int myAge;
    private int myParentKind;

    private FGeneration(@NotNull FGens bestGens) {
        if (bestGens == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bestGens", "com/jetbrains/cidr/lang/settings/formatter/extractor/FGeneration", "<init>"));
        }
        this.myParentKind = -1;
        this.myGensPool = new ArrayList<FGens>(GENERATION_POOL_SIZE);
        for (int i = 0; i < GENERATION_POOL_SIZE; ++i) {
            this.myGensPool.add(new FGens(bestGens).mutate(i == 0 ? 0 : MUTATION_PER_GEN));
        }
        this.myAge = 0;
    }

    private FGeneration(@NotNull FGeneration previous, int parentKind) {
        if (previous == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "previous", "com/jetbrains/cidr/lang/settings/formatter/extractor/FGeneration", "<init>"));
        }
        this.myAge = previous.myAge + 1;
        this.myParentKind = parentKind;
        this.myGensPool = new ArrayList<FGens>(GENERATION_POOL_SIZE);
        int mutationsCount = MUTATION_PER_GEN;
        int prevPullSize = previous.myGensPool.size();
        for (int i = 0; i < GENERATION_POOL_SIZE; ++i) {
            int parent1 = 0;
            int parent2 = 0;
            int iterations = 0;
            while (parent1 == parent2) {
                parent1 = FUtils.getRandomLess(prevPullSize);
                parent2 = FUtils.getRandomLess(prevPullSize);
                if (++iterations <= 25) continue;
            }
            this.myGensPool.add(FGens.breed(previous.myGensPool.get(parent1), previous.myGensPool.get(parent2), mutationsCount));
        }
    }

    public static FGeneration createZeroGeneration(@NotNull FGens gens) {
        if (gens == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gens", "com/jetbrains/cidr/lang/settings/formatter/extractor/FGeneration", "createZeroGeneration"));
        }
        return new FGeneration(gens);
    }

    public static FGeneration createNextGeneration(FDiffer differ, @NotNull FGeneration previous) {
        if (previous == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "previous", "com/jetbrains/cidr/lang/settings/formatter/extractor/FGeneration", "createNextGeneration"));
        }
        int parentKind = previous.reduceToSize(differ, (int)(0.2 * (double)previous.myGensPool.size()));
        return previous.tryAgain() ? new FGeneration(previous, parentKind) : previous;
    }

    private int reduceToSize(FDiffer differ, int newPoolSize) {
        ArrayList<Pair> ranges = new ArrayList<Pair>(this.myGensPool.size());
        int i = 0;
        for (FGens gens : this.myGensPool) {
            int range = differ.getDifference(gens);
            ranges.add(Pair.create((Object)range, (Object)i++));
            if (range != 0) continue;
            this.myAge = GEN_COUNT;
            newPoolSize = 1;
            break;
        }
        Collections.sort(ranges, new Comparator<Pair<Integer, Integer>>(){

            @Override
            public int compare(Pair<Integer, Integer> o1, Pair<Integer, Integer> o2) {
                return (Integer)o1.first - (Integer)o2.first;
            }
        });
        ArrayList<FGens> gensPool = new ArrayList<FGens>(newPoolSize);
        int count = 0;
        int worseForward = 0;
        for (Pair pair : ranges) {
            if (count >= newPoolSize) break;
            FGens gens = this.myGensPool.get((Integer)pair.second);
            gensPool.add(gens);
            ++count;
            worseForward = (Integer)pair.first;
        }
        this.myGensPool = gensPool;
        return worseForward;
    }

    public boolean tryAgain() {
        return this.myAge < GEN_COUNT;
    }

    public FGens getBestGens(FDiffer differ) {
        this.reduceToSize(differ, 1);
        return this.myGensPool.get(0);
    }

    public int getAge() {
        return this.myAge;
    }

    public int getParentKind() {
        return this.myParentKind;
    }
}

