/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.settings.formatter.extractor;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.ui.BalloonLayout;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.settings.formatter.extractor.FDiffer;
import com.jetbrains.cidr.lang.settings.formatter.extractor.FGens;
import com.jetbrains.cidr.lang.settings.formatter.extractor.FUtils;
import com.jetbrains.cidr.lang.settings.formatter.extractor.FValue;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import java.awt.Frame;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;

public class FExtractCodeStyleAction
extends AnAction {
    static DateFormat formatter = new SimpleDateFormat("mm:ss");

    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        final Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor == null) {
            return;
        }
        final PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        if (file2 == null) {
            return;
        }
        final CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)project);
        FGens origGens = new FGens(FUtils.getFormattingValues(settings, file2.getLanguage()));
        final FGens forSelection = origGens.copy();
        Task.Backgroundable task = new Task.Backgroundable(project, "Code style extractor", true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/cidr/lang/settings/formatter/extractor/FExtractCodeStyleAction$1", "run"));
                }
                try {
                    FixtureFDiffer differ = new FixtureFDiffer(project, file2, settings);
                    forSelection.dropToInitial();
                    FUtils.resetRandom();
                    long startTime = System.nanoTime();
                    FUtils.adjustValuesGA(forSelection, differ, indicator);
                    FExtractCodeStyleAction.this.reportResult("GA", forSelection, differ, startTime);
                    startTime = System.nanoTime();
                    FUtils.adjustValuesMin(forSelection, differ, indicator);
                    FExtractCodeStyleAction.this.reportResult("MIN", forSelection, differ, startTime);
                    FExtractCodeStyleAction.this.reportResult(forSelection, project);
                }
                catch (ProcessCanceledException e) {
                    OCLog.LOG.info("Code extraction was canceled");
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        };
        ProgressManager.getInstance().run((Task)task);
    }

    public void reportResult(final FGens forSelection, final Project project) {
        final Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder("Formatting Options were extracted<br/><a href=\"apply\">Apply</a> <a href=\"details\">Details...</a>", MessageType.INFO, new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    boolean apply = "apply".equals(e.getDescription());
                    if (!apply) {
                        StringBuilder descriptions = new StringBuilder("<html>Set formatting options:");
                        List<FValue> values = forSelection.getValues();
                        for (FValue value : values) {
                            if (value.state != FValue.STATE.SELECTED) continue;
                            descriptions.append("<br>").append(value.serializer.getInstanceName()).append(".").append(value.name).append(" = ").append(value.value).append(";");
                        }
                        descriptions.append("</html>");
                        boolean bl = apply = 0 == Messages.showYesNoCancelDialog((String)descriptions.toString(), (String)"Extracted Formatted Options", (String)"Apply", (String)"Ignore", (String)"Cancel", (Icon)Messages.getInformationIcon());
                    }
                    if (apply) {
                        forSelection.applySelected();
                    }
                }
            }
        }).setDisposable((Disposable)ApplicationManager.getApplication()).setShowCallout(false).setFadeoutTime(0L).setShowCallout(false).setAnimationCycle(0).setHideOnClickOutside(false).setHideOnKeyOutside(false).setCloseButtonEnabled(true).setHideOnLinkClick(true).createBalloon();
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                BalloonLayout layout;
                Frame window = WindowManager.getInstance().getFrame(project);
                if (window == null) {
                    window = JOptionPane.getRootFrame();
                }
                if (window instanceof IdeFrame && (layout = ((IdeFrame)window).getBalloonLayout()) != null) {
                    layout.add(balloon);
                }
            }
        });
    }

    private void reportResult(String label, FGens gens, FixtureFDiffer differ, long startTime) throws Exception {
        Date date = new Date((System.nanoTime() - startTime) / 1000000L);
        System.out.println(label + " range:" + differ.getDifference(gens) + "  Execution Time: " + formatter.format(date));
    }

    private class FixtureFDiffer
    implements FDiffer {
        private final Project myProject;
        private final String myOrigText;
        private final CodeStyleSettings mySettings;
        private final PsiFile myFile;

        public FixtureFDiffer(Project project, PsiFile file2, CodeStyleSettings settings) {
            this.myProject = project;
            this.myFile = file2;
            this.myOrigText = this.myFile.getText();
            this.mySettings = settings;
        }

        @Override
        public int getDifference(final @NotNull FGens gens) {
            if (gens == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gens", "com/jetbrains/cidr/lang/settings/formatter/extractor/FExtractCodeStyleAction$FixtureFDiffer", "getDifference"));
            }
            final int[] ret = new int[]{0};
            WriteCommandAction.runWriteCommandAction((Project)this.myProject, (Runnable)new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    FGens orig = gens.apply(true);
                    try {
                        OCCodeFragment file2 = OCElementFactory.codeFragment(FixtureFDiffer.this.myOrigText, FixtureFDiffer.this.myProject, (PsiElement)FixtureFDiffer.this.myFile, false, true);
                        String newText = file2.getText();
                        ret[0] = FUtils.getDiff(FixtureFDiffer.this.mySettings, FixtureFDiffer.this.myOrigText, newText);
                    }
                    finally {
                        orig.apply(false);
                    }
                }
            });
            return ret[0];
        }
    }
}

