/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.settings;

import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.DisplayPriority;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.settings.OCBaseLanguageCodeStyleSettingsProvider;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.OCCustomOption;
import com.jetbrains.cidr.lang.settings.OCGenerateCodeConfigurable;
import com.jetbrains.cidr.lang.settings.OCIndentOptionsEditor;
import org.jetbrains.annotations.NotNull;

public class OCLanguageCodeStyleSettingsProvider
extends OCBaseLanguageCodeStyleSettingsProvider {
    public static final OCCustomOption CUSTOM_OPTION = OCLanguage.getCustomOption();

    public OCLanguageCodeStyleSettingsProvider() {
        super(OCLanguage.getInstance());
    }

    @Override
    @NotNull
    public CommonCodeStyleSettings getDefaultCommonSettings() {
        CommonCodeStyleSettings result2 = super.getDefaultCommonSettings();
        CUSTOM_OPTION.configureDefaultSettings(result2);
        CommonCodeStyleSettings commonCodeStyleSettings = result2;
        if (commonCodeStyleSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/settings/OCLanguageCodeStyleSettingsProvider", "getDefaultCommonSettings"));
        }
        return commonCodeStyleSettings;
    }

    @NotNull
    public static String getCodeSample(@NotNull String fileNameWithoutExt) {
        if (fileNameWithoutExt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileNameWithoutExt", "com/jetbrains/cidr/lang/settings/OCLanguageCodeStyleSettingsProvider", "getCodeSample"));
        }
        String defExampleExtension = CUSTOM_OPTION.getExampleExtension();
        String string = OCLanguageCodeStyleSettingsProvider.getCodeSample(fileNameWithoutExt, defExampleExtension);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/settings/OCLanguageCodeStyleSettingsProvider", "getCodeSample"));
        }
        return string;
    }

    @NotNull
    public static String getCodeSample(@NotNull String fileNameWithoutExtension, @NotNull String extension) {
        if (fileNameWithoutExtension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileNameWithoutExtension", "com/jetbrains/cidr/lang/settings/OCLanguageCodeStyleSettingsProvider", "getCodeSample"));
        }
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/jetbrains/cidr/lang/settings/OCLanguageCodeStyleSettingsProvider", "getCodeSample"));
        }
        String string = OCCustomOption.ResourceReader.readExampleString(OCCustomOption.class, "formatter/" + extension + "/" + fileNameWithoutExtension + "." + extension);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/settings/OCLanguageCodeStyleSettingsProvider", "getCodeSample"));
        }
        return string;
    }

    @NotNull
    public static OCCustomOption.CustomOption[] getFoldingCustomOptions() {
        OCCustomOption.CustomOption[] customOptionArray = CUSTOM_OPTION.getFoldingCustomOptions();
        if (customOptionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/settings/OCLanguageCodeStyleSettingsProvider", "getFoldingCustomOptions"));
        }
        return customOptionArray;
    }

    @NotNull
    public static AttributesDescriptor[] getAttributeDescriptors() {
        AttributesDescriptor[] attributesDescriptorArray = CUSTOM_OPTION.getAttributeDescriptors();
        if (attributesDescriptorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/settings/OCLanguageCodeStyleSettingsProvider", "getAttributeDescriptors"));
        }
        return attributesDescriptorArray;
    }

    @Override
    @NotNull
    protected String getCodeSampleContent(@NotNull String fileNameWithoutExt) {
        if (fileNameWithoutExt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileNameWithoutExt", "com/jetbrains/cidr/lang/settings/OCLanguageCodeStyleSettingsProvider", "getCodeSampleContent"));
        }
        String string = OCLanguageCodeStyleSettingsProvider.getCodeSample(fileNameWithoutExt);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/settings/OCLanguageCodeStyleSettingsProvider", "getCodeSampleContent"));
        }
        return string;
    }

    public String getFileExt() {
        return CUSTOM_OPTION.getExampleExtension();
    }

    public DisplayPriority getDisplayPriority() {
        return DisplayPriority.KEY_LANGUAGE_SETTINGS;
    }

    public IndentOptionsEditor getIndentOptionsEditor() {
        return new OCIndentOptionsEditor(this);
    }

    public void customizeSettings(@NotNull CodeStyleSettingsCustomizable c, @NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/jetbrains/cidr/lang/settings/OCLanguageCodeStyleSettingsProvider", "customizeSettings"));
        }
        if (settingsType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsType", "com/jetbrains/cidr/lang/settings/OCLanguageCodeStyleSettingsProvider", "customizeSettings"));
        }
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS) {
            c.showStandardOptions(CUSTOM_OPTION.getWrappingAndBracesOptions());
            for (OCCustomOption.RenameAction renameAction : CUSTOM_OPTION.getWrappingAndBracesRenames()) {
                c.renameStandardOption(renameAction.from, renameAction.to);
            }
            for (OCCustomOption.CustomOption customOption : CUSTOM_OPTION.getWrappingAndBracesCustomOptions()) {
                c.showCustomOption(OCCodeStyleSettings.class, customOption.fieldName, customOption.title, customOption.groupName, customOption.anchor, customOption.anchorFieldName, customOption.options);
            }
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.SPACING_SETTINGS) {
            c.showStandardOptions(CUSTOM_OPTION.getSpacingOptions());
            for (OCCustomOption.RenameAction renameAction : CUSTOM_OPTION.getSpacingRenames()) {
                c.renameStandardOption(renameAction.from, renameAction.to);
            }
            for (OCCustomOption.CustomOption customOption : CUSTOM_OPTION.getSpacingCustomOptions()) {
                c.showCustomOption(OCCodeStyleSettings.class, customOption.fieldName, customOption.title, customOption.groupName, customOption.anchor, customOption.anchorFieldName, customOption.options);
            }
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.INDENT_SETTINGS) {
            for (OCCustomOption.CustomOption customOption : CUSTOM_OPTION.getIndentCustomOptions()) {
                c.showCustomOption(OCCodeStyleSettings.class, customOption.fieldName, customOption.title, customOption.groupName, customOption.anchor, customOption.anchorFieldName, customOption.options);
            }
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.LANGUAGE_SPECIFIC) {
            OCGenerateCodeConfigurable.customizeSettings(c);
        } else {
            c.showStandardOptions(new String[]{"KEEP_BLANK_LINES_IN_DECLARATIONS", "KEEP_BLANK_LINES_IN_CODE", "KEEP_BLANK_LINES_BEFORE_RBRACE", "BLANK_LINES_BEFORE_IMPORTS", "BLANK_LINES_AFTER_IMPORTS", "BLANK_LINES_AROUND_CLASS", "BLANK_LINES_AFTER_CLASS_HEADER", "BLANK_LINES_AROUND_FIELD_IN_INTERFACE", "BLANK_LINES_AROUND_METHOD_IN_INTERFACE", "BLANK_LINES_AROUND_FIELD", "BLANK_LINES_AROUND_METHOD", "BLANK_LINES_BEFORE_METHOD_BODY"});
        }
        for (OCCustomOption.RenameAction renameAction : CUSTOM_OPTION.getBlankLinesRenames()) {
            c.renameStandardOption(renameAction.from, renameAction.to);
        }
    }
}

