/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.settings;

import com.intellij.application.options.SmartIndentOptionsEditor;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.util.ReflectionUtil;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.OCLanguageCodeStyleSettingsProvider;
import java.awt.Dimension;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCIndentOptionsEditor
extends SmartIndentOptionsEditor
implements CodeStyleSettingsCustomizable {
    private final ArrayList<UIOption> indentOptions = new ArrayList();
    private final OCLanguageCodeStyleSettingsProvider languageProvider;
    private static final Dimension SPACE_BOX = new Dimension(10, 8);
    private static final Set<String> INDENTED_OPTIONS = new HashSet<String>(Arrays.asList("INDENT_INTERFACE_MEMBERS_EXCEPT_IVARS_BLOCK", "INDENT_DIRECTIVE_AS_CODE"));

    public OCIndentOptionsEditor(OCLanguageCodeStyleSettingsProvider languageProvider) {
        this.languageProvider = languageProvider;
    }

    protected void addUIOption(@NotNull String fieldName, @NotNull String title) {
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/jetbrains/cidr/lang/settings/OCIndentOptionsEditor", "addUIOption"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/jetbrains/cidr/lang/settings/OCIndentOptionsEditor", "addUIOption"));
        }
        this.indentOptions.add(new UIOption(fieldName, title));
    }

    protected static OCCodeStyleSettings getOCSettings(CodeStyleSettings settings) {
        return (OCCodeStyleSettings)settings.getCustomSettings(OCCodeStyleSettings.class);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (UIOption option : this.indentOptions) {
            option.setEnabled(enabled);
        }
    }

    public void reset(@NotNull CodeStyleSettings settings, @NotNull CommonCodeStyleSettings.IndentOptions options) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/jetbrains/cidr/lang/settings/OCIndentOptionsEditor", "reset"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/jetbrains/cidr/lang/settings/OCIndentOptionsEditor", "reset"));
        }
        super.reset(settings, options);
        OCCodeStyleSettings ocSettings = OCIndentOptionsEditor.getOCSettings(settings);
        for (UIOption option : this.indentOptions) {
            option.writeToUI(ocSettings);
        }
    }

    public void apply(CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions options) {
        super.apply(settings, options);
        OCCodeStyleSettings ocSettings = OCIndentOptionsEditor.getOCSettings(settings);
        for (UIOption option : this.indentOptions) {
            option.readFromUI(ocSettings);
        }
    }

    public boolean isModified(CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions options) {
        OCCodeStyleSettings ocSettings = OCIndentOptionsEditor.getOCSettings(settings);
        boolean modified = super.isModified(settings, options);
        for (UIOption option : this.indentOptions) {
            modified |= option.isModified(ocSettings);
        }
        return modified;
    }

    protected void addComponents() {
        super.addComponents();
        this.languageProvider.customizeSettings(this, LanguageCodeStyleSettingsProvider.SettingsType.INDENT_SETTINGS);
    }

    public void showAllStandardOptions() {
    }

    public void showStandardOptions(String ... optionNames) {
    }

    public void showCustomOption(Class<? extends CustomCodeStyleSettings> settingsClass, String fieldName, String title, @Nullable String groupName, Object ... options) {
        this.showCustomOption(settingsClass, fieldName, title, groupName, null, null, options);
    }

    public void showCustomOption(Class<? extends CustomCodeStyleSettings> settingsClass, String fieldName, String title, @Nullable String groupName, @Nullable CodeStyleSettingsCustomizable.OptionAnchor anchor, @Nullable String anchorFieldName, Object ... options) {
        this.addUIOption(fieldName, title);
    }

    public void renameStandardOption(String fieldName, String newTitle) {
    }

    public void moveStandardOption(String fieldName, String newGroup) {
    }

    private class UIOption {
        private Field field;
        private Class<?> type;
        private JTextField edit;
        private JCheckBox checkBox;
        private JLabel label;

        public UIOption(@NotNull String fieldName, String title) {
            if (fieldName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/jetbrains/cidr/lang/settings/OCIndentOptionsEditor$UIOption", "<init>"));
            }
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/jetbrains/cidr/lang/settings/OCIndentOptionsEditor$UIOption", "<init>"));
            }
            if (fieldName == "SPACE_SEPARATOR") {
                OCIndentOptionsEditor.this.add(new Box.Filler(SPACE_BOX, SPACE_BOX, SPACE_BOX));
                return;
            }
            try {
                this.field = ReflectionUtil.findField(OCCodeStyleSettings.class, null, (String)fieldName);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            Class<?> clazz = this.type = this.field != null ? this.field.getType() : null;
            if (Boolean.TYPE.equals(this.type)) {
                this.checkBox = new JCheckBox(title);
                OCIndentOptionsEditor.this.add(this.checkBox, INDENTED_OPTIONS.contains(fieldName));
            } else if (Integer.TYPE.equals(this.type)) {
                this.edit = OCIndentOptionsEditor.this.createIndentTextField();
                this.label = new JLabel(title + ":");
                this.label.setLabelFor(this.edit);
                OCIndentOptionsEditor.this.add(this.label, this.edit);
            }
        }

        public void setEnabled(boolean enabled) {
            if (Boolean.TYPE.equals(this.type)) {
                this.checkBox.setEnabled(enabled);
            } else if (Integer.TYPE.equals(this.type)) {
                this.edit.setEnabled(enabled);
                this.label.setEnabled(enabled);
            }
        }

        public void writeToUI(OCCodeStyleSettings ocSettings) {
            try {
                if (Boolean.TYPE.equals(this.type)) {
                    this.checkBox.setSelected(this.field.getBoolean((Object)ocSettings));
                } else if (Integer.TYPE.equals(this.type)) {
                    this.edit.setText(String.valueOf(this.field.getInt((Object)ocSettings)));
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }

        public void readFromUI(OCCodeStyleSettings ocSettings) {
            try {
                if (Boolean.TYPE.equals(this.type)) {
                    this.field.setBoolean((Object)ocSettings, this.checkBox.isSelected());
                } else if (Integer.TYPE.equals(this.type)) {
                    this.field.setInt((Object)ocSettings, OCIndentOptionsEditor.this.getFieldValue(this.edit, 0, this.field.getInt((Object)ocSettings)));
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }

        public boolean isModified(OCCodeStyleSettings ocSettings) {
            try {
                if (Boolean.TYPE.equals(this.type)) {
                    return OCIndentOptionsEditor.isFieldModified((JCheckBox)this.checkBox, (boolean)this.field.getBoolean((Object)ocSettings));
                }
                if (Integer.TYPE.equals(this.type)) {
                    return OCIndentOptionsEditor.isFieldModified((JTextField)this.edit, (int)this.field.getInt((Object)ocSettings));
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            return false;
        }
    }
}

