/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.settings;

import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ui.GridBag;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.OCEnumComboOption;
import com.jetbrains.cidr.lang.settings.OCEnumGroupOption;
import com.jetbrains.cidr.lang.settings.OCOption;
import com.jetbrains.cidr.lang.util.OCDeclarationKind;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.util.Arrays;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class OCGenerateCodeConfigurable
implements Configurable {
    private final OCCodeStyleSettings myOCSettings;
    private final CommonCodeStyleSettings myOCCommonSettings;
    private JCheckBox myRetainParametersBox;
    private JCheckBox myUseSettersBox;
    private JCheckBox myPutIvarsToImplementationBox;
    private JCheckBox mySemicolonAfterMethodSignatureBox;
    private JCheckBox myUseNSTypesInIntroduce;
    private JCheckBox myLineCommentOnFirstColumnCheckBox;
    private JCheckBox myBlockCommentOnFirstColumnCheckBox;
    private JCheckBox myBlockCommentIndentCheckBox;
    private JPanel myIvarReleaseFormatComponent;
    private JPanel myGenerateIvarsForPropertiesComponent;
    private JPanel myTypeQualifiersPlacingComponent;
    private JTextField myIvarPrefixField;
    private JTextField myIvarSuffixField;
    private DefaultListModel myFileDeclsOrder;
    private DefaultListModel myClassDeclsOrder;
    private JTextField myFieldPrefixField;
    private JTextField myFieldSuffixField;
    private JTextField myGetterPrefixField;
    private JTextField mySetterPrefixField;
    private OCEnumComboOption<OCCodeStyleSettings.ReleaseStyle> myIvarReleaseFormatOption;
    private OCEnumComboOption<OCCodeStyleSettings.RememberedOption> myGenerateIvarsForPropertiesOption;
    private OCEnumGroupOption<OCCodeStyleSettings.Placement> myTypeQualifiersPlacingOption;

    public OCGenerateCodeConfigurable(CodeStyleSettings settings) {
        this.myOCCommonSettings = settings.getCommonSettings((Language)OCLanguage.getInstance());
        this.myOCSettings = (OCCodeStyleSettings)settings.getCustomSettings(OCCodeStyleSettings.class);
    }

    @Nls
    public String getDisplayName() {
        return "Code Generation";
    }

    public String getHelpTopic() {
        return "Code_Style_Code_Gen";
    }

    private void addGeneralComponent(JPanel optionsPanel, JPanel orderPanel) {
        this.myLineCommentOnFirstColumnCheckBox = new JCheckBox(ApplicationBundle.message((String)"checkbox.line.comment.at.first.column", (Object[])new Object[0]));
        this.myBlockCommentOnFirstColumnCheckBox = new JCheckBox(ApplicationBundle.message((String)"checkbox.block.comment.at.first.column", (Object[])new Object[0]));
        this.myBlockCommentIndentCheckBox = new JCheckBox(OCBundle.message("checkbox.block.comment.indent", new Object[0]));
        this.myFileDeclsOrder = new DefaultListModel();
        this.myTypeQualifiersPlacingOption = new OCEnumGroupOption<OCCodeStyleSettings.Placement>("Const/volatile qualifier placement", OCEnumGroupOption.Presentation.Line, (T[])OCCodeStyleSettings.Placement.values(), "const int x = 0", "int const x = 0");
        this.myTypeQualifiersPlacingComponent = this.myTypeQualifiersPlacingOption.createComponent();
        JPanel comments = new JPanel(new GridBagLayout());
        GridBag bag = new GridBag().setDefaultWeightX(1.0).setDefaultAnchor(17);
        comments.add((Component)this.myLineCommentOnFirstColumnCheckBox, bag.nextLine());
        comments.add((Component)this.myBlockCommentOnFirstColumnCheckBox, bag.nextLine());
        comments.add((Component)this.myBlockCommentIndentCheckBox, bag.nextLine());
        JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout());
        panel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"General", (boolean)true));
        panel.add(comments);
        panel.add(this.myTypeQualifiersPlacingComponent);
        optionsPanel.add(panel);
        this.myFileDeclsOrder = new DefaultListModel();
        orderPanel.add(OCGenerateCodeConfigurable.createDeclarationsOrderPanel(OCDeclarationKind.ourFileDeclarationKinds, this.myFileDeclsOrder, "Top-level declarations order"));
    }

    private void addObjCComponent(JPanel optionsPanel, JPanel orderPanel) {
        this.myRetainParametersBox = new JCheckBox("Retain object parameters in initWith...");
        this.myUseSettersBox = new JCheckBox("Use property setters in initWith...");
        this.myPutIvarsToImplementationBox = new JCheckBox("Put ivars to implementation if possible");
        this.mySemicolonAfterMethodSignatureBox = new JCheckBox("Semicolon after method signature in implementation");
        this.myIvarReleaseFormatOption = new OCEnumComboOption<OCCodeStyleSettings.ReleaseStyle>("Ivars release style (for 'dealloc')", (T[])OCCodeStyleSettings.ReleaseStyle.values(), "[ivar release]", "[ivar release], ivar = nil", "property = nil");
        this.myGenerateIvarsForPropertiesOption = new OCEnumComboOption<OCCodeStyleSettings.RememberedOption>("Generate ivar declarations for properties", (T[])OCCodeStyleSettings.RememberedOption.values(), "Always generate", "Never generate", "Ask");
        this.myUseNSTypesInIntroduce = new JCheckBox("Use NSInteger and CGFloat in introduce variable");
        this.myIvarPrefixField = new JTextField(5);
        this.myIvarSuffixField = new JTextField(5);
        this.myIvarReleaseFormatComponent = this.myIvarReleaseFormatOption.createComponent();
        this.myGenerateIvarsForPropertiesComponent = this.myGenerateIvarsForPropertiesOption.createComponent();
        JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout());
        panel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"Objective-C", (boolean)true));
        JPanel general = new JPanel(new GridBagLayout());
        GridBag bag = new GridBag().setDefaultWeightX(1.0).setDefaultAnchor(17);
        general.add((Component)new JLabel("Prefix for instance variables:"), bag.nextLine().next().weightx(0.0).insets(0, 0, 0, 10));
        general.add((Component)this.myIvarPrefixField, bag.next().fillCellNone());
        general.add((Component)new JLabel("Suffix for instance variables:"), bag.nextLine().next().weightx(0.0).insets(0, 0, 0, 10));
        general.add((Component)this.myIvarSuffixField, bag.next().fillCellNone());
        general.add((Component)this.myRetainParametersBox, bag.nextLine().next().coverLine().insets(13, -1, -1, -1));
        general.add((Component)this.myUseSettersBox, bag.nextLine().next().coverLine());
        general.add((Component)this.mySemicolonAfterMethodSignatureBox, bag.nextLine().next().coverLine());
        general.add((Component)this.myPutIvarsToImplementationBox, bag.nextLine().next().coverLine());
        general.add((Component)this.myUseNSTypesInIntroduce, bag.nextLine().next().coverLine());
        panel.add(general);
        panel.add(this.myIvarReleaseFormatComponent);
        panel.add(this.myGenerateIvarsForPropertiesComponent);
        optionsPanel.add(panel);
        this.myClassDeclsOrder = new DefaultListModel();
        orderPanel.add(OCGenerateCodeConfigurable.createDeclarationsOrderPanel(OCDeclarationKind.ourClassDeclarationKinds, this.myClassDeclsOrder, "Objective-C class order"));
    }

    private void addCppComponent(JPanel optionsPanel) {
        this.myFieldPrefixField = new JTextField(5);
        this.myFieldSuffixField = new JTextField(5);
        this.myGetterPrefixField = new JTextField(5);
        this.mySetterPrefixField = new JTextField(5);
        JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout());
        panel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"C++", (boolean)true));
        JPanel general = new JPanel(new GridBagLayout());
        GridBag bag = new GridBag().setDefaultWeightX(1.0).setDefaultAnchor(17);
        general.add((Component)new JLabel("Prefix for fields:"), bag.nextLine().next().weightx(0.0).insets(0, 0, 0, 10));
        general.add((Component)this.myFieldPrefixField, bag.next().fillCellNone());
        general.add((Component)new JLabel("Prefix for getters:"), bag.next().weightx(0.0).insets(0, 0, 0, 10));
        general.add((Component)this.myGetterPrefixField, bag.next().fillCellNone());
        general.add((Component)new JLabel("Suffix for fields:"), bag.nextLine().next().weightx(0.0).insets(0, 0, 0, 10));
        general.add((Component)this.myFieldSuffixField, bag.next().fillCellNone());
        general.add((Component)new JLabel("Prefix for setters:"), bag.next().weightx(0.0).insets(0, 0, 0, 10));
        general.add((Component)this.mySetterPrefixField, bag.next().fillCellNone());
        panel.add(general);
        optionsPanel.add(panel);
    }

    public JComponent createComponent() {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel optionsPanel = new JPanel((LayoutManager)new VerticalFlowLayout());
        JPanel orderPanel = new JPanel((LayoutManager)new VerticalFlowLayout());
        this.addGeneralComponent(optionsPanel, orderPanel);
        if (PlatformUtils.isAppCode()) {
            this.addObjCComponent(optionsPanel, orderPanel);
        }
        this.addCppComponent(optionsPanel);
        panel.add((Component)optionsPanel, "Center");
        panel.add((Component)orderPanel, "East");
        JScrollPane scroll = ScrollPaneFactory.createScrollPane((Component)panel);
        scroll.setHorizontalScrollBarPolicy(30);
        scroll.setVerticalScrollBarPolicy(20);
        scroll.setBorder(null);
        return scroll;
    }

    private static JPanel createDeclarationsOrderPanel(List<OCDeclarationKind> values, DefaultListModel model, String title) {
        JBList list = new JBList((ListModel)model);
        int width = 150;
        int height = 0;
        for (int i = 0; i < values.size(); ++i) {
            Dimension eachSize = list.getCellRenderer().getListCellRendererComponent(list, values.get(i), i, true, true).getPreferredSize();
            width = Math.max(width, eachSize.width);
            height = (int)((double)height + eachSize.getHeight());
        }
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JList)list);
        JPanel listPanel = decorator.disableAddAction().disableRemoveAction().setPreferredSize(new Dimension(width, height)).createPanel();
        listPanel.setBorder(IdeBorderFactory.createBorder());
        JPanel borderedPanel = new JPanel(new BorderLayout());
        borderedPanel.add(listPanel);
        borderedPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)title, (boolean)false));
        return borderedPanel;
    }

    public boolean isModified() {
        if (this.myOCCommonSettings == null || this.myOCSettings == null) {
            return false;
        }
        boolean isModified = this.isModifiedGeneralOptions();
        isModified |= this.isModifiedCppOptions();
        if (PlatformUtils.isAppCode()) {
            isModified |= this.isModifiedObjCOptions();
        }
        return isModified;
    }

    private boolean isModifiedCppOptions() {
        boolean modified = OCGenerateCodeConfigurable.isModified(this.myFieldPrefixField, this.myOCSettings.FIELDS_PREFIX);
        modified |= OCGenerateCodeConfigurable.isModified(this.myFieldSuffixField, this.myOCSettings.FIELDS_SUFFIX);
        modified |= OCGenerateCodeConfigurable.isModified(this.myGetterPrefixField, this.myOCSettings.GETTERS_PREFIX);
        return modified |= OCGenerateCodeConfigurable.isModified(this.mySetterPrefixField, this.myOCSettings.SETTERS_PREFIX);
    }

    private boolean isModifiedObjCOptions() {
        boolean modified = OCGenerateCodeConfigurable.isModified(this.myRetainParametersBox, this.myOCSettings.RETAIN_OBJECT_PARAMETERS_IN_CONSTRUCTOR);
        modified |= OCGenerateCodeConfigurable.isModified(this.myUseSettersBox, this.myOCSettings.USE_SETTERS_IN_CONSTRUCTOR);
        modified |= OCGenerateCodeConfigurable.isModified(this.myPutIvarsToImplementationBox, this.myOCSettings.PUT_IVARS_TO_IMPLEMENTATION);
        modified |= OCGenerateCodeConfigurable.isModified(this.mySemicolonAfterMethodSignatureBox, this.myOCSettings.SEMICOLON_AFTER_METHOD_SIGNATURE);
        modified |= OCGenerateCodeConfigurable.isModified(this.myUseNSTypesInIntroduce, this.myOCSettings.INTRODUCE_USE_NS_TYPES);
        modified |= OCGenerateCodeConfigurable.isModified(this.myIvarReleaseFormatOption, this.myIvarReleaseFormatComponent, this.myOCSettings.RELEASE_STYLE);
        modified |= OCGenerateCodeConfigurable.isModified(this.myGenerateIvarsForPropertiesOption, this.myGenerateIvarsForPropertiesComponent, this.myOCSettings.GENERATE_INSTANCE_VARIABLES_FOR_PROPERTIES);
        modified |= OCGenerateCodeConfigurable.isModified(this.myIvarPrefixField, this.myOCSettings.IVARS_PREFIX);
        modified |= OCGenerateCodeConfigurable.isModified(this.myIvarSuffixField, this.myOCSettings.IVARS_SUFFIX);
        return modified |= OCGenerateCodeConfigurable.isModified(this.myClassDeclsOrder, this.myOCSettings.CLASS_DECLARATIONS_ORDER);
    }

    private boolean isModifiedGeneralOptions() {
        boolean modified = OCGenerateCodeConfigurable.isModified(this.myLineCommentOnFirstColumnCheckBox, this.myOCCommonSettings.LINE_COMMENT_AT_FIRST_COLUMN);
        modified |= OCGenerateCodeConfigurable.isModified(this.myBlockCommentOnFirstColumnCheckBox, this.myOCCommonSettings.BLOCK_COMMENT_AT_FIRST_COLUMN);
        modified |= OCGenerateCodeConfigurable.isModified(this.myBlockCommentIndentCheckBox, this.myOCSettings.INDENT_BLOCK_COMMENT);
        modified |= OCGenerateCodeConfigurable.isModified(this.myFileDeclsOrder, this.myOCSettings.FILE_DECLARATIONS_ORDER);
        return modified |= OCGenerateCodeConfigurable.isModified(this.myTypeQualifiersPlacingOption, this.myTypeQualifiersPlacingComponent, this.myOCSettings.TYPE_QUALIFIERS_PLACEMENT);
    }

    public void apply() throws ConfigurationException {
        if (this.myOCCommonSettings == null || this.myOCSettings == null) {
            return;
        }
        this.applyGeneralOptions();
        this.applyCppOptions();
        if (PlatformUtils.isAppCode()) {
            this.applyObjCOptions();
        }
    }

    private void applyCppOptions() {
        this.myOCSettings.FIELDS_PREFIX = this.myFieldPrefixField.getText().trim();
        this.myOCSettings.FIELDS_SUFFIX = this.myFieldSuffixField.getText().trim();
        this.myOCSettings.GETTERS_PREFIX = this.myGetterPrefixField.getText().trim();
        this.myOCSettings.SETTERS_PREFIX = this.mySetterPrefixField.getText().trim();
    }

    private void applyObjCOptions() {
        this.myOCSettings.RETAIN_OBJECT_PARAMETERS_IN_CONSTRUCTOR = this.myRetainParametersBox.isSelected();
        this.myOCSettings.USE_SETTERS_IN_CONSTRUCTOR = this.myUseSettersBox.isSelected();
        this.myOCSettings.PUT_IVARS_TO_IMPLEMENTATION = this.myPutIvarsToImplementationBox.isSelected();
        this.myOCSettings.SEMICOLON_AFTER_METHOD_SIGNATURE = this.mySemicolonAfterMethodSignatureBox.isSelected();
        this.myOCSettings.INTRODUCE_USE_NS_TYPES = this.myUseNSTypesInIntroduce.isSelected();
        this.myOCSettings.RELEASE_STYLE = this.myIvarReleaseFormatOption.getSelectedValue(this.myIvarReleaseFormatComponent);
        this.myOCSettings.GENERATE_INSTANCE_VARIABLES_FOR_PROPERTIES = this.myGenerateIvarsForPropertiesOption.getSelectedValue(this.myGenerateIvarsForPropertiesComponent);
        this.myOCSettings.IVARS_PREFIX = this.myIvarPrefixField.getText().trim();
        this.myOCSettings.IVARS_SUFFIX = this.myIvarSuffixField.getText().trim();
        this.myOCSettings.CLASS_DECLARATIONS_ORDER = Arrays.asList(ArrayUtil.toObjectArray(OCDeclarationKind.class, (Object[])this.myClassDeclsOrder.toArray()));
    }

    private void applyGeneralOptions() {
        this.myOCCommonSettings.LINE_COMMENT_AT_FIRST_COLUMN = this.myLineCommentOnFirstColumnCheckBox.isSelected();
        this.myOCCommonSettings.BLOCK_COMMENT_AT_FIRST_COLUMN = this.myBlockCommentOnFirstColumnCheckBox.isSelected();
        this.myOCSettings.INDENT_BLOCK_COMMENT = this.myBlockCommentIndentCheckBox.isSelected();
        this.myOCSettings.FILE_DECLARATIONS_ORDER = Arrays.asList(ArrayUtil.toObjectArray(OCDeclarationKind.class, (Object[])this.myFileDeclsOrder.toArray()));
        this.myOCSettings.TYPE_QUALIFIERS_PLACEMENT = this.myTypeQualifiersPlacingOption.getSelectedValue(this.myTypeQualifiersPlacingComponent);
    }

    public static void customizeSettings(@NotNull CodeStyleSettingsCustomizable c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/jetbrains/cidr/lang/settings/OCGenerateCodeConfigurable", "customizeSettings"));
        }
        c.showStandardOptions(new String[]{"LINE_COMMENT_AT_FIRST_COLUMN", "BLOCK_COMMENT_AT_FIRST_COLUMN"});
    }

    public void reset() {
        if (this.myOCCommonSettings == null || this.myOCSettings == null) {
            return;
        }
        this.resetGeneralOptions();
        this.resetCppOptions();
        if (PlatformUtils.isAppCode()) {
            this.resetObjCOptions();
        }
    }

    private void resetCppOptions() {
        this.myFieldPrefixField.setText(this.myOCSettings.FIELDS_PREFIX);
        this.myFieldSuffixField.setText(this.myOCSettings.FIELDS_SUFFIX);
        this.myGetterPrefixField.setText(this.myOCSettings.GETTERS_PREFIX);
        this.mySetterPrefixField.setText(this.myOCSettings.SETTERS_PREFIX);
    }

    private void resetObjCOptions() {
        this.myRetainParametersBox.setSelected(this.myOCSettings.RETAIN_OBJECT_PARAMETERS_IN_CONSTRUCTOR);
        this.myUseSettersBox.setSelected(this.myOCSettings.USE_SETTERS_IN_CONSTRUCTOR);
        this.myPutIvarsToImplementationBox.setSelected(this.myOCSettings.PUT_IVARS_TO_IMPLEMENTATION);
        this.mySemicolonAfterMethodSignatureBox.setSelected(this.myOCSettings.SEMICOLON_AFTER_METHOD_SIGNATURE);
        this.myUseNSTypesInIntroduce.setSelected(this.myOCSettings.INTRODUCE_USE_NS_TYPES);
        this.myIvarReleaseFormatOption.selectValue(this.myIvarReleaseFormatComponent, this.myOCSettings.RELEASE_STYLE);
        this.myGenerateIvarsForPropertiesOption.selectValue(this.myGenerateIvarsForPropertiesComponent, this.myOCSettings.GENERATE_INSTANCE_VARIABLES_FOR_PROPERTIES);
        this.myIvarPrefixField.setText(this.myOCSettings.IVARS_PREFIX);
        this.myIvarSuffixField.setText(this.myOCSettings.IVARS_SUFFIX);
        this.myClassDeclsOrder.removeAllElements();
        for (OCDeclarationKind kind : this.myOCSettings.CLASS_DECLARATIONS_ORDER) {
            this.myClassDeclsOrder.addElement(kind);
        }
    }

    private void resetGeneralOptions() {
        this.myLineCommentOnFirstColumnCheckBox.setSelected(this.myOCCommonSettings.LINE_COMMENT_AT_FIRST_COLUMN);
        this.myBlockCommentOnFirstColumnCheckBox.setSelected(this.myOCCommonSettings.BLOCK_COMMENT_AT_FIRST_COLUMN);
        this.myBlockCommentIndentCheckBox.setSelected(this.myOCSettings.INDENT_BLOCK_COMMENT);
        this.myTypeQualifiersPlacingOption.selectValue(this.myTypeQualifiersPlacingComponent, this.myOCSettings.TYPE_QUALIFIERS_PLACEMENT);
        this.myFileDeclsOrder.removeAllElements();
        for (OCDeclarationKind kind : this.myOCSettings.FILE_DECLARATIONS_ORDER) {
            this.myFileDeclsOrder.addElement(kind);
        }
    }

    private static boolean isModified(JCheckBox checkBox, boolean value) {
        return checkBox.isSelected() != value;
    }

    private static <T, Comp extends JComponent> boolean isModified(OCOption<T, Comp> option, Comp component, T value) {
        return !option.getSelectedValue(component).equals(value);
    }

    private static boolean isModified(JTextField textField, String value) {
        return !textField.getText().trim().equals(value);
    }

    private static boolean isModified(DefaultListModel model, List<OCDeclarationKind> order) {
        assert (model.size() == order.size());
        for (int i = 0; i < model.size(); ++i) {
            if (model.elementAt(i) == order.get(i)) continue;
            return true;
        }
        return false;
    }

    public void disposeUIResources() {
    }
}

