/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search.usages;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArraySelectionExpression;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCForeachStatement;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCPostfixExpression;
import com.jetbrains.cidr.lang.psi.OCPrefixExpression;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCExpectedTypeUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;

public class OCReadWriteAccessDetector
extends ReadWriteAccessDetector {
    public boolean isReadWriteAccessible(PsiElement element) {
        return element instanceof OCDeclarator || element instanceof OCMethodSelectorPart || element instanceof OCReferenceElement && element.getParent() instanceof OCSynthesizeProperty;
    }

    public boolean isDeclarationWriteAccess(PsiElement element) {
        return element instanceof OCDeclarator && (((OCDeclarator)element).getInitializer() != null || element.getParent().getParent() instanceof OCForeachStatement);
    }

    public ReadWriteAccessDetector.Access getReferenceAccess(PsiElement referencedElement, PsiReference reference) {
        return this.getExpressionAccess(reference.getElement());
    }

    public ReadWriteAccessDetector.Access getExpressionAccess(PsiElement expression) {
        if (expression instanceof OCReferenceElement || expression instanceof OCReferenceExpression || expression instanceof OCQualifiedExpression || expression instanceof OCArraySelectionExpression || expression instanceof OCUnaryExpression && ((OCUnaryExpression)expression).getOperationSign() == OCTokenTypes.MUL) {
            PsiElement parent = PsiTreeUtil.skipParentsOfType((PsiElement)expression, (Class[])new Class[]{OCReferenceExpression.class, OCParenthesizedExpression.class});
            OCElementType operator = null;
            if (parent instanceof OCAssignmentExpression && PsiTreeUtil.isAncestor((PsiElement)((OCAssignmentExpression)parent).getReceiverExpression(), (PsiElement)expression, (boolean)false)) {
                return ((OCAssignmentExpression)parent).getOperationSign() == OCTokenTypes.EQ ? ReadWriteAccessDetector.Access.Write : ReadWriteAccessDetector.Access.ReadWrite;
            }
            if (parent instanceof OCPrefixExpression) {
                operator = ((OCPrefixExpression)parent).getOperationSign();
            } else if (parent instanceof OCPostfixExpression) {
                operator = ((OCPostfixExpression)parent).getOperationSign();
            }
            return operator == OCTokenTypes.PLUSPLUS || operator == OCTokenTypes.MINUSMINUS ? ReadWriteAccessDetector.Access.ReadWrite : ReadWriteAccessDetector.Access.Read;
        }
        if (expression instanceof OCSendMessageExpression) {
            return ((OCSendMessageExpression)expression).getMessageSelector().endsWith(":") ? ReadWriteAccessDetector.Access.Write : ReadWriteAccessDetector.Access.Read;
        }
        return ReadWriteAccessDetector.Access.Read;
    }

    public boolean canBeConstReference(PsiElement expression, boolean checkPointerType) {
        OCType receiverType;
        OCType expectedType;
        PsiElement parent = expression.getParent();
        if (expression instanceof OCReferenceElement) {
            expression = parent;
            parent = expression.getParent();
        }
        if (parent instanceof OCQualifiedExpression) {
            OCSymbol function;
            if (OCParenthesesUtils.topmostParenthesized((OCExpression)parent).getParent() instanceof OCCallExpression && (function = ((OCQualifiedExpression)parent).resolveToSymbol()) instanceof OCFunctionSymbol && !((OCFunctionSymbol)function).isConst() && !((OCFunctionSymbol)function).resolveIsStatic()) {
                return false;
            }
            if (this.getExpressionAccess(parent) != ReadWriteAccessDetector.Access.Read) {
                return false;
            }
        }
        if (expression instanceof OCExpression && (expectedType = OCExpectedTypeUtil.getExpectedType((OCExpression)expression)) instanceof OCCppReferenceType && !((OCCppReferenceType)expectedType).getRefType().isConst()) {
            return false;
        }
        if (checkPointerType && parent instanceof OCAssignmentExpression && ((OCAssignmentExpression)parent).getSourceExpression() == expression && (receiverType = ((OCAssignmentExpression)parent).getReceiverExpression().getResolvedType()) instanceof OCPointerType && !((OCPointerType)receiverType).getRefType().isConst()) {
            return false;
        }
        if (checkPointerType && parent instanceof OCDeclarator && (receiverType = ((OCDeclarator)parent).getResolvedType()) instanceof OCPointerType && !((OCPointerType)receiverType).getRefType().isConst()) {
            return false;
        }
        return !(parent instanceof OCUnaryExpression) || ((OCUnaryExpression)parent).getOperationSign() != OCTokenTypes.MUL || this.getExpressionAccess(parent) == ReadWriteAccessDetector.Access.Read;
    }
}

