/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search.usages;

import com.intellij.find.findUsages.AbstractFindUsagesDialog;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashSet;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.search.OCClassInheritorsSearch;
import com.jetbrains.cidr.lang.search.OCSearchUtil;
import com.jetbrains.cidr.lang.search.OCStructInheritorsSearch;
import com.jetbrains.cidr.lang.search.usages.OCFindUsagesDialog;
import com.jetbrains.cidr.lang.search.usages.OCFindUsagesOptions;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolderVirtualPsiElement;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCSynthesizeSymbol;
import java.util.Collection;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFindUsagesHandler
extends FindUsagesHandler {
    private boolean myDeleteMode;

    public OCFindUsagesHandler(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/jetbrains/cidr/lang/search/usages/OCFindUsagesHandler", "<init>"));
        }
        super(psiElement);
    }

    public OCFindUsagesHandler(@NotNull PsiElement psiElement, boolean isDeleteMode) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/jetbrains/cidr/lang/search/usages/OCFindUsagesHandler", "<init>"));
        }
        super(psiElement);
        this.myDeleteMode = isDeleteMode;
    }

    private String getActionName() {
        return this.myDeleteMode ? "delete" : "find usages of";
    }

    @Override
    @NotNull
    public PsiElement[] getPrimaryElements() {
        OCSymbol symbol;
        PsiElement element = this.getPsiElement();
        if (element instanceof OCFile) {
            symbol = ((OCFile)element).getSameNamedClass();
        } else if (element instanceof OCSymbolDeclarator) {
            symbol = ((OCSymbolDeclarator)element).getSymbol();
        } else {
            PsiElement[] psiElementArray = super.getPrimaryElements();
            if (psiElementArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/search/usages/OCFindUsagesHandler", "getPrimaryElements"));
            }
            return psiElementArray;
        }
        HashSet result2 = new HashSet();
        final CommonProcessors.CollectProcessor psiCollector = new CommonProcessors.CollectProcessor((Collection)result2);
        Processor<OCSymbol> collector = new Processor<OCSymbol>(){

            public boolean process(OCSymbol symbol) {
                OCFindUsagesHandler.processSymbol(symbol, (Processor<PsiElement>)((Processor)psiCollector));
                return true;
            }
        };
        if (symbol instanceof OCSymbolWithParent) {
            OCSearchUtil.Ancestor ancestor = OCSearchUtil.findSomeAncestor((OCSymbolWithParent)symbol);
            if (ancestor != null) {
                int code;
                String subject = symbol.getKind().getNameLowercase();
                String message = symbol.getNameWithKindUppercase() + " overrides " + subject + " in " + ancestor.getSymbol().getParent().getNameWithKindLowercase() + (ancestor.isOutOfProject() ? " which is out of project" : "");
                if (this.myDeleteMode && ancestor.isOutOfProject()) {
                    code = Messages.showYesNoDialog((Project)this.getProject(), (String)(message + ". Do you want to proceed the refactoring?"), (String)"Warning", (Icon)Messages.getQuestionIcon());
                    if (code != 0) {
                        if (PsiElement.EMPTY_ARRAY == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/search/usages/OCFindUsagesHandler", "getPrimaryElements"));
                        }
                        return PsiElement.EMPTY_ARRAY;
                    }
                } else {
                    code = ApplicationManager.getApplication().isUnitTestMode() ? 0 : Messages.showYesNoDialog((String)(message + "\n\nDo you want to " + this.getActionName() + " the base " + subject + "?"), (String)"Method search", (Icon)Messages.getQuestionIcon());
                    if (code == 0) {
                        OCSearchUtil.processMemberAncestors((OCSymbolWithParent)symbol, (Processor<? super OCSymbolWithParent>)collector, !this.myDeleteMode);
                    } else {
                        result2.add(element);
                    }
                }
            } else {
                result2.add(element);
            }
            if (this.myDeleteMode) {
                boolean isGeneratedFromProperty = false;
                if (symbol instanceof OCMethodSymbol) {
                    OCMethodSymbol method = (OCMethodSymbol)symbol;
                    OCMethodSymbol associatedSymbol = method.getAssociatedSymbol();
                    boolean bl = isGeneratedFromProperty = associatedSymbol != null && associatedSymbol.getGeneratedFromProperty() != null;
                }
                if (!isGeneratedFromProperty) {
                    OCSearchUtil.processMembersHierarchy((OCSymbolWithParent)symbol, collector, false, true, true);
                }
            }
        } else if (symbol != null) {
            if (this.myDeleteMode) {
                if (element instanceof OCMethodSelectorPart) {
                    psiCollector.process((Object)element);
                } else {
                    symbol.processSameSymbols(collector);
                }
            } else {
                psiCollector.process((Object)element);
            }
        }
        if (symbol != null) {
            symbol = symbol.getDefinitionSymbol();
            if (this.myDeleteMode && symbol instanceof OCClassSymbol) {
                result2.clear();
                final String categoryName = ((OCClassSymbol)symbol).getCategoryName();
                symbol.processSameSymbols(new Processor<OCSymbol>((Set)result2, psiCollector){
                    final /* synthetic */ Set val$result;
                    final /* synthetic */ CommonProcessors.CollectProcessor val$psiCollector;
                    {
                        this.val$result = set;
                        this.val$psiCollector = collectProcessor;
                    }

                    public boolean process(OCSymbol curSymbol) {
                        if (categoryName != null && !categoryName.equals(((OCClassSymbol)curSymbol).getCategoryName())) {
                            return true;
                        }
                        OCFile file2 = curSymbol.getContainingOCFile();
                        if (file2 != null && curSymbol.equals(file2.getSameNamedClass()) && !file2.hasExtraTopLevelDefinitions()) {
                            this.val$result.add(file2);
                        } else if (!this.val$result.contains(file2)) {
                            OCFindUsagesHandler.processSymbol(curSymbol, (Processor<PsiElement>)((Processor)this.val$psiCollector));
                        }
                        return true;
                    }
                });
            }
            if (result2.isEmpty()) {
                result2.add(element);
            }
            PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray((Collection)result2);
            if (psiElementArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/search/usages/OCFindUsagesHandler", "getPrimaryElements"));
            }
            return psiElementArray;
        }
        PsiElement[] psiElementArray = super.getPrimaryElements();
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/search/usages/OCFindUsagesHandler", "getPrimaryElements"));
        }
        return psiElementArray;
    }

    void processSecondaryElements(AssociatedElementProcessor processor2) {
        block15: {
            Object symbol;
            PsiElement element;
            block14: {
                element = this.getPsiElement();
                if (!(element instanceof OCSymbolDeclarator)) {
                    return;
                }
                symbol = ((OCSymbolDeclarator)element).getSymbol();
                if (!(symbol instanceof OCInstanceVariableSymbol)) break block14;
                OCPropertySymbol property = ((OCInstanceVariableSymbol)symbol).getAssociatedProperty();
                if (property == null) break block15;
                if (((OCInstanceVariableSymbol)symbol).isClang4ImplicitIvar()) {
                    processor2.process(new OCSymbolHolderVirtualPsiElement((OCSymbol)symbol));
                }
                if (processor2.proceedProperty(property)) {
                    OCFindUsagesHandler.processSymbol(property, processor2);
                    this.processSynthesizes(property, processor2);
                }
                break block15;
            }
            if (symbol instanceof OCPropertySymbol) {
                OCInstanceVariableSymbol ivar = ((OCPropertySymbol)symbol).getAssociatedIvar();
                if (ivar != null) {
                    if (ivar.isClang4ImplicitIvar()) {
                        processor2.process(new OCSymbolHolderVirtualPsiElement(ivar));
                    } else if (processor2.proceedIvar(ivar)) {
                        OCFindUsagesHandler.processSymbol(ivar, processor2);
                    }
                }
                this.processSynthesizes((OCPropertySymbol)symbol, processor2);
            } else if (symbol instanceof OCClassSymbol && processor2.proceedDerivedClasses()) {
                for (OCClassSymbol clazz : OCClassInheritorsSearch.search((OCClassSymbol)symbol).findAll()) {
                    OCFindUsagesHandler.processSymbol(clazz, processor2);
                }
            } else if (symbol instanceof OCStructSymbol && ((OCElement)element).getContainingOCFile().isCpp() && processor2.proceedDerivedClasses()) {
                for (OCStructSymbol struct : OCStructInheritorsSearch.search((OCStructSymbol)symbol, element).findAll()) {
                    OCFindUsagesHandler.processSymbol(struct, processor2);
                }
            }
        }
    }

    private void processSynthesizes(OCPropertySymbol symbol, final Processor<PsiElement> processor2) {
        if (this.myDeleteMode) {
            symbol.processSynthesizes((Processor<? super OCSynthesizeSymbol>)new Processor<OCSynthesizeSymbol>(){

                public boolean process(OCSynthesizeSymbol symbol) {
                    OCFindUsagesHandler.processSymbol(symbol, (Processor<PsiElement>)processor2);
                    return true;
                }
            });
        }
    }

    @Override
    @NotNull
    public PsiElement[] getSecondaryElements() {
        HashSet result2 = new HashSet();
        if (this.myDeleteMode) {
            this.processSecondaryElements(new AssociatedElementProcessor((Set)result2){
                final /* synthetic */ Set val$result;
                {
                    this.val$result = set;
                }

                @Override
                public boolean proceedProperty(OCPropertySymbol property) {
                    String message = "Do you want to " + OCFindUsagesHandler.this.getActionName() + " the " + property.getNameWithKindLowercase() + " as well?";
                    return ApplicationManager.getApplication().isUnitTestMode() || Messages.showYesNoDialog((String)message, (String)"Properties search", (Icon)Messages.getQuestionIcon()) == 0;
                }

                @Override
                public boolean proceedIvar(OCInstanceVariableSymbol ivar) {
                    if (ivar.getGeneratedFromProperty() != null) {
                        return true;
                    }
                    String message = "Do you want to " + OCFindUsagesHandler.this.getActionName() + " the " + ivar.getNameWithKindLowercase() + " as well?";
                    return ApplicationManager.getApplication().isUnitTestMode() || Messages.showYesNoDialog((String)message, (String)"Instance variables search", (Icon)Messages.getQuestionIcon()) == 0;
                }

                @Override
                public boolean proceedDerivedClasses() {
                    return false;
                }

                public boolean process(PsiElement element) {
                    this.val$result.add(element);
                    return true;
                }
            });
        } else {
            final OCFindUsagesOptions options = OCFindUsagesOptions.getInstance(this.getProject());
            this.processSecondaryElements(new AssociatedElementProcessor((Set)result2){
                final /* synthetic */ Set val$result;
                {
                    this.val$result = set;
                }

                @Override
                public boolean proceedProperty(OCPropertySymbol property) {
                    return options.isSearchForProperties;
                }

                @Override
                public boolean proceedIvar(OCInstanceVariableSymbol ivar) {
                    return options.isSearchForIvars;
                }

                @Override
                public boolean proceedDerivedClasses() {
                    return options.isSearchForDerivedClasses;
                }

                public boolean process(PsiElement element) {
                    this.val$result.add(element);
                    return true;
                }
            });
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray((Collection)result2);
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/search/usages/OCFindUsagesHandler", "getSecondaryElements"));
        }
        return psiElementArray;
    }

    private static void processSymbol(OCSymbol symbol, Processor<PsiElement> processor2) {
        if (symbol == null) {
            return;
        }
        Object def = symbol.locateDefinition();
        if (def != null) {
            processor2.process(def);
        }
    }

    @Override
    protected boolean isSearchForTextOccurencesAvailable(@NotNull PsiElement psiElement, boolean isSingleFile) {
        Object symbol;
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/jetbrains/cidr/lang/search/usages/OCFindUsagesHandler", "isSearchForTextOccurencesAvailable"));
        }
        if (isSingleFile) {
            return false;
        }
        return !(psiElement instanceof OCSymbolDeclarator) || (symbol = ((OCSymbolDeclarator)psiElement).getSymbol()) == null || !symbol.getKind().isLocal();
    }

    @Override
    @NotNull
    public FindUsagesOptions getFindUsagesOptions(@Nullable DataContext dataContext) {
        OCFindUsagesOptions oCFindUsagesOptions = OCFindUsagesOptions.getInstance(this.getProject());
        if (oCFindUsagesOptions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/search/usages/OCFindUsagesHandler", "getFindUsagesOptions"));
        }
        return oCFindUsagesOptions;
    }

    @Override
    @NotNull
    public AbstractFindUsagesDialog getFindUsagesDialog(boolean isSingleFile, boolean toShowInNewTab, boolean mustOpenInNewTab) {
        OCFindUsagesDialog oCFindUsagesDialog = new OCFindUsagesDialog(this.getPsiElement(), this.getProject(), OCFindUsagesOptions.getInstance(this.getProject()), toShowInNewTab, mustOpenInNewTab, isSingleFile, this);
        if (oCFindUsagesDialog == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/search/usages/OCFindUsagesHandler", "getFindUsagesDialog"));
        }
        return oCFindUsagesDialog;
    }

    static interface AssociatedElementProcessor
    extends Processor<PsiElement> {
        public boolean proceedProperty(OCPropertySymbol var1);

        public boolean proceedIvar(OCInstanceVariableSymbol var1);

        public boolean proceedDerivedClasses();
    }
}

