/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search.constructors;

import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.types.OCType;
import org.jetbrains.annotations.NotNull;

public abstract class OCBaseConstructorReference
implements PsiReference {
    @NotNull
    protected final PsiElement myElement;
    @NotNull
    protected final OCSymbolDeclarator myField;
    @NotNull
    protected final OCFunctionSymbol myTargetConstructor;

    public OCBaseConstructorReference(@NotNull PsiElement element, @NotNull OCSymbolDeclarator field, @NotNull OCFunctionSymbol targetConstructor) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/search/constructors/OCBaseConstructorReference", "<init>"));
        }
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/jetbrains/cidr/lang/search/constructors/OCBaseConstructorReference", "<init>"));
        }
        if (targetConstructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetConstructor", "com/jetbrains/cidr/lang/search/constructors/OCBaseConstructorReference", "<init>"));
        }
        this.myElement = element;
        this.myField = field;
        this.myTargetConstructor = targetConstructor;
    }

    public PsiElement getElement() {
        return this.myElement;
    }

    public PsiElement resolve() {
        return this.myTargetConstructor.locateDefinition();
    }

    @NotNull
    public OCFunctionSymbol getTargetConstructor() {
        OCFunctionSymbol oCFunctionSymbol = this.myTargetConstructor;
        if (oCFunctionSymbol == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/search/constructors/OCBaseConstructorReference", "getTargetConstructor"));
        }
        return oCFunctionSymbol;
    }

    @NotNull
    public OCSymbolDeclarator getField() {
        OCSymbolDeclarator oCSymbolDeclarator = this.myField;
        if (oCSymbolDeclarator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/search/constructors/OCBaseConstructorReference", "getField"));
        }
        return oCSymbolDeclarator;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myElement.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/search/constructors/OCBaseConstructorReference", "getCanonicalText"));
        }
        return string;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        return null;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/search/constructors/OCBaseConstructorReference", "bindToElement"));
        }
        return null;
    }

    public boolean isReferenceTo(PsiElement element) {
        if (!(element instanceof OCFunctionDeclaration)) {
            return false;
        }
        OCSymbol symbol = ((OCFunctionDeclaration)element).getSymbol();
        if (Comparing.equal((Object)this.myTargetConstructor, (Object)symbol)) {
            return true;
        }
        if (symbol != null && symbol.isGlobal()) {
            OCQualifiedName symbolName;
            OCQualifiedName thisName = this.myTargetConstructor.getResolvedQualifiedName();
            if (Comparing.equal((Object)thisName, (Object)(symbolName = ((OCSymbolWithQualifiedName)symbol).getResolvedQualifiedName()))) {
                OCType symbolType;
                OCType thisResolvedType;
                return !(symbol instanceof OCFunctionSymbol) || (thisResolvedType = this.myTargetConstructor.getResolvedType()).equals((Object)(symbolType = symbol.getResolvedType()), element);
            }
            return false;
        }
        return false;
    }

    @NotNull
    public Object[] getVariants() {
        Object[] objectArray = new Object[]{};
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/search/constructors/OCBaseConstructorReference", "getVariants"));
        }
        return objectArray;
    }

    public boolean isSoft() {
        return false;
    }
}

